/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.importFrom.googleDocs;

import com.google.api.client.auth.oauth2.Credential;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.fileActions.utils.GoogleDocsImportUtils;
import org.intellij.plugins.markdown.google.utils.GoogleAccountsUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/fileActions/importFrom/googleDocs/GoogleDocsImportPasteProvider;", "Lcom/intellij/ide/PasteProvider;", "()V", "isPasteEnabled", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isPastePossible", "performPaste", "", "intellij.markdown.core"})
public final class GoogleDocsImportPasteProvider
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        String string = ClipboardUtil.getTextInClipboard();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ClipboardUtil.getTextInClipboard() ?: return");
        String copiedLink = string;
        if (GoogleDocsImportUtils.INSTANCE.isLinkToDocumentCorrect(copiedLink)) {
            String docsId = GoogleDocsImportUtils.INSTANCE.extractDocsId(copiedLink);
            Object object = CommonDataKeys.PROJECT.getData(dataContext);
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CommonDataKeys.PROJECT.getData(dataContext)!!");
            Project project = (Project)object;
            Object object2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
            if (object2 == null || (object2 = object2.getPath()) == null) {
                String string2 = project.getBasePath();
                object2 = string2;
                Intrinsics.checkNotNull((Object)string2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"CommonDataKeys.VIRTUAL_F\u2026ath ?: project.basePath!!");
            Object suggestedPath = object2;
            Credential credential = GoogleAccountsUtils.INSTANCE.chooseAccount(project);
            if (credential == null) {
                return;
            }
            Credential credentials = credential;
            GoogleDocsImportUtils.INSTANCE.importGoogleDoc(project, credentials, docsId, (String)suggestedPath);
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return Registry.is((String)"markdown.google.docs.import.paste.link.enable") && LangDataKeys.IDE_VIEW.getData(dataContext) != null;
    }
}

