/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.accounts;

import com.intellij.collaboration.auth.ui.AccountsListModelBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.google.GoogleAppCredentialsException;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountManager;
import org.intellij.plugins.markdown.google.accounts.GoogleUserInfoService;
import org.intellij.plugins.markdown.google.accounts.data.GoogleAccount;
import org.intellij.plugins.markdown.google.accounts.data.GoogleUserInfo;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthRequest;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthRequestKt;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0003R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsListModel;", "Lcom/intellij/collaboration/auth/ui/AccountsListModelBase;", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleAccount;", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "()V", "userInfoService", "Lorg/intellij/plugins/markdown/google/accounts/GoogleUserInfoService;", "getUserInfoService", "()Lorg/intellij/plugins/markdown/google/accounts/GoogleUserInfoService;", "addAccount", "", "parentComponent", "Ljavax/swing/JComponent;", "point", "Lcom/intellij/ui/awt/RelativePoint;", "editAccount", "account", "isAccountUnique", "", "accountId", "", "showNetworkErrorMessage", "updateAccountList", "userInfo", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleUserInfo;", "credentials", "AcquireUserInfoTask", "Companion", "intellij.markdown.core"})
public final class GoogleAccountsListModel
extends AccountsListModelBase<GoogleAccount, GoogleCredentials> {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    private final GoogleUserInfoService getUserInfoService() {
        boolean $i$f$service = false;
        Class<GoogleUserInfoService> serviceClass$iv = GoogleUserInfoService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ")");
        }
        return (GoogleUserInfoService)object;
    }

    public void addAccount(@NotNull JComponent parentComponent, @Nullable RelativePoint point) {
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        new AcquireUserInfoTask(parentComponent, (Function2<? super GoogleCredentials, ? super GoogleUserInfo, Unit>)((Function2)new Function2<GoogleCredentials, GoogleUserInfo, Unit>(this){
            final /* synthetic */ GoogleAccountsListModel this$0;

            public final void invoke(@NotNull GoogleCredentials userCred, @NotNull GoogleUserInfo userInfo) {
                Intrinsics.checkNotNullParameter((Object)userCred, (String)"userCred");
                Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
                if (GoogleAccountsListModel.access$isAccountUnique(this.this$0, userInfo.getId())) {
                    GoogleAccountsListModel.access$updateAccountList(this.this$0, userInfo, userCred);
                }
            }
            {
                this.this$0 = googleAccountsListModel;
                super(2);
            }
        })).queue();
    }

    public void editAccount(@NotNull JComponent parentComponent, @NotNull GoogleAccount account) {
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        new AcquireUserInfoTask(parentComponent, (Function2<? super GoogleCredentials, ? super GoogleUserInfo, Unit>)((Function2)new Function2<GoogleCredentials, GoogleUserInfo, Unit>(this, account){
            final /* synthetic */ GoogleAccountsListModel this$0;
            final /* synthetic */ GoogleAccount $account;

            public final void invoke(@NotNull GoogleCredentials userCred, @NotNull GoogleUserInfo userInfo) {
                Intrinsics.checkNotNullParameter((Object)userCred, (String)"userCred");
                Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
                this.this$0.getNewCredentials().put(this.$account, userCred);
                this.$account.setName(userInfo.getEmail());
                GoogleAccountsListModel.access$notifyCredentialsChanged(this.this$0, this.$account);
            }
            {
                this.this$0 = googleAccountsListModel;
                this.$account = googleAccount;
                super(2);
            }
        })).queue();
    }

    private final boolean isAccountUnique(String accountId) {
        boolean bl;
        block3: {
            List list2 = this.getAccountsListModel().getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"accountsListModel.items");
            Iterable $this$none$iv = list2;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    GoogleAccount it = (GoogleAccount)((Object)element$iv);
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)accountId)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @RequiresEdt
    private final void updateAccountList(GoogleUserInfo userInfo, GoogleCredentials credentials) {
        GoogleAccount account = GoogleAccountManager.Companion.createAccount(userInfo);
        this.getAccountsListModel().add((Object)account);
        this.getNewCredentials().put(account, credentials);
        this.notifyCredentialsChanged(account);
    }

    private final void showNetworkErrorMessage(JComponent parentComponent) {
        String string = MarkdownBundle.message("markdown.google.network.problems.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026.network.problems.title\")");
        String string2 = MarkdownBundle.message("markdown.google.login.network.problems.msg", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MarkdownBundle.message(\"\u2026in.network.problems.msg\")");
        MessageDialogBuilder.Message message = new MessageDialogBuilder.Message(string, string2);
        String[] stringArray = new String[1];
        String string3 = Messages.getOkButton();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Messages.getOkButton()");
        stringArray[0] = string3;
        ((MessageDialogBuilder.Message)message.buttons(stringArray).icon(UIUtil.getErrorIcon())).show(null, (Component)parentComponent);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GoogleAccountsListModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$isAccountUnique(GoogleAccountsListModel $this, String accountId) {
        return $this.isAccountUnique(accountId);
    }

    public static final /* synthetic */ void access$updateAccountList(GoogleAccountsListModel $this, GoogleUserInfo userInfo, GoogleCredentials credentials) {
        $this.updateAccountList(userInfo, credentials);
    }

    public static final /* synthetic */ void access$notifyCredentialsChanged(GoogleAccountsListModel $this, GoogleAccount account) {
        $this.notifyCredentialsChanged(account);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R>\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsListModel$AcquireUserInfoTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "parentComponent", "Ljavax/swing/JComponent;", "process", "Lkotlin/Function2;", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "Lkotlin/ParameterName;", "name", "userCred", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleUserInfo;", "userInfo", "", "(Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsListModel;Ljavax/swing/JComponent;Lkotlin/jvm/functions/Function2;)V", "credentials", "onSuccess", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.markdown.core"})
    private final class AcquireUserInfoTask
    extends Task.Modal {
        private GoogleCredentials credentials;
        private GoogleUserInfo userInfo;
        private final Function2<GoogleCredentials, GoogleUserInfo, Unit> process;

        public void run(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            CompletableFuture credentialsFuture = new CompletableFuture();
            try {
                GoogleUserInfo googleUserInfo;
                CompletableFuture<GoogleUserInfo> completableFuture;
                GoogleCredentials it;
                GoogleCredentials googleCredentials;
                GoogleOAuthRequest request = GoogleOAuthRequestKt.getGoogleAuthRequest();
                boolean $i$f$service = false;
                Class<GoogleOAuthService> serviceClass$iv = GoogleOAuthService.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ")");
                }
                credentialsFuture = ((GoogleOAuthService)((Object)object)).authorize(request);
                GoogleCredentials googleCredentials2 = this.credentials = (GoogleCredentials)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)credentialsFuture, (ProgressIndicator)indicator);
                if (googleCredentials2 != null) {
                    it = googleCredentials = googleCredentials2;
                    boolean bl = false;
                    completableFuture = GoogleAccountsListModel.this.getUserInfoService().acquireUserInfo(it.getAccessToken(), indicator);
                } else {
                    completableFuture = null;
                }
                CompletableFuture<GoogleUserInfo> userInfoFuture = completableFuture;
                AcquireUserInfoTask acquireUserInfoTask = this;
                CompletableFuture<GoogleUserInfo> completableFuture2 = userInfoFuture;
                if (completableFuture2 != null) {
                    it = googleCredentials = completableFuture2;
                    AcquireUserInfoTask acquireUserInfoTask2 = acquireUserInfoTask;
                    boolean bl = false;
                    GoogleUserInfo googleUserInfo2 = (GoogleUserInfo)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)((Future)((Object)it)));
                    acquireUserInfoTask = acquireUserInfoTask2;
                    googleUserInfo = googleUserInfo2;
                } else {
                    googleUserInfo = null;
                }
                acquireUserInfoTask.userInfo = googleUserInfo;
            }
            catch (Throwable t) {
                Throwable throwable = t;
                if (throwable instanceof ProcessCanceledException) {
                    LOG.info("The authorization process has been canceled");
                } else if (throwable instanceof GoogleAppCredentialsException) {
                    JComponent jComponent = this.getParentComponent();
                    if (jComponent != null) {
                        JComponent jComponent2;
                        JComponent it = jComponent2 = jComponent;
                        boolean bl = false;
                        JComponent jComponent3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)jComponent3, (String)"it");
                        GoogleAccountsListModel.this.showNetworkErrorMessage(jComponent3);
                    }
                } else {
                    LOG.info(t.getLocalizedMessage());
                }
                credentialsFuture.cancel(true);
            }
        }

        public void onSuccess() {
            if (this.credentials != null && this.userInfo != null) {
                GoogleCredentials googleCredentials = this.credentials;
                Intrinsics.checkNotNull((Object)googleCredentials);
                GoogleUserInfo googleUserInfo = this.userInfo;
                Intrinsics.checkNotNull((Object)googleUserInfo);
                this.process.invoke((Object)googleCredentials, (Object)googleUserInfo);
            }
        }

        public AcquireUserInfoTask(@NotNull JComponent parentComponent, Function2<? super GoogleCredentials, ? super GoogleUserInfo, Unit> process) {
            Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
            Intrinsics.checkNotNullParameter(process, (String)"process");
            super(null, parentComponent, MarkdownBundle.message("markdown.google.account.login.progress.title", new Object[0]), true);
            this.process = process;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsListModel$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

