/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownBlocks;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.MarkdownRangedFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.MarkdownWrappingFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.settings.MarkdownCustomCodeStyleSettings;
import org.intellij.plugins.markdown.lang.psi.MarkdownAstUtils;
import org.intellij.plugins.markdown.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011J@\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0002R.\u0010\u0003\u001a\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004j\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownBlocks;", "", "()V", "elementsToWrap", "Ljava/util/HashSet;", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "Lkotlin/collections/HashSet;", "create", "Lorg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownFormattingBlock;", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacing", "Lcom/intellij/formatting/SpacingBuilder;", "align", "Lkotlin/Function1;", "Lcom/intellij/formatting/Alignment;", "Lkotlin/sequences/Sequence;", "nodes", "filterFromWhitespaces", "sequence", "isInsideBlockquote", "", "shouldWrapInsideBlockquote", "intellij.markdown.core"})
public final class MarkdownBlocks {
    private static final HashSet<IElementType> elementsToWrap;
    @NotNull
    public static final MarkdownBlocks INSTANCE;

    @NotNull
    public final Sequence<MarkdownFormattingBlock> create(@NotNull Sequence<? extends ASTNode> nodes, @NotNull CodeStyleSettings settings, @NotNull SpacingBuilder spacing, @NotNull Function1<? super ASTNode, ? extends Alignment> align) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        Intrinsics.checkNotNullParameter(align, (String)"align");
        return SequencesKt.map(this.filterFromWhitespaces(nodes), (Function1)((Function1)new Function1<ASTNode, MarkdownFormattingBlock>(settings, spacing, align){
            final /* synthetic */ CodeStyleSettings $settings;
            final /* synthetic */ SpacingBuilder $spacing;
            final /* synthetic */ Function1 $align;

            @NotNull
            public final MarkdownFormattingBlock invoke(@NotNull ASTNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MarkdownBlocks.INSTANCE.create(it, this.$settings, this.$spacing, (Function1<? super ASTNode, ? extends Alignment>)this.$align);
            }
            {
                this.$settings = codeStyleSettings;
                this.$spacing = spacingBuilder;
                this.$align = function1;
                super(1);
            }
        }));
    }

    @NotNull
    public final MarkdownFormattingBlock create(@NotNull ASTNode node, @NotNull CodeStyleSettings settings, @NotNull SpacingBuilder spacing, @NotNull Function1<? super ASTNode, ? extends Alignment> align) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        Intrinsics.checkNotNullParameter(align, (String)"align");
        IElementType iElementType = node.getElementType();
        return MarkdownTokenTypeSets.LIST_MARKERS.contains(iElementType) || MarkdownTokenTypeSets.WHITE_SPACES.contains(iElementType) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.BLOCK_QUOTE) ? (MarkdownFormattingBlock)MarkdownRangedFormattingBlock.Companion.trimmed(node, settings, spacing, (Alignment)align.invoke((Object)node), null) : (elementsToWrap.contains(iElementType) ? (this.isInsideBlockquote(node) && !this.shouldWrapInsideBlockquote(settings) ? new MarkdownFormattingBlock(node, settings, spacing, (Alignment)align.invoke((Object)node), null, 16, null) : (MarkdownFormattingBlock)new MarkdownWrappingFormattingBlock(settings, spacing, node, (Alignment)align.invoke((Object)node), null, 16, null)) : new MarkdownFormattingBlock(node, settings, spacing, (Alignment)align.invoke((Object)node), null, 16, null));
    }

    private final boolean isInsideBlockquote(ASTNode node) {
        boolean bl;
        block1: {
            Sequence<ASTNode> $this$any$iv = MarkdownAstUtils.INSTANCE.parents(node, false);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                IElementType iElementType = MarkdownTokenTypeSets.BLOCK_QUOTE;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypeSets.BLOCK_QUOTE");
                if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean shouldWrapInsideBlockquote(CodeStyleSettings settings) {
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(MarkdownCustomCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"settings.getCustomSettin\u2026tyleSettings::class.java)");
        MarkdownCustomCodeStyleSettings customSettings = (MarkdownCustomCodeStyleSettings)customCodeStyleSettings;
        return customSettings.WRAP_TEXT_IF_LONG && customSettings.WRAP_TEXT_INSIDE_BLOCKQUOTES;
    }

    @NotNull
    public final Sequence<ASTNode> filterFromWhitespaces(@NotNull Sequence<? extends ASTNode> sequence) {
        Intrinsics.checkNotNullParameter(sequence, (String)"sequence");
        return SequencesKt.filter(sequence, (Function1)filterFromWhitespaces.1.INSTANCE);
    }

    private MarkdownBlocks() {
    }

    static {
        MarkdownBlocks markdownBlocks;
        INSTANCE = markdownBlocks = new MarkdownBlocks();
        elementsToWrap = SetsKt.hashSetOf((Object[])new IElementType[]{MarkdownElementTypes.PARAGRAPH, MarkdownElementTypes.EMPH, MarkdownElementTypes.STRONG, MarkdownElementTypes.STRIKETHROUGH});
    }
}

