/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.MarkdownIcons;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.ui.actions.styling.CreateOrChangeListActionGroup$CreateListImpl$setSelected$;
import org.intellij.plugins.markdown.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00062\u00020\u0001:\u0005\u0005\u0006\u0007\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "()V", "isPopup", "", "CheckmarkList", "Companion", "CreateListImpl", "OrderedList", "UnorderedList", "intellij.markdown.core"})
public final class CreateOrChangeListActionGroup
extends DefaultActionGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isPopup() {
        return true;
    }

    public CreateOrChangeListActionGroup() {
        super(new AnAction[]{(AnAction)new UnorderedList(), (AnAction)new OrderedList(), (AnAction)new CheckmarkList()});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$OrderedList;", "Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$CreateListImpl;", "()V", "createMarkerText", "", "index", "", "isSameMarker", "", "markerElement", "Lcom/intellij/psi/PsiElement;", "intellij.markdown.core"})
    public static final class OrderedList
    extends CreateListImpl {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isSameMarker(@NotNull PsiElement markerElement) {
            Intrinsics.checkNotNullParameter((Object)markerElement, (String)"markerElement");
            if (Companion.hasCheckbox(markerElement)) return false;
            String string = Companion.obtainMarkerText(markerElement);
            if (string == null) return false;
            Integer n = StringsKt.toIntOrNull((String)string);
            if (n == null) return false;
            return true;
        }

        @Override
        @NotNull
        public String createMarkerText(int index) {
            return index + 1 + ".";
        }

        public OrderedList() {
            Supplier<String> supplier = MarkdownBundle.messagePointer("markdown.create.list.popup.ordered.action.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(\"markdown\u2026pup.ordered.action.text\")");
            Icon icon = MarkdownIcons.EditorActions.NumberedList;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MarkdownIcons.EditorActions.NumberedList");
            super(supplier, null, icon, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$UnorderedList;", "Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$CreateListImpl;", "()V", "createMarkerText", "", "index", "", "isSameMarker", "", "markerElement", "Lcom/intellij/psi/PsiElement;", "intellij.markdown.core"})
    public static final class UnorderedList
    extends CreateListImpl {
        @Override
        public boolean isSameMarker(@NotNull PsiElement markerElement) {
            Intrinsics.checkNotNullParameter((Object)markerElement, (String)"markerElement");
            return !Companion.hasCheckbox(markerElement) && Intrinsics.areEqual((Object)Companion.obtainMarkerText(markerElement), (Object)"*");
        }

        @Override
        @NotNull
        public String createMarkerText(int index) {
            return "*";
        }

        public UnorderedList() {
            Supplier<String> supplier = MarkdownBundle.messagePointer("markdown.create.list.popup.unordered.action.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(\"markdown\u2026p.unordered.action.text\")");
            Icon icon = MarkdownIcons.EditorActions.BulletList;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MarkdownIcons.EditorActions.BulletList");
            super(supplier, null, icon, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$CheckmarkList;", "Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$CreateListImpl;", "()V", "createMarkerText", "", "index", "", "isSameMarker", "", "markerElement", "Lcom/intellij/psi/PsiElement;", "processListElement", "originalChild", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "intellij.markdown.core"})
    public static final class CheckmarkList
    extends CreateListImpl {
        @Override
        public boolean isSameMarker(@NotNull PsiElement markerElement) {
            Intrinsics.checkNotNullParameter((Object)markerElement, (String)"markerElement");
            return Companion.hasCheckbox(markerElement);
        }

        @Override
        @NotNull
        public String createMarkerText(int index) {
            return index + 1 + ". [ ]";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PsiElement processListElement(@NotNull MarkdownListItem originalChild, int index) {
            void marker2;
            Intrinsics.checkNotNullParameter((Object)originalChild, (String)"originalChild");
            Pair<PsiElement, PsiElement> pair = MarkdownPsiElementFactory.createListMarkerWithCheckbox(originalChild.getProject(), index + 1 + ".", true);
            PsiElement psiElement = (PsiElement)ExtensionsKt.component1(pair);
            PsiElement checkbox = (PsiElement)ExtensionsKt.component2(pair);
            PsiElement psiElement2 = originalChild.getMarkerElement();
            Intrinsics.checkNotNull((Object)psiElement2);
            PsiElement addedMarker = psiElement2.replace((PsiElement)marker2);
            originalChild.addAfter(checkbox, addedMarker);
            return (PsiElement)originalChild;
        }

        public CheckmarkList() {
            Supplier<String> supplier = MarkdownBundle.messagePointer("markdown.create.list.popup.checkmark.action.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(\"markdown\u2026p.checkmark.action.text\")");
            Icon icon = MarkdownIcons.EditorActions.CheckmarkList;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MarkdownIcons.EditorActions.CheckmarkList");
            super(supplier, null, icon, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 $2\u00020\u0001:\u0001$B5\u0012\u0011\u0010\u0002\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u0012\u0013\b\u0002\u0010\u0006\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0016H\u0016\u00a8\u0006%"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$CreateListImpl;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "text", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "description", "icon", "Ljavax/swing/Icon;", "(Ljava/util/function/Supplier;Ljava/util/function/Supplier;Ljavax/swing/Icon;)V", "createListFromText", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "caret", "Lcom/intellij/openapi/editor/Caret;", "createMarkerText", "index", "", "isSameMarker", "", "markerElement", "Lcom/intellij/psi/PsiElement;", "isSelected", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "processListElement", "originalChild", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "replaceList", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;", "list", "setSelected", "state", "Companion", "intellij.markdown.core"})
    public static abstract class CreateListImpl
    extends ToggleAction {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Project project = event.getProject();
            if (project == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"event.project ?: return");
            Project project2 = project;
            Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor2 == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"event.getData(CommonDataKeys.EDITOR) ?: return");
            Editor editor3 = editor2;
            Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
            if (caret == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"event.getData(CommonDataKeys.CARET) ?: return");
            Caret caret2 = caret;
            Object object = event.getData(CommonDataKeys.PSI_FILE);
            if (!(object instanceof MarkdownFile)) {
                object = null;
            }
            MarkdownFile markdownFile = (MarkdownFile)object;
            if (markdownFile == null) {
                return;
            }
            MarkdownFile file = markdownFile;
            int caretOffset = caret2.getSelectionStart();
            Document document = editor3.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            Document document2 = document;
            MarkdownList list2 = CreateListImpl.Companion.findList(file, document2, caretOffset);
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable(this, project2, state, list2, document2, caret2){
                final /* synthetic */ CreateListImpl this$0;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ boolean $state$inlined;
                final /* synthetic */ MarkdownList $list$inlined;
                final /* synthetic */ Document $document$inlined;
                final /* synthetic */ Caret $caret$inlined;
                {
                    this.this$0 = createListImpl;
                    this.$project$inlined = project;
                    this.$state$inlined = bl;
                    this.$list$inlined = markdownList;
                    this.$document$inlined = document;
                    this.$caret$inlined = caret;
                }

                public final T compute() {
                    boolean bl = false;
                    Project project$iv = this.$project$inlined;
                    String name$iv = null;
                    String groupId$iv = null;
                    boolean $i$f$executeCommand = false;
                    CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this){
                        final /* synthetic */ CreateListImpl$setSelected$$inlined$runWriteAction$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            boolean bl = false;
                            if (this.this$0.$state$inlined && this.this$0.$list$inlined == null) {
                                CreateListImpl.access$createListFromText(this.this$0.this$0, this.this$0.$project$inlined, this.this$0.$document$inlined, this.this$0.$caret$inlined);
                            } else if (this.this$0.$state$inlined && this.this$0.$list$inlined != null) {
                                CreateListImpl.access$replaceList(this.this$0.this$0, this.this$0.$list$inlined);
                            } else if (!this.this$0.$state$inlined && this.this$0.$list$inlined != null) {
                                Companion.access$replaceListWithText(CreateListImpl.Companion, this.this$0.$document$inlined, this.this$0.$list$inlined);
                            }
                        }
                    }, name$iv, (Object)groupId$iv);
                    return (T)Unit.INSTANCE;
                }
            });
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Object object = event.getData(CommonDataKeys.PSI_FILE);
            if (!(object instanceof MarkdownFile)) {
                object = null;
            }
            MarkdownFile markdownFile = (MarkdownFile)object;
            if (markdownFile == null) {
                return false;
            }
            MarkdownFile file = markdownFile;
            Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor2 == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"event.getData(CommonData\u2026s.EDITOR) ?: return false");
            Editor editor3 = editor2;
            CaretModel caretModel = editor3.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            Caret caret = caretModel.getCurrentCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
            int caretOffset = caret.getOffset();
            Document document = editor3.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            Document document2 = document;
            MarkdownList markdownList = CreateListImpl.Companion.findList(file, document2, caretOffset);
            if (markdownList == null) {
                return false;
            }
            MarkdownList list2 = markdownList;
            MarkdownListItem markdownListItem = (MarkdownListItem)CollectionsKt.firstOrNull(ListUtils.INSTANCE.getItems(list2));
            if (markdownListItem == null || (markdownListItem = markdownListItem.getMarkerElement()) == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)markdownListItem, (String)"list.items.firstOrNull()\u2026erElement ?: return false");
            MarkdownListItem marker2 = markdownListItem;
            return this.isSameMarker((PsiElement)marker2);
        }

        public abstract boolean isSameMarker(@NotNull PsiElement var1);

        @NotNull
        public abstract String createMarkerText(int var1);

        @NotNull
        public PsiElement processListElement(@NotNull MarkdownListItem originalChild, int index) {
            Intrinsics.checkNotNullParameter((Object)originalChild, (String)"originalChild");
            PsiElement psiElement = MarkdownPsiElementFactory.createListMarker(originalChild.getProject(), this.createMarkerText(index));
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"MarkdownPsiElementFactor\u2026 createMarkerText(index))");
            PsiElement marker2 = psiElement;
            PsiElement psiElement2 = originalChild.getMarkerElement();
            if (psiElement2 == null) {
                return (PsiElement)originalChild;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"originalChild.markerElem\u2026t ?: return originalChild");
            PsiElement originalMarker = psiElement2;
            if (Companion.hasCheckbox(originalMarker)) {
                PsiElement psiElement3 = originalMarker.getNextSibling();
                if (psiElement3 != null) {
                    psiElement3.delete();
                }
            }
            originalMarker.replace(marker2);
            return (PsiElement)originalChild;
        }

        private final MarkdownList replaceList(MarkdownList list2) {
            MarkdownList markdownList = MarkdownPsiElementFactory.createEmptyList(list2.getProject(), true);
            Intrinsics.checkNotNullExpressionValue((Object)markdownList, (String)"MarkdownPsiElementFactor\u2026yList(list.project, true)");
            MarkdownList resultList = markdownList;
            PsiElement psiElement = list2.getFirstChild();
            if (psiElement == null || (psiElement = PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true)) == null) {
                return list2;
            }
            PsiElement children2 = psiElement;
            int itemIndex = 0;
            for (PsiElement child : children2) {
                PsiElement psiElement2 = child;
                if (psiElement2 instanceof MarkdownListItem) {
                    resultList.add(this.processListElement((MarkdownListItem)child, itemIndex));
                    ++itemIndex;
                    continue;
                }
                resultList.add(child);
            }
            PsiElement psiElement3 = list2.replace((PsiElement)resultList);
            if (psiElement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownList");
            }
            return (MarkdownList)psiElement3;
        }

        private final void createListFromText(Project project, Document document, Caret caret) {
            int startLine = document.getLineNumber(caret.getSelectionStart());
            int endLine = document.getLineNumber(caret.getSelectionEnd());
            CharSequence charSequence = document.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
            CharSequence text = charSequence;
            int n = startLine;
            Sequence lines2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new IntRange(n, endLine))), (Function1)((Function1)new Function1<Integer, String>(text, document){
                final /* synthetic */ CharSequence $text;
                final /* synthetic */ Document $document;

                @NotNull
                public final String invoke(int it) {
                    CharSequence charSequence = this.$text;
                    int n = this.$document.getLineStartOffset(it);
                    int n2 = this.$document.getLineEndOffset(it);
                    return ((Object)charSequence.subSequence(n, n2)).toString();
                }
                {
                    this.$text = charSequence;
                    this.$document = document;
                    super(1);
                }
            }));
            Function1 function1 = (Function1)new Function1<Integer, String>(this){

                @NotNull
                public final String invoke(int p1) {
                    return ((CreateListImpl)((Object)this.receiver)).createMarkerText(p1);
                }
            };
            MarkdownList markdownList = MarkdownPsiElementFactory.createList(project, SequencesKt.asIterable((Sequence)lines2), new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)markdownList, (String)"MarkdownPsiElementFactor\u2026le(), ::createMarkerText)");
            MarkdownList list2 = markdownList;
            document.replaceString(document.getLineStartOffset(startLine), document.getLineEndOffset(endLine), (CharSequence)list2.getText());
        }

        public CreateListImpl(@NotNull Supplier<String> text, @NotNull Supplier<String> description, @NotNull Icon icon) {
            Intrinsics.checkNotNullParameter(text, (String)"text");
            Intrinsics.checkNotNullParameter(description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            super(text, description, icon);
        }

        public /* synthetic */ CreateListImpl(Supplier supplier, Supplier supplier2, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                supplier2 = supplier;
            }
            this(supplier, supplier2, icon);
        }

        public static final /* synthetic */ void access$createListFromText(CreateListImpl $this, Project project, Document document, Caret caret) {
            $this.createListFromText(project, document, caret);
        }

        public static final /* synthetic */ MarkdownList access$replaceList(CreateListImpl $this, MarkdownList list2) {
            return $this.replaceList(list2);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$CreateListImpl$Companion;", "", "()V", "findList", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "replaceListWithText", "", "list", "intellij.markdown.core"})
        public static final class Companion {
            private final MarkdownList findList(MarkdownFile file, Document document, int offset) {
                MarkdownListItem markdownListItem = ListUtils.INSTANCE.getListItemAt(file, offset, document);
                return markdownListItem != null ? ListUtils.INSTANCE.getList(markdownListItem) : null;
            }

            private final void replaceListWithText(Document document, MarkdownList list2) {
                TextRange range;
                MarkdownListItem markdownListItem = (MarkdownListItem)CollectionsKt.firstOrNull(ListUtils.INSTANCE.getItems(list2));
                if (markdownListItem == null) {
                    return;
                }
                MarkdownListItem firstItem = markdownListItem;
                StringBuilder builder = new StringBuilder();
                for (PsiElement element2 : PsiTreeUtilKt.siblings$default((PsiElement)((PsiElement)firstItem), (boolean)true, (boolean)false, (int)2, null)) {
                    String string;
                    PsiElement psiElement = element2;
                    if (psiElement instanceof MarkdownListItem) {
                        string = ((MarkdownListItem)element2).getItemText();
                        if (string == null) {
                            string = "";
                        }
                    } else {
                        string = element2.getText();
                    }
                    String text = string;
                    builder.append(text);
                }
                TextRange textRange = range = list2.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
                document.replaceString(textRange.getStartOffset(), range.getEndOffset(), (CharSequence)builder.toString());
            }

            private Companion() {
            }

            public static final /* synthetic */ void access$replaceListWithText(Companion $this, Document document, MarkdownList list2) {
                $this.replaceListWithText(document, list2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/CreateOrChangeListActionGroup$Companion;", "", "()V", "hasCheckbox", "", "element", "Lcom/intellij/psi/PsiElement;", "obtainMarkerText", "", "markerElement", "intellij.markdown.core"})
    public static final class Companion {
        private final String obtainMarkerText(PsiElement markerElement) {
            String string = markerElement.getText();
            return string != null ? StringsKt.trimEnd((String)string, (char[])new char[]{'.', ')', ' '}) : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasCheckbox(PsiElement element2) {
            PsiElement psiElement = element2.getNextSibling();
            if (psiElement == null) return false;
            IElementType iElementType = MarkdownTokenTypes.CHECK_BOX;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.CHECK_BOX");
            if (!PsiUtilsKt.hasType(psiElement, iElementType)) return false;
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

