/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.jcef;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Base64;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.intellij.plugins.markdown.ui.preview.jcef.HtmlResourceSavingSettings;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u000fJ\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u001c\u0010\u0019\u001a\u000e\u0018\u00010\u0003\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0011H\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0011H\u0002R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/HtmlExporter;", "", "htmlSource", "", "savingSettings", "Lorg/intellij/plugins/markdown/ui/preview/jcef/HtmlResourceSavingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "targetFile", "Ljava/io/File;", "(Ljava/lang/String;Lorg/intellij/plugins/markdown/ui/preview/jcef/HtmlResourceSavingSettings;Lcom/intellij/openapi/project/Project;Ljava/io/File;)V", "document", "Lorg/jsoup/nodes/Document;", "kotlin.jvm.PlatformType", "appendInlineStylesContent", "", "styles", "Lorg/jsoup/select/Elements;", "encodeImage", "url", "bytes", "", "export", "getImgUriWithProtocol", "imgSrc", "getRelativeImagePath", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/util/NlsSafe;", "resDir", "getResource", "getSavedImageFile", "imgUrl", "getStyleContent", "linkElement", "Lorg/jsoup/nodes/Element;", "inlineImagesContent", "images", "saveImages", "intellij.markdown.core"})
public final class HtmlExporter {
    private final Document document;
    private final HtmlResourceSavingSettings savingSettings;
    private final Project project;
    private final File targetFile;

    public final void export() {
        Element element2;
        Element $this$with = element2 = this.document.head();
        boolean bl = false;
        $this$with.getElementsByTag("script").remove();
        $this$with.getElementsByTag("meta").remove();
        Elements elements2 = $this$with.select("link[rel=\"stylesheet\"]");
        Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"select(\"link[rel=\\\"stylesheet\\\"]\")");
        this.appendInlineStylesContent(elements2);
        Elements images = this.document.body().getElementsByTag("img");
        if (this.savingSettings.isSaved()) {
            Elements elements3 = images;
            Intrinsics.checkNotNullExpressionValue((Object)elements3, (String)"images");
            this.saveImages(elements3);
        } else {
            Elements elements4 = images;
            Intrinsics.checkNotNullExpressionValue((Object)elements4, (String)"images");
            this.inlineImagesContent(elements4);
        }
        String string = this.document.html();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.html()");
        FilesKt.writeText$default((File)this.targetFile, (String)string, null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendInlineStylesContent(Elements styles) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)styles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Element element2;
            String content2;
            Element element3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Element it = (Element)element$iv$iv;
            boolean bl2 = false;
            Element element4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)element4, (String)"it");
            Element element5 = this.getStyleContent(element4) == null ? null : (element3 = new Element("style").text(content2));
            if (element3 == null) continue;
            Element it$iv$iv = element2 = element3;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List inlinedStyles = (List)destination$iv$iv;
        styles.remove();
        Iterable $this$forEach$iv = inlinedStyles;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            if (!it.hasText()) continue;
            this.document.head().appendChild((Node)it);
        }
    }

    private final String getStyleContent(Element linkElement) {
        String string;
        String string2 = linkElement.attr("href");
        if (string2 == null) {
            return null;
        }
        String url = string2;
        try {
            string = HttpRequests.request((String)url).readString();
        }
        catch (IOException exception) {
            String name = new File(url).getName();
            String string3 = MarkdownBundle.message("markdown.export.style.not.found.msg", name);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MarkdownBundle.message(\"\u2026yle.not.found.msg\", name)");
            MarkdownNotifications.showWarning$default(MarkdownNotifications.INSTANCE, this.project, "markdown.export.html.missing.style", null, string3, 4, null);
            string = null;
        }
        return string;
    }

    private final void inlineImagesContent(Elements images) {
        Iterable $this$forEach$iv = (Iterable)images;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CharSequence charSequence;
            Element it = (Element)element$iv;
            boolean bl = false;
            String string = it.attr("src");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.attr(\"src\")");
            String imgSrc = this.getImgUriWithProtocol(string);
            byte[] content2 = this.getResource(imgSrc);
            if (content2 == null || !((charSequence = (CharSequence)imgSrc).length() > 0)) continue;
            it.attr("src", this.encodeImage(imgSrc, content2));
        }
    }

    private final String encodeImage(String url, byte[] bytes) {
        CharSequence extension = FileUtil.getExtension((CharSequence)url, (String)"png");
        CharSequence contentType = Intrinsics.areEqual((Object)extension, (Object)"svg") ? (CharSequence)"svg+xml" : extension;
        return "data:image/" + contentType + ";base64, " + Base64.encode((byte[])bytes);
    }

    private final void saveImages(Elements images) {
        Iterable $this$forEach$iv = (Iterable)images;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CharSequence charSequence;
            String imgSrc;
            Element it = (Element)element$iv;
            boolean bl = false;
            String string = imgSrc = it.attr("src");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imgSrc");
            String imgUri = this.getImgUriWithProtocol(string);
            byte[] content2 = this.getResource(imgUri);
            if (content2 == null || !((charSequence = (CharSequence)imgSrc).length() > 0)) continue;
            File savedImgFile = this.getSavedImageFile(this.savingSettings.getResourceDir(), imgSrc);
            FileUtil.createIfDoesntExist((File)savedImgFile);
            FilesKt.writeBytes((File)savedImgFile, (byte[])content2);
            String relativeImgPath = this.getRelativeImagePath(this.savingSettings.getResourceDir());
            it.attr("src", FileUtil.join((String[])new String[]{relativeImgPath, new File(imgSrc).getName()}));
        }
    }

    private final String getImgUriWithProtocol(String imgSrc) {
        String string;
        if (StringsKt.startsWith$default((String)imgSrc, (String)"file:", (boolean)false, (int)2, null)) {
            string = imgSrc;
        } else {
            String string2 = new File(imgSrc).toURI().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"File(imgSrc).toURI().toString()");
        }
        return string;
    }

    private final byte[] getResource(String url) {
        byte[] byArray;
        try {
            byArray = HttpRequests.request((String)url).readBytes(null);
        }
        catch (IOException exception) {
            String name = new File(url).getName();
            String string = MarkdownBundle.message("markdown.export.images.not.found.msg", name);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026ges.not.found.msg\", name)");
            MarkdownNotifications.showWarning$default(MarkdownNotifications.INSTANCE, this.project, "markdown.export.html.missing.image", null, string, 4, null);
            byArray = null;
        }
        return byArray;
    }

    private final File getSavedImageFile(String resDir, String imgUrl) {
        return new File(FileUtil.join((String[])new String[]{resDir, new File(imgUrl).getName()}));
    }

    private final String getRelativeImagePath(String resDir) {
        return FileUtil.getRelativePath((File)this.targetFile.getParentFile(), (File)new File(resDir));
    }

    public HtmlExporter(@NotNull String htmlSource, @NotNull HtmlResourceSavingSettings savingSettings, @NotNull Project project, @NotNull File targetFile) {
        Intrinsics.checkNotNullParameter((Object)htmlSource, (String)"htmlSource");
        Intrinsics.checkNotNullParameter((Object)savingSettings, (String)"savingSettings");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        this.savingSettings = savingSettings;
        this.project = project;
        this.targetFile = targetFile;
        this.document = Jsoup.parse((String)htmlSource);
    }
}

