/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/debugger/streams/resolve/PrependResolver;", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver;", "()V", "resolve", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver$Result;", "info", "Lcom/intellij/debugger/streams/trace/TraceInfo;", "intellij.java.debugger.streams"})
public final class PrependResolver
implements ValuesOrderResolver {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Map direct = new LinkedHashMap();
        Map reverse = new LinkedHashMap();
        List<TraceElement> valuesBefore = TraceUtil.sortedByTime(info.getValuesOrderBefore().values());
        List<TraceElement> valuesAfter = TraceUtil.sortedByTime(info.getValuesOrderAfter().values());
        List<TraceElement> list2 = valuesBefore;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"valuesBefore");
        Collection collection = list2;
        if (!collection.isEmpty()) {
            int indexOfFirstItemFromSource;
            block5: {
                int n;
                TraceElement firstBefore = (TraceElement)CollectionsKt.first(valuesBefore);
                List<TraceElement> list3 = valuesAfter;
                Intrinsics.checkNotNullExpressionValue(list3, (String)"valuesAfter");
                List<TraceElement> $this$indexOfFirst$iv = list3;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<TraceElement> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    TraceElement item$iv;
                    TraceElement it = item$iv = iterator.next();
                    boolean bl = false;
                    TraceElement traceElement = it;
                    Intrinsics.checkNotNullExpressionValue((Object)traceElement, (String)"it");
                    int n2 = traceElement.getTime();
                    TraceElement traceElement2 = firstBefore;
                    Intrinsics.checkNotNullExpressionValue((Object)traceElement2, (String)"firstBefore");
                    if (n2 > traceElement2.getTime()) {
                        n = index$iv;
                        break block5;
                    }
                    int n3 = index$iv;
                    index$iv = n3 + 1;
                }
                n = indexOfFirstItemFromSource = -1;
            }
            if (indexOfFirstItemFromSource != -1) {
                for (Pair pair : CollectionsKt.zip((Iterable)valuesBefore, (Iterable)valuesAfter.subList(indexOfFirstItemFromSource, valuesAfter.size()))) {
                    void before;
                    TraceElement index$iv = (TraceElement)pair.component1();
                    TraceElement after = (TraceElement)pair.component2();
                    void v6 = before;
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"before");
                    Object[] objectArray = new TraceElement[1];
                    TraceElement traceElement = after;
                    Intrinsics.checkNotNullExpressionValue((Object)traceElement, (String)"after");
                    objectArray[0] = traceElement;
                    direct.put(v6, CollectionsKt.mutableListOf((Object[])objectArray));
                    reverse.put(after, CollectionsKt.mutableListOf((Object[])new TraceElement[]{before}));
                }
            }
        }
        ValuesOrderResolver.Result result = ValuesOrderResolver.Result.of(direct, reverse);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"ValuesOrderResolver.Result.of(direct, reverse)");
        return result;
    }
}

