/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.BoxSelectionListener;
import com.android.tools.adtui.model.BoxSelectionModel;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultTimeline;
import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.event.EventModel;
import com.android.tools.adtui.model.event.LifecycleEventModel;
import com.android.tools.adtui.model.event.UserEvent;
import com.android.tools.adtui.model.trackgroup.TrackGroupActionListener;
import com.android.tools.adtui.model.trackgroup.TrackGroupModel;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.EventStreamServer;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.ProfilerTrackRendererType;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.CaptureThreadComparator;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureHandler;
import com.android.tools.profilers.cpu.CpuCaptureMinimapModel;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadTrackModel;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import com.android.tools.profilers.cpu.analysis.CpuFullTraceAnalysisModel;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.systemtrace.BufferQueueTooltip;
import com.android.tools.profilers.cpu.systemtrace.BufferQueueTrackModel;
import com.android.tools.profilers.cpu.systemtrace.CpuCoreTrackModel;
import com.android.tools.profilers.cpu.systemtrace.CpuFrameTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuFramesModel;
import com.android.tools.profilers.cpu.systemtrace.CpuFrequencyTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuFrequencyTrackModel;
import com.android.tools.profilers.cpu.systemtrace.CpuKernelTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuSystemTraceData;
import com.android.tools.profilers.cpu.systemtrace.CpuThreadSliceInfo;
import com.android.tools.profilers.cpu.systemtrace.RssMemoryTooltip;
import com.android.tools.profilers.cpu.systemtrace.RssMemoryTrackModel;
import com.android.tools.profilers.cpu.systemtrace.SurfaceflingerTooltip;
import com.android.tools.profilers.cpu.systemtrace.SurfaceflingerTrackModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceCpuCapture;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrame;
import com.android.tools.profilers.cpu.systemtrace.VsyncTooltip;
import com.android.tools.profilers.cpu.systemtrace.VsyncTrackModel;
import com.android.tools.profilers.event.LifecycleEventDataSeries;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.UserEventDataSeries;
import com.android.tools.profilers.event.UserEventTooltip;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureStage
extends Stage<Timeline> {
    private final CpuCaptureHandler myCpuCaptureHandler;
    private final AspectModel<Aspect> myAspect;
    private final List<CpuAnalysisModel> myAnalysisModels;
    private final List<TrackGroupModel> myTrackGroupModels;
    private final MultiSelectionModel<CpuAnalyzable> myMultiSelectionModel;
    private CpuCaptureMinimapModel myMinimapModel;
    private State myState;
    private CpuCapture myCapture;
    private final Timeline myTrackGroupTimeline;

    @NotNull
    public static File saveCapture(long traceId, ByteString data) {
        File file;
        try {
            File trace = FileUtil.createTempFile((String)String.format(Locale.US, "cpu_trace_%d", traceId), (String)".trace", (boolean)true);
            try (FileOutputStream out = new FileOutputStream(trace);){
                out.write(data.toByteArray());
            }
            file = trace;
        }
        catch (IOException io) {
            throw new IllegalStateException("Unable to save trace to disk");
        }
        if (file == null) {
            CpuCaptureStage.$$$reportNull$$$0(0);
        }
        return file;
    }

    @Nullable
    private static File getAndSaveCapture(@NotNull StudioProfilers profilers, long traceId) {
        if (profilers == null) {
            CpuCaptureStage.$$$reportNull$$$0(1);
        }
        Transport.BytesRequest traceRequest = Transport.BytesRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setId(String.valueOf(traceId)).build();
        Transport.BytesResponse traceResponse = profilers.getClient().getTransportClient().getBytes(traceRequest);
        if (!traceResponse.getContents().isEmpty()) {
            return CpuCaptureStage.saveCapture(traceId, traceResponse.getContents());
        }
        return null;
    }

    @Nullable
    public static CpuCaptureStage create(@NotNull StudioProfilers profilers, @NotNull ProfilingConfiguration configuration, long traceId) {
        File captureFile;
        if (profilers == null) {
            CpuCaptureStage.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            CpuCaptureStage.$$$reportNull$$$0(3);
        }
        if ((captureFile = CpuCaptureStage.getAndSaveCapture(profilers, traceId)) == null) {
            return null;
        }
        String captureProcessNameHint = CpuProfiler.getTraceInfoFromId(profilers, traceId).getConfiguration().getAppName();
        return new CpuCaptureStage(profilers, configuration, captureFile, traceId, captureProcessNameHint, profilers.getSession().getPid());
    }

    @NotNull
    public static CpuCaptureStage create(@NotNull StudioProfilers profilers, @NotNull ProfilingConfiguration configuration, @NotNull File captureFile, long sessionId) {
        if (profilers == null) {
            CpuCaptureStage.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            CpuCaptureStage.$$$reportNull$$$0(5);
        }
        if (captureFile == null) {
            CpuCaptureStage.$$$reportNull$$$0(6);
        }
        return new CpuCaptureStage(profilers, configuration, captureFile, sessionId, null, 0);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public CpuCaptureStage(@NotNull StudioProfilers profilers, @NotNull ProfilingConfiguration configuration, @NotNull File captureFile, long traceId, @Nullable String captureProcessNameHint, int n) {
        void captureProcessIdHint;
        if (profilers == null) {
            CpuCaptureStage.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            CpuCaptureStage.$$$reportNull$$$0(8);
        }
        if (captureFile == null) {
            CpuCaptureStage.$$$reportNull$$$0(9);
        }
        super(profilers);
        this.myAspect = new AspectModel();
        this.myAnalysisModels = new ArrayList<CpuAnalysisModel>();
        this.myTrackGroupModels = new ArrayList<TrackGroupModel>();
        this.myMultiSelectionModel = new MultiSelectionModel();
        this.myState = State.PARSING;
        this.myTrackGroupTimeline = new DefaultTimeline();
        this.myCpuCaptureHandler = new CpuCaptureHandler(profilers.getIdeServices(), captureFile, traceId, configuration, captureProcessNameHint, (int)captureProcessIdHint);
    }

    public State getState() {
        return this.myState;
    }

    @NotNull
    public AspectModel<Aspect> getAspect() {
        AspectModel<Aspect> aspectModel = this.myAspect;
        if (aspectModel == null) {
            CpuCaptureStage.$$$reportNull$$$0(10);
        }
        return aspectModel;
    }

    @NotNull
    public CpuCaptureHandler getCaptureHandler() {
        CpuCaptureHandler cpuCaptureHandler = this.myCpuCaptureHandler;
        if (cpuCaptureHandler == null) {
            CpuCaptureStage.$$$reportNull$$$0(11);
        }
        return cpuCaptureHandler;
    }

    @NotNull
    public List<TrackGroupModel> getTrackGroupModels() {
        List<TrackGroupModel> list = this.myTrackGroupModels;
        if (list == null) {
            CpuCaptureStage.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public MultiSelectionModel<CpuAnalyzable> getMultiSelectionModel() {
        MultiSelectionModel<CpuAnalyzable> multiSelectionModel = this.myMultiSelectionModel;
        if (multiSelectionModel == null) {
            CpuCaptureStage.$$$reportNull$$$0(13);
        }
        return multiSelectionModel;
    }

    @NotNull
    public CpuCaptureMinimapModel getMinimapModel() {
        assert (this.myState == State.ANALYZING);
        CpuCaptureMinimapModel cpuCaptureMinimapModel = this.myMinimapModel;
        if (cpuCaptureMinimapModel == null) {
            CpuCaptureStage.$$$reportNull$$$0(14);
        }
        return cpuCaptureMinimapModel;
    }

    @NotNull
    public List<CpuAnalysisModel> getAnalysisModels() {
        List<CpuAnalysisModel> list = this.myAnalysisModels;
        if (list == null) {
            CpuCaptureStage.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public Timeline getCaptureTimeline() {
        Timeline timeline = this.getCapture().getTimeline();
        if (timeline == null) {
            CpuCaptureStage.$$$reportNull$$$0(16);
        }
        return timeline;
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        Timeline timeline = this.myTrackGroupTimeline;
        if (timeline == null) {
            CpuCaptureStage.$$$reportNull$$$0(17);
        }
        return timeline;
    }

    private void setState(State state) {
        this.myState = state;
        this.myAspect.changed((Enum)Aspect.STATE);
    }

    @NotNull
    public CpuCapture getCapture() {
        assert (this.myState == State.ANALYZING);
        CpuCapture cpuCapture = this.myCapture;
        if (cpuCapture == null) {
            CpuCaptureStage.$$$reportNull$$$0(18);
        }
        return cpuCapture;
    }

    @Override
    public void enter() {
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuCaptureHandler);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getStageType());
        this.myCpuCaptureHandler.parse(capture -> {
            try {
                if (capture == null) {
                    if (this.getStudioProfilers().getSessionsManager().isSessionAlive()) {
                        this.getStudioProfilers().getIdeServices().getMainExecutor().execute(() -> this.getStudioProfilers().setStage(this.getParentStage()));
                    } else {
                        this.getStudioProfilers().getIdeServices().getMainExecutor().execute(() -> this.getStudioProfilers().setStage(new NullMonitorStage(this.getStudioProfilers(), "The profiler was unable to parse the trace file. Please make sure the file selected is a valid trace.")));
                    }
                } else {
                    this.myCapture = capture;
                    this.onCaptureParsed((CpuCapture)capture);
                    this.setState(State.ANALYZING);
                }
            }
            catch (Exception ex) {
                Logger.getInstance(CpuCaptureStage.class).error((Throwable)ex);
            }
        });
    }

    @Override
    public void exit() {
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuCaptureHandler);
    }

    @Override
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.CPU_CAPTURE_STAGE;
    }

    public void addCpuAnalysisModel(@NotNull CpuAnalysisModel model) {
        if (model == null) {
            CpuCaptureStage.$$$reportNull$$$0(19);
        }
        this.myAnalysisModels.add(model);
        this.myAspect.changed((Enum)Aspect.ANALYSIS_MODEL_UPDATED);
    }

    @Override
    @NotNull
    public Stage<?> getParentStage() {
        return new CpuProfilerStage(this.getStudioProfilers());
    }

    @Override
    @NotNull
    public Class<? extends Stage<?>> getHomeStageClass() {
        return CpuProfilerStage.class;
    }

    public void removeCpuAnalysisModel(int index) {
        this.myAnalysisModels.remove(index);
        this.myAspect.changed((Enum)Aspect.ANALYSIS_MODEL_UPDATED);
    }

    private void onCaptureParsed(@NotNull CpuCapture capture) {
        if (capture == null) {
            CpuCaptureStage.$$$reportNull$$$0(20);
        }
        this.myTrackGroupTimeline.getDataRange().set(capture.getRange());
        this.myMinimapModel = new CpuCaptureMinimapModel(this.getStudioProfilers(), capture, this.getTimeline().getViewRange());
        this.initTrackGroupList(capture);
        this.addCpuAnalysisModel(new CpuFullTraceAnalysisModel(capture, this.getTimeline().getViewRange()));
        if (this.getStudioProfilers().getSession().getPid() == 0) {
            this.insertImportedTraceEvent(capture);
        }
    }

    private void insertImportedTraceEvent(@NotNull CpuCapture capture) {
        if (capture == null) {
            CpuCaptureStage.$$$reportNull$$$0(21);
        }
        Cpu.CpuTraceInfo importedTraceInfo = Cpu.CpuTraceInfo.newBuilder().setTraceId(this.getStudioProfilers().getSession().getSessionId()).setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMax())).setConfiguration(Cpu.CpuTraceConfiguration.newBuilder().setUserOptions(Cpu.CpuTraceConfiguration.UserOptions.newBuilder().setTraceType(capture.getType()))).build();
        EventStreamServer streamServer = this.getStudioProfilers().getSessionsManager().getEventStreamServer(this.getStudioProfilers().getSession().getStreamId());
        if (streamServer != null) {
            streamServer.getEventDeque().offer(Common.Event.newBuilder().setGroupId(importedTraceInfo.getTraceId()).setTimestamp(importedTraceInfo.getToTimestamp()).setIsEnded(true).setKind(Common.Event.Kind.CPU_TRACE).setCpuTrace(Cpu.CpuTraceData.newBuilder().setTraceEnded(Cpu.CpuTraceData.TraceEnded.newBuilder().setTraceInfo(importedTraceInfo))).build());
        }
    }

    private void initTrackGroupList(@NotNull CpuCapture capture) {
        if (capture == null) {
            CpuCaptureStage.$$$reportNull$$$0(22);
        }
        this.myTrackGroupModels.clear();
        final FeatureTracker featureTracker = this.getStudioProfilers().getIdeServices().getFeatureTracker();
        if (this.getStudioProfilers().getSession().getPid() != 0) {
            this.myTrackGroupModels.add(CpuCaptureStage.createInteractionTrackGroup(this.getStudioProfilers(), this.getTimeline()));
        }
        if (capture.getSystemTraceData() != null) {
            this.myTrackGroupModels.add(CpuCaptureStage.createDisplayTrackGroup(capture.getMainThreadId(), capture.getSystemTraceData(), this.getTimeline()));
            this.myTrackGroupModels.add(CpuCaptureStage.createCpuCoresTrackGroup(capture.getMainThreadId(), capture.getSystemTraceData(), this.getTimeline()));
            this.myTrackGroupModels.add(CpuCaptureStage.createRssMemoryTrackGroup(capture.getSystemTraceData(), this.getTimeline()));
        }
        this.myTrackGroupModels.add(CpuCaptureStage.createThreadsTrackGroup(capture, this.getTimeline(), this.getMultiSelectionModel(), featureTracker));
        this.myTrackGroupModels.forEach(model -> model.addActionListener(new TrackGroupActionListener(){

            public void onGroupMovedUp(@NotNull String title) {
                if (title == null) {
                    1.$$$reportNull$$$0(0);
                }
                featureTracker.trackMoveTrackGroupUp(title);
            }

            public void onGroupMovedDown(@NotNull String title) {
                if (title == null) {
                    1.$$$reportNull$$$0(1);
                }
                featureTracker.trackMoveTrackGroupDown(title);
            }

            public void onGroupCollapsed(@NotNull String title) {
                if (title == null) {
                    1.$$$reportNull$$$0(2);
                }
                featureTracker.trackCollapseTrackGroup(title);
            }

            public void onGroupExpanded(@NotNull String title) {
                if (title == null) {
                    1.$$$reportNull$$$0(3);
                }
                featureTracker.trackExpandTrackGroup(title);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "title";
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureStage$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onGroupMovedUp";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onGroupMovedDown";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onGroupCollapsed";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onGroupExpanded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    private static TrackGroupModel createInteractionTrackGroup(@NotNull StudioProfilers studioProfilers, @NotNull Timeline timeline) {
        if (studioProfilers == null) {
            CpuCaptureStage.$$$reportNull$$$0(23);
        }
        if (timeline == null) {
            CpuCaptureStage.$$$reportNull$$$0(24);
        }
        TrackGroupModel interaction = TrackGroupModel.newBuilder().setTitle("Interaction").build();
        EventModel userEventEventModel = new EventModel(new RangedSeries(timeline.getViewRange(), (DataSeries)new UserEventDataSeries(studioProfilers)));
        LifecycleEventModel lifecycleEventModel = new LifecycleEventModel(new RangedSeries(timeline.getViewRange(), (DataSeries)new LifecycleEventDataSeries(studioProfilers, false)), new RangedSeries(timeline.getViewRange(), (DataSeries)new LifecycleEventDataSeries(studioProfilers, true)));
        interaction.addTrackModel(TrackModel.newBuilder((Object)userEventEventModel, (Enum)ProfilerTrackRendererType.USER_INTERACTION, (String)"User").setDefaultTooltipModel((TooltipModel)new UserEventTooltip(timeline, (EventModel<UserEvent>)userEventEventModel)));
        interaction.addTrackModel(TrackModel.newBuilder((Object)lifecycleEventModel, (Enum)ProfilerTrackRendererType.APP_LIFECYCLE, (String)"Lifecycle").setDefaultTooltipModel((TooltipModel)new LifecycleTooltip(timeline, lifecycleEventModel)));
        return interaction;
    }

    private static TrackGroupModel createDisplayTrackGroup(int mainThreadId, @NotNull CpuSystemTraceData systemTraceData, @NotNull Timeline timeline) {
        if (systemTraceData == null) {
            CpuCaptureStage.$$$reportNull$$$0(25);
        }
        if (timeline == null) {
            CpuCaptureStage.$$$reportNull$$$0(26);
        }
        TrackGroupModel display = TrackGroupModel.newBuilder().setTitle("Display").setTitleHelpText("This section contains display info. <p><b>Frames</b>: when a frame is being drawn. Long frames are colored red.</p><p><b>SurfaceFlinger</b>: system process responsible for sending buffers to display.</p><p><b>VSYNC</b>: a signal that synchronizes the display pipeline.</p><p><b>BufferQueue</b>: how many frame buffers are queued up, waiting for SurfaceFlinger to consume.</p>").setTitleHelpLink("Learn more", "https://source.android.com/devices/graphics").build();
        CpuFramesModel.FrameState mainFrames = new CpuFramesModel.FrameState("Main", mainThreadId, SystemTraceFrame.FrameThread.MAIN, systemTraceData, timeline.getViewRange());
        CpuFrameTooltip mainFrameTooltip = new CpuFrameTooltip(timeline);
        mainFrameTooltip.setFrameSeries(mainFrames.getSeries());
        display.addTrackModel(TrackModel.newBuilder((Object)mainFrames, (Enum)ProfilerTrackRendererType.FRAMES, (String)"Frames").setDefaultTooltipModel((TooltipModel)mainFrameTooltip));
        SurfaceflingerTrackModel sfModel = new SurfaceflingerTrackModel(systemTraceData, timeline.getViewRange());
        SurfaceflingerTooltip sfTooltip = new SurfaceflingerTooltip(timeline, sfModel.getSurfaceflingerEvents());
        display.addTrackModel(TrackModel.newBuilder((Object)((Object)sfModel), (Enum)ProfilerTrackRendererType.SURFACEFLINGER, (String)"SurfaceFlinger").setDefaultTooltipModel((TooltipModel)sfTooltip));
        VsyncTrackModel vsyncModel = new VsyncTrackModel(systemTraceData, timeline.getViewRange());
        VsyncTooltip vsyncTooltip = new VsyncTooltip(timeline, (RangedSeries<Long>)vsyncModel.getVsyncCounterSeries());
        display.addTrackModel(TrackModel.newBuilder((Object)((Object)vsyncModel), (Enum)ProfilerTrackRendererType.VSYNC, (String)"VSYNC").setDefaultTooltipModel((TooltipModel)vsyncTooltip));
        BufferQueueTrackModel bufferQueueTrackModel = new BufferQueueTrackModel(systemTraceData, timeline.getViewRange());
        BufferQueueTooltip bufferQueueTooltip = new BufferQueueTooltip(timeline, (RangedSeries<Long>)bufferQueueTrackModel.getBufferQueueSeries());
        display.addTrackModel(TrackModel.newBuilder((Object)((Object)bufferQueueTrackModel), (Enum)ProfilerTrackRendererType.BUFFER_QUEUE, (String)"BufferQueue").setDefaultTooltipModel((TooltipModel)bufferQueueTooltip));
        return display;
    }

    private static TrackGroupModel createThreadsTrackGroup(@NotNull CpuCapture capture, @NotNull Timeline timeline, @NotNull MultiSelectionModel<CpuAnalyzable> multiSelectionModel, final @NotNull FeatureTracker featureTracker) {
        if (capture == null) {
            CpuCaptureStage.$$$reportNull$$$0(27);
        }
        if (timeline == null) {
            CpuCaptureStage.$$$reportNull$$$0(28);
        }
        if (multiSelectionModel == null) {
            CpuCaptureStage.$$$reportNull$$$0(29);
        }
        if (featureTracker == null) {
            CpuCaptureStage.$$$reportNull$$$0(30);
        }
        boolean collapseThreads = !(capture instanceof SystemTraceCpuCapture);
        List threadInfos = capture.getThreads().stream().sorted(new CaptureThreadComparator(capture)).collect(Collectors.toList());
        String threadsTitle = String.format(Locale.getDefault(), "Threads (%d)", threadInfos.size());
        BoxSelectionModel boxSelectionModel = new BoxSelectionModel(timeline.getSelectionRange(), timeline.getViewRange());
        boxSelectionModel.addBoxSelectionListener(new BoxSelectionListener(){

            public void boxSelectionCreated(long durationUs, int trackCount) {
                featureTracker.trackSelectBox(durationUs, trackCount);
            }
        });
        TrackGroupModel threads = TrackGroupModel.newBuilder().setTitle(threadsTitle).setTitleHelpText("This section contains thread info. Double-click on the thread name to expand/collapse. Shift+click to select multiple threads.").setTrackSelectable(true).setBoxSelectionModel(boxSelectionModel).build();
        for (CpuThreadInfo threadInfo : threadInfos) {
            String title = threadInfo.getName();
            threads.addTrackModel(TrackModel.newBuilder((Object)new CpuThreadTrackModel(capture, threadInfo, timeline, multiSelectionModel), (Enum)ProfilerTrackRendererType.CPU_THREAD, (String)title).setCollapsible(true).setCollapsed(collapseThreads));
        }
        return threads;
    }

    private static TrackGroupModel createCpuCoresTrackGroup(int mainThreadId, @NotNull CpuSystemTraceData systemTraceData, @NotNull Timeline timeline) {
        if (systemTraceData == null) {
            CpuCaptureStage.$$$reportNull$$$0(31);
        }
        if (timeline == null) {
            CpuCaptureStage.$$$reportNull$$$0(32);
        }
        int cpuCount = systemTraceData.getCpuCount();
        String coresTitle = String.format(Locale.getDefault(), "CPU cores (%d)", cpuCount);
        TrackGroupModel cores = TrackGroupModel.newBuilder().setTitle(coresTitle).setCollapsedInitially(true).build();
        for (int cpuId = 0; cpuId < cpuCount; ++cpuId) {
            int coreId = cpuId;
            LazyDataSeries<CpuThreadSliceInfo> coreSchedSeries = new LazyDataSeries<CpuThreadSliceInfo>(() -> systemTraceData.getCpuThreadSliceInfoStates(coreId));
            CpuKernelTooltip kernelTooltip = new CpuKernelTooltip(timeline, mainThreadId);
            kernelTooltip.setCpuSeries(cpuId, coreSchedSeries);
            cores.addTrackModel(TrackModel.newBuilder((Object)new CpuCoreTrackModel(coreSchedSeries, timeline.getViewRange(), mainThreadId), (Enum)ProfilerTrackRendererType.CPU_CORE, (String)("CPU " + cpuId)).setDefaultTooltipModel((TooltipModel)kernelTooltip));
            String cpuFrequencyTitle = "CPU " + cpuId + " Frequency";
            List cpuFreqCounters = systemTraceData.getCpuCounters().get(cpuId).getOrDefault("cpufreq", Collections.emptyList());
            CpuFrequencyTrackModel cpuFreqTrackModel = new CpuFrequencyTrackModel(cpuFreqCounters, timeline.getViewRange());
            CpuFrequencyTooltip cpuFreqTooltip = new CpuFrequencyTooltip(timeline, cpuId, (RangedSeries<Long>)cpuFreqTrackModel.getCpuFrequencySeries());
            cores.addTrackModel(TrackModel.newBuilder((Object)((Object)cpuFreqTrackModel), (Enum)ProfilerTrackRendererType.CPU_FREQUENCY, (String)cpuFrequencyTitle).setDefaultTooltipModel((TooltipModel)cpuFreqTooltip));
        }
        return cores;
    }

    private static TrackGroupModel createRssMemoryTrackGroup(@NotNull CpuSystemTraceData systemTraceData, @NotNull Timeline timeline) {
        if (systemTraceData == null) {
            CpuCaptureStage.$$$reportNull$$$0(33);
        }
        if (timeline == null) {
            CpuCaptureStage.$$$reportNull$$$0(34);
        }
        TrackGroupModel memory = TrackGroupModel.newBuilder().setTitle("Process Memory (RSS)").setTitleHelpText("This section shows the memory footprint of the app.<p><b>Resident Set Size (RSS)</b> is the portion of memory the app occupies in RAM, combining both shared and non-shared pages.</p>").setTitleHelpLink("Learn more", "https://d.android.com/r/studio-ui/profiler/rss-memory").setCollapsedInitially(true).build();
        RssMemoryTrackModel.Companion.getIncludedCountersNameMap().forEach((counterName, displayName) -> {
            if (systemTraceData.getMemoryCounters().containsKey(counterName)) {
                RssMemoryTrackModel trackModel = new RssMemoryTrackModel(systemTraceData.getMemoryCounters().get(counterName), timeline.getViewRange());
                RssMemoryTooltip tooltip2 = new RssMemoryTooltip(timeline, (String)counterName, (RangedSeries<Long>)trackModel.getMemoryCounterSeries());
                memory.addTrackModel(TrackModel.newBuilder((Object)((Object)trackModel), (Enum)ProfilerTrackRendererType.RSS_MEMORY, (String)displayName).setDefaultTooltipModel((TooltipModel)tooltip2));
            }
        });
        return memory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureStage";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "studioProfilers";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeline";
                break;
            }
            case 25: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemTraceData";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiSelectionModel";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "saveCapture";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureStage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspect";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackGroupModels";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultiSelectionModel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimapModel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalysisModels";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureTimeline";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeline";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapture";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAndSaveCapture";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addCpuAnalysisModel";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "onCaptureParsed";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "insertImportedTraceEvent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "initTrackGroupList";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createInteractionTrackGroup";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createDisplayTrackGroup";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createThreadsTrackGroup";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createCpuCoresTrackGroup";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createRssMemoryTrackGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum State {
        PARSING,
        ANALYZING;

    }

    public static enum Aspect {
        STATE,
        ANALYSIS_MODEL_UPDATED;

    }
}

