/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.analysis.CpuThreadStateTableKt;
import com.android.tools.profilers.cpu.analysis.CustomBorderTableCellRenderer;
import com.android.tools.profilers.cpu.analysis.DurationRenderer;
import com.android.tools.profilers.cpu.analysis.IntegerAsStringTableCellRender;
import com.android.tools.profilers.cpu.analysis.PercentRenderer;
import com.android.tools.profilers.cpu.analysis.ThreadStateRow;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable;", "", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "threadStateSeriesList", "", "Lcom/android/tools/adtui/model/DataSeries;", "Lcom/android/tools/profilers/cpu/ThreadState;", "range", "Lcom/android/tools/adtui/model/Range;", "(Lcom/android/tools/profilers/StudioProfilers;Ljava/util/List;Lcom/android/tools/adtui/model/Range;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "getRange", "()Lcom/android/tools/adtui/model/Range;", "table", "Ljavax/swing/JTable;", "getTable$annotations", "()V", "getTable", "()Ljavax/swing/JTable;", "getThreadStateSeriesList", "()Ljava/util/List;", "Column", "ThreadStateTableModel", "intellij.android.profilers.ui"})
public final class CpuThreadStateTable {
    @NotNull
    private final JComponent component;
    @NotNull
    private final JTable table;
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final List<DataSeries<ThreadState>> threadStateSeriesList;
    @NotNull
    private final Range range;

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTable$annotations() {
    }

    @NotNull
    public final JTable getTable() {
        return this.table;
    }

    @NotNull
    public final StudioProfilers getProfilers() {
        return this.profilers;
    }

    @NotNull
    public final List<DataSeries<ThreadState>> getThreadStateSeriesList() {
        return this.threadStateSeriesList;
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    /*
     * WARNING - void declaration
     */
    public CpuThreadStateTable(@NotNull StudioProfilers profilers, @NotNull List<? extends DataSeries<ThreadState>> threadStateSeriesList, @NotNull Range range) {
        void $this$apply;
        HideablePanel hideablePanel;
        JPanel $this$apply2;
        JBTable jBTable;
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter(threadStateSeriesList, (String)"threadStateSeriesList");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.profilers = profilers;
        this.threadStateSeriesList = threadStateSeriesList;
        this.range = range;
        JBTable jBTable2 = jBTable = new JBTable((TableModel)new ThreadStateTableModel());
        CpuThreadStateTable cpuThreadStateTable = this;
        boolean bl = false;
        $this$apply2.setAutoCreateRowSorter(true);
        $this$apply2.setShowVerticalLines(true);
        $this$apply2.setShowHorizontalLines(false);
        TableColumn tableColumn = $this$apply2.getColumnModel().getColumn(Column.THREAD_STATE.ordinal());
        Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"columnModel.getColumn(Column.THREAD_STATE.ordinal)");
        tableColumn.setCellRenderer(new CustomBorderTableCellRenderer(null, 1, null));
        TableColumn tableColumn2 = $this$apply2.getColumnModel().getColumn(Column.TIME.ordinal());
        Intrinsics.checkNotNullExpressionValue((Object)tableColumn2, (String)"columnModel.getColumn(Column.TIME.ordinal)");
        tableColumn2.setCellRenderer(new DurationRenderer(null, 1, null));
        TableColumn tableColumn3 = $this$apply2.getColumnModel().getColumn(Column.PERCENT.ordinal());
        Intrinsics.checkNotNullExpressionValue((Object)tableColumn3, (String)"columnModel.getColumn(Column.PERCENT.ordinal)");
        tableColumn3.setCellRenderer(new PercentRenderer(null, 1, null));
        TableColumn tableColumn4 = $this$apply2.getColumnModel().getColumn(Column.OCCURRENCES.ordinal());
        Intrinsics.checkNotNullExpressionValue((Object)tableColumn4, (String)"columnModel.getColumn(Column.OCCURRENCES.ordinal)");
        tableColumn4.setCellRenderer(new IntegerAsStringTableCellRender(null, 1, null));
        Unit unit = Unit.INSTANCE;
        cpuThreadStateTable.table = (JTable)jBTable;
        JPanel $this$apply3 = $this$apply2 = new JPanel((LayoutManager)new TabularLayout("*", "Fit,Fit"));
        boolean $i$a$-apply-CpuThreadStateTable$tableContainer$22 = false;
        $this$apply3.setBorder(JBUI.Borders.customLine((Color)((Color)StudioColorsKt.getBorder()), (int)2));
        $this$apply3.setOpaque(false);
        $this$apply3.add((Component)((JBTable)this.table).getTableHeader(), new TabularLayout.Constraint(0, 0, 0, 4, null));
        $this$apply3.add((Component)this.table, new TabularLayout.Constraint(1, 0, 0, 4, null));
        JPanel tableContainer = $this$apply2;
        Border border = JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)((Color)StudioColorsKt.getBorder()), (int)1), (Border)((Border)JBUI.Borders.empty((int)8, (int)0, (int)0, (int)0)), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"JBUI.Borders.merge(JBUI.\u2026.empty(8, 0, 0, 0), true)");
        Border contentBorder = border;
        HideablePanel $i$a$-apply-CpuThreadStateTable$tableContainer$22 = hideablePanel = new HideablePanel.Builder("States", (JComponent)tableContainer).setPanelBorder((Border)JBUI.Borders.empty()).setContentBorder(contentBorder).build();
        cpuThreadStateTable = this;
        boolean bl2 = false;
        $this$apply.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        unit = Unit.INSTANCE;
        HideablePanel hideablePanel2 = hideablePanel;
        Intrinsics.checkNotNullExpressionValue((Object)hideablePanel2, (String)"HideablePanel.Builder(\"S\u2026ContentBackground\n      }");
        cpuThreadStateTable.component = (JComponent)hideablePanel2;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$ThreadStateTableModel;", "Ljavax/swing/table/AbstractTableModel;", "(Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable;)V", "dataRows", "", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "observer", "Lcom/android/tools/adtui/model/AspectObserver;", "computeDistribution", "", "getColumnClass", "Ljava/lang/Class;", "columnIndex", "", "getColumnCount", "getColumnName", "", "column", "getRowCount", "getValueAt", "", "rowIndex", "intellij.android.profilers.ui"})
    private final class ThreadStateTableModel
    extends AbstractTableModel {
        private final AspectObserver observer = new AspectObserver();
        private List<ThreadStateRow> dataRows = CollectionsKt.emptyList();

        @Override
        public int getRowCount() {
            return this.dataRows.size();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length;
        }

        @Override
        @NotNull
        public Object getValueAt(int rowIndex, int columnIndex) {
            return Column.values()[columnIndex].getValueFrom(this.dataRows.get(rowIndex));
        }

        @Override
        @NotNull
        public Class<?> getColumnClass(int columnIndex) {
            return Column.values()[columnIndex].getType();
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            return Column.values()[column].getDisplayName();
        }

        /*
         * WARNING - void declaration
         */
        private final void computeDistribution() {
            EnumMap threadStateToRow = new EnumMap(ThreadState.class);
            double totalDuration = CpuThreadStateTable.this.getRange().getLength() * (double)CpuThreadStateTable.this.getThreadStateSeriesList().size();
            Iterable $this$forEach$iv = CpuThreadStateTable.this.getThreadStateSeriesList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                DataSeries threadStateSeries = (DataSeries)element$iv;
                boolean bl = false;
                long nextTimestamp = (long)CpuThreadStateTable.this.getRange().getMax();
                List list = threadStateSeries.getDataForRange(CpuThreadStateTable.this.getRange());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"threadStateSeries.getDataForRange(range)");
                Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.asReversedMutable((List)list)), (Function1)((Function1)new Function1<SeriesData<ThreadState>, Boolean>(this, threadStateToRow, totalDuration){
                    final /* synthetic */ ThreadStateTableModel this$0;
                    final /* synthetic */ EnumMap $threadStateToRow$inlined;
                    final /* synthetic */ double $totalDuration$inlined;
                    {
                        this.this$0 = threadStateTableModel;
                        this.$threadStateToRow$inlined = enumMap;
                        this.$totalDuration$inlined = d;
                        super(1);
                    }

                    public final boolean invoke(SeriesData<ThreadState> it) {
                        return it.x < (long)this.this$0.CpuThreadStateTable.this.getRange().getMax();
                    }
                }));
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    long l;
                    Object object;
                    void $this$getOrPut$iv;
                    SeriesData threadStateDataPoint = (SeriesData)element$iv2;
                    boolean bl2 = false;
                    Map map2 = threadStateToRow;
                    Object key$iv = threadStateDataPoint.value;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        Object object2 = threadStateDataPoint.value;
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"threadStateDataPoint.value");
                        ThreadStateRow answer$iv = new ThreadStateRow((ThreadState)((Object)object2), totalDuration, 0L, 0L, 12, null);
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    map2 = object;
                    ThreadStateRow $this$apply = (ThreadStateRow)((Object)map2);
                    boolean bl4 = false;
                    long l2 = (long)CpuThreadStateTable.this.getRange().getMin();
                    long duration = nextTimestamp - Math.max(l2, l = threadStateDataPoint.x);
                    if (duration >= 0L) {
                        ThreadStateRow threadStateRow = $this$apply;
                        threadStateRow.setDuration(threadStateRow.getDuration() + duration);
                        ThreadStateRow threadStateRow2 = $this$apply;
                        threadStateRow2.setOccurrences(threadStateRow2.getOccurrences() + 1L);
                        nextTimestamp = threadStateDataPoint.x;
                        continue;
                    }
                    CpuThreadStateTableKt.access$getLogger().warn("Negative duration in thread state table: " + duration + ".");
                }
            }
            Collection collection = threadStateToRow.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"threadStateToRow.values");
            Iterable $this$sortedByDescending$iv = CollectionsKt.toList((Iterable)collection);
            boolean $i$f$sortedByDescending = false;
            this.dataRows = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ThreadStateRow it = (ThreadStateRow)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getDuration());
                    it = (ThreadStateRow)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    Long l = it.getDuration();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            });
            this.fireTableDataChanged();
        }

        public ThreadStateTableModel() {
            CpuThreadStateTable.this.getRange().addDependency(this.observer).onChange((Enum)Range.Aspect.RANGE, new Runnable(){

                @Override
                public final void run() {
                    this.computeDistribution();
                }
            });
            this.computeDistribution();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "", "displayName", "", "type", "Ljava/lang/Class;", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/Class;)V", "getDisplayName", "()Ljava/lang/String;", "getType", "()Ljava/lang/Class;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "THREAD_STATE", "TIME", "PERCENT", "OCCURRENCES", "intellij.android.profilers.ui"})
    private static final abstract class Column
    extends Enum<Column> {
        public static final /* enum */ Column THREAD_STATE;
        public static final /* enum */ Column TIME;
        public static final /* enum */ Column PERCENT;
        public static final /* enum */ Column OCCURRENCES;
        private static final /* synthetic */ Column[] $VALUES;
        @NotNull
        private final String displayName;
        @NotNull
        private final Class<?> type;

        static {
            Column[] columnArray = new Column[4];
            Column[] columnArray2 = columnArray;
            columnArray[0] = THREAD_STATE = new THREAD_STATE("THREAD_STATE", 0);
            columnArray[1] = TIME = new TIME("TIME", 1);
            columnArray[2] = PERCENT = new PERCENT("PERCENT", 2);
            columnArray[3] = OCCURRENCES = new OCCURRENCES("OCCURRENCES", 3);
            $VALUES = columnArray;
        }

        @NotNull
        public abstract Object getValueFrom(@NotNull ThreadStateRow var1);

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final Class<?> getType() {
            return this.type;
        }

        private Column(String displayName, Class<?> type) {
            this.displayName = displayName;
            this.type = type;
        }

        public /* synthetic */ Column(String $enum$name, int $enum$ordinal, String displayName, Class type, DefaultConstructorMarker $constructor_marker) {
            this(displayName, type);
        }

        public static Column[] values() {
            return (Column[])$VALUES.clone();
        }

        public static Column valueOf(String string) {
            return Enum.valueOf(Column.class, string);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column$THREAD_STATE;", "Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "intellij.android.profilers.ui"})
        static final class THREAD_STATE
        extends Column {
            @Override
            @NotNull
            public Object getValueFrom(@NotNull ThreadStateRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getThreadState().getDisplayName();
            }

            /*
             * WARNING - void declaration
             */
            THREAD_STATE() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column$TIME;", "Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "intellij.android.profilers.ui"})
        static final class TIME
        extends Column {
            @Override
            @NotNull
            public Object getValueFrom(@NotNull ThreadStateRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getDuration();
            }

            /*
             * WARNING - void declaration
             */
            TIME() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column$PERCENT;", "Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "intellij.android.profilers.ui"})
        static final class PERCENT
        extends Column {
            @Override
            @NotNull
            public Object getValueFrom(@NotNull ThreadStateRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getPercentage();
            }

            /*
             * WARNING - void declaration
             */
            PERCENT() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column$OCCURRENCES;", "Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "intellij.android.profilers.ui"})
        static final class OCCURRENCES
        extends Column {
            @Override
            @NotNull
            public Object getValueFrom(@NotNull ThreadStateRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getOccurrences();
            }

            /*
             * WARNING - void declaration
             */
            OCCURRENCES() {
                void var1_1;
            }
        }
    }
}

