/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.common.DataVisualizationColors;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

class JavaMethodHChartColors {
    JavaMethodHChartColors() {
    }

    private static void validateModel(@NotNull CaptureNodeModel model) {
        if (model == null) {
            JavaMethodHChartColors.$$$reportNull$$$0(0);
        }
        if (!(model instanceof JavaMethodModel)) {
            throw new IllegalStateException("Model must be an instance of JavaMethodModel.");
        }
    }

    private static boolean isMethodVendor(CaptureNodeModel method) {
        return method.getFullName().startsWith("java.") || method.getFullName().startsWith("sun.") || method.getFullName().startsWith("javax.") || method.getFullName().startsWith("apple.") || method.getFullName().startsWith("com.apple.");
    }

    private static boolean isMethodPlatform(CaptureNodeModel method) {
        return method.getFullName().startsWith("android.") || method.getFullName().startsWith("com.android.");
    }

    static Color getFillColor(@NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isUnmatched, boolean isFocused, boolean isDeselected) {
        if (model == null) {
            JavaMethodHChartColors.$$$reportNull$$$0(1);
        }
        JavaMethodHChartColors.validateModel(model);
        Object color = chartType == CaptureDetails.Type.CALL_CHART ? (isDeselected ? DataVisualizationColors.INSTANCE.getColor("Gray", isFocused) : (JavaMethodHChartColors.isMethodVendor(model) ? (isFocused ? ProfilerColors.CPU_CALLCHART_VENDOR_HOVER : ProfilerColors.CPU_CALLCHART_VENDOR) : (JavaMethodHChartColors.isMethodPlatform(model) ? (isFocused ? ProfilerColors.CPU_CALLCHART_PLATFORM_HOVER : ProfilerColors.CPU_CALLCHART_PLATFORM) : (isFocused ? ProfilerColors.CPU_CALLCHART_APP_HOVER : ProfilerColors.CPU_CALLCHART_APP)))) : (JavaMethodHChartColors.isMethodVendor(model) ? (isFocused ? ProfilerColors.CPU_FLAMECHART_VENDOR_HOVER : ProfilerColors.CPU_FLAMECHART_VENDOR) : (JavaMethodHChartColors.isMethodPlatform(model) ? (isFocused ? ProfilerColors.CPU_FLAMECHART_PLATFORM_HOVER : ProfilerColors.CPU_FLAMECHART_PLATFORM) : (isFocused ? ProfilerColors.CPU_FLAMECHART_APP_HOVER : ProfilerColors.CPU_FLAMECHART_APP)));
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor((Color)color) : color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "model";
        objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/JavaMethodHChartColors";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validateModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFillColor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

