/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyEventsCountDataSeries;
import com.android.tools.profilers.energy.LegacyEnergyEventsCountDataSeries;
import com.android.tools.profilers.energy.LegacyEnergyEventsDataSeries;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class DetailedEnergyEventsCount {
    @NotNull
    private final RangedContinuousSeries myLocationCountSeries;
    @NotNull
    private final RangedContinuousSeries myWakeLockCountSeries;
    @NotNull
    private final RangedContinuousSeries myAlarmAndJobCountSeries;

    public DetailedEnergyEventsCount(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            DetailedEnergyEventsCount.$$$reportNull$$$0(0);
        }
        Range countRange = new Range(0.0, 400.0);
        this.myLocationCountSeries = new RangedContinuousSeries("Location", profilers.getTimeline().getViewRange(), countRange, DetailedEnergyEventsCount.createEventsCountSeries(profilers, kind -> kind == EnergyDuration.Kind.LOCATION));
        this.myWakeLockCountSeries = new RangedContinuousSeries("Wake Locks", profilers.getTimeline().getViewRange(), countRange, DetailedEnergyEventsCount.createEventsCountSeries(profilers, kind -> kind == EnergyDuration.Kind.WAKE_LOCK));
        this.myAlarmAndJobCountSeries = new RangedContinuousSeries("Alarms & Jobs", profilers.getTimeline().getViewRange(), countRange, DetailedEnergyEventsCount.createEventsCountSeries(profilers, kind -> kind == EnergyDuration.Kind.ALARM || kind == EnergyDuration.Kind.JOB));
    }

    @NotNull
    public RangedContinuousSeries getLocationCountSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myLocationCountSeries;
        if (rangedContinuousSeries == null) {
            DetailedEnergyEventsCount.$$$reportNull$$$0(1);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getWakeLockCountSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myWakeLockCountSeries;
        if (rangedContinuousSeries == null) {
            DetailedEnergyEventsCount.$$$reportNull$$$0(2);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getAlarmAndJobCountSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myAlarmAndJobCountSeries;
        if (rangedContinuousSeries == null) {
            DetailedEnergyEventsCount.$$$reportNull$$$0(3);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    private static DataSeries<Long> createEventsCountSeries(StudioProfilers profilers, Predicate<EnergyDuration.Kind> kindFilter) {
        if (profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            return new EnergyEventsCountDataSeries(profilers.getClient().getTransportClient(), profilers.getSession().getStreamId(), profilers.getSession().getPid(), kindFilter);
        }
        return new LegacyEnergyEventsCountDataSeries((RangedSeries<Common.Event>)new RangedSeries(profilers.getTimeline().getDataRange(), (DataSeries)new LegacyEnergyEventsDataSeries(profilers.getClient(), profilers.getSession())), kindFilter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/energy/DetailedEnergyEventsCount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/energy/DetailedEnergyEventsCount";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationCountSeries";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWakeLockCountSeries";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlarmAndJobCountSeries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

