/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.android.tools.profilers.memory.AllocStatsDataSeries;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.android.tools.profilers.memory.GcDurationData;
import com.android.tools.profilers.memory.MemoryUsage;
import org.jetbrains.annotations.NotNull;

public class DetailedMemoryUsage
extends MemoryUsage {
    private static final String JAVA_MEM = "Java";
    private static final String NATIVE_MEM = "Native";
    private static final String GRAPHICS_MEM = "Graphics";
    private static final String STACK_MEM = "Stack";
    private static final String CODE_MEM = "Code";
    private static final String OTHERS_MEM = "Others";
    private static final String ALLOCATED = "Allocated";
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Range myObjectsRange;
    @NotNull
    private final RangedContinuousSeries myJavaSeries;
    @NotNull
    private final RangedContinuousSeries myNativeSeries;
    @NotNull
    private final RangedContinuousSeries myGraphicsSeries;
    @NotNull
    private final RangedContinuousSeries myStackSeries;
    @NotNull
    private final RangedContinuousSeries myCodeSeries;
    @NotNull
    private final RangedContinuousSeries myOtherSeries;
    @NotNull
    private final RangedContinuousSeries myObjectsSeries;
    @NotNull
    private final DurationDataModel<GcDurationData> myGcDurations;
    @NotNull
    private final DurationDataModel<AllocationSamplingRateDurationData> myAllocationSamplingRateDurations;

    public DetailedMemoryUsage(@NotNull StudioProfilers profilers, @NotNull BaseStreamingMemoryProfilerStage memoryProfilerStage) {
        if (profilers == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(0);
        }
        if (memoryProfilerStage == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(1);
        }
        super(profilers);
        this.myProfilers = profilers;
        this.myObjectsRange = new Range(0.0, 0.0);
        this.myJavaSeries = this.createRangedSeries(profilers, JAVA_MEM, this.getMemoryRange(), 0, UnifiedEventDataSeries.fromFieldToDataExtractor(e -> (long)e.getMemoryUsage().getJavaMem() * 1024L));
        this.myNativeSeries = this.createRangedSeries(profilers, NATIVE_MEM, this.getMemoryRange(), 0, UnifiedEventDataSeries.fromFieldToDataExtractor(e -> (long)e.getMemoryUsage().getNativeMem() * 1024L));
        this.myGraphicsSeries = this.createRangedSeries(profilers, GRAPHICS_MEM, this.getMemoryRange(), 0, UnifiedEventDataSeries.fromFieldToDataExtractor(e -> (long)e.getMemoryUsage().getGraphicsMem() * 1024L));
        this.myStackSeries = this.createRangedSeries(profilers, STACK_MEM, this.getMemoryRange(), 0, UnifiedEventDataSeries.fromFieldToDataExtractor(e -> (long)e.getMemoryUsage().getStackMem() * 1024L));
        this.myCodeSeries = this.createRangedSeries(profilers, CODE_MEM, this.getMemoryRange(), 0, UnifiedEventDataSeries.fromFieldToDataExtractor(e -> (long)e.getMemoryUsage().getCodeMem() * 1024L));
        this.myOtherSeries = this.createRangedSeries(profilers, OTHERS_MEM, this.getMemoryRange(), 0, UnifiedEventDataSeries.fromFieldToDataExtractor(e -> (long)e.getMemoryUsage().getOthersMem() * 1024L));
        AllocStatsDataSeries series = new AllocStatsDataSeries(this.myProfilers, sample -> sample.getJavaAllocationCount() - sample.getJavaFreeCount());
        this.myObjectsSeries = new RangedContinuousSeries(ALLOCATED, profilers.getTimeline().getViewRange(), this.getObjectsRange(), (DataSeries)series);
        this.myGcDurations = memoryProfilerStage.getGcStatsModel();
        this.myAllocationSamplingRateDurations = memoryProfilerStage.getAllocationSamplingRateDurations();
        this.add(this.myJavaSeries);
        this.add(this.myNativeSeries);
        this.add(this.myGraphicsSeries);
        this.add(this.myStackSeries);
        this.add(this.myCodeSeries);
        this.add(this.myOtherSeries);
        this.add(this.myObjectsSeries);
        this.getMemoryRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> this.changed((Enum)LineChartModel.Aspect.LINE_CHART));
        this.getObjectsRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> this.changed((Enum)LineChartModel.Aspect.LINE_CHART));
    }

    @NotNull
    public Range getObjectsRange() {
        Range range = this.myObjectsRange;
        if (range == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(2);
        }
        return range;
    }

    @NotNull
    public RangedContinuousSeries getJavaSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myJavaSeries;
        if (rangedContinuousSeries == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(3);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getNativeSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myNativeSeries;
        if (rangedContinuousSeries == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(4);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getGraphicsSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myGraphicsSeries;
        if (rangedContinuousSeries == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(5);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getStackSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myStackSeries;
        if (rangedContinuousSeries == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(6);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getCodeSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myCodeSeries;
        if (rangedContinuousSeries == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(7);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getOtherSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myOtherSeries;
        if (rangedContinuousSeries == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(8);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getObjectsSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myObjectsSeries;
        if (rangedContinuousSeries == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(9);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public DurationDataModel<GcDurationData> getGcDurations() {
        DurationDataModel<GcDurationData> durationDataModel = this.myGcDurations;
        if (durationDataModel == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(10);
        }
        return durationDataModel;
    }

    @NotNull
    public DurationDataModel<AllocationSamplingRateDurationData> getAllocationSamplingRateDurations() {
        DurationDataModel<AllocationSamplingRateDurationData> durationDataModel = this.myAllocationSamplingRateDurations;
        if (durationDataModel == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(11);
        }
        return durationDataModel;
    }

    @Override
    protected String getTotalSeriesLabel() {
        return "Total";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memoryProfilerStage";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/DetailedMemoryUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/DetailedMemoryUsage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaSeries";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeSeries";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphicsSeries";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackSeries";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeSeries";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherSeries";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsSeries";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGcDurations";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationSamplingRateDurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

