/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.NewRowInstruction;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.NumberFormatter;
import com.android.tools.adtui.stdui.ContextMenuItem;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.inspectors.common.api.stacktrace.CodeLocation;
import com.android.tools.inspectors.common.ui.ContextMenuInstaller;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.AttributeColumn;
import com.android.tools.profilers.memory.CapturePanelTabContainer;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.ClassGrouping;
import com.android.tools.profilers.memory.CsvExporter;
import com.android.tools.profilers.memory.LazyMemoryObjectTreeNode;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.PercentColumnRenderer;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.AllHeapSet;
import com.android.tools.profilers.memory.adapters.classifiers.ClassSet;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.android.tools.profilers.memory.adapters.classifiers.MethodSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeAllocationMethodSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeCallStackSet;
import com.android.tools.profilers.memory.adapters.classifiers.PackageSet;
import com.android.tools.profilers.memory.adapters.classifiers.ThreadSet;
import com.android.tools.profilers.memory.adapters.instancefilters.ActivityFragmentLeakInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.UIUtilities;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryClassifierView
extends AspectObserver
implements CapturePanelTabContainer {
    private static final int LABEL_COLUMN_WIDTH = 800;
    private static final int MODULE_COLUMN_WIDTH = 100;
    private static final int HEAP_UPDATING_DELAY_MS = 250;
    private static final int MIN_COLUMN_WIDTH = 16;
    private static final String HELP_TIP_HEADER_LIVE_ALLOCATION = "Selected range has no allocations or deallocations";
    private static final String HELP_TIP_DESCRIPTION_LIVE_ALLOCATION = "Select a valid range in the timeline where the Java memory is changing to view allocations and deallocations.";
    private static final String HELP_TIP_HEADER_EXPLICIT_CAPTURE = "Selected capture has no contents";
    private static final String HELP_TIP_DESCRIPTION_EXPLICIT_CAPTURE = "There are no allocations in the selected capture.";
    private static final String HELP_TIP_HEADER_FILTER_NO_MATCH = "Selected filters have no match";
    @NotNull
    private final MemoryCaptureSelection mySelection;
    @NotNull
    private final ContextMenuInstaller myContextMenuInstaller;
    @NotNull
    private final Map<CaptureObject.ClassifierAttribute, AttributeColumn<ClassifierSet>> myAttributeColumns;
    @Nullable
    private CaptureObject myCaptureObject;
    @Nullable
    private HeapSet myHeapSet;
    @Nullable
    private ClassSet myClassSet;
    @Nullable
    private ClassifierSet mySelectedClassifierSet;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final JPanel myClassifierPanel;
    @NotNull
    private final LoadingPanel myLoadingPanel;
    @Nullable
    private InstructionsPanel myHelpTipPanel;
    @Nullable
    private JComponent myColumnTree;
    @Nullable
    private JTree myTree;
    @Nullable
    private DefaultTreeModel myTreeModel;
    @Nullable
    private TableColumnModel myTableColumnModel;
    @Nullable
    private MemoryClassifierTreeNode myTreeRoot;
    @Nullable
    private Comparator<MemoryObjectTreeNode<ClassifierSet>> myInitialComparator;
    private final CsvExporter myCsvExporter;

    public MemoryClassifierView(@NotNull MemoryCaptureSelection selection2, @NotNull IdeProfilerComponents ideProfilerComponents) {
        if (selection2 == null) {
            MemoryClassifierView.$$$reportNull$$$0(0);
        }
        if (ideProfilerComponents == null) {
            MemoryClassifierView.$$$reportNull$$$0(1);
        }
        this.myAttributeColumns = new HashMap<CaptureObject.ClassifierAttribute, AttributeColumn<ClassifierSet>>();
        this.myCaptureObject = null;
        this.myHeapSet = null;
        this.myClassSet = null;
        this.mySelectedClassifierSet = null;
        this.myPanel = new JPanel(new BorderLayout());
        this.myClassifierPanel = new JPanel(new BorderLayout());
        this.mySelection = selection2;
        this.myCsvExporter = new CsvExporter((Function0<? extends JTree>)((Function0)() -> this.myTree), (Function0<? extends CaptureObject>)((Function0)() -> this.myCaptureObject), ideProfilerComponents, selection2.getIdeServices());
        this.myContextMenuInstaller = ideProfilerComponents.createContextMenuInstaller();
        this.myLoadingPanel = ideProfilerComponents.createLoadingPanel(250);
        this.myLoadingPanel.setLoadingText("");
        this.mySelection.getAspect().addDependency((AspectObserver)this).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADING_CAPTURE, this::loadCapture).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADED_CAPTURE, this::refreshCapture).onChange((Enum)CaptureSelectionAspect.CURRENT_HEAP, this::refreshHeapSet).onChange((Enum)CaptureSelectionAspect.CURRENT_HEAP_UPDATING, this::startHeapLoadingUi).onChange((Enum)CaptureSelectionAspect.CURRENT_HEAP_UPDATED, this::stopHeapLoadingUi).onChange((Enum)CaptureSelectionAspect.CURRENT_HEAP_CONTENTS, this::refreshTree).onChange((Enum)CaptureSelectionAspect.CURRENT_CLASS, this::refreshClassSet).onChange((Enum)CaptureSelectionAspect.CLASS_GROUPING, this::refreshGrouping).onChange((Enum)CaptureSelectionAspect.CURRENT_FILTER, this::refreshFilter);
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.LABEL, new AttributeColumn("Class Name", this::getNameColumnRenderer, 2, 800, SortOrder.ASCENDING, MemoryClassifierView.createTreeNodeComparator(Comparator.comparing(ClassifierSet::getName), Comparator.comparing(ClassifierSet::getName))));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.MODULE, new AttributeColumn("Module Name", this::getModuleColumnRenderer, 2, 100, SortOrder.ASCENDING, MemoryClassifierView.createTreeNodeComparator(Comparator.comparing(NativeCallStackSet::getModuleName))));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.ALLOCATIONS, this.makeColumn("Allocations", 110, ClassifierSet::getDeltaAllocationCount));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.DEALLOCATIONS, this.makeColumn("Deallocations", 130, ClassifierSet::getDeltaDeallocationCount));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.TOTAL_COUNT, this.makeColumn("Total Count", 110, ClassifierSet::getTotalObjectCount));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.NATIVE_SIZE, this.makeColumn("Native Size", 110, ClassifierSet::getTotalNativeSize, Comparator.comparing(ClassifierSet::getName)));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.SHALLOW_SIZE, this.makeColumn("Shallow Size", 120, ClassifierSet::getTotalShallowSize, Comparator.comparing(ClassifierSet::getName)));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.RETAINED_SIZE, this.makeColumn("Retained Size", 130, ClassifierSet::getTotalRetainedSize));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.ALLOCATIONS_SIZE, this.makeColumn("Allocations Size", 160, ClassifierSet::getAllocationSize));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.DEALLOCATIONS_SIZE, this.makeColumn("Deallocations Size", 180, ClassifierSet::getDeallocationSize));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.REMAINING_SIZE, this.makeColumn("Remaining Size", 140, ClassifierSet::getTotalRemainingSize));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.SHALLOW_DIFFERENCE, this.makeColumn("Shallow Size Change", 110, ClassifierSet::getDeltaShallowSize));
    }

    private AttributeColumn<ClassifierSet> makeColumn(@NotNull String name, int width, @NotNull ToLongFunction<ClassifierSet> prop, @NotNull Comparator<ClassifierSet> comp) {
        if (name == null) {
            MemoryClassifierView.$$$reportNull$$$0(2);
        }
        if (prop == null) {
            MemoryClassifierView.$$$reportNull$$$0(3);
        }
        if (comp == null) {
            MemoryClassifierView.$$$reportNull$$$0(4);
        }
        Function<MemoryObjectTreeNode, String> textGetter = node -> NumberFormatter.formatInteger((Number)prop.applyAsLong((ClassifierSet)node.getAdapter()));
        Supplier<ColoredTreeCellRenderer> renderer = () -> new PercentColumnRenderer(textGetter, v -> null, 4, node -> {
            MemoryObjectTreeNode parent = node.myParent;
            if (parent == null) {
                return 0;
            }
            assert (this.myTreeRoot != null);
            long myVal = prop.applyAsLong((ClassifierSet)node.getAdapter());
            ClassifierSet root = (ClassifierSet)this.myTreeRoot.getAdapter();
            long parentVal = prop.applyAsLong(root);
            return parentVal == 0L ? 0 : (int)(myVal * 100L / parentVal);
        });
        int preferredWidth = Math.max(80, width);
        int maxWidth = preferredWidth * 4;
        return new AttributeColumn<ClassifierSet>(name, renderer, 4, preferredWidth, maxWidth, SortOrder.DESCENDING, MemoryClassifierView.createTreeNodeComparator(comp, Comparator.comparingLong(prop)));
    }

    private AttributeColumn<ClassifierSet> makeColumn(String name, int width, ToLongFunction<ClassifierSet> prop) {
        return this.makeColumn(name, width, prop, Comparator.comparingLong(prop));
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            MemoryClassifierView.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @Override
    public void onSelectionChanged(boolean selected) {
    }

    @VisibleForTesting
    @Nullable
    public JTree getTree() {
        return this.myTree;
    }

    @VisibleForTesting
    @Nullable
    JComponent getColumnTree() {
        return this.myColumnTree;
    }

    @VisibleForTesting
    @Nullable
    TableColumnModel getTableColumnModel() {
        return this.myTableColumnModel;
    }

    @VisibleForTesting
    @NotNull
    JPanel getClassifierPanel() {
        JPanel jPanel = this.myClassifierPanel;
        if (jPanel == null) {
            MemoryClassifierView.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    private void reset() {
        this.myCaptureObject = null;
        this.myHeapSet = null;
        this.myClassSet = null;
        this.myClassifierPanel.removeAll();
        this.myHelpTipPanel = null;
        this.myColumnTree = null;
        this.myTree = null;
        this.myTreeRoot = null;
        this.myTreeModel = null;
        this.myTableColumnModel = null;
        this.myPanel.removeAll();
        this.mySelection.selectClassSet(null);
    }

    private void loadCapture() {
        if (this.mySelection.getSelectedCapture() == null || this.myCaptureObject != this.mySelection.getSelectedCapture()) {
            this.reset();
        }
    }

    private void refreshFilter() {
        if (this.myHeapSet != null) {
            this.refreshTree();
        }
    }

    @VisibleForTesting
    public void refreshCapture() {
        this.myCaptureObject = this.mySelection.getSelectedCapture();
        if (this.myCaptureObject == null) {
            this.reset();
            return;
        }
        assert (this.myColumnTree == null && this.myTreeModel == null && this.myTreeRoot == null && this.myTree == null);
        this.myTree = new JTree();
        int defaultFontHeight = this.myTree.getFontMetrics(this.myTree.getFont()).getHeight();
        this.myTree.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
        this.myTree.setBorder(ProfilerLayout.TABLE_ROW_BORDER);
        this.myTree.setRootVisible(true);
        this.myTree.setShowsRootHandles(false);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (MemoryClassifierView.this.myTree.getSelectionCount() == 0) {
                    MemoryClassifierView.this.myTree.setSelectionRow(0);
                }
            }
        });
        this.myTree.addTreeSelectionListener(e -> {
            TreePath path = e.getPath();
            if (!e.isAddedPath()) {
                return;
            }
            assert (path.getLastPathComponent() instanceof MemoryClassifierTreeNode);
            MemoryClassifierTreeNode classifierNode = (MemoryClassifierTreeNode)path.getLastPathComponent();
            this.mySelectedClassifierSet = (ClassifierSet)classifierNode.getAdapter();
            if (classifierNode.getAdapter() instanceof ClassSet && this.myClassSet != classifierNode.getAdapter()) {
                this.myClassSet = (ClassSet)classifierNode.getAdapter();
                this.mySelection.selectClassSet(this.myClassSet);
            }
        });
        this.myContextMenuInstaller.installNavigationContextMenu((JComponent)this.myTree, this.mySelection.getIdeServices().getCodeNavigator(), () -> {
            NativeCallStackSet nativeSet;
            TreePath selection2 = this.myTree.getSelectionPath();
            if (selection2 == null || !(selection2.getLastPathComponent() instanceof MemoryObjectTreeNode)) {
                return null;
            }
            Object treeNodeAdapter = ((MemoryObjectTreeNode)selection2.getLastPathComponent()).getAdapter();
            if (treeNodeAdapter instanceof ClassSet) {
                ClassSet classSet = (ClassSet)treeNodeAdapter;
                return new CodeLocation.Builder(classSet.getClassEntry().getClassName()).build();
            }
            if (treeNodeAdapter instanceof NativeCallStackSet && !Strings.isNullOrEmpty((String)(nativeSet = (NativeCallStackSet)treeNodeAdapter).getFileName())) {
                return new CodeLocation.Builder(nativeSet.getName()).setMethodName(nativeSet.getName()).setFileName(nativeSet.getFileName()).setLineNumber(nativeSet.getLineNumber() - 1).build();
            }
            return null;
        });
        if (this.mySelection.getIdeServices().getFeatureConfig().isMemoryCSVExportEnabled()) {
            this.myContextMenuInstaller.installGenericContextMenu((JComponent)this.myTree, this.myCsvExporter.makeClassExportItem());
            this.myContextMenuInstaller.installGenericContextMenu((JComponent)this.myTree, (ContextMenuItem)this.myCsvExporter.makeInstanceExportItem());
        }
        List<CaptureObject.ClassifierAttribute> attributes = this.myCaptureObject.getClassifierAttributes();
        this.myTableColumnModel = new DefaultTableColumnModel();
        ColumnTreeBuilder builder = new ColumnTreeBuilder(this.myTree, this.myTableColumnModel);
        CaptureObject.ClassifierAttribute sortAttribute = Collections.max(attributes, Comparator.comparingInt(CaptureObject.ClassifierAttribute::getWeight));
        for (CaptureObject.ClassifierAttribute attribute : attributes) {
            AttributeColumn<ClassifierSet> column = this.myAttributeColumns.get((Object)attribute);
            ColumnTreeBuilder.ColumnBuilder columnBuilder = column.getBuilder();
            columnBuilder.setMinWidth(16);
            if (sortAttribute == attribute) {
                columnBuilder.setInitialOrder(attribute.getSortOrder());
                this.myInitialComparator = attribute.getSortOrder() == SortOrder.ASCENDING ? column.getComparator() : Collections.reverseOrder(column.getComparator());
            }
            builder.addColumn(columnBuilder);
        }
        builder.setTreeSorter((comparator, sortOrder) -> {
            if (this.myTreeRoot != null && this.myTreeModel != null) {
                TreePath selectionPath = this.myTree.getSelectionPath();
                this.myTreeRoot.sort(comparator);
                this.myTreeModel.nodeStructureChanged(this.myTreeRoot);
                if (selectionPath != null) {
                    this.myTree.expandPath(selectionPath.getParentPath());
                    this.myTree.setSelectionPath(selectionPath);
                    this.myTree.scrollPathToVisible(selectionPath);
                }
            }
        });
        builder.setHoverColor(StandardColors.HOVER_COLOR);
        builder.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        builder.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
        builder.setShowVerticalLines(true);
        builder.setTableIntercellSpacing(new Dimension());
        this.myColumnTree = builder.build();
        this.myHelpTipPanel = this.mySelection.getSelectedCapture().isExportable() ? this.makeInstructionsPanel(HELP_TIP_HEADER_EXPLICIT_CAPTURE, HELP_TIP_DESCRIPTION_EXPLICIT_CAPTURE) : this.makeInstructionsPanel(HELP_TIP_HEADER_LIVE_ALLOCATION, HELP_TIP_DESCRIPTION_LIVE_ALLOCATION);
        this.myPanel.add((Component)this.myClassifierPanel, "Center");
    }

    private InstructionsPanel makeInstructionsPanel(String header, String desc) {
        return new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(UIUtilities.getFontMetrics((JComponent)this.myClassifierPanel, (Font)ProfilerFonts.H3_FONT), header), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(UIUtilities.getFontMetrics((JComponent)this.myClassifierPanel, (Font)ProfilerFonts.STANDARD_FONT), desc)}).setColors(JBColor.foreground(), null).build();
    }

    private void startHeapLoadingUi() {
        if (this.myColumnTree == null) {
            return;
        }
        this.myPanel.remove(this.myClassifierPanel);
        this.myPanel.add((Component)this.myLoadingPanel.getComponent(), "Center");
        this.myLoadingPanel.setChildComponent(this.myClassifierPanel);
        this.myLoadingPanel.startLoading();
    }

    private void stopHeapLoadingUi() {
        if (this.myColumnTree == null) {
            return;
        }
        this.myPanel.remove(this.myLoadingPanel.getComponent());
        this.myPanel.add((Component)this.myClassifierPanel, "Center");
        this.myLoadingPanel.setChildComponent(null);
        this.myLoadingPanel.stopLoading();
    }

    private void refreshClassifierPanel() {
        assert (this.myTreeRoot != null && this.myColumnTree != null && this.myHelpTipPanel != null);
        this.myClassifierPanel.removeAll();
        if (((ClassifierSet)this.myTreeRoot.getAdapter()).isEmpty()) {
            if (this.myCaptureObject != null && !this.myCaptureObject.getSelectedInstanceFilters().isEmpty()) {
                List filterNames = this.myCaptureObject.getSelectedInstanceFilters().stream().map(CaptureObjectInstanceFilter::getDisplayName).collect(Collectors.toList());
                String msg = String.format("There are no allocations satisfying selected filter%s: %s", filterNames.size() > 1 ? "s" : "", String.join((CharSequence)", ", filterNames));
                this.myClassifierPanel.add((Component)this.makeInstructionsPanel(HELP_TIP_HEADER_FILTER_NO_MATCH, msg), "Center");
            } else {
                this.myClassifierPanel.add((Component)this.myHelpTipPanel, "Center");
            }
        } else {
            this.myClassifierPanel.add((Component)this.myColumnTree, "Center");
        }
        this.myClassifierPanel.revalidate();
        this.myClassifierPanel.repaint();
    }

    private void refreshTree() {
        TreePath treePath;
        if (this.myHeapSet == null) {
            return;
        }
        assert (this.myTreeRoot != null && this.myTreeModel != null && this.myTree != null);
        this.refreshClassifierPanel();
        this.myTreeRoot.reset();
        this.myTreeRoot.expandNode();
        this.myTreeModel.nodeStructureChanged(this.myTreeRoot);
        if (this.mySelectedClassifierSet != null) {
            if (!this.mySelectedClassifierSet.isEmpty()) {
                MemoryObjectTreeNode<ClassifierSet> nodeToSelect = MemoryClassifierView.findSmallestSuperSetNode((MemoryObjectTreeNode<ClassifierSet>)this.myTreeRoot, this.mySelectedClassifierSet);
                if (nodeToSelect != null && nodeToSelect.getAdapter().equals(this.mySelectedClassifierSet)) {
                    treePath = new TreePath(nodeToSelect.getPathToRoot().toArray());
                    this.myTree.expandPath(treePath.getParentPath());
                    this.myTree.setSelectionPath(treePath);
                    this.myTree.scrollPathToVisible(treePath);
                } else {
                    this.mySelectedClassifierSet = null;
                }
            } else {
                this.mySelectedClassifierSet = null;
            }
        }
        if (!this.mySelection.getFilterHandler().getFilter().isEmpty()) {
            MemoryClassifierTreeNode treeNode = this.myTreeRoot;
            while (treeNode != null) {
                if (((ClassifierSet)treeNode.getAdapter()).getIsMatched()) {
                    treePath = new TreePath(treeNode.getPathToRoot().toArray());
                    this.myTree.expandPath(treePath.getParentPath());
                    break;
                }
                treeNode.expandNode();
                this.myTreeModel.nodeStructureChanged(treeNode);
                MemoryClassifierTreeNode nextNode = null;
                Iterator iterator = treeNode.getChildren().iterator();
                if (iterator.hasNext()) {
                    MemoryObjectTreeNode child = (MemoryObjectTreeNode)iterator.next();
                    assert (!((ClassifierSet)child.getAdapter()).getIsFiltered());
                    assert (child instanceof MemoryClassifierTreeNode);
                    nextNode = (MemoryClassifierTreeNode)child;
                }
                treeNode = nextNode;
            }
        }
    }

    private void refreshHeapSet() {
        assert (this.myCaptureObject != null && this.myTree != null);
        HeapSet heapSet = this.mySelection.getSelectedHeapSet();
        if (heapSet == this.myHeapSet) {
            return;
        }
        this.myHeapSet = heapSet;
        if (this.myHeapSet != null) {
            this.refreshGrouping();
        }
        if (this.myHeapSet instanceof AllHeapSet) {
            this.myTree.setRootVisible(false);
            this.myTree.setShowsRootHandles(true);
        } else {
            this.myTree.setRootVisible(true);
            this.myTree.setShowsRootHandles(false);
        }
    }

    @VisibleForTesting
    public void refreshGrouping() {
        ClassifierSet classifierSet;
        HeapSet heapSet = this.mySelection.getSelectedHeapSet();
        if (heapSet == null || this.myCaptureObject == null || this.myTree == null) {
            return;
        }
        Comparator comparator = this.myTreeRoot == null ? this.myInitialComparator : this.myTreeRoot.getComparator();
        heapSet.setClassGrouping(this.mySelection.getClassGrouping());
        this.myTreeRoot = new MemoryClassifierTreeNode(heapSet);
        this.myTreeRoot.expandNode();
        if (comparator != null) {
            this.myTreeRoot.sort(comparator);
        }
        this.myTreeModel = new DefaultTreeModel(this.myTreeRoot);
        this.myTree.setModel(this.myTreeModel);
        assert (this.myColumnTree != null);
        String headerName = null;
        switch (this.mySelection.getClassGrouping()) {
            case ARRANGE_BY_CLASS: {
                headerName = "Class Name";
                break;
            }
            case ARRANGE_BY_CALLSTACK: 
            case NATIVE_ARRANGE_BY_CALLSTACK: {
                headerName = "Callstack Name";
                break;
            }
            case ARRANGE_BY_PACKAGE: {
                headerName = "Package Name";
                break;
            }
            case NATIVE_ARRANGE_BY_ALLOCATION_METHOD: {
                headerName = "Allocation function";
            }
        }
        assert (this.myTableColumnModel != null);
        this.myTableColumnModel.getColumn(0).setHeaderValue(headerName);
        ClassSet selectedClassSet = this.mySelection.getSelectedClassSet();
        InstanceObject selectedInstance = this.mySelection.getSelectedInstanceObject();
        List<FieldObject> fieldPath = this.mySelection.getSelectedFieldObjectPath();
        this.refreshClassifierPanel();
        if (selectedClassSet == null) {
            return;
        }
        MemoryObjectTreeNode<ClassifierSet> nodeToSelect = MemoryClassifierView.findSmallestSuperSetNode((MemoryObjectTreeNode<ClassifierSet>)this.myTreeRoot, selectedClassSet);
        if (!(nodeToSelect != null && nodeToSelect.getAdapter() instanceof ClassSet || selectedInstance == null || (classifierSet = ((ClassifierSet)this.myTreeRoot.getAdapter()).findContainingClassifierSet(selectedInstance)) == null)) {
            nodeToSelect = MemoryClassifierView.findSmallestSuperSetNode((MemoryObjectTreeNode<ClassifierSet>)this.myTreeRoot, classifierSet);
        }
        if (nodeToSelect == null || !(nodeToSelect.getAdapter() instanceof ClassSet)) {
            this.mySelection.selectClassSet(null);
            return;
        }
        assert (this.myTree != null);
        TreePath treePath = new TreePath(nodeToSelect.getPathToRoot().toArray());
        this.myClassSet = (ClassSet)nodeToSelect.getAdapter();
        this.myTree.expandPath(treePath.getParentPath());
        this.myTree.setSelectionPath(treePath);
        this.myTree.scrollPathToVisible(treePath);
        this.mySelection.selectClassSet(this.myClassSet);
        this.mySelection.selectInstanceObject(selectedInstance);
        this.mySelection.selectFieldObjectPath(fieldPath);
    }

    @VisibleForTesting
    @Nullable
    public static MemoryObjectTreeNode<ClassifierSet> findSmallestSuperSetNode(@NotNull MemoryObjectTreeNode<ClassifierSet> rootNode, @NotNull ClassifierSet targetSet) {
        if (rootNode == null) {
            MemoryClassifierView.$$$reportNull$$$0(7);
        }
        if (targetSet == null) {
            MemoryClassifierView.$$$reportNull$$$0(8);
        }
        Set<InstanceObject> target = targetSet.getInstancesStream().collect(Collectors.toSet());
        return targetSet.isEmpty() ? rootNode : (rootNode.getAdapter().isSupersetOf(target) ? MemoryClassifierView.findSmallestSuperSetNode(rootNode, target) : null);
    }

    @NotNull
    private static MemoryObjectTreeNode<ClassifierSet> findSmallestSuperSetNode(@NotNull MemoryObjectTreeNode<ClassifierSet> rootNode, @NotNull Set<InstanceObject> targetSet) {
        if (rootNode == null) {
            MemoryClassifierView.$$$reportNull$$$0(9);
        }
        if (targetSet == null) {
            MemoryClassifierView.$$$reportNull$$$0(10);
        }
        ImmutableList<MemoryObjectTreeNode<ClassifierSet>> childNodes = rootNode.getChildren();
        if (rootNode.getAdapter().immediateInstancesOverlapWith(targetSet)) {
            MemoryObjectTreeNode<ClassifierSet> memoryObjectTreeNode = rootNode;
            if (memoryObjectTreeNode == null) {
                MemoryClassifierView.$$$reportNull$$$0(11);
            }
            return memoryObjectTreeNode;
        }
        List subResults = childNodes.stream().filter(node -> ((ClassifierSet)node.getAdapter()).overlapsWith(targetSet)).collect(Collectors.toList());
        assert (childNodes.isEmpty() || !subResults.isEmpty());
        MemoryObjectTreeNode<ClassifierSet> memoryObjectTreeNode = subResults.size() == 1 ? MemoryClassifierView.findSmallestSuperSetNode((MemoryObjectTreeNode<ClassifierSet>)((MemoryObjectTreeNode)subResults.get(0)), targetSet) : rootNode;
        if (memoryObjectTreeNode == null) {
            MemoryClassifierView.$$$reportNull$$$0(12);
        }
        return memoryObjectTreeNode;
    }

    private void refreshClassSet() {
        if (this.myTreeRoot == null || this.myTreeModel == null || this.myTree == null || this.myClassSet == this.mySelection.getSelectedClassSet()) {
            return;
        }
        this.myClassSet = this.mySelection.getSelectedClassSet();
        if (this.myClassSet != null && !this.myClassSet.isEmpty()) {
            MemoryObjectTreeNode<ClassifierSet> node = MemoryClassifierView.findSmallestSuperSetNode((MemoryObjectTreeNode<ClassifierSet>)this.myTreeRoot, this.myClassSet);
            if (node != null) {
                TreePath treePath = new TreePath(node.getPathToRoot().toArray());
                this.myTree.expandPath(treePath.getParentPath());
                this.myTree.setSelectionPath(treePath);
                this.myTree.scrollPathToVisible(treePath);
            } else {
                this.myClassSet = null;
                this.mySelection.selectClassSet(null);
            }
        }
        if (this.myClassSet == null) {
            this.mySelectedClassifierSet = null;
            this.myTree.clearSelection();
        }
    }

    @NotNull
    @VisibleForTesting
    ColoredTreeCellRenderer getModuleColumnRenderer() {
        return new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                NativeCallStackSet set;
                String name;
                if (tree == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!(value instanceof MemoryObjectTreeNode)) {
                    return;
                }
                MemoryObjectTreeNode node = (MemoryObjectTreeNode)value;
                if (node.getAdapter() instanceof NativeCallStackSet && !Strings.isNullOrEmpty((String)(name = (set = (NativeCallStackSet)node.getAdapter()).getModuleName())) && name.contains("/")) {
                    name = name.substring(name.lastIndexOf("/") + 1);
                    this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES, name);
                }
                this.setTextAlign(2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/profilers/memory/MemoryClassifierView$2", "customizeCellRenderer"));
            }
        };
    }

    @NotNull
    @VisibleForTesting
    ColoredTreeCellRenderer getNameColumnRenderer() {
        return new ColoredTreeCellRenderer(){
            private long myLeakCount = 0L;

            protected void paintComponent(Graphics g) {
                if (this.myLeakCount > 0L) {
                    int width = this.getWidth();
                    int height = this.getHeight();
                    String text = String.valueOf(this.myLeakCount);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    int textWidth = g.getFontMetrics().stringWidth(text);
                    Icon i = this.mySelected && this.isFocused() ? ColoredIconGenerator.generateWhiteIcon((Icon)StudioIcons.Common.WARNING) : StudioIcons.Common.WARNING;
                    int iconWidth = i.getIconWidth();
                    int iconHeight = i.getIconHeight();
                    i.paintIcon((Component)((Object)this), g, width - iconWidth - textWidth - 6, (height - iconHeight) / 2);
                    g.drawString(text, width - textWidth - 4, (height + iconHeight) / 2 - 2);
                }
                super.paintComponent(g);
            }

            private void setIconColorized(Icon icon) {
                this.setIcon(this.mySelected && this.isFocused() ? ColoredIconGenerator.generateWhiteIcon((Icon)icon) : icon);
            }

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                ClassifierSet set;
                if (tree == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!(value instanceof MemoryObjectTreeNode)) {
                    return;
                }
                MemoryObjectTreeNode node = (MemoryObjectTreeNode)value;
                if (node.getAdapter() instanceof ClassSet) {
                    ClassSet classSet = (ClassSet)node.getAdapter();
                    this.setIconColorized(((ClassSet)node.getAdapter()).hasStackInfo() ? StudioIcons.Profiler.Overlays.CLASS_STACK : PlatformIcons.CLASS_ICON);
                    String className = classSet.getClassEntry().getSimpleClassName();
                    String packageName = classSet.getClassEntry().getPackageName();
                    this.append(className, SimpleTextAttributes.REGULAR_ATTRIBUTES, className);
                    if (MemoryClassifierView.this.mySelection.getClassGrouping() == ClassGrouping.ARRANGE_BY_CLASS && !packageName.isEmpty()) {
                        String packageText = " (" + packageName + ")";
                        this.append(packageText, SimpleTextAttributes.GRAY_ATTRIBUTES, packageText);
                    }
                } else if (node.getAdapter() instanceof PackageSet) {
                    set = (ClassifierSet)node.getAdapter();
                    this.setIconColorized(set.hasStackInfo() ? StudioIcons.Profiler.Overlays.PACKAGE_STACK : PlatformIcons.PACKAGE_ICON);
                    String name = set.getName();
                    this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES, name);
                } else if (node.getAdapter() instanceof MethodSet) {
                    this.setIconColorized(PlatformIcons.METHOD_ICON);
                    MethodSet methodObject = (MethodSet)node.getAdapter();
                    String name = methodObject.getMethodName();
                    String className = methodObject.getClassName();
                    String nameAndLine = name + "()";
                    this.append(nameAndLine, SimpleTextAttributes.REGULAR_ATTRIBUTES, nameAndLine);
                    if (!Strings.isNullOrEmpty((String)className)) {
                        String classNameText = " (" + className + ")";
                        this.append(classNameText, SimpleTextAttributes.GRAY_ATTRIBUTES, classNameText);
                    }
                } else if (node.getAdapter() instanceof ThreadSet) {
                    this.setIconColorized(AllIcons.Debugger.ThreadSuspended);
                    String threadName = node.getAdapter().getName();
                    this.append(threadName, SimpleTextAttributes.REGULAR_ATTRIBUTES, threadName);
                } else if (node.getAdapter() instanceof HeapSet) {
                    set = (ClassifierSet)node.getAdapter();
                    this.setIconColorized(set.hasStackInfo() ? StudioIcons.Profiler.Overlays.PACKAGE_STACK : PlatformIcons.PACKAGE_ICON);
                    String name = set.getName() + " heap";
                    this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES, name);
                } else if (node.getAdapter() instanceof NativeCallStackSet) {
                    set = (ClassifierSet)node.getAdapter();
                    this.setIconColorized(StudioIcons.Profiler.Overlays.METHOD_STACK);
                    String name = set.getName();
                    this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES, name);
                } else if (node.getAdapter() instanceof NativeAllocationMethodSet) {
                    set = (ClassifierSet)node.getAdapter();
                    this.setIconColorized(StudioIcons.Profiler.Overlays.ARRAY_STACK);
                    String name = set.getName();
                    this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES, name);
                }
                if (node.getAdapter() instanceof ClassifierSet) {
                    ActivityFragmentLeakInstanceFilter leakFilter = MemoryClassifierView.this.myCaptureObject != null ? MemoryClassifierView.this.myCaptureObject.getActivityFragmentLeakFilter() : null;
                    long l = this.myLeakCount = leakFilter != null ? (long)((ClassifierSet)node.getAdapter()).getInstanceFilterMatchCount(leakFilter) : 0L;
                    this.setToolTipText((String)(this.myLeakCount > 1L ? "There are " + this.myLeakCount + " leaks" : (this.myLeakCount > 0L ? "There is 1 leak" : null)));
                }
                this.setTextAlign(2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/profilers/memory/MemoryClassifierView$3", "customizeCellRenderer"));
            }
        };
    }

    private static Comparator<MemoryObjectTreeNode<ClassifierSet>> createTreeNodeComparator(@NotNull Comparator<NativeCallStackSet> comparator) {
        if (comparator == null) {
            MemoryClassifierView.$$$reportNull$$$0(13);
        }
        return (o1, o2) -> {
            ClassifierSet firstArg = (ClassifierSet)o1.getAdapter();
            ClassifierSet secondArg = (ClassifierSet)o2.getAdapter();
            if (firstArg instanceof NativeCallStackSet && secondArg instanceof NativeCallStackSet) {
                return comparator.compare((NativeCallStackSet)firstArg, (NativeCallStackSet)secondArg);
            }
            return 0;
        };
    }

    private static Comparator<MemoryObjectTreeNode<ClassifierSet>> createTreeNodeComparator(@NotNull Comparator<ClassifierSet> classifierSetComparator, @NotNull Comparator<ClassSet> classSetComparator) {
        if (classifierSetComparator == null) {
            MemoryClassifierView.$$$reportNull$$$0(14);
        }
        if (classSetComparator == null) {
            MemoryClassifierView.$$$reportNull$$$0(15);
        }
        return (o1, o2) -> {
            ClassifierSet firstArg = (ClassifierSet)o1.getAdapter();
            ClassifierSet secondArg = (ClassifierSet)o2.getAdapter();
            int compareResult = firstArg instanceof ClassSet && secondArg instanceof ClassSet ? classSetComparator.compare((ClassSet)firstArg, (ClassSet)secondArg) : (firstArg instanceof ClassSet ? 1 : (secondArg instanceof ClassSet ? -1 : classifierSetComparator.compare(firstArg, secondArg)));
            return compareResult;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProfilerComponents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryClassifierView";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSet";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classifierSetComparator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSetComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryClassifierView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassifierPanel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findSmallestSuperSetNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "makeColumn";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findSmallestSuperSetNode";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTreeNodeComparator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MemoryClassifierTreeNode
    extends LazyMemoryObjectTreeNode<ClassifierSet> {
        private MemoryClassifierTreeNode(@NotNull ClassifierSet classifierSet) {
            if (classifierSet == null) {
                MemoryClassifierTreeNode.$$$reportNull$$$0(0);
            }
            super(classifierSet, false);
        }

        @Override
        public void add(@NotNull MemoryObjectTreeNode child) {
            if (child == null) {
                MemoryClassifierTreeNode.$$$reportNull$$$0(1);
            }
            if (this.myMemoizedChildrenCount == this.myChildren.size()) {
                super.add(child);
                ++this.myMemoizedChildrenCount;
            }
        }

        @Override
        public void remove(@NotNull MutableTreeNode child) {
            if (child == null) {
                MemoryClassifierTreeNode.$$$reportNull$$$0(2);
            }
            if (this.myMemoizedChildrenCount == this.myChildren.size()) {
                super.remove(child);
                --this.myMemoizedChildrenCount;
            }
        }

        @Override
        public int computeChildrenCount() {
            return ((ClassifierSet)this.getAdapter()).getChildrenClassifierSets().size();
        }

        @Override
        public void expandNode() {
            if (this.myMemoizedChildrenCount == this.myChildren.size()) {
                return;
            }
            this.getChildCount();
            ((ClassifierSet)this.getAdapter()).getChildrenClassifierSets().forEach(set -> {
                MemoryClassifierTreeNode node = new MemoryClassifierTreeNode((ClassifierSet)set);
                node.setTreeModel(this.getTreeModel());
                this.insert(node, this.myChildren.size());
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classifierSet";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/profilers/memory/MemoryClassifierView$MemoryClassifierTreeNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "remove";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

