/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.formatter.NumberFormatter;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.stdui.CloseButton;
import com.android.tools.adtui.stdui.CommonTabbedPane;
import com.android.tools.adtui.stdui.ContextMenuItem;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.inspectors.common.api.stacktrace.CodeLocation;
import com.android.tools.inspectors.common.ui.ContextMenuInstaller;
import com.android.tools.inspectors.common.ui.stacktrace.StackTraceView;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.AttributeColumn;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.InstanceDetailsTreeNode;
import com.android.tools.profilers.memory.LazyMemoryObjectTreeNode;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.NearestGCRootTreeNode;
import com.android.tools.profilers.memory.ReferenceTreeNode;
import com.android.tools.profilers.memory.SimpleColumnRenderer;
import com.android.tools.profilers.memory.ValueColumnRenderer;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.android.tools.profilers.memory.adapters.ReferenceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassSet;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.android.tools.profilers.memory.instanceviewers.BitmapViewer;
import com.android.tools.profilers.memory.instanceviewers.InstanceViewer;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongFunction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryInstanceDetailsView
extends AspectObserver {
    private static final String TITLE_TAB_FIELDS = "Fields";
    private static final String TITLE_TAB_REFERENCES = "References";
    private static final String TITLE_TAB_ALLOCATION_CALLSTACK = "Allocation Call Stack";
    private static final String TITLE_TAB_DEALLOCATION_CALLSTACK = "Deallocation Call Stack";
    private static final int LABEL_COLUMN_WIDTH = 500;
    @NotNull
    private final MemoryCaptureSelection mySelection;
    @NotNull
    private final IdeProfilerComponents myIdeProfilerComponents;
    @NotNull
    private final JTabbedPane myTabsPanel;
    @NotNull
    private final StackTraceView myAllocationStackTraceView;
    @NotNull
    private final StackTraceView myDeallocationStackTraceView;
    @Nullable
    private JComponent myReferenceColumnTree;
    @Nullable
    private JTree myReferenceTree;
    @Nullable
    private JTree myFieldTree;
    @NotNull
    private final JBCheckBox myGCRootCheckBox;
    @NotNull
    private final JPanel myRefPanel;
    @NotNull
    private final JBLabel myTitle;
    @NotNull
    private final JBPanel myPanel;
    @NotNull
    private final Map<CaptureObject.InstanceAttribute, AttributeColumn> myAttributeColumns;
    @NotNull
    private final List<InstanceViewer> myInstanceViewers;

    MemoryInstanceDetailsView(@NotNull MemoryCaptureSelection selection2, @NotNull IdeProfilerComponents ideProfilerComponents, @NotNull StreamingTimeline timeline) {
        if (selection2 == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(0);
        }
        if (ideProfilerComponents == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(1);
        }
        if (timeline == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(2);
        }
        this.myGCRootCheckBox = new JBCheckBox("Show nearest GC root only", false);
        this.myRefPanel = new JPanel(new BorderLayout());
        this.myTitle = new JBLabel();
        this.myPanel = new JBPanel((LayoutManager)new BorderLayout());
        this.myAttributeColumns = new HashMap<CaptureObject.InstanceAttribute, AttributeColumn>();
        this.myInstanceViewers = new ArrayList<InstanceViewer>();
        this.mySelection = selection2;
        this.mySelection.getAspect().addDependency((AspectObserver)this).onChange((Enum)CaptureSelectionAspect.CURRENT_INSTANCE, this::instanceChanged).onChange((Enum)CaptureSelectionAspect.CURRENT_FIELD_PATH, this::fieldChanged);
        this.myIdeProfilerComponents = ideProfilerComponents;
        this.myTabsPanel = new CommonTabbedPane();
        this.myTabsPanel.addChangeListener(this::trackActiveTab);
        this.myAllocationStackTraceView = ideProfilerComponents.createStackView(selection2.getAllocationStackTraceModel());
        this.myDeallocationStackTraceView = ideProfilerComponents.createStackView(selection2.getDeallocationStackTraceModel());
        JPanel titleWrapper = new JPanel(new BorderLayout());
        titleWrapper.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, AdtUiUtils.DEFAULT_BORDER_COLOR));
        this.myTitle.setBorder((Border)new JBEmptyBorder(4, 4, 4, 0));
        titleWrapper.add((Component)this.myTitle, "Center");
        titleWrapper.add((Component)new CloseButton(e -> this.mySelection.selectInstanceObject(null)), "East");
        this.myPanel.add((Component)this.myTabsPanel, (Object)"Center");
        this.myPanel.add((Component)titleWrapper, (Object)"North");
        this.myPanel.setBorder((Border)BorderFactory.createMatteBorder(0, 1, 0, 0, AdtUiUtils.DEFAULT_BORDER_COLOR));
        this.myInstanceViewers.add(new BitmapViewer());
        this.myGCRootCheckBox.addItemListener(e -> {
            this.instanceChanged();
            this.myTabsPanel.setSelectedComponent(this.myRefPanel);
            if (e.getStateChange() == 1) {
                this.repeatedlyExpandFirstReference();
            }
        });
        LongFunction<String> timeFormatter = t -> TimeFormatter.getSemiSimplifiedClockString((long)timeline.convertToRelativeTimeUs(t));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.LABEL, new AttributeColumn("Reference", () -> new SimpleColumnRenderer(SimpleColumnRenderer.onSubclass(ReferenceObject.class, v -> v.getName() + " in " + v.getValueText(), ValueObject::getValueText), value -> ValueColumnRenderer.getValueObjectIcon((ValueObject)value.getAdapter()), 2), 2, 500, SortOrder.ASCENDING, Comparator.comparing(o -> ((ValueObject)o.getAdapter()).getName())));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.DEPTH, SimpleColumnRenderer.makeIntColumn("Depth", 150, ValueObject.class, ValueObject::getDepth, d -> 0L <= d && d < Integer.MAX_VALUE, NumberFormatter::formatInteger, SortOrder.ASCENDING));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.ALLOCATION_TIME, SimpleColumnRenderer.makeIntColumn("Alloc Time", 100, InstanceObject.class, InstanceObject::getAllocTime, t -> t > Long.MIN_VALUE, timeFormatter, SortOrder.ASCENDING));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.DEALLOCATION_TIME, SimpleColumnRenderer.makeIntColumn("Dealloc Time", 120, InstanceObject.class, InstanceObject::getDeallocTime, t -> t < Long.MAX_VALUE, timeFormatter, SortOrder.DESCENDING));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.NATIVE_SIZE, SimpleColumnRenderer.makeSizeColumn("Native Size", 110, ValueObject::getNativeSize));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.SHALLOW_SIZE, SimpleColumnRenderer.makeSizeColumn("Shallow Size", 120, ValueObject::getShallowSize));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.RETAINED_SIZE, SimpleColumnRenderer.makeSizeColumn("Retained Size", 130, ValueObject::getRetainedSize));
        this.instanceChanged();
    }

    private void trackActiveTab(ChangeEvent event) {
        if (this.myTabsPanel.getSelectedIndex() < 0) {
            return;
        }
        FeatureTracker featureTracker = this.mySelection.getIdeServices().getFeatureTracker();
        switch (this.myTabsPanel.getTitleAt(this.myTabsPanel.getSelectedIndex())) {
            case "References": {
                featureTracker.trackSelectMemoryReferences();
                break;
            }
            case "Allocation Call Stack": 
            case "Deallocation Call Stack": {
                featureTracker.trackSelectMemoryStack();
                break;
            }
        }
    }

    @NotNull
    JComponent getComponent() {
        JBPanel jBPanel = this.myPanel;
        if (jBPanel == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(3);
        }
        return jBPanel;
    }

    @VisibleForTesting
    @Nullable
    JTree getReferenceTree() {
        return this.myReferenceTree;
    }

    @VisibleForTesting
    @Nullable
    JComponent getReferenceColumnTree() {
        return this.myReferenceColumnTree;
    }

    @VisibleForTesting
    @Nullable
    JTree getFieldTree() {
        return this.myFieldTree;
    }

    @VisibleForTesting
    JBCheckBox getGCRootCheckBox() {
        return this.myGCRootCheckBox;
    }

    private void instanceChanged() {
        List<CodeLocation> deallocCallStack;
        List<CodeLocation> allocCallStack;
        CaptureObject capture = this.mySelection.getSelectedCapture();
        InstanceObject instance = this.mySelection.getSelectedInstanceObject();
        List<FieldObject> fieldPath = this.mySelection.getSelectedFieldObjectPath();
        if (capture == null || instance == null) {
            this.myFieldTree = null;
            this.myReferenceTree = null;
            this.myReferenceColumnTree = null;
            this.getComponent().setVisible(false);
            return;
        }
        this.myTitle.setText("Instance Details - " + (instance.getName().isEmpty() ? instance.getValueText() : instance.getName()));
        this.myTabsPanel.removeAll();
        boolean hasContent = false;
        if (instance.getFieldCount() > 0) {
            JComponent fieldColumnTree = this.buildFieldColumnTree(capture, instance);
            this.myTabsPanel.addTab(TITLE_TAB_FIELDS, fieldColumnTree);
            hasContent = true;
        }
        this.myReferenceColumnTree = this.buildReferenceColumnTree(capture, instance);
        if (this.myReferenceColumnTree != null) {
            this.myRefPanel.removeAll();
            this.myRefPanel.add((Component)this.myReferenceColumnTree, "Center");
            this.myRefPanel.add((Component)this.myGCRootCheckBox, "North");
            this.myTabsPanel.addTab(TITLE_TAB_REFERENCES, this.myRefPanel);
            hasContent = true;
        }
        if (!(allocCallStack = instance.getAllocationCodeLocations()).isEmpty()) {
            this.myAllocationStackTraceView.getModel().setStackFrames(instance.getAllocationThreadId(), allocCallStack);
            JComponent stackTraceView = this.myAllocationStackTraceView.getComponent();
            stackTraceView.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
            this.myTabsPanel.addTab(TITLE_TAB_ALLOCATION_CALLSTACK, stackTraceView);
            hasContent = true;
        }
        if (!(deallocCallStack = instance.getDeallocationCodeLocations()).isEmpty()) {
            this.myDeallocationStackTraceView.getModel().setStackFrames(instance.getDeallocationThreadId(), deallocCallStack);
            JComponent stackTraceView = this.myDeallocationStackTraceView.getComponent();
            stackTraceView.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
            this.myTabsPanel.addTab(TITLE_TAB_DEALLOCATION_CALLSTACK, stackTraceView);
            hasContent = true;
        }
        InstanceObject finalInstance = instance;
        this.myInstanceViewers.forEach(viewer -> {
            JComponent component = viewer.createComponent(this.myIdeProfilerComponents, capture, finalInstance);
            if (component != null) {
                this.myTabsPanel.addTab(viewer.getTitle(), component);
            }
        });
        this.getComponent().setVisible(hasContent);
    }

    private void fieldChanged() {
        List<FieldObject> fieldPath = this.mySelection.getSelectedFieldObjectPath();
        if (!fieldPath.isEmpty()) {
            assert (this.myFieldTree != null);
            MemoryObjectTreeNode instanceNode = (MemoryObjectTreeNode)this.myFieldTree.getModel().getRoot();
            assert (instanceNode != null);
            List<MemoryObjectTreeNode<MemoryObject>> fields = MemoryInstanceDetailsView.findLeafNodesForFieldPath(instanceNode, fieldPath);
            if (!fields.isEmpty()) {
                this.selectPath(fields.get(0));
            }
        }
    }

    private void selectPath(@NotNull MemoryObjectTreeNode<MemoryObject> targetNode) {
        if (targetNode == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(4);
        }
        assert (this.myFieldTree != null);
        TreePath path = new TreePath(((DefaultTreeModel)this.myFieldTree.getModel()).getPathToRoot(targetNode));
        this.myFieldTree.expandPath(path.getParentPath());
        this.myFieldTree.setSelectionPath(path);
        this.myFieldTree.scrollPathToVisible(path);
    }

    @NotNull
    private static List<MemoryObjectTreeNode<MemoryObject>> findLeafNodesForFieldPath(@NotNull MemoryObjectTreeNode<MemoryObject> parentNode, @NotNull List<FieldObject> fieldPath) {
        if (parentNode == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(5);
        }
        if (fieldPath == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(6);
        }
        assert (!fieldPath.isEmpty());
        FieldObject currentField = fieldPath.get(0);
        ArrayList<MemoryObjectTreeNode<MemoryObject>> results = new ArrayList<MemoryObjectTreeNode<MemoryObject>>(1);
        if (fieldPath.size() == 1) {
            parentNode.getChildren().stream().filter(child -> child.getAdapter().equals(currentField)).forEach(results::add);
        } else {
            List<FieldObject> slice = fieldPath.subList(1, fieldPath.size());
            parentNode.getChildren().stream().filter(child -> child.getAdapter().equals(currentField)).forEach(child -> results.addAll(MemoryInstanceDetailsView.findLeafNodesForFieldPath(child, slice)));
        }
        ArrayList<MemoryObjectTreeNode<MemoryObject>> arrayList = results;
        if (arrayList == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private JComponent buildFieldColumnTree(@NotNull CaptureObject captureObject, @NotNull InstanceObject instance) {
        if (captureObject == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(8);
        }
        if (instance == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(9);
        }
        this.myFieldTree = this.buildFieldTree(instance);
        List<CaptureObject.InstanceAttribute> supportedAttributes = captureObject.getInstanceAttributes();
        CaptureObject.InstanceAttribute sortAttribute = Collections.max(supportedAttributes, Comparator.comparingInt(CaptureObject.InstanceAttribute::getWeight));
        ColumnTreeBuilder builder = new ColumnTreeBuilder(this.myFieldTree);
        for (CaptureObject.InstanceAttribute attribute : supportedAttributes) {
            AttributeColumn column = attribute == CaptureObject.InstanceAttribute.LABEL ? new AttributeColumn("Instance", ValueColumnRenderer::new, 2, 500, SortOrder.ASCENDING, Comparator.comparing(SimpleColumnRenderer.onSubclass(ValueObject.class, o -> o.getName().isEmpty() ? o.getValueText() : o.getName(), o -> ""))) : this.myAttributeColumns.get((Object)attribute);
            ColumnTreeBuilder.ColumnBuilder columnBuilder = column.getBuilder();
            if (sortAttribute == attribute) {
                columnBuilder.setInitialOrder(attribute.getSortOrder());
            }
            builder.addColumn(columnBuilder);
        }
        builder.setTreeSorter((comparator, order) -> {
            assert (this.myFieldTree != null);
            DefaultTreeModel treeModel = (DefaultTreeModel)this.myFieldTree.getModel();
            MemoryObjectTreeNode root = (MemoryObjectTreeNode)treeModel.getRoot();
            root.sort(comparator);
            treeModel.nodeStructureChanged(root);
        });
        return builder.setHoverColor(StandardColors.HOVER_COLOR).setBackground(ProfilerColors.DEFAULT_BACKGROUND).setBorder(AdtUiUtils.DEFAULT_TOP_BORDER).setShowVerticalLines(true).setTableIntercellSpacing(new Dimension()).setShowHeaderTooltips(true).build();
    }

    private JTree buildFieldTree(@NotNull InstanceObject instance) {
        if (instance == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(10);
        }
        final InstanceDetailsTreeNode fieldTreeRoot = new InstanceDetailsTreeNode(instance);
        final DefaultTreeModel fieldTreeModel = new DefaultTreeModel(fieldTreeRoot);
        fieldTreeRoot.setTreeModel(fieldTreeModel);
        ((LazyMemoryObjectTreeNode)fieldTreeRoot).expandNode();
        final JTree tree = new JTree();
        int defaultFontHeight = tree.getFontMetrics(tree.getFont()).getHeight();
        tree.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
        tree.setBorder(ProfilerLayout.TABLE_ROW_BORDER);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                assert (path.getLastPathComponent() instanceof LazyMemoryObjectTreeNode);
                LazyMemoryObjectTreeNode treeNode = (LazyMemoryObjectTreeNode)path.getLastPathComponent();
                if (treeNode != fieldTreeRoot) {
                    treeNode.expandNode();
                    fieldTreeModel.nodeStructureChanged(treeNode);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        tree.addTreeSelectionListener(e -> {
            TreePath path = e.getPath();
            if (e.isAddedPath()) {
                MemoryObjectTreeNode node = (MemoryObjectTreeNode)path.getLastPathComponent();
                node.select();
                Object memoryObject = node.getAdapter();
                if (memoryObject instanceof FieldObject) {
                    Object[] fieldNodePath = Arrays.copyOfRange(path.getPath(), 1, path.getPathCount());
                    ArrayList<FieldObject> fieldObjectPath = new ArrayList<FieldObject>(fieldNodePath.length);
                    for (Object fieldNode : fieldNodePath) {
                        if (!(fieldNode instanceof MemoryObjectTreeNode) || !(((MemoryObjectTreeNode)fieldNode).getAdapter() instanceof FieldObject)) {
                            return;
                        }
                        fieldObjectPath.add((FieldObject)((MemoryObjectTreeNode)fieldNode).getAdapter());
                    }
                    this.mySelection.selectFieldObjectPath(fieldObjectPath);
                }
            }
        });
        tree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (tree.getSelectionCount() == 0 && tree.getRowCount() != 0) {
                    tree.setSelectionRow(0);
                }
            }
        });
        tree.setModel(fieldTreeModel);
        this.myIdeProfilerComponents.createContextMenuInstaller().installGenericContextMenu((JComponent)tree, new ContextMenuItem(){

            @NotNull
            public String getText() {
                return "Go to Instance";
            }

            @Nullable
            public Icon getIcon() {
                return null;
            }

            public boolean isEnabled() {
                return MemoryInstanceDetailsView.this.mySelection.getSelectedInstanceObject() != null && !MemoryInstanceDetailsView.this.mySelection.getSelectedFieldObjectPath().isEmpty();
            }

            public void run() {
                List<FieldObject> fieldPath = MemoryInstanceDetailsView.this.mySelection.getSelectedFieldObjectPath();
                FieldObject selectedField = fieldPath.get(fieldPath.size() - 1);
                if (selectedField.getValueType().getIsPrimitive() || selectedField.getValueType() == ValueObject.ValueType.NULL) {
                    return;
                }
                InstanceObject selectedObject = selectedField.getAsInstance();
                assert (selectedObject != null);
                HeapSet heapSet = MemoryInstanceDetailsView.this.mySelection.getSelectedCapture().getHeapSet(selectedObject.getHeapId());
                assert (heapSet != null);
                ClassifierSet classifierSet = heapSet.findContainingClassifierSet(selectedObject);
                assert (classifierSet instanceof ClassSet);
                MemoryInstanceDetailsView.this.mySelection.selectHeapSet(heapSet);
                MemoryInstanceDetailsView.this.mySelection.selectClassSet((ClassSet)classifierSet);
                MemoryInstanceDetailsView.this.mySelection.selectInstanceObject(selectedObject);
                MemoryInstanceDetailsView.this.mySelection.selectFieldObjectPath(Collections.emptyList());
            }
        });
        return tree;
    }

    @Nullable
    private JComponent buildReferenceColumnTree(@NotNull CaptureObject captureObject, @NotNull InstanceObject instance) {
        if (captureObject == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(11);
        }
        if (instance == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(12);
        }
        if (instance.getReferences().isEmpty()) {
            this.myReferenceTree = null;
            return null;
        }
        this.myReferenceTree = this.buildReferenceTree(instance);
        ColumnTreeBuilder builder = new ColumnTreeBuilder(this.myReferenceTree);
        for (CaptureObject.InstanceAttribute attribute : captureObject.getInstanceAttributes()) {
            ColumnTreeBuilder.ColumnBuilder column = this.myAttributeColumns.get((Object)attribute).getBuilder();
            if (attribute == CaptureObject.InstanceAttribute.DEPTH) {
                column.setInitialOrder(attribute.getSortOrder());
            }
            builder.addColumn(column);
        }
        builder.setTreeSorter((comparator, sortOrder) -> {
            assert (this.myReferenceTree.getModel() instanceof DefaultTreeModel);
            DefaultTreeModel treeModel = (DefaultTreeModel)this.myReferenceTree.getModel();
            assert (treeModel.getRoot() instanceof MemoryObjectTreeNode);
            MemoryObjectTreeNode root = (MemoryObjectTreeNode)treeModel.getRoot();
            root.sort(comparator);
            treeModel.nodeStructureChanged(root);
        });
        builder.setHoverColor(StandardColors.HOVER_COLOR);
        builder.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        builder.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
        builder.setShowVerticalLines(true);
        builder.setTableIntercellSpacing(new Dimension());
        builder.setShowHeaderTooltips(true);
        return builder.build();
    }

    @VisibleForTesting
    @NotNull
    JTree buildReferenceTree(@NotNull InstanceObject instance) {
        Object root;
        if (instance == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(13);
        }
        Comparator comparator = null;
        if (this.myReferenceTree != null && this.myReferenceTree.getModel() != null && this.myReferenceTree.getModel().getRoot() != null && (root = this.myReferenceTree.getModel().getRoot()) instanceof ReferenceTreeNode) {
            comparator = ((ReferenceTreeNode)root).getComparator();
        }
        ReferenceTreeNode treeRoot = this.myGCRootCheckBox.isSelected() ? new NearestGCRootTreeNode(instance) : new ReferenceTreeNode(instance);
        treeRoot.expandNode();
        if (comparator != null) {
            treeRoot.sort(comparator);
        }
        final DefaultTreeModel treeModel = new DefaultTreeModel(treeRoot);
        final JTree tree = new JTree(treeModel);
        int defaultFontHeight = tree.getFontMetrics(tree.getFont()).getHeight();
        tree.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
        tree.setBorder(ProfilerLayout.TABLE_ROW_BORDER);
        tree.setRootVisible(true);
        tree.setShowsRootHandles(true);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                assert (path.getLastPathComponent() instanceof MemoryObjectTreeNode);
                ReferenceTreeNode treeNode = (ReferenceTreeNode)path.getLastPathComponent();
                treeNode.expandNode();
                treeModel.nodeStructureChanged(treeNode);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        ContextMenuInstaller contextMenuInstaller = this.myIdeProfilerComponents.createContextMenuInstaller();
        contextMenuInstaller.installNavigationContextMenu((JComponent)tree, this.mySelection.getIdeServices().getCodeNavigator(), () -> {
            TreePath selection2 = tree.getSelectionPath();
            if (selection2 == null) {
                return null;
            }
            Object memoryObject = ((MemoryObjectTreeNode)selection2.getLastPathComponent()).getAdapter();
            if (memoryObject instanceof InstanceObject) {
                return new CodeLocation.Builder(((InstanceObject)memoryObject).getClassEntry().getClassName()).build();
            }
            assert (memoryObject instanceof ReferenceObject);
            return new CodeLocation.Builder(((ReferenceObject)memoryObject).getReferenceInstance().getClassEntry().getClassName()).build();
        });
        contextMenuInstaller.installGenericContextMenu((JComponent)tree, new ContextMenuItem(){

            @NotNull
            public String getText() {
                return "Go to Instance";
            }

            @Nullable
            public Icon getIcon() {
                return null;
            }

            public boolean isEnabled() {
                return tree.getSelectionPath() != null;
            }

            public void run() {
                CaptureObject captureObject = MemoryInstanceDetailsView.this.mySelection.getSelectedCapture();
                TreePath selection2 = tree.getSelectionPath();
                assert (captureObject != null && selection2 != null);
                Object memoryObject = ((MemoryObjectTreeNode)selection2.getLastPathComponent()).getAdapter();
                if (memoryObject instanceof InstanceObject) {
                    assert (memoryObject == MemoryInstanceDetailsView.this.mySelection.getSelectedInstanceObject());
                } else {
                    assert (memoryObject instanceof ReferenceObject);
                    InstanceObject targetInstance = ((ReferenceObject)memoryObject).getReferenceInstance();
                    HeapSet heapSet = captureObject.getHeapSet(targetInstance.getHeapId());
                    assert (heapSet != null);
                    MemoryInstanceDetailsView.this.mySelection.selectHeapSet(heapSet);
                    ClassifierSet classifierSet = heapSet.findContainingClassifierSet(targetInstance);
                    assert (classifierSet instanceof ClassSet);
                    MemoryInstanceDetailsView.this.mySelection.selectClassSet((ClassSet)classifierSet);
                    MemoryInstanceDetailsView.this.mySelection.selectInstanceObject(targetInstance);
                }
            }
        });
        JTree jTree = tree;
        if (jTree == null) {
            MemoryInstanceDetailsView.$$$reportNull$$$0(14);
        }
        return jTree;
    }

    private void repeatedlyExpandFirstReference() {
        assert (this.myReferenceTree != null);
        ReferenceTreeNode node = (ReferenceTreeNode)this.myReferenceTree.getModel().getRoot();
        node.expandNode();
        while (!node.myChildren.isEmpty()) {
            node = (ReferenceTreeNode)node.myChildren.get(0);
            node.expandNode();
        }
        TreePath path = new TreePath(node.getPathToRoot().toArray());
        this.myReferenceTree.expandPath(path);
        this.myReferenceTree.setSelectionPath(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProfilerComponents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeline";
                break;
            }
            case 3: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryInstanceDetailsView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldPath";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryInstanceDetailsView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findLeafNodesForFieldPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildReferenceTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findLeafNodesForFieldPath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildFieldColumnTree";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildFieldTree";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildReferenceColumnTree";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildReferenceTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

