/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public final class ClassDb {
    public static final int INVALID_CLASS_ID = -1;
    public static final String JAVA_LANG_STRING = "java.lang.String";
    public static final String JAVA_LANG_CLASS = "java.lang.Class";
    private final Map<Long, ClassEntry> myClassEntries = new HashMap<Long, ClassEntry>();
    private boolean myResolvedSubclasses = false;

    public void clear() {
        this.myClassEntries.clear();
        this.myResolvedSubclasses = false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ClassEntry registerClass(long classId, @NotNull String string) {
        void className;
        if (string == null) {
            ClassDb.$$$reportNull$$$0(0);
        }
        ClassEntry classEntry = this.registerClass(classId, -1L, (String)className);
        if (classEntry == null) {
            ClassDb.$$$reportNull$$$0(1);
        }
        return classEntry;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ClassEntry registerClass(long classId, long superClassId, @NotNull String string) {
        void className;
        ClassEntry entry;
        if (string == null) {
            ClassDb.$$$reportNull$$$0(2);
        }
        if ((entry = this.myClassEntries.get(classId)) == null || superClassId != entry.mySuperClassId || !className.equals(entry.myClassName)) {
            entry = new ClassEntry(classId, superClassId, (String)className);
            this.myClassEntries.put(classId, entry);
        }
        ClassEntry classEntry = entry;
        if (classEntry == null) {
            ClassDb.$$$reportNull$$$0(3);
        }
        return classEntry;
    }

    @NotNull
    public ClassEntry getEntry(long classId) {
        assert (this.myClassEntries.containsKey(classId));
        ClassEntry classEntry = this.myClassEntries.get(classId);
        if (classEntry == null) {
            ClassDb.$$$reportNull$$$0(4);
        }
        return classEntry;
    }

    @NotNull
    public Set<ClassEntry> getEntriesByName(@NotNull String className) {
        if (className == null) {
            ClassDb.$$$reportNull$$$0(5);
        }
        HashSet<ClassEntry> entries = new HashSet<ClassEntry>();
        for (ClassEntry entry : this.myClassEntries.values()) {
            if (!entry.getClassName().equals(className)) continue;
            entries.add(entry);
        }
        HashSet<ClassEntry> hashSet = entries;
        if (hashSet == null) {
            ClassDb.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    public Set<ClassEntry> getDescendantClasses(long classId) {
        this.resolveSubClasses();
        ClassEntry klass = this.getEntry(classId);
        HashSet<ClassEntry> descendants = new HashSet<ClassEntry>();
        Stack<ClassEntry> searchStack = new Stack<ClassEntry>();
        searchStack.push(klass);
        while (!searchStack.isEmpty()) {
            ClassEntry searchEntry = (ClassEntry)searchStack.pop();
            descendants.add(searchEntry);
            for (long subClassId : searchEntry.getSubClassIds()) {
                searchStack.push(this.getEntry(subClassId));
            }
        }
        return descendants;
    }

    private boolean resolveSubClasses() {
        if (this.myResolvedSubclasses) {
            return false;
        }
        for (ClassEntry entry : this.myClassEntries.values()) {
            long superClassId = entry.getSuperClassId();
            if (superClassId == -1L) continue;
            this.getEntry(superClassId).getSubClassIds().add(entry.getClassId());
        }
        this.myResolvedSubclasses = true;
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/ClassDb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/ClassDb";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "registerClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntry";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntriesByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerClass";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEntriesByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ClassEntry {
        @NotNull
        private final Set<Long> mySubClassIds;
        @NotNull
        private final long myClassId;
        @NotNull
        private final long mySuperClassId;
        @NotNull
        private final String myClassName;
        @NotNull
        private final String[] mySplitPackageName;

        /*
         * WARNING - void declaration
         */
        public ClassEntry(long classId, long superClassId, @NotNull String string) {
            void className;
            if (string == null) {
                ClassEntry.$$$reportNull$$$0(0);
            }
            this.mySubClassIds = new HashSet<Long>();
            this.myClassId = classId;
            this.mySuperClassId = superClassId;
            this.myClassName = className;
            String packageName = this.getPackageName();
            this.mySplitPackageName = packageName.isEmpty() ? ArrayUtil.EMPTY_STRING_ARRAY : packageName.split("\\.");
        }

        public long getClassId() {
            return this.myClassId;
        }

        public long getSuperClassId() {
            return this.mySuperClassId;
        }

        public Set<Long> getSubClassIds() {
            return this.mySubClassIds;
        }

        @NotNull
        public String getClassName() {
            String string = this.myClassName;
            if (string == null) {
                ClassEntry.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getPackageName() {
            int lastIndexOfDot = this.getLastIndexOfDot();
            return lastIndexOfDot > 0 ? this.myClassName.substring(0, lastIndexOfDot) : "";
        }

        @NotNull
        public String[] getSplitPackageName() {
            if (this.mySplitPackageName == null) {
                ClassEntry.$$$reportNull$$$0(2);
            }
            return this.mySplitPackageName;
        }

        @NotNull
        public String getSimpleClassName() {
            String string = this.myClassName.substring(this.getLastIndexOfDot() + 1);
            if (string == null) {
                ClassEntry.$$$reportNull$$$0(3);
            }
            return string;
        }

        public int hashCode() {
            return this.myClassName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ClassEntry && this.myClassName.equals(((ClassEntry)obj).myClassName);
        }

        private int getLastIndexOfDot() {
            return this.myClassName.lastIndexOf(46);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/memory/adapters/ClassDb$ClassEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/memory/adapters/ClassDb$ClassEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSplitPackageName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimpleClassName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

