/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.gnu.trove.decorator;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.gnu.trove.TFloatDoubleHashMap;
import org.gradle.internal.impldep.gnu.trove.TFloatDoubleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFloatDoubleHashMapDecorator
extends AbstractMap<Float, Double> {
    protected final TFloatDoubleHashMap _map;

    public TFloatDoubleHashMapDecorator(TFloatDoubleHashMap map) {
        this._map = map;
    }

    @Override
    public Double put(Float key, Double value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Float && val instanceof Double) {
                    float k = this.unwrapKey(key);
                    double v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Double get(Object object) {
        return this.get((Float)object);
    }

    public Double get(Float key) {
        float k = this.unwrapKey(key);
        double v = this._map.get(k);
        if (v == 0.0) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Double remove(Float key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Double remove(Object object) {
        return this.remove((Float)object);
    }

    @Override
    public Set<Map.Entry<Float, Double>> entrySet() {
        return new AbstractSet<Map.Entry<Float, Double>>(){

            @Override
            public int size() {
                return TFloatDoubleHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TFloatDoubleHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TFloatDoubleHashMapDecorator.this.containsKey(k) && TFloatDoubleHashMapDecorator.this.get(k).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Float, Double>> iterator() {
                return new Iterator<Map.Entry<Float, Double>>(){
                    private final TFloatDoubleIterator it;
                    {
                        this.it = TFloatDoubleHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Float, Double> next() {
                        this.it.advance();
                        final Float key = TFloatDoubleHashMapDecorator.this.wrapKey(this.it.key());
                        final Double v = TFloatDoubleHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Float, Double>(){
                            private Double val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public Float getKey() {
                                return key;
                            }

                            @Override
                            public Double getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Double setValue(Double value) {
                                this.val = value;
                                return TFloatDoubleHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<Float, Double> o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Float, Double>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TFloatDoubleHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Double> map) {
        Iterator<Map.Entry<? extends Float, ? extends Double>> it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry<? extends Float, ? extends Double> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Float wrapKey(float k) {
        return new Float(k);
    }

    protected float unwrapKey(Object key) {
        return ((Float)key).floatValue();
    }

    protected Double wrapValue(double k) {
        return new Double(k);
    }

    protected double unwrapValue(Object value) {
        return (Double)value;
    }
}

