/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import org.gradle.internal.impldep.org.eclipse.jgit.api.GitCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.RefNotFoundException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ReflogEntry;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ReflogReader;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;

public class ReflogCommand
extends GitCommand<Collection<ReflogEntry>> {
    private String ref = "HEAD";

    public ReflogCommand(Repository repo) {
        super(repo);
    }

    public ReflogCommand setRef(String ref) {
        this.checkCallable();
        this.ref = ref;
        return this;
    }

    @Override
    public Collection<ReflogEntry> call() throws GitAPIException, InvalidRefNameException {
        this.checkCallable();
        try {
            ReflogReader reader = this.repo.getReflogReader(this.ref);
            if (reader == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.ref));
            }
            return reader.getReverseEntries();
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, this.ref), e);
        }
    }
}

