/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator40;
import org.jetbrains.plugins.groovy.annotator.UtilKt;
import org.jetbrains.plugins.groovy.annotator.intentions.AddToPermitsList;
import org.jetbrains.plugins.groovy.annotator.intentions.GrChangeModifiersFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GrReplaceReturnWithYield;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrYieldStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSwitchExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrPermitsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrRecordDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.util.GrRecordUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.SealedUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;
import org.jetbrains.plugins.groovy.transformations.immutable.GrImmutableUtils;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 A2\u00020\u0001:\u0001AB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J'\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\b\"\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u001a\u0010 \u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0013H\u0002J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\tH\u0016J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0019H\u0016J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u001cH\u0016J\u0014\u00104\u001a\u00020\u0006*\u00020\u001c2\u0006\u00105\u001a\u000206H\u0002J\u0014\u00107\u001a\u00020\u0006*\u00020\u001c2\u0006\u00108\u001a\u000209H\u0002J\u0014\u0010:\u001a\u00020\u0006*\u00020\u001c2\u0006\u0010;\u001a\u00020<H\u0002J\u0014\u0010=\u001a\u00020\u0006*\u00020\u001c2\u0006\u0010>\u001a\u00020?H\u0002J\f\u0010@\u001a\u00020\u0006*\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotator40;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "checkArrowColonConsistency", "", "caseSections", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/clauses/GrCaseSection;", "([Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/clauses/GrCaseSection;)V", "checkCompactConstructor", "method", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "checkEnum", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "checkExclusiveness", "exclusiveElement", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/psi/PsiElement;)Lkotlin/Unit;", "checkFormalRecordParameters", "formalParameter", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/params/GrParameter;", "record", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrRecordDefinition;", "checkNonSealed", "owner", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "nonSealedElement", "checkRecordModifiers", "recordDefinition", "checkSealed", "sealedElement", "checkSealingModifiers", "createExclusivenessAnnotation", "element", "visitCaseSection", "caseSection", "visitMethod", "visitRecordDefinition", "visitSwitchElement", "switchElement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrSwitchElement;", "visitSwitchExpression", "switchExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrSwitchExpression;", "visitSwitchStatement", "switchStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrSwitchStatement;", "visitTypeDefinition", "typeDefinition", "checkExtendsClause", "extendsClause", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrExtendsClause;", "checkImplementsClause", "implementsClause", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrImplementsClause;", "checkPermissions", "referenceClause", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrReferenceList;", "checkPermitsClause", "permitsClause", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrPermitsClause;", "forbidForRecord", "Companion", "intellij.groovy.psi"})
public final class GroovyAnnotator40
extends GroovyElementVisitor {
    private final AnnotationHolder holder;
    private static final List<String> CONFLICTING_MODIFIERS;
    private static final List<String> FORBIDDEN_FOR_RECORD;
    @NotNull
    public static final Companion Companion;

    @Override
    public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        GrPermitsClause it;
        GrReferenceList grReferenceList;
        Intrinsics.checkNotNullParameter((Object)typeDefinition, (String)"typeDefinition");
        this.checkSealingModifiers(typeDefinition);
        GrPermitsClause grPermitsClause = typeDefinition.getPermitsClause();
        if (grPermitsClause != null) {
            it = grReferenceList = grPermitsClause;
            boolean bl = false;
            GrPermitsClause grPermitsClause2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)grPermitsClause2, (String)"it");
            this.checkPermitsClause(typeDefinition, grPermitsClause2);
        }
        GrExtendsClause grExtendsClause = typeDefinition.getExtendsClause();
        if (grExtendsClause != null) {
            it = grReferenceList = grExtendsClause;
            boolean bl = false;
            GrPermitsClause grPermitsClause3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)grPermitsClause3, (String)"it");
            this.checkExtendsClause(typeDefinition, (GrExtendsClause)((Object)grPermitsClause3));
        }
        GrImplementsClause grImplementsClause = typeDefinition.getImplementsClause();
        if (grImplementsClause != null) {
            it = grReferenceList = grImplementsClause;
            boolean bl = false;
            GrPermitsClause grPermitsClause4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)grPermitsClause4, (String)"it");
            this.checkImplementsClause(typeDefinition, (GrImplementsClause)((Object)grPermitsClause4));
        }
        super.visitTypeDefinition(typeDefinition);
    }

    @Override
    public void visitRecordDefinition(@NotNull GrRecordDefinition recordDefinition) {
        Intrinsics.checkNotNullParameter((Object)recordDefinition, (String)"recordDefinition");
        GrModifierList grModifierList = (GrModifierList)recordDefinition.getModifierList();
        if (grModifierList != null) {
            GrModifierList grModifierList2;
            GrModifierList it = grModifierList2 = grModifierList;
            boolean bl = false;
            GrModifierList grModifierList3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)grModifierList3, (String)"it");
            this.checkRecordModifiers(grModifierList3);
        }
        GrParameter[] grParameterArray = recordDefinition.getParameters();
        int n = grParameterArray.length;
        for (int i = 0; i < n; ++i) {
            GrParameter formalParameter;
            GrParameter grParameter = formalParameter = grParameterArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)grParameter, (String)"formalParameter");
            this.checkFormalRecordParameters(grParameter, recordDefinition);
        }
        super.visitRecordDefinition(recordDefinition);
    }

    private final void checkFormalRecordParameters(GrParameter formalParameter, GrRecordDefinition record) {
        GrField grField;
        block4: {
            GrField[] grFieldArray;
            GrField[] grFieldArray2;
            if (formalParameter.hasModifierProperty("static")) {
                return;
            }
            GrField[] grFieldArray3 = record.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)grFieldArray3, (String)"record.fields");
            for (GrField grField2 : grFieldArray2 = (grFieldArray = grFieldArray3)) {
                GrField it = grField2;
                boolean bl = false;
                GrField grField3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)grField3, (String)"it");
                if (!Intrinsics.areEqual((Object)grField3.getName(), (Object)formalParameter.getName())) continue;
                grField = grField2;
                break block4;
            }
            grField = null;
        }
        if (grField == null) {
            return;
        }
        GrField field = grField;
        if (!GrImmutableUtils.isImmutable(field)) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.record.parameter.should.be.immutable", formalParameter.getName())).range(formalParameter.getNameIdentifierGroovy()).create();
        }
    }

    private final void checkRecordModifiers(GrModifierList recordDefinition) {
        block7: {
            GrAnnotation grAnnotation;
            block6: {
                GrAnnotation grAnnotation2;
                GrAnnotation it;
                GrAnnotation[] grAnnotationArray;
                GrAnnotation[] grAnnotationArray2;
                block5: {
                    PsiElement psiElement = recordDefinition.getModifier("sealed");
                    if (psiElement != null) {
                        this.forbidForRecord(psiElement);
                    }
                    PsiElement psiElement2 = recordDefinition.getModifier("non-sealed");
                    if (psiElement2 != null) {
                        this.forbidForRecord(psiElement2);
                    }
                    GrAnnotation[] grAnnotationArray3 = recordDefinition.getAnnotations();
                    Intrinsics.checkNotNullExpressionValue((Object)grAnnotationArray3, (String)"recordDefinition.annotations");
                    for (GrAnnotation grAnnotation3 : grAnnotationArray2 = (grAnnotationArray = grAnnotationArray3)) {
                        it = grAnnotation3;
                        boolean bl = false;
                        GrAnnotation grAnnotation4 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)grAnnotation4, (String)"it");
                        if (!Intrinsics.areEqual((Object)grAnnotation4.getQualifiedName(), (Object)"groovy.transform.Sealed")) continue;
                        grAnnotation2 = grAnnotation3;
                        break block5;
                    }
                    grAnnotation2 = null;
                }
                if (grAnnotation2 != null) {
                    this.forbidForRecord(grAnnotation2);
                }
                GrAnnotation[] grAnnotationArray4 = recordDefinition.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)grAnnotationArray4, (String)"recordDefinition.annotations");
                for (GrAnnotation grAnnotation3 : grAnnotationArray2 = (grAnnotationArray = grAnnotationArray4)) {
                    it = grAnnotation3;
                    boolean bl = false;
                    GrAnnotation grAnnotation5 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)grAnnotation5, (String)"it");
                    if (!Intrinsics.areEqual((Object)grAnnotation5.getQualifiedName(), (Object)"groovy.transform.NonSealed")) continue;
                    grAnnotation = grAnnotation3;
                    break block6;
                }
                grAnnotation = null;
            }
            if (grAnnotation == null) break block7;
            this.forbidForRecord(grAnnotation);
        }
    }

    private final void forbidForRecord(PsiElement $this$forbidForRecord) {
        String elementName = $this$forbidForRecord instanceof GrAnnotation ? ((GrAnnotation)$this$forbidForRecord).getShortName() : $this$forbidForRecord.getText();
        AnnotationBuilder annotationBuilder = this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.0.not.allowed.for.record", elementName)).range($this$forbidForRecord);
        String string = GroovyBundle.message("intention.name.remove.wrong.modifiers.for.record", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GroovyBundle.message(\"in\u2026ng.modifiers.for.record\")");
        annotationBuilder.withFix((IntentionAction)new GrChangeModifiersFix(FORBIDDEN_FOR_RECORD, null, string, true)).create();
    }

    private final void checkSealingModifiers(GrTypeDefinition owner) {
        GrModifierList grModifierList = (GrModifierList)owner.getModifierList();
        if (grModifierList == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)grModifierList, (String)"owner.modifierList ?: return");
        GrModifierList modifierList = grModifierList;
        if (owner instanceof GrEnumTypeDefinition) {
            this.checkEnum(modifierList);
            return;
        }
        PsiElement sealed = modifierList.getModifier("sealed");
        PsiElement nonSealed = modifierList.getModifier("non-sealed");
        PsiElement psiElement = modifierList.getModifier("final");
        PsiAnnotation sealedAnno = modifierList.findAnnotation("groovy.transform.Sealed");
        PsiAnnotation nonSealedAnno = modifierList.findAnnotation("groovy.transform.NonSealed");
        this.checkExclusiveness(sealed, nonSealed, psiElement, (PsiElement)sealedAnno, (PsiElement)nonSealedAnno);
        PsiElement psiElement2 = sealed;
        if (psiElement2 == null) {
            psiElement2 = (PsiElement)sealedAnno;
        }
        this.checkSealed(owner, psiElement2);
        PsiElement psiElement3 = nonSealed;
        if (psiElement3 == null) {
            psiElement3 = (PsiElement)nonSealedAnno;
        }
        this.checkNonSealed(owner, psiElement3);
    }

    /*
     * WARNING - void declaration
     */
    private final Unit checkExclusiveness(PsiElement ... exclusiveElement) {
        Unit unit;
        Iterable iterable;
        List it = iterable = ArraysKt.filterNotNull((Object[])exclusiveElement);
        boolean bl = false;
        List list = it.size() > 1 ? iterable : null;
        if (list != null) {
            void $this$forEach$iv;
            iterable = list;
            GroovyAnnotator40 groovyAnnotator40 = this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement p1 = (PsiElement)element$iv;
                boolean bl2 = false;
                groovyAnnotator40.createExclusivenessAnnotation(p1);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final void createExclusivenessAnnotation(PsiElement element) {
        String elementName = element instanceof GrAnnotation ? ((GrAnnotation)element).getShortName() : element.getText();
        AnnotationBuilder annotationBuilder = this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.only.one.final.sealed.non.sealed.should.be.applied.to.class", new Object[0])).range(element);
        String string = GroovyBundle.message("leave.only.modifier.or.annotation.0", elementName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GroovyBundle.message(\"le\u2026notation.0\", elementName)");
        annotationBuilder.withFix((IntentionAction)new GrChangeModifiersFix(CONFLICTING_MODIFIERS, null, string, false, 8, null)).create();
    }

    private final void checkSealed(GrTypeDefinition owner, PsiElement sealedElement) {
        if (sealedElement == null) {
            return;
        }
        if (SealedUtil.getAllPermittedClassElements(owner).isEmpty()) {
            if (owner.isInterface()) {
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.interface.has.no.explicit.or.implicit.implementors", owner.getName())).range(sealedElement).create();
            } else {
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.class.has.no.explicit.or.implicit.subclasses", owner.getName())).range(sealedElement).create();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkNonSealed(GrTypeDefinition owner, PsiElement nonSealedElement) {
        boolean bl;
        block9: {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            if (nonSealedElement == null) {
                return;
            }
            Iterable $this$flatMap$iv = CollectionsKt.listOfNotNull((Object[])new GrReferenceList[]{owner.getExtendsClause(), owner.getImplementsClause()});
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                GrReferenceList it = (GrReferenceList)element$iv$iv;
                boolean bl2 = false;
                Object[] objectArray = it.getReferencedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"it.referencedTypes");
                Iterable list$iv$iv = ArraysKt.asList((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List referencedClasses = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = referencedClasses;
            boolean $i$f$mapNotNull = false;
            $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PsiClass psiClass;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                PsiClassType p1 = (PsiClassType)element$iv$iv;
                boolean bl4 = false;
                PsiClass psiClass2 = p1.resolve();
                if (psiClass2 == null) continue;
                PsiClass it$iv$iv = psiClass = psiClass2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$all$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiClass it = (PsiClass)element$iv;
                    boolean bl6 = false;
                    if (!(it instanceof GrTypeDefinition) || SealedUtil.getSealedElement((GrTypeDefinition)it) == null) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl) {
            if (owner.isInterface()) {
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.interface.cannot.be.non.sealed.without.sealed.parent", owner.getName())).range(nonSealedElement).create();
            } else {
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.class.cannot.be.non.sealed.without.sealed.parent", owner.getName())).range(nonSealedElement).create();
            }
        }
    }

    private final void checkEnum(GrModifierList modifierList) {
        block1: {
            PsiAnnotation it;
            PsiAnnotation psiAnnotation;
            String string = GroovyBundle.message("inspection.message.modifier.sealed.cannot.be.applied.to.enum.class", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GroovyBundle.message(\"in\u2026e.applied.to.enum.class\")");
            UtilKt.checkModifierIsNotAllowed(modifierList, "sealed", string, this.holder);
            String string2 = GroovyBundle.message("inspection.message.modifier.non.sealed.cannot.be.applied.to.enum.class", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GroovyBundle.message(\"in\u2026e.applied.to.enum.class\")");
            UtilKt.checkModifierIsNotAllowed(modifierList, "non-sealed", string2, this.holder);
            PsiAnnotation psiAnnotation2 = modifierList.findAnnotation("groovy.transform.Sealed");
            if (psiAnnotation2 != null) {
                it = psiAnnotation = psiAnnotation2;
                boolean bl = false;
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.annotation.sealed.cannot.be.applied.to.enum.class", new Object[0])).range((PsiElement)it).create();
            }
            PsiAnnotation psiAnnotation3 = modifierList.findAnnotation("groovy.transform.NonSealed");
            if (psiAnnotation3 == null) break block1;
            it = psiAnnotation = psiAnnotation3;
            boolean bl = false;
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.annotation.non.sealed.cannot.be.applied.to.enum.class", new Object[0])).range((PsiElement)it).create();
        }
    }

    private final void checkPermitsClause(GrTypeDefinition $this$checkPermitsClause, GrPermitsClause permitsClause) {
        block6: {
            block5: {
                if (permitsClause.getKeyword() == null) break block5;
                PsiClassType[] psiClassTypeArray = permitsClause.getReferencedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"permitsClause.referencedTypes");
                PsiClassType[] psiClassTypeArray2 = psiClassTypeArray;
                if (!(psiClassTypeArray2.length == 0)) break block6;
            }
            super.visitPermitsClause(permitsClause);
            return;
        }
        GrModifierList grModifierList = (GrModifierList)$this$checkPermitsClause.getModifierList();
        if (grModifierList != null) {
            if (grModifierList.hasModifierProperty("sealed")) {
                return;
            }
        }
        String string = GroovyBundle.message("add.modifier.sealed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GroovyBundle.message(\"add.modifier.sealed\")");
        GrChangeModifiersFix fix = new GrChangeModifiersFix(CONFLICTING_MODIFIERS, "sealed", string, false, 8, null);
        AnnotationBuilder annotationBuilder = this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.invalid.permits.clause.must.be.sealed", $this$checkPermitsClause.getName()));
        PsiElement psiElement = permitsClause.getKeyword();
        Intrinsics.checkNotNull((Object)psiElement);
        annotationBuilder.range(psiElement).withFix((IntentionAction)fix).create();
    }

    private final void checkExtendsClause(GrTypeDefinition $this$checkExtendsClause, GrExtendsClause extendsClause) {
        this.checkPermissions($this$checkExtendsClause, extendsClause);
    }

    private final void checkImplementsClause(GrTypeDefinition $this$checkImplementsClause, GrImplementsClause implementsClause) {
        this.checkPermissions($this$checkImplementsClause, implementsClause);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkPermissions(GrTypeDefinition $this$checkPermissions, GrReferenceList referenceClause) {
        PsiClassType ownerType = InferenceKt.type($this$checkPermissions);
        Object[] objectArray = referenceClause.getReferencedTypes();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"referenceClause.referencedTypes");
        Object[] objectArray2 = referenceClause.getReferenceElementsGroovy();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"referenceClause.referenceElementsGroovy");
        for (Pair pair : ArraysKt.zip((Object[])objectArray, (Object[])objectArray2)) {
            AnnotationBuilder annotationBuilder;
            GrTypeDefinition baseClass;
            PsiClass psiClass;
            Object object;
            void type2;
            PsiClassType psiClassType = (PsiClassType)pair.component1();
            GrCodeReferenceElement element = (GrCodeReferenceElement)pair.component2();
            if (type2.resolve() != null) {
                PsiClass psiClass2;
                PsiClass it = psiClass2;
                boolean bl = false;
                object = it instanceof GrTypeDefinition && SealedUtil.getSealedElement((GrTypeDefinition)it) != null ? psiClass2 : null;
            } else {
                object = psiClass = null;
            }
            if (!(object instanceof GrTypeDefinition)) {
                psiClass = null;
            }
            if ((GrTypeDefinition)psiClass == null) {
                continue;
            }
            List<PsiClass> permittedClasses = SealedUtil.getAllPermittedClasses(baseClass);
            if (permittedClasses.contains($this$checkPermissions)) continue;
            AnnotationBuilder $this$apply = annotationBuilder = this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.not.allowed.in.sealed.hierarchy", ownerType.getClassName())).range((PsiElement)element);
            boolean bl = false;
            if (baseClass.hasModifierProperty("sealed")) {
                if (baseClass.getPermitsClause() != null) {
                    GrPermitsClause grPermitsClause;
                    GrPermitsClause it = grPermitsClause;
                    boolean bl2 = false;
                    PsiClass psiClass3 = $this$checkPermissions;
                    GrPermitsClause grPermitsClause2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)grPermitsClause2, (String)"it");
                    $this$apply.withFix((IntentionAction)new AddToPermitsList(psiClass3, grPermitsClause2));
                }
            }
            annotationBuilder.create();
        }
    }

    @Override
    public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
        Intrinsics.checkNotNullParameter((Object)switchStatement, (String)"switchStatement");
        this.visitSwitchElement(switchStatement);
        super.visitSwitchStatement(switchStatement);
    }

    @Override
    public void visitSwitchExpression(@NotNull GrSwitchExpression switchExpression) {
        Intrinsics.checkNotNullParameter((Object)switchExpression, (String)"switchExpression");
        this.visitSwitchElement(switchExpression);
        super.visitSwitchExpression(switchExpression);
    }

    @Override
    public void visitMethod(@NotNull GrMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (method.getContainingClass() instanceof GrRecordDefinition && GrRecordUtils.isCompactConstructor(method)) {
            this.checkCompactConstructor(method);
        }
        super.visitMethod(method);
    }

    private final void checkCompactConstructor(GrMethod method) {
        if (method.getModifierList().getModifier("public") == null && method.getModifierList().getModifier("private") == null && method.getModifierList().getModifier("protected") == null) {
            AnnotationBuilder annotationBuilder = this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.compact.constructor.should.have.explicit.visibility.modifier", new Object[0])).range(method.getNameIdentifierGroovy());
            List list = CollectionsKt.emptyList();
            String string = GroovyBundle.message("intention.name.make.compact.constructor.public", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GroovyBundle.message(\"in\u2026pact.constructor.public\")");
            annotationBuilder.withFix((IntentionAction)new GrChangeModifiersFix(list, "public", string, false, 8, null)).create();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void visitSwitchElement(GrSwitchElement switchElement) {
        block18: {
            PsiElement it;
            boolean $i$f$all;
            GrCaseSection[] $this$all$iv;
            Sequence jointFlow2;
            int n;
            Object object;
            GrCaseSection[] caseSections;
            block17: {
                boolean bl;
                block14: {
                    void var7_10;
                    void var7_8;
                    void $this$forEach$iv;
                    Object it2;
                    if (PsiUtil.isPlainSwitchStatement(switchElement)) {
                        return;
                    }
                    GrCaseSection[] grCaseSectionArray = switchElement.getCaseSections();
                    if (grCaseSectionArray == null) {
                        grCaseSectionArray = new GrCaseSection[]{};
                    }
                    GrCaseSection[] grCaseSectionArray2 = caseSections = grCaseSectionArray;
                    if (grCaseSectionArray2.length == 0) {
                        GrCaseSection[] grCaseSectionArray3 = switchElement.getFirstChild();
                        if (grCaseSectionArray3 != null) {
                            it2 = grCaseSectionArray2 = grCaseSectionArray3;
                            boolean bl2 = false;
                            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.case.or.default.branches.are.expected", new Object[0])).range((PsiElement)it2).create();
                        }
                    }
                    this.checkArrowColonConsistency(caseSections);
                    grCaseSectionArray2 = caseSections;
                    it2 = this;
                    boolean $i$f$forEach = false;
                    object = $this$forEach$iv;
                    boolean bl2 = false;
                    n = ((void)object).length;
                    while (var7_8 < n) {
                        void var9_16 = object[var7_8];
                        ++var7_8;
                        void p1 = var9_16;
                        boolean bl3 = false;
                        ((GroovyAnnotator40)it2).visitCaseSection((GrCaseSection)p1);
                    }
                    jointFlow2 = SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])caseSections), (Function1)visitSwitchElement.jointFlow.1.INSTANCE);
                    if (!(switchElement instanceof GrSwitchStatement)) break block17;
                    $this$all$iv = caseSections;
                    $i$f$all = false;
                    object = $this$all$iv;
                    boolean bl3 = false;
                    n = ((PsiElement)object).length;
                    while (var7_10 < n) {
                        PsiElement psiElement = object[var7_10];
                        ++var7_10;
                        it = psiElement;
                        boolean bl4 = false;
                        PsiElement psiElement2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"it");
                        if (psiElement2.getColon() != null) continue;
                        bl = false;
                        break block14;
                    }
                    bl = true;
                }
                if (bl) break block18;
            }
            if (!(($this$all$iv = caseSections).length == 0)) {
                boolean bl;
                block15: {
                    void var7_12;
                    $this$all$iv = caseSections;
                    $i$f$all = false;
                    object = $this$all$iv;
                    boolean bl4 = false;
                    n = ((PsiElement)object).length;
                    while (var7_12 < n) {
                        PsiElement psiElement = object[var7_12];
                        ++var7_12;
                        it = psiElement;
                        boolean bl5 = false;
                        PsiElement psiElement3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"it");
                        if (psiElement3.getColon() != null) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
                if (bl) {
                    boolean bl5;
                    block16: {
                        $this$all$iv = jointFlow2;
                        $i$f$all = false;
                        for (Object e : $this$all$iv) {
                            Instruction it3 = (Instruction)e;
                            boolean bl6 = false;
                            Instruction instruction = it3;
                            Intrinsics.checkNotNullExpressionValue((Object)instruction, (String)"it");
                            if (!(instruction.getElement() instanceof GrYieldStatement) && !(it3.getElement() instanceof GrThrowStatement)) continue;
                            bl5 = false;
                            break block16;
                        }
                        bl5 = true;
                    }
                    if (bl5) {
                        PsiElement psiElement = switchElement.getFirstChild();
                        if (psiElement == null) {
                            psiElement = switchElement;
                        }
                        PsiElement errorOwner = psiElement;
                        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.yield.or.throw.expected.in.case.section", new Object[0])).range(errorOwner).create();
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkArrowColonConsistency(GrCaseSection[] caseSections) {
        void $this$mapNotNullTo$iv$iv;
        PsiElement psiElement;
        void $this$mapNotNullTo$iv$iv2;
        Object $this$mapNotNull$iv = caseSections;
        boolean $i$f$mapNotNull = false;
        GrCaseSection[] grCaseSectionArray = $this$mapNotNull$iv;
        Object destination$iv$iv = (GrCaseSection[])new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        void var10_16 = $this$forEach$iv$iv$iv;
        int n = ((void)var10_16).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv$iv = var10_16[i];
            void element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            void p1 = element$iv$iv;
            boolean bl2 = false;
            PsiElement psiElement2 = p1.getArrow();
            if (psiElement2 == null) continue;
            PsiElement it$iv$iv = psiElement = psiElement2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Object p1 = $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean bl = false;
        destination$iv$iv = (Collection)p1;
        Object object = !destination$iv$iv.isEmpty() ? $this$mapNotNull$iv : null;
        if (object == null) {
            return;
        }
        Object arrows = object;
        Object $this$mapNotNull$iv2 = caseSections;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        for (void element$iv$iv$iv : $this$forEach$iv$iv$iv2) {
            PsiElement psiElement3;
            void element$iv$iv = element$iv$iv$iv;
            boolean bl4 = false;
            void p12 = element$iv$iv;
            boolean bl5 = false;
            psiElement = p12.getColon();
            if (psiElement == null) continue;
            PsiElement it$iv$iv = psiElement3 = psiElement;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Object p13 = $this$mapNotNull$iv2 = (List)destination$iv$iv2;
        boolean bl7 = false;
        Collection collection = (Collection)p13;
        Object object2 = !collection.isEmpty() ? $this$mapNotNull$iv2 : null;
        if (object2 == null) {
            return;
        }
        Object colons = object2;
        for (PsiElement element : CollectionsKt.plus((Collection)((Collection)arrows), (Iterable)((Iterable)colons))) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.mixing.arrows.colons.not.allowed", new Object[0])).range(element).create();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitCaseSection(@NotNull GrCaseSection caseSection) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)caseSection, (String)"caseSection");
        PsiElement $this$parentOfType$iv = caseSection;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        GrSwitchElement grSwitchElement = (GrSwitchElement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, GrSwitchElement.class, (boolean)true);
        if (grSwitchElement != null) {
            PsiElement p1 = $this$parentOfType$iv = grSwitchElement;
            boolean bl = false;
            if (PsiUtil.isPlainSwitchStatement((GrSwitchElement)p1)) {
                return;
            }
        }
        Instruction[] flow = ControlFlowUtils.getCaseSectionInstructions(caseSection);
        List<GrStatement> list = ControlFlowUtils.collectReturns(flow, caseSection, false);
        Intrinsics.checkNotNullExpressionValue(list, (String)"ControlFlowUtils.collect\u2026flow, caseSection, false)");
        List<GrStatement> returns = list;
        Iterable $this$filterIsInstance$iv = returns;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GrReturnStatement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (GrReturnStatement returnStatement : (List)destination$iv$iv) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("inspection.message.switch.expressions.do.not.support.return", new Object[0])).range((PsiElement)returnStatement).withFix((IntentionAction)new GrReplaceReturnWithYield()).create();
        }
        super.visitCaseSection(caseSection);
    }

    public GroovyAnnotator40(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    static {
        Companion = new Companion(null);
        CONFLICTING_MODIFIERS = CollectionsKt.listOf((Object[])new String[]{"sealed", "non-sealed", "final", "groovy.transform.Sealed", "groovy.transform.NonSealed"});
        FORBIDDEN_FOR_RECORD = CollectionsKt.listOf((Object[])new String[]{"sealed", "non-sealed", "groovy.transform.Sealed", "groovy.transform.NonSealed"});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotator40$Companion;", "", "()V", "CONFLICTING_MODIFIERS", "", "", "FORBIDDEN_FOR_RECORD", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

