/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.Serializable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.console.GrSelectModuleAction;
import org.jetbrains.plugins.groovy.console.GroovyConsole;
import org.jetbrains.plugins.groovy.console.GroovyConsoleStateService;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtil;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtilKt;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/groovy/console/GrSelectModuleAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/UpdateInBackground;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "consoleService", "Lorg/jetbrains/plugins/groovy/console/GroovyConsoleStateService;", "getConsoleService", "()Lorg/jetbrains/plugins/groovy/console/GroovyConsoleStateService;", "consoleService$delegate", "Lkotlin/Lazy;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "displayTextInToolbar", "", "moduleSelected", "module", "Lcom/intellij/openapi/module/Module;", "update", "intellij.groovy"})
public final class GrSelectModuleAction
extends AnAction
implements UpdateInBackground {
    private final Lazy consoleService$delegate;
    private final Project project;
    private final VirtualFile file;

    private final GroovyConsoleStateService getConsoleService() {
        Lazy lazy = this.consoleService$delegate;
        GrSelectModuleAction grSelectModuleAction = this;
        Object var3_3 = null;
        return (GroovyConsoleStateService)lazy.getValue();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Module module = this.getConsoleService().getSelectedModule(this.file);
        if (module == null || module.isDisposed()) {
            return;
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setText(GroovyConsoleUtil.getTitle(module));
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Serializable serializable = e.getInputEvent();
        if (serializable == null || (serializable = serializable.getComponent()) == null) {
            return;
        }
        Serializable component = serializable;
        ListPopup popup2 = ModuleChooserUtil.createSelectModulePopup(this.project, GroovyConsoleUtilKt.getApplicableModules(this.project), (Function1<? super Module, String>)((Function1)actionPerformed.popup.1.INSTANCE), (Function1<? super Module, Unit>)((Function1)new Function1<Module, Unit>(this){

            public final void invoke(@NotNull Module p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                GrSelectModuleAction.access$moduleSelected((GrSelectModuleAction)((Object)this.receiver), p1);
            }
        }));
        popup2.showUnderneathOf((Component)component);
    }

    private final void moduleSelected(Module module) {
        if (Intrinsics.areEqual((Object)this.getConsoleService().getSelectedModule(this.file), (Object)module)) {
            return;
        }
        GroovyConsole.stopConsole(this.file);
        this.getConsoleService().setFileModule(this.file, module);
    }

    public GrSelectModuleAction(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(GroovyBundle.message("select.module.action.text", new Object[0]), GroovyBundle.message("select.module.action.description", new Object[0]), AllIcons.Nodes.Module);
        this.project = project;
        this.file = file;
        this.consoleService$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GroovyConsoleStateService>(this){
            final /* synthetic */ GrSelectModuleAction this$0;

            @NotNull
            public final GroovyConsoleStateService invoke() {
                return GroovyConsoleStateService.Companion.getInstance(GrSelectModuleAction.access$getProject$p(this.this$0));
            }
            {
                this.this$0 = grSelectModuleAction;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ void access$moduleSelected(GrSelectModuleAction $this, Module module) {
        $this.moduleSelected(module);
    }

    public static final /* synthetic */ Project access$getProject$p(GrSelectModuleAction $this) {
        return $this.project;
    }
}

