/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GrReassignedLocalVarsChecker {
    @Nullable
    public static PsiType getReassignedVarType(@NotNull GrReferenceExpression refExpr, boolean honorCompileStatic) {
        if (refExpr == null) {
            GrReassignedLocalVarsChecker.$$$reportNull$$$0(0);
        }
        if (honorCompileStatic && !CompileStaticUtil.isCompileStatic(refExpr) || refExpr.getQualifier() != null) {
            return null;
        }
        PsiElement resolved = refExpr.resolve();
        if (!PsiUtil.isLocalVariable(resolved)) {
            return null;
        }
        assert (resolved instanceof GrVariable);
        return TypeInferenceHelper.getCurrentContext().getExpressionType((GrVariable)resolved, variable -> GrReassignedLocalVarsChecker.getLeastUpperBoundByVar(variable));
    }

    @Nullable
    private static PsiType getLeastUpperBoundByVar(@NotNull GrVariable var) {
        if (var == null) {
            GrReassignedLocalVarsChecker.$$$reportNull$$$0(1);
        }
        return (PsiType)RecursionManager.doPreventingRecursion((Object)var, (boolean)false, (Computable)((NullableComputable)() -> {
            Collection all = ReferencesSearch.search((PsiElement)var, (SearchScope)var.getUseScope()).findAll();
            GrExpression initializer = var.getInitializerGroovy();
            if (initializer == null && all.isEmpty()) {
                return var.getDeclaredType();
            }
            PsiType result2 = initializer != null ? initializer.getType() : null;
            PsiManager manager = var.getManager();
            for (PsiReference reference : all) {
                PsiElement ref = reference.getElement();
                if (!(ref instanceof GrReferenceExpression) || !PsiUtil.isLValue((GrReferenceExpression)ref)) continue;
                result2 = TypesUtil.getLeastUpperBoundNullable(result2, TypeInferenceHelper.getInitializerTypeFor(ref), manager);
            }
            return result2;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrReassignedLocalVarsChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getReassignedVarType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLeastUpperBoundByVar";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

