/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.impl;

import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.api.DelegateArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.impl.NullArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.impl.PositionalArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.impl.VarargArgumentMapping;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u000b\u001a\u00020\u0001\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\f0\u000f\u001a\u001a\u0010\u0011\u001a\u00020\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u001a\u0012\u0010\u0019\u001a\u00020\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0012\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0017H\u0002\u001a\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"\u001a \u0010#\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0002\u001a\"\u0010$\u001a\u00020 2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\r0&2\u0006\u0010!\u001a\u00020\"\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\"\u001b\u0010\u0007\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006("}, d2={"OBJECT_SHIFT", "", "PRIMITIVE_SHIFT", "primitiveDistances", "", "", "[[I", "primitives", "", "Lorg/jetbrains/annotations/NotNull;", "[Ljava/lang/String;", "compare", "X", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/CallParameter;", "left", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/ArgumentMapping;", "right", "getMaximumInterfaceDistance", "argument", "Lcom/intellij/psi/PsiClass;", "interfaceClass", "getPrimitiveDistance", "from", "Lcom/intellij/psi/PsiType;", "to", "getPrimitiveIndex", "name", "getPrimitiveName", "type", "objectDistance", "parameter", "parameterDistance", "", "context", "Lcom/intellij/psi/PsiElement;", "parameterDistance0", "positionalParametersDistance", "map", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "intellij.groovy.psi"})
public final class DistanceKt {
    private static final int PRIMITIVE_SHIFT = 21;
    private static final int OBJECT_SHIFT = 23;
    private static final String[] primitives;
    private static final int[][] primitiveDistances;

    public static final <X extends CallParameter> int compare(@NotNull ArgumentMapping<? extends X> left, @NotNull ArgumentMapping<? extends X> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (left instanceof DelegateArgumentMapping) {
            return DistanceKt.compare(((DelegateArgumentMapping)left).getDelegate(), right);
        }
        if (right instanceof DelegateArgumentMapping) {
            return DistanceKt.compare(left, ((DelegateArgumentMapping)right).getDelegate());
        }
        if (left instanceof NullArgumentMapping && right instanceof NullArgumentMapping) {
            return 0;
        }
        if (left instanceof NullArgumentMapping) {
            return 1;
        }
        if (right instanceof NullArgumentMapping) {
            return -1;
        }
        if (left instanceof VarargArgumentMapping && right instanceof VarargArgumentMapping) {
            return VarargArgumentMapping.Companion.compare((VarargArgumentMapping)left, (VarargArgumentMapping)right);
        }
        if (left instanceof VarargArgumentMapping) {
            return 1;
        }
        if (right instanceof VarargArgumentMapping) {
            return -1;
        }
        long leftDistance = ((PositionalArgumentMapping)left).getDistance();
        long rightDistance = ((PositionalArgumentMapping)right).getDistance();
        return leftDistance == 0L ? -1 : (rightDistance == 0L ? 1 : (int)(leftDistance == rightDistance ? 0 : (leftDistance < rightDistance ? -1 : 1)));
    }

    /*
     * WARNING - void declaration
     */
    public static final long positionalParametersDistance(@NotNull Map<Argument, ? extends CallParameter> map2, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        long result2 = 0L;
        Object object = map2;
        Iterator<Map.Entry<Argument, ? extends CallParameter>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            PsiType parameterType;
            PsiType runtimeType;
            void argument;
            Map.Entry<Argument, ? extends CallParameter> entry;
            Map.Entry<Argument, ? extends CallParameter> entry2 = entry = iterator2.next();
            object = entry2.getKey();
            entry2 = entry;
            CallParameter parameter = entry2.getValue();
            if (argument.getRuntimeType() == null) {
                continue;
            }
            if (parameter.getType() == null) {
                continue;
            }
            result2 += DistanceKt.parameterDistance(runtimeType, parameterType, context);
        }
        return result2;
    }

    public static final long parameterDistance(@NotNull PsiType argument, @NotNull PsiType parameter, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiType psiType = TypeConversionUtil.erasure((PsiType)parameter);
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"TypeConversionUtil.erasure(parameter)");
        return DistanceKt.parameterDistance0(argument, psiType, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final long parameterDistance0(PsiType argument, PsiType parameter, PsiElement context) {
        PsiClass psiClass;
        PsiClass argumentClass;
        if (Intrinsics.areEqual((Object)argument, (Object)parameter)) {
            return 0L;
        }
        PsiType psiType = parameter;
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType;
        PsiClass parameterClass = psiClassType != null ? psiClassType.resolve() : null;
        PsiType psiType2 = argument;
        if (!(psiType2 instanceof PsiClassType)) {
            psiType2 = null;
        }
        PsiClassType psiClassType2 = (PsiClassType)psiType2;
        Object object = argumentClass = psiClassType2 != null ? psiClassType2.resolve() : null;
        if (Intrinsics.areEqual((Object)PsiType.NULL, (Object)argument)) {
            if (parameter instanceof PsiPrimitiveType) {
                return 0x1000000L;
            }
            PsiClass psiClass2 = parameterClass;
            if (psiClass2 != null) {
                if (psiClass2.isInterface()) {
                    return -1L;
                }
            }
            long l = (long)DistanceKt.objectDistance(parameter) << 23;
            return l;
        }
        if (parameterClass != null && parameterClass.isInterface()) {
            int dist = DistanceKt.getMaximumInterfaceDistance(argumentClass, parameterClass);
            if (dist > -1) return dist;
            if (!InheritanceUtil.isInheritor((PsiType)argument, (String)"groovy.lang.Closure")) {
                return dist;
            }
        }
        long objectDistance = 0L;
        int pd = DistanceKt.getPrimitiveDistance(parameter, argument);
        if (pd != -1) {
            return (long)pd << 21;
        }
        objectDistance += (long)(primitives.length + 1);
        if (argument instanceof PsiArrayType && !(parameter instanceof PsiArrayType)) {
            objectDistance += (long)4;
        }
        if (argument instanceof PsiPrimitiveType) {
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)context.getProject());
            JvmPrimitiveTypeKind jvmPrimitiveTypeKind = ((PsiPrimitiveType)argument).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind, (String)"argument.kind");
            psiClass = javaPsiFacade.findClass(jvmPrimitiveTypeKind.getBoxedFqn(), context.getResolveScope());
        } else {
            psiClass = argumentClass;
        }
        PsiClass argumentClass2 = psiClass;
        while (argumentClass2 != null) {
            if (Intrinsics.areEqual((Object)argumentClass2, (Object)parameterClass)) return objectDistance << 23;
            if (Intrinsics.areEqual((Object)argumentClass2.getQualifiedName(), (Object)"groovy.lang.GString")) {
                PsiClass psiClass3 = parameterClass;
                if (Intrinsics.areEqual((Object)(psiClass3 != null ? psiClass3.getQualifiedName() : null), (Object)"java.lang.String")) {
                    objectDistance += (long)2;
                    return objectDistance << 23;
                }
            }
            argumentClass2 = argumentClass2.getSuperClass();
            objectDistance += (long)3;
        }
        return objectDistance << 23;
    }

    private static final int objectDistance(PsiType parameter) {
        int psiTypeSuperTypes = parameter.getSuperTypes().length;
        int superTypesCount = parameter instanceof PsiArrayType ? psiTypeSuperTypes + 1 : psiTypeSuperTypes;
        return superTypesCount * 2;
    }

    private static final int getPrimitiveIndex(String name) {
        return ArraysKt.indexOf((Object[])primitives, (Object)name);
    }

    private static final String getPrimitiveName(PsiType type2) {
        String string;
        PsiType psiType = type2;
        if (psiType instanceof PsiPrimitiveType) {
            JvmPrimitiveTypeKind jvmPrimitiveTypeKind = ((PsiPrimitiveType)type2).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind, (String)"type.kind");
            string = jvmPrimitiveTypeKind.getName();
        } else if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type2).resolve();
            string = psiClass != null ? psiClass.getQualifiedName() : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final int getPrimitiveDistance(PsiType from, PsiType to) {
        int fromIndex = DistanceKt.getPrimitiveIndex(DistanceKt.getPrimitiveName(from));
        if (fromIndex < 0) {
            return -1;
        }
        int toIndex = DistanceKt.getPrimitiveIndex(DistanceKt.getPrimitiveName(to));
        if (toIndex < 0) {
            return -1;
        }
        return primitiveDistances[toIndex][fromIndex];
    }

    private static final int getMaximumInterfaceDistance(PsiClass argument, PsiClass interfaceClass) {
        if (argument == null) {
            return -1;
        }
        if (argument.isEquivalentTo((PsiElement)interfaceClass)) {
            return 0;
        }
        PsiClass[] interfaces = argument.getInterfaces();
        int max = -1;
        for (PsiClass anInterface : interfaces) {
            int sub = DistanceKt.getMaximumInterfaceDistance(anInterface, interfaceClass);
            if (sub != -1) {
                ++sub;
            }
            max = Math.max(max, sub);
        }
        int superClassMax = DistanceKt.getMaximumInterfaceDistance(argument.getSuperClass(), interfaceClass);
        if (superClassMax != -1) {
            ++superClassMax;
        }
        return Math.max(max, superClassMax);
    }

    static {
        String[] stringArray = new String[20];
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind = JvmPrimitiveTypeKind.BOOLEAN;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind, (String)"JvmPrimitiveTypeKind.BOOLEAN");
        stringArray[0] = jvmPrimitiveTypeKind.getName();
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind2 = JvmPrimitiveTypeKind.BOOLEAN;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind2, (String)"JvmPrimitiveTypeKind.BOOLEAN");
        stringArray[1] = jvmPrimitiveTypeKind2.getBoxedFqn();
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind3 = JvmPrimitiveTypeKind.BYTE;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind3, (String)"JvmPrimitiveTypeKind.BYTE");
        stringArray[2] = jvmPrimitiveTypeKind3.getName();
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind4 = JvmPrimitiveTypeKind.BYTE;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind4, (String)"JvmPrimitiveTypeKind.BYTE");
        stringArray[3] = jvmPrimitiveTypeKind4.getBoxedFqn();
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind5 = JvmPrimitiveTypeKind.SHORT;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind5, (String)"JvmPrimitiveTypeKind.SHORT");
        stringArray[4] = jvmPrimitiveTypeKind5.getName();
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind6 = JvmPrimitiveTypeKind.SHORT;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind6, (String)"JvmPrimitiveTypeKind.SHORT");
        stringArray[5] = jvmPrimitiveTypeKind6.getBoxedFqn();
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind7 = JvmPrimitiveTypeKind.CHAR;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind7, (String)"JvmPrimitiveTypeKind.CHAR");
        stringArray[6] = jvmPrimitiveTypeKind7.getName();
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind8 = JvmPrimitiveTypeKind.CHAR;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind8, (String)"JvmPrimitiveTypeKind.CHAR");
        stringArray[7] = jvmPrimitiveTypeKind8.getBoxedFqn();
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind9 = JvmPrimitiveTypeKind.INT;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind9, (String)"JvmPrimitiveTypeKind.INT");
        stringArray[8] = jvmPrimitiveTypeKind9.getName();
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind10 = JvmPrimitiveTypeKind.INT;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind10, (String)"JvmPrimitiveTypeKind.INT");
        stringArray[9] = jvmPrimitiveTypeKind10.getBoxedFqn();
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind11 = JvmPrimitiveTypeKind.LONG;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind11, (String)"JvmPrimitiveTypeKind.LONG");
        stringArray[10] = jvmPrimitiveTypeKind11.getName();
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind12 = JvmPrimitiveTypeKind.LONG;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind12, (String)"JvmPrimitiveTypeKind.LONG");
        stringArray[11] = jvmPrimitiveTypeKind12.getBoxedFqn();
        stringArray[12] = "java.math.BigInteger";
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind13 = JvmPrimitiveTypeKind.FLOAT;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind13, (String)"JvmPrimitiveTypeKind.FLOAT");
        stringArray[13] = jvmPrimitiveTypeKind13.getName();
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind14 = JvmPrimitiveTypeKind.FLOAT;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind14, (String)"JvmPrimitiveTypeKind.FLOAT");
        stringArray[14] = jvmPrimitiveTypeKind14.getBoxedFqn();
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind15 = JvmPrimitiveTypeKind.DOUBLE;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind15, (String)"JvmPrimitiveTypeKind.DOUBLE");
        stringArray[15] = jvmPrimitiveTypeKind15.getName();
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind16 = JvmPrimitiveTypeKind.DOUBLE;
        Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind16, (String)"JvmPrimitiveTypeKind.DOUBLE");
        stringArray[16] = jvmPrimitiveTypeKind16.getBoxedFqn();
        stringArray[17] = "java.math.BigDecimal";
        stringArray[18] = "java.lang.Number";
        stringArray[19] = "java.lang.Object";
        primitives = stringArray;
        primitiveDistances = new int[][]{{0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 2}, {1, 0, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 2}, {18, 19, 0, 1, 2, 3, 16, 17, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {18, 19, 1, 0, 2, 3, 16, 17, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {18, 19, 14, 15, 0, 1, 16, 17, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}, {18, 19, 14, 15, 1, 0, 16, 17, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}, {18, 19, 16, 17, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}, {18, 19, 16, 17, 14, 15, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}, {18, 19, 14, 15, 12, 13, 16, 17, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, {18, 19, 14, 15, 12, 13, 16, 17, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, {18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, {18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9}, {18, 19, 9, 10, 7, 8, 16, 17, 5, 6, 3, 4, 0, 14, 15, 12, 13, 11, 1, 2}, {18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 8, 9, 7, 0, 1, 2, 3, 4, 5, 6}, {18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 8, 9, 7, 1, 0, 2, 3, 4, 5, 6}, {18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 8, 9, 7, 5, 6, 0, 1, 2, 3, 4}, {18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 8, 9, 7, 5, 6, 1, 0, 2, 3, 4}, {18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 8, 9, 7, 5, 6, 3, 4, 0, 1, 2}, {18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 8, 9, 7, 5, 6, 3, 4, 2, 0, 1}, {18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 8, 9, 7, 5, 6, 3, 4, 2, 1, 0}};
    }
}

