/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.kotlin.commonNative.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFunctionBreakpoint;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFunctionBreakpointType;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B\u000f\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J4\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/KonanSymbolicBreakpointHandler;", "Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrCodePointHandlerBase;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaMethodBreakpointProperties;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolicBreakpoint;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "addCodepointsInBackend", "", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "breakpoint", "threadId", "", "frameIndex", "", "checkKotlinBreakpoint", "", "getLocationPackage", "", "kotlin-ultimate.common-native"})
public final class KonanSymbolicBreakpointHandler
extends CidrCodePointHandlerBase<XLineBreakpoint<JavaMethodBreakpointProperties>, LLSymbolicBreakpoint> {
    @NotNull
    protected Collection<LLSymbolicBreakpoint> addCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull XLineBreakpoint<JavaMethodBreakpointProperties> breakpoint2, long threadId, int frameIndex) throws ExecutionException {
        DebuggerDriver.SymbolicBreakpoint symbolicBreakpoint;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        this.checkKotlinBreakpoint(breakpoint2);
        DebuggerDriver.SymbolicBreakpoint $this$apply = symbolicBreakpoint = new DebuggerDriver.SymbolicBreakpoint();
        boolean bl = false;
        $this$apply.setRegexpPattern(true);
        JavaMethodBreakpointProperties javaMethodBreakpointProperties = (JavaMethodBreakpointProperties)breakpoint2.getProperties();
        if (javaMethodBreakpointProperties != null) {
            String string;
            JavaMethodBreakpointProperties javaMethodBreakpointProperties2;
            JavaMethodBreakpointProperties $this$run = javaMethodBreakpointProperties2 = javaMethodBreakpointProperties;
            boolean bl2 = false;
            String string2 = $this$run.myClassPattern;
            if (string2 == null) {
                string2 = string = this.getLocationPackage(breakpoint2);
            }
            if (string2 == null) {
                string = "";
            }
            $this$apply.setPattern(string + "#" + $this$run.myMethodName + "\\(");
        }
        DebuggerDriver.SymbolicBreakpoint symBreakpoint = symbolicBreakpoint;
        return CollectionsKt.listOfNotNull((Object)driver.addSymbolicBreakpoint(symBreakpoint));
    }

    private final void checkKotlinBreakpoint(XLineBreakpoint<JavaMethodBreakpointProperties> breakpoint2) {
        if (breakpoint2.getUserData(Breakpoint.DATA_KEY) == null) {
            Breakpoint kotlinBreakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)((XBreakpoint)breakpoint2));
            breakpoint2.putUserData(Breakpoint.DATA_KEY, (Object)kotlinBreakpoint);
        }
    }

    private final String getLocationPackage(XLineBreakpoint<JavaMethodBreakpointProperties> breakpoint2) {
        Object object = breakpoint2.getUserData(Breakpoint.DATA_KEY);
        if (!(object instanceof KotlinFunctionBreakpoint)) {
            object = null;
        }
        KotlinFunctionBreakpoint kotlinFunctionBreakpoint = (KotlinFunctionBreakpoint)((Object)object);
        if (kotlinFunctionBreakpoint == null) {
            return null;
        }
        KotlinFunctionBreakpoint kotlinBreakpoint = kotlinFunctionBreakpoint;
        boolean $i$f$runReadAction = false;
        return String.valueOf(ApplicationManager.getApplication().runReadAction(new Computable(kotlinBreakpoint){
            final /* synthetic */ KotlinFunctionBreakpoint $kotlinBreakpoint$inlined;
            {
                this.$kotlinBreakpoint$inlined = kotlinFunctionBreakpoint;
            }

            public final T compute() {
                boolean bl = false;
                SourcePosition sourcePosition2 = this.$kotlinBreakpoint$inlined.getSourcePosition();
                Object object = sourcePosition2 != null ? sourcePosition2.getFile() : null;
                if (!(object instanceof KtFile)) {
                    object = null;
                }
                KtFile ktFile = (KtFile)object;
                return (T)(ktFile != null ? ktFile.getPackageFqName() : null);
            }
        }));
    }

    public KonanSymbolicBreakpointHandler(@Nullable CidrDebugProcess process2) {
        super(process2, KotlinFunctionBreakpointType.class);
    }
}

