/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.kotlin.commonNative.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.externalSystem.debugger.DebuggerBackendExtension;
import com.intellij.openapi.project.Project;
import com.jetbrains.kotlin.commonNative.BinaryExecutable;
import com.jetbrains.kotlin.commonNative.KonanBundle;
import com.jetbrains.kotlin.commonNative.runconfig.AttachmentStrategy;
import com.jetbrains.kotlin.commonNative.runconfig.BinaryRunConfiguration;
import com.jetbrains.kotlin.commonNative.runconfig.BinaryRunConfigurationType;
import com.jetbrains.kotlin.commonNative.workspace.WorkspaceBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@InternalIgnoreDependencyViolation
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0016\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/LLDBBackend;", "Lcom/intellij/openapi/externalSystem/debugger/DebuggerBackendExtension;", "()V", "debugConfigurationSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "project", "Lcom/intellij/openapi/project/Project;", "processName", "", "processParameters", "debuggerSetupArgs", "serverArgs", "", "findDebugVariant", "Lcom/jetbrains/kotlin/commonNative/BinaryExecutable$Variant$Debug;", "id", "initializationCode", "dispatchPort", "sertializedParams", "Companion", "kotlin-ultimate.common-native"})
public final class LLDBBackend
implements DebuggerBackendExtension {
    @NotNull
    public static final String DEBUG_SERVER_PATH_KEY = "DEBUG_SERVER_PATH";
    @NotNull
    public static final String DEBUG_SERVER_ARGS_KEY = "DEBUG_SERVER_ARGS";
    @NotNull
    public static final String PROJECT_PATH_KEY = "PROJECT_PATH";
    @NotNull
    public static final String ATTACH_BY_NAME_KEY = "ATTACH_BY_NAME";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String id() {
        return "Gradle LLDB";
    }

    private final String debuggerSetupArgs(List<String> serverArgs) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (String arg : serverArgs) {
            $this$buildString.append("'" + arg + "', ");
        }
        $this$buildString.append("'127.0.0.1:' + debugPort, '--', task.executable");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public List<String> initializationCode(@NotNull String dispatchPort, @NotNull String sertializedParams) {
        Intrinsics.checkNotNullParameter((Object)dispatchPort, (String)"dispatchPort");
        Intrinsics.checkNotNullParameter((Object)sertializedParams, (String)"sertializedParams");
        HashMap params2 = this.splitParameters(sertializedParams);
        String string = (String)params2.get(DEBUG_SERVER_PATH_KEY);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params[DEBUG_SERVER_PATH\u2026EY] ?: return emptyList()");
        String debugServerPath = string;
        Object object = (String)params2.get(DEBUG_SERVER_ARGS_KEY);
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object debugServerArgs = object;
        String string2 = (String)params2.get(DEBUG_SERVER_PATH_KEY);
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"params[DEBUG_SERVER_PATH\u2026EY] ?: return emptyList()");
        String projectPath2 = string2;
        return CollectionsKt.listOf((Object)StringsKt.trimIndent((String)("\n            ({\n                def isInstance = { Task task, String fqn ->\n                    for (def klass = task.class; klass != Object.class; klass = klass.superclass) {\n                        if (klass.canonicalName == fqn) {\n                            return true            \n                        }\n                    }        \n                    return false\n                }\n            \n                gradle.taskGraph.whenReady { taskGraph ->\n                    taskGraph.allTasks.each { Task task ->  \n                        if (task.hasProperty('debugMode') \n                            && isInstance(task, 'org.jetbrains.kotlin.gradle.targets.native.tasks.KotlinNativeSimulatorTest')) {\n                            task.doFirst {\n                                ForkedDebuggerHelper.setupDebugger('" + this.id() + "', task.path, 'ATTACH_BY_NAME=true', 'PROJECT_PATH=" + projectPath2 + "')\n                                task.debugMode = true\n                            }\n                            \n                            task.doLast {\n                                ForkedDebuggerHelper.signalizeFinish('" + this.id() + "', task.path)\n                            }\n                        } else if (isInstance(task, 'org.jetbrains.kotlin.gradle.targets.native.tasks.KotlinNativeTest') \n                                   || isInstance(task, 'org.gradle.api.tasks.Exec')) {\n                            task.doFirst {\n                                def debugPort = ForkedDebuggerHelper.setupDebugger('" + this.id() + "', task.path, 'ATTACH_BY_NAME=false', 'PROJECT_PATH=" + projectPath2 + "')\n                                task.args = [" + this.debuggerSetupArgs((List<String>)debugServerArgs) + "] + task.args\n                                task.executable = new File('" + debugServerPath + "')\n                            }\n                            \n                            task.doLast {\n                                ForkedDebuggerHelper.signalizeFinish('" + this.id() + "', task.path)\n                            }\n                        }\n                    }\n                }\n            })()\n            ")));
    }

    @NotNull
    public RunnerAndConfigurationSettings debugConfigurationSettings(@NotNull Project project2, @NotNull String processName, @NotNull String processParameters) {
        BinaryRunConfiguration binaryRunConfiguration;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter((Object)processParameters, (String)"processParameters");
        HashMap params2 = this.splitParameters(processParameters);
        Project $this$service$iv = project2;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(RunManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        RunManager runManager = (RunManager)object;
        RunnerAndConfigurationSettings settings2 = runManager.createConfiguration(processName, BinaryRunConfigurationType.Companion.getInstance().getFactory());
        RunConfiguration runConfiguration = settings2.getConfiguration();
        if (runConfiguration == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.kotlin.commonNative.runconfig.BinaryRunConfiguration");
        }
        BinaryRunConfiguration $this$with = binaryRunConfiguration = (BinaryRunConfiguration)runConfiguration;
        boolean bl = false;
        BinaryExecutable.Variant.Debug variant = this.findDebugVariant(project2, processName);
        $this$with.setExecutable(variant.getFile());
        $this$with.setAttachmentStrategy(AttachmentStrategy.ByName.INSTANCE);
        $this$with.setWorkingDirectory(variant.getParams().getWorkingDirectory());
        $this$with.setProgramParameters(variant.getParams().getProgramParameters());
        $this$with.setEnvs(variant.getParams().getEnvironmentVariables());
        String string = (String)params2.get(ATTACH_BY_NAME_KEY);
        if (string != null) {
            String string2 = string;
            if (!Boolean.parseBoolean(string2)) {
                String string3 = (String)params2.get("DEBUG_SERVER_PORT");
                if (string3 != null) {
                    int n;
                    string2 = string3;
                    int it = n = Integer.parseInt(string2);
                    boolean bl2 = false;
                    $this$with.setAttachmentStrategy(new AttachmentStrategy.ByPort(it));
                }
            }
        }
        settings2.setActivateToolWindowBeforeRun(false);
        return settings2;
    }

    /*
     * WARNING - void declaration
     */
    private final BinaryExecutable.Variant.Debug findDebugVariant(Project project2, String processName) {
        Object v1;
        block6: {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            BinaryExecutable it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String string = processName;
            int n = StringsKt.lastIndexOf$default((CharSequence)processName, (char)':', (int)0, (boolean)false, (int)6, null) + 1;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String taskName2 = string2;
            String string3 = processName;
            int n2 = 0;
            int n3 = StringsKt.lastIndexOf$default((CharSequence)processName, (char)':', (int)0, (boolean)false, (int)6, null) + 1;
            String string4 = string3.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String projectPrefix = string4;
            boolean taskIsTest = StringsKt.endsWith$default((String)taskName2, (String)"Test", (boolean)false, (int)2, null);
            boolean taskIsRun = StringsKt.startsWith$default((String)taskName2, (String)"run", (boolean)false, (int)2, null);
            Function1 execFilter2 = (Function1)new Function1<BinaryExecutable, Boolean>(taskIsTest, taskName2, taskIsRun){
                final /* synthetic */ boolean $taskIsTest;
                final /* synthetic */ String $taskName;
                final /* synthetic */ boolean $taskIsRun;

                public final boolean invoke(@NotNull BinaryExecutable exec) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
                    if (this.$taskIsTest) {
                        String targetId = StringsKt.removeSuffix((String)this.$taskName, (CharSequence)"Test");
                        bl = StringsKt.contains$default((CharSequence)exec.getTargetName(), (CharSequence)targetId, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)exec.getName(), (CharSequence)"test", (boolean)false, (int)2, null);
                    } else {
                        bl = this.$taskIsRun;
                    }
                    return bl;
                }
                {
                    this.$taskIsTest = bl;
                    this.$taskName = string;
                    this.$taskIsRun = bl2;
                    super(1);
                }
            };
            Function1 variantFilter2 = (Function1)new Function1<BinaryExecutable.Variant, Boolean>(taskIsRun, taskName2, taskIsTest){
                final /* synthetic */ boolean $taskIsRun;
                final /* synthetic */ String $taskName;
                final /* synthetic */ boolean $taskIsTest;

                public final boolean invoke(@NotNull BinaryExecutable.Variant variant) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                    if (this.$taskIsRun) {
                        String executableId = StringsKt.removePrefix((String)this.$taskName, (CharSequence)"run");
                        bl = StringsKt.contains$default((CharSequence)variant.getGradleTask(), (CharSequence)executableId, (boolean)false, (int)2, null);
                    } else {
                        bl = this.$taskIsTest;
                    }
                    return bl;
                }
                {
                    this.$taskIsRun = bl;
                    this.$taskName = string;
                    this.$taskIsTest = bl2;
                    super(1);
                }
            };
            Object $this$service$iv = project2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(WorkspaceBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            $this$service$iv = ((WorkspaceBase)object).getAllAvailableExecutables();
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BinaryExecutable)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.endsWith$default((String)it.getProjectPrefix(), (String)projectPrefix, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BinaryExecutable)element$iv$iv;
                boolean bl = false;
                if (!((Boolean)execFilter2.invoke((Object)it)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$filterIsInstanceTo$iv$iv;
                it = (BinaryExecutable)element$iv$iv;
                boolean bl = false;
                Iterable $this$filterIsInstance$iv = it.getVariants();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv2 instanceof BinaryExecutable.Variant.Debug)) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List variants2 = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = variants2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BinaryExecutable.Variant.Debug it2 = (BinaryExecutable.Variant.Debug)element$iv;
                boolean bl = false;
                if (!((Boolean)variantFilter2.invoke((Object)it2)).booleanValue()) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        BinaryExecutable.Variant.Debug debug = v1;
        if (debug == null) {
            throw (Throwable)new ExecutionException(KonanBundle.message("error.message.no.executable.for.processname", processName));
        }
        return debug;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/LLDBBackend$Companion;", "", "()V", "ATTACH_BY_NAME_KEY", "", "DEBUG_SERVER_ARGS_KEY", "DEBUG_SERVER_PATH_KEY", "PROJECT_PATH_KEY", "kotlin-ultimate.common-native"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

