/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.eval4j.jdi;

import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.AbstractValue;
import org.jetbrains.eval4j.Eval;
import org.jetbrains.eval4j.FieldDescription;
import org.jetbrains.eval4j.MembersKt;
import org.jetbrains.eval4j.MethodDescription;
import org.jetbrains.eval4j.NewObjectValue;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JDIEval;
import org.jetbrains.eval4j.jdi.JdiEvalKt;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001dH\u0002J\u001c\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u001a\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020#H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020#H\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u0019H\u0016J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u0019H\u0016J\u0018\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u00101\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016J.\u00102\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u00104\u001a\u00020\fH\u0016J0\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u00192\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001080\u001d2\u0006\u0010&\u001a\u00020'H\u0002J\u001e\u00109\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0016J\u001c\u0010:\u001a\u00020\f2\b\u0010;\u001a\u0004\u0018\u00010\u00112\b\u0010<\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010=\u001a\u00020\f2\u0006\u0010>\u001a\u00020\u00192\u0006\u0010?\u001a\u00020\u0015H\u0016J2\u0010@\u001a\u0004\u0018\u0001082\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020%2\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001080\u001d2\u0006\u0010D\u001a\u00020\tH\u0016J2\u0010E\u001a\u0004\u0018\u0001082\u0006\u0010F\u001a\u00020G2\u0006\u0010C\u001a\u00020%2\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001080\u001d2\u0006\u0010\b\u001a\u00020\tH\u0016J2\u0010E\u001a\u0004\u0018\u0001082\u0006\u0010F\u001a\u00020H2\u0006\u0010C\u001a\u00020%2\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001080\u001d2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010I\u001a\u00020\u00192\u0006\u0010J\u001a\u00020\u0015H\u0016J\u001a\u0010I\u001a\u00020\u00192\u0006\u0010J\u001a\u00020\u00152\b\u0010K\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010L\u001a\u00020\u00112\u0006\u0010M\u001a\u00020\u000f2\u0006\u0010K\u001a\u00020\u0005H\u0002J\u0010\u0010N\u001a\u00020\u00192\u0006\u0010O\u001a\u00020\u000fH\u0016J,\u0010P\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001080\u001d2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00110\u001dH\u0002J\u0018\u0010R\u001a\u00020\u00192\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001080\u001dH\u0002J\u0018\u0010S\u001a\u00020\u00192\u0006\u0010T\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0010\u0010U\u001a\u00020\u00192\u0006\u0010J\u001a\u00020\u0015H\u0016J\u001e\u0010V\u001a\u00020\u00192\u0006\u0010T\u001a\u00020\u00152\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\t0\u001dH\u0016J \u0010X\u001a\u00020Y2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00192\u0006\u0010Z\u001a\u00020\u0019H\u0016J \u0010[\u001a\u00020Y2\u0006\u00100\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010Z\u001a\u00020\u0019H\u0016J\u0018\u0010\\\u001a\u00020Y2\u0006\u0010 \u001a\u00020!2\u0006\u0010Z\u001a\u00020\u0019H\u0016J \u0010]\u001a\u00020\f2\u0006\u0010C\u001a\u00020%2\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001080\u001dH\u0002J\u0018\u0010^\u001a\u00020\u00192\u0006\u0010_\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u0015H\u0002J\f\u0010,\u001a\u00020`*\u00020\u0019H\u0002J\u0018\u0010a\u001a\u00020b*\u00020\u00152\n\b\u0002\u0010K\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010c\u001a\u00020#*\u00020\u00152\n\b\u0002\u0010K\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u0010d\u001a\u00020Y*\n\u0012\u0006\u0012\u0004\u0018\u0001080\u001dH\u0002J\u0014\u0010e\u001a\u00020Y*\n\u0012\u0006\u0012\u0004\u0018\u0001080\u001dH\u0002J\u0012\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d*\u00020%H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00110\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\u00020\u0015*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006g"}, d2={"Lorg/jetbrains/eval4j/jdi/JDIEval;", "Lorg/jetbrains/eval4j/Eval;", "vm", "Lcom/sun/jdi/VirtualMachine;", "defaultClassLoader", "Lcom/sun/jdi/ClassLoaderReference;", "thread", "Lcom/sun/jdi/ThreadReference;", "invokePolicy", "", "(Lcom/sun/jdi/VirtualMachine;Lcom/sun/jdi/ClassLoaderReference;Lcom/sun/jdi/ThreadReference;I)V", "isJava8OrLater", "", "primitiveTypes", "", "", "kotlin.jvm.PlatformType", "Lcom/sun/jdi/Type;", "getThread", "()Lcom/sun/jdi/ThreadReference;", "arrayElementType", "Lorg/jetbrains/org/objectweb/asm/Type;", "getArrayElementType", "(Lorg/jetbrains/org/objectweb/asm/Type;)Lorg/jetbrains/org/objectweb/asm/Type;", "fillArray", "Lorg/jetbrains/eval4j/Value;", "elementType", "size", "nestedSizes", "", "findField", "Lcom/sun/jdi/Field;", "fieldDesc", "Lorg/jetbrains/eval4j/FieldDescription;", "receiver", "Lcom/sun/jdi/ReferenceType;", "findMethod", "Lcom/sun/jdi/Method;", "methodDesc", "Lorg/jetbrains/eval4j/MethodDescription;", "clazz", "findMethodOrNull", "findStaticField", "getArrayElement", "array", "index", "getArrayLength", "getField", "instance", "getStaticField", "invokeMethod", "arguments", "invokeSpecial", "invokeMethodWithReflection", "ownerType", "args", "Lcom/sun/jdi/Value;", "invokeStaticMethod", "isArrayOfInterfaces", "valueType", "expectedType", "isInstanceOf", "value", "targetType", "jdiInvokeMethod", "obj", "Lcom/sun/jdi/ObjectReference;", "method", "policy", "jdiInvokeStaticMethod", "type", "Lcom/sun/jdi/ClassType;", "Lcom/sun/jdi/InterfaceType;", "loadClass", "classType", "classLoader", "loadClassByName", "name", "loadString", "str", "mapArguments", "expectedTypes", "mirrorOfArgs", "newArray", "arrayType", "newInstance", "newMultiDimensionalArray", "dimensionSizes", "setArrayElement", "", "newValue", "setField", "setStaticField", "shouldInvokeMethodWithReflection", "unboxType", "boxedValue", "Lcom/sun/jdi/ArrayReference;", "asArrayType", "Lcom/sun/jdi/ArrayType;", "asReferenceType", "disableCollection", "enableCollection", "safeArgumentTypes", "kotlin.jvm-debugger.eval4j"})
public class JDIEval
implements Eval {
    private final Map<String, com.sun.jdi.Type> primitiveTypes;
    private final boolean isJava8OrLater;
    private final VirtualMachine vm;
    private final ClassLoaderReference defaultClassLoader;
    @NotNull
    private final ThreadReference thread;
    private final int invokePolicy;

    @Override
    @NotNull
    public Value loadClass(@NotNull Type classType) {
        Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
        return this.loadClass(classType, this.defaultClassLoader);
    }

    private final Value loadClass(Type classType, ClassLoaderReference classLoader2) {
        List<ReferenceType> loadedClasses;
        List<ReferenceType> list2 = loadedClasses = this.vm.classesByName(JdiEvalKt.getJdiName(classType));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"loadedClasses");
        Collection collection = list2;
        if (!collection.isEmpty()) {
            Iterator<ReferenceType> iterator = loadedClasses.iterator();
            while (iterator.hasNext()) {
                ReferenceType loadedClass;
                ReferenceType referenceType = loadedClass = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"loadedClass");
                if (!referenceType.isPrepared() || !JdiEvalKt.access$getBOOTSTRAP_CLASS_DESCRIPTORS$p().contains(classType.getDescriptor()) && !Intrinsics.areEqual((Object)loadedClass.classLoader(), (Object)classLoader2)) continue;
                return JdiValuesKt.asValue(loadedClass.classObject());
            }
        }
        if (classLoader2 == null) {
            Type type2 = JdiEvalKt.access$getCLASS$p();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"CLASS");
            String string = type2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CLASS.internalName");
            return this.invokeStaticMethod(new MethodDescription(string, "forName", "(Ljava/lang/String;)Ljava/lang/Class;", true), CollectionsKt.listOf((Object)JdiValuesKt.asValue(this.vm.mirrorOf(JdiEvalKt.getJdiName(classType)))));
        }
        Type type3 = JdiEvalKt.access$getCLASS$p();
        Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"CLASS");
        String string = type3.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CLASS.internalName");
        return this.invokeStaticMethod(new MethodDescription(string, "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", true), CollectionsKt.listOf((Object[])new AbstractValue[]{JdiValuesKt.asValue(this.vm.mirrorOf(JdiEvalKt.getJdiName(classType))), ValuesKt.boolean(true), JdiValuesKt.asValue(classLoader2)}));
    }

    private final com.sun.jdi.Type loadClassByName(String name2, ClassLoaderReference classLoader2) {
        com.sun.jdi.Type type2;
        com.sun.jdi.Type baseType;
        com.sun.jdi.Type type3;
        String baseTypeName;
        String string;
        int n;
        CharSequence $this$count$iv = name2;
        boolean $i$f$count2 = false;
        int count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            if (!(it == '[')) continue;
            ++count$iv;
        }
        int dimensions = count$iv;
        if (dimensions > 0) {
            String $i$f$count2 = name2;
            int n2 = 0;
            n = StringsKt.indexOf$default((CharSequence)name2, (char)'[', (int)0, (boolean)false, (int)6, null);
            String string2 = $i$f$count2.substring(n2, n);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = baseTypeName = name2;
        }
        if ((type3 = this.primitiveTypes.get(baseTypeName)) == null) {
            Type type4 = Type.getType((String)("L" + baseTypeName + ";"));
            Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"Type.getType(\"L$baseTypeName;\")");
            type3 = baseType = (com.sun.jdi.Type)this.asReferenceType(type4, classLoader2);
        }
        if (dimensions == 0) {
            type2 = baseType;
        } else {
            Type type5 = Type.getType((String)(StringsKt.repeat((CharSequence)"[", (int)dimensions) + JdiValuesKt.asType(baseType).getDescriptor()));
            Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"Type.getType(\"[\".repeat(\u2026Type.asType().descriptor)");
            type2 = this.asReferenceType(type5, classLoader2);
        }
        return type2;
    }

    @Override
    @NotNull
    public Value loadString(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return JdiValuesKt.asValue(this.vm.mirrorOf(str));
    }

    @Override
    @NotNull
    public Value newInstance(@NotNull Type classType) {
        Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
        return new NewObjectValue(classType);
    }

    @Override
    public boolean isInstanceOf(@NotNull Value value2, @NotNull Type targetType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        boolean bl2 = bl = targetType.getSort() == 10 || targetType.getSort() == 9;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Can't check isInstanceOf() for non-object type " + targetType;
            throw new AssertionError((Object)string);
        }
        Value clazz = this.loadClass(targetType);
        Type type2 = JdiEvalKt.access$getCLASS$p();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"CLASS");
        String string = type2.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CLASS.internalName");
        return ValuesKt.getBoolean(Eval.DefaultImpls.invokeMethod$default(this, clazz, new MethodDescription(string, "isInstance", "(Ljava/lang/Object;)Z", false), CollectionsKt.listOf((Object)value2), false, 8, null));
    }

    private final ReferenceType asReferenceType(Type $this$asReferenceType, ClassLoaderReference classLoader2) {
        ClassObjectReference classObjectReference = JdiValuesKt.getJdiClass(this.loadClass($this$asReferenceType, classLoader2));
        Intrinsics.checkNotNull((Object)classObjectReference);
        ReferenceType referenceType = classObjectReference.reflectedType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"loadClass(this, classLoa\u2026diClass!!.reflectedType()");
        return referenceType;
    }

    static /* synthetic */ ReferenceType asReferenceType$default(JDIEval jDIEval, Type type2, ClassLoaderReference classLoaderReference, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asReferenceType");
        }
        if ((n & 1) != 0) {
            classLoaderReference = jDIEval.defaultClassLoader;
        }
        return jDIEval.asReferenceType(type2, classLoaderReference);
    }

    private final ArrayType asArrayType(Type $this$asArrayType, ClassLoaderReference classLoader2) {
        ReferenceType referenceType = this.asReferenceType($this$asArrayType, classLoader2);
        if (referenceType == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.ArrayType");
        }
        return (ArrayType)referenceType;
    }

    static /* synthetic */ ArrayType asArrayType$default(JDIEval jDIEval, Type type2, ClassLoaderReference classLoaderReference, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asArrayType");
        }
        if ((n & 1) != 0) {
            classLoaderReference = jDIEval.defaultClassLoader;
        }
        return jDIEval.asArrayType(type2, classLoaderReference);
    }

    @Override
    @NotNull
    public Value newArray(@NotNull Type arrayType, int size) {
        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
        ArrayType jdiArrayType = JDIEval.asArrayType$default(this, arrayType, null, 1, null);
        return JdiValuesKt.asValue(jdiArrayType.newInstance(size));
    }

    private final Type getArrayElementType(Type $this$arrayElementType) {
        boolean bl;
        boolean bl2 = bl = $this$arrayElementType.getSort() == 9;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Not an array type: " + $this$arrayElementType;
            throw new AssertionError((Object)string);
        }
        String string = $this$arrayElementType.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor");
        String string2 = string;
        int n = 1;
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        Type type2 = Type.getType((String)string3);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"Type.getType(descriptor.substring(1))");
        return type2;
    }

    /*
     * WARNING - void declaration
     */
    private final Value fillArray(Type elementType, int size, List<Integer> nestedSizes) {
        Type type2 = Type.getType((String)("[" + elementType.getDescriptor()));
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"Type.getType(\"[\" + elementType.descriptor)");
        Value arr = this.newArray(type2, size);
        Collection collection = nestedSizes;
        if (!collection.isEmpty()) {
            Type nestedElementType = this.getArrayElementType(elementType);
            int nestedSize = ((Number)nestedSizes.get(0)).intValue();
            List tail = CollectionsKt.drop((Iterable)nestedSizes, (int)1);
            int n = 0;
            int n2 = size;
            while (n < n2) {
                void i;
                this.setArrayElement(arr, ValuesKt.int((int)i), this.fillArray(nestedElementType, nestedSize, tail));
                ++i;
            }
        }
        return arr;
    }

    @Override
    @NotNull
    public Value newMultiDimensionalArray(@NotNull Type arrayType, @NotNull List<Integer> dimensionSizes) {
        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
        Intrinsics.checkNotNullParameter(dimensionSizes, (String)"dimensionSizes");
        return this.fillArray(this.getArrayElementType(arrayType), ((Number)dimensionSizes.get(0)).intValue(), CollectionsKt.drop((Iterable)dimensionSizes, (int)1));
    }

    private final ArrayReference array(Value $this$array) {
        ObjectReference objectReference = ValuesKt.checkNull(JdiValuesKt.getJdiObj($this$array));
        if (objectReference == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.ArrayReference");
        }
        return (ArrayReference)objectReference;
    }

    @Override
    @NotNull
    public Value getArrayLength(@NotNull Value array2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        return ValuesKt.int(this.array(array2).length());
    }

    @Override
    @NotNull
    public Value getArrayElement(@NotNull Value array2, @NotNull Value index2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        try {
            return JdiValuesKt.asValue(this.array(array2).getValue(ValuesKt.getInt(index2)));
        }
        catch (IndexOutOfBoundsException e) {
            Void void_ = ValuesKt.throwInterpretingException(new ArrayIndexOutOfBoundsException(e.getMessage()));
            throw new KotlinNothingValueException();
        }
    }

    @Override
    public void setArrayElement(@NotNull Value array2, @NotNull Value index2, @NotNull Value newValue2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)newValue2, (String)"newValue");
        try {
            this.array(array2).setValue(ValuesKt.getInt(index2), JdiValuesKt.asJdiValue(newValue2, this.vm, this.getArrayElementType(array2.getAsmType())));
            return;
        }
        catch (IndexOutOfBoundsException e) {
            Void void_ = ValuesKt.throwInterpretingException(new ArrayIndexOutOfBoundsException(e.getMessage()));
            throw new KotlinNothingValueException();
        }
    }

    private final Field findField(FieldDescription fieldDesc, ReferenceType receiver2) {
        Comparable<ReferenceType> comparable = receiver2;
        if (comparable != null && (comparable = comparable.fieldByName(fieldDesc.getName())) != null) {
            Comparable<ReferenceType> comparable2;
            Comparable<ReferenceType> it = comparable2 = comparable;
            boolean bl = false;
            return it;
        }
        Field field = JDIEval.asReferenceType$default(this, MembersKt.getOwnerType(fieldDesc), null, 1, null).fieldByName(fieldDesc.getName());
        if (field != null) {
            Field field2;
            Field it = field2 = field;
            boolean bl = false;
            return it;
        }
        Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Field not found: " + fieldDesc));
        throw new KotlinNothingValueException();
    }

    static /* synthetic */ Field findField$default(JDIEval jDIEval, FieldDescription fieldDescription, ReferenceType referenceType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findField");
        }
        if ((n & 2) != 0) {
            referenceType = null;
        }
        return jDIEval.findField(fieldDescription, referenceType);
    }

    private final Field findStaticField(FieldDescription fieldDesc) {
        Field field = JDIEval.findField$default(this, fieldDesc, null, 2, null);
        if (!field.isStatic()) {
            Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Field is not static: " + fieldDesc));
            throw new KotlinNothingValueException();
        }
        return field;
    }

    @Override
    @NotNull
    public Value getStaticField(@NotNull FieldDescription fieldDesc) {
        Intrinsics.checkNotNullParameter((Object)fieldDesc, (String)"fieldDesc");
        Field field = this.findStaticField(fieldDesc);
        return JdiValuesKt.asValue((com.sun.jdi.Value)JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow((Function0)new Function0<com.sun.jdi.Value>(field){
            final /* synthetic */ Field $field;

            public final com.sun.jdi.Value invoke() {
                return this.$field.declaringType().getValue(this.$field);
            }
            {
                this.$field = field;
                super(0);
            }
        }), field, null, 2, null));
    }

    @Override
    public void setStaticField(@NotNull FieldDescription fieldDesc, @NotNull Value newValue2) {
        Intrinsics.checkNotNullParameter((Object)fieldDesc, (String)"fieldDesc");
        Intrinsics.checkNotNullParameter((Object)newValue2, (String)"newValue");
        Field field = this.findStaticField(fieldDesc);
        if (field.isFinal()) {
            Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Can't modify a final field: " + field));
            throw new KotlinNothingValueException();
        }
        ReferenceType referenceType = field.declaringType();
        if (!(referenceType instanceof ClassType)) {
            referenceType = null;
        }
        ClassType classType = (ClassType)referenceType;
        if (classType == null) {
            Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Can't a field in a non-class: " + field));
            throw new KotlinNothingValueException();
        }
        ClassType clazz = classType;
        com.sun.jdi.Type type2 = field.type();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"field.type()");
        com.sun.jdi.Value jdiValue = JdiValuesKt.asJdiValue(newValue2, this.vm, JdiValuesKt.asType(type2));
        JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow((Function0)new Function0<Unit>(clazz, field, jdiValue){
            final /* synthetic */ ClassType $clazz;
            final /* synthetic */ Field $field;
            final /* synthetic */ com.sun.jdi.Value $jdiValue;

            public final void invoke() {
                this.$clazz.setValue(this.$field, this.$jdiValue);
            }
            {
                this.$clazz = classType;
                this.$field = field;
                this.$jdiValue = value2;
                super(0);
            }
        }), field, null, 2, null);
    }

    private final Method findMethod(MethodDescription methodDesc, ReferenceType clazz) {
        Method method = this.findMethodOrNull(methodDesc, clazz);
        if (method != null) {
            return method;
        }
        Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchMethodError("Method not found: " + methodDesc));
        throw new KotlinNothingValueException();
    }

    static /* synthetic */ Method findMethod$default(JDIEval jDIEval, MethodDescription methodDescription, ReferenceType referenceType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findMethod");
        }
        if ((n & 2) != 0) {
            referenceType = JDIEval.asReferenceType$default(jDIEval, MembersKt.getOwnerType(methodDescription), null, 1, null);
        }
        return jDIEval.findMethod(methodDescription, referenceType);
    }

    /*
     * WARNING - void declaration
     */
    private final Method findMethodOrNull(MethodDescription methodDesc, ReferenceType clazz) {
        String methodName2 = methodDesc.getName();
        Method method = null;
        ReferenceType referenceType = clazz;
        if (referenceType instanceof ClassType) {
            method = ((ClassType)clazz).concreteMethodByName(methodName2, methodDesc.getDesc());
        } else if (referenceType instanceof ArrayType) {
            Type type2 = JdiEvalKt.access$getOBJECT$p();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"OBJECT");
            ReferenceType objectType = JDIEval.asReferenceType$default(this, type2, null, 1, null);
            method = this.findMethodOrNull(methodDesc, objectType);
            if (method == null && Intrinsics.areEqual((Object)methodDesc.getName(), (Object)"clone") && Intrinsics.areEqual((Object)methodDesc.getDesc(), (Object)"()[Ljava/lang/Object;")) {
                Type type3 = JdiEvalKt.access$getOBJECT$p();
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"OBJECT");
                String string = type3.getInternalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"OBJECT.internalName");
                method = this.findMethodOrNull(new MethodDescription(string, "clone", "()[Ljava/lang/Object;", false), objectType);
            }
        } else {
            List<Method> list2 = clazz.methodsByName(methodName2, methodDesc.getDesc());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"clazz.methodsByName(methodName, methodDesc.desc)");
            method = (Method)CollectionsKt.firstOrNull(list2);
        }
        if (method != null) {
            return method;
        }
        String internalNameWithoutSuffix = KotlinTypeMapper.InternalNameMapper.INSTANCE.internalNameWithoutModuleSuffix(methodName2);
        if (internalNameWithoutSuffix != null) {
            void $this$filterTo$iv$iv;
            List<Method> list3 = clazz.visibleMethods();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"clazz.visibleMethods()");
            Iterable $this$filter$iv = list3;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String name2;
                Method it = (Method)element$iv$iv;
                boolean bl = false;
                String string = name2 = it.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                if (!(StringsKt.startsWith$default((String)string, (String)internalNameWithoutSuffix, (boolean)false, (int)2, null) && KotlinTypeMapper.InternalNameMapper.INSTANCE.canBeMangledInternalName(name2) && Intrinsics.areEqual((Object)it.signature(), (Object)methodDesc.getDesc()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List internalMethods = (List)destination$iv$iv;
            Collection collection = internalMethods;
            if (!collection.isEmpty()) {
                Method method2 = (Method)CollectionsKt.singleOrNull((List)internalMethods);
                if (method2 == null) {
                    Void void_ = ValuesKt.throwBrokenCodeException(new IllegalArgumentException("Several internal methods found for " + methodDesc));
                    throw new KotlinNothingValueException();
                }
                return method2;
            }
        }
        return null;
    }

    @Nullable
    public com.sun.jdi.Value jdiInvokeStaticMethod(@NotNull ClassType type2, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int invokePolicy) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return type2.invokeMethod(this.thread, method, args, invokePolicy);
    }

    @Nullable
    public com.sun.jdi.Value jdiInvokeStaticMethod(@NotNull InterfaceType type2, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int invokePolicy) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return type2.invokeMethod(this.thread, method, args, invokePolicy);
    }

    @Override
    @NotNull
    public Value invokeStaticMethod(@NotNull MethodDescription methodDesc, @NotNull List<? extends Value> arguments2) {
        Intrinsics.checkNotNullParameter((Object)methodDesc, (String)"methodDesc");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Method method = JDIEval.findMethod$default(this, methodDesc, null, 2, null);
        if (!method.isStatic()) {
            Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchMethodError("Method is not static: " + methodDesc));
            throw new KotlinNothingValueException();
        }
        ReferenceType declaringType = method.declaringType();
        List<com.sun.jdi.Value> args = this.mapArguments(arguments2, this.safeArgumentTypes(method));
        if (this.shouldInvokeMethodWithReflection(method, args)) {
            ReferenceType referenceType = declaringType;
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType");
            return this.invokeMethodWithReflection(JdiValuesKt.asType(referenceType), ValuesKt.getNULL_VALUE(), args, methodDesc);
        }
        this.disableCollection(args);
        com.sun.jdi.Value result2 = (com.sun.jdi.Value)JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow((Function0)new Function0<com.sun.jdi.Value>(this, declaringType, method, args){
            final /* synthetic */ JDIEval this$0;
            final /* synthetic */ ReferenceType $declaringType;
            final /* synthetic */ Method $method;
            final /* synthetic */ List $args;

            @Nullable
            public final com.sun.jdi.Value invoke() {
                com.sun.jdi.Value value2;
                ReferenceType referenceType = this.$declaringType;
                if (referenceType instanceof ClassType) {
                    value2 = this.this$0.jdiInvokeStaticMethod((ClassType)this.$declaringType, this.$method, (List<? extends com.sun.jdi.Value>)this.$args, JDIEval.access$getInvokePolicy$p(this.this$0));
                } else if (referenceType instanceof InterfaceType) {
                    if (!JDIEval.access$isJava8OrLater$p(this.this$0)) {
                        String message2 = "Calling interface static methods is not supported in JVM " + JDIEval.access$getVm$p(this.this$0).version() + " (" + this.$method + ")";
                        Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchMethodError(message2));
                        throw new KotlinNothingValueException();
                    }
                    value2 = this.this$0.jdiInvokeStaticMethod((InterfaceType)this.$declaringType, this.$method, (List<? extends com.sun.jdi.Value>)this.$args, JDIEval.access$getInvokePolicy$p(this.this$0));
                } else {
                    String message3 = "Calling static methods is only supported for classes and interfaces (" + this.$method + ")";
                    Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchMethodError(message3));
                    throw new KotlinNothingValueException();
                }
                return value2;
            }
            {
                this.this$0 = jDIEval;
                this.$declaringType = referenceType;
                this.$method = method;
                this.$args = list2;
                super(0);
            }
        }), method, null, 2, null);
        this.enableCollection(args);
        return JdiValuesKt.asValue(result2);
    }

    @Override
    @NotNull
    public Value getField(@NotNull Value instance2, @NotNull FieldDescription fieldDesc) {
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)fieldDesc, (String)"fieldDesc");
        ObjectReference receiver2 = ValuesKt.checkNull(JdiValuesKt.getJdiObj(instance2));
        Field field = this.findField(fieldDesc, receiver2.referenceType());
        return JdiValuesKt.asValue((com.sun.jdi.Value)JdiEvalKt.access$ifFail(JdiEvalKt.access$mayThrow((Function0)new Function0<com.sun.jdi.Value>(receiver2, field){
            final /* synthetic */ ObjectReference $receiver;
            final /* synthetic */ Field $field;

            public final com.sun.jdi.Value invoke() {
                com.sun.jdi.Value value2;
                try {
                    value2 = this.$receiver.getValue(this.$field);
                }
                catch (IllegalArgumentException e) {
                    throw (Throwable)new IllegalArgumentException("Possibly incompatible types: field declaring type = " + this.$field.declaringType() + ", instance type = " + this.$receiver.referenceType());
                }
                return value2;
            }
            {
                this.$receiver = objectReference;
                this.$field = field;
                super(0);
            }
        }), field, receiver2));
    }

    @Override
    public void setField(@NotNull Value instance2, @NotNull FieldDescription fieldDesc, @NotNull Value newValue2) {
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)fieldDesc, (String)"fieldDesc");
        Intrinsics.checkNotNullParameter((Object)newValue2, (String)"newValue");
        ObjectReference receiver2 = ValuesKt.checkNull(JdiValuesKt.getJdiObj(instance2));
        Field field = this.findField(fieldDesc, receiver2.referenceType());
        com.sun.jdi.Type type2 = field.type();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"field.type()");
        com.sun.jdi.Value jdiValue = JdiValuesKt.asJdiValue(newValue2, this.vm, JdiValuesKt.asType(type2));
        JdiEvalKt.access$mayThrow((Function0)new Function0<Unit>(receiver2, field, jdiValue){
            final /* synthetic */ ObjectReference $receiver;
            final /* synthetic */ Field $field;
            final /* synthetic */ com.sun.jdi.Value $jdiValue;

            public final void invoke() {
                this.$receiver.setValue(this.$field, this.$jdiValue);
            }
            {
                this.$receiver = objectReference;
                this.$field = field;
                this.$jdiValue = value2;
                super(0);
            }
        });
    }

    private final Value unboxType(Value boxedValue, Type type2) {
        MethodDescription methodDescription;
        Type type3 = type2;
        if (Intrinsics.areEqual((Object)type3, (Object)Type.INT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Integer", "intValue", "()I", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.BOOLEAN_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Boolean", "booleanValue", "()Z", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.CHAR_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Character", "charValue", "()C", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.SHORT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Character", "shortValue", "()S", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.LONG_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Long", "longValue", "()J", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.BYTE_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Byte", "byteValue", "()B", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.FLOAT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Float", "floatValue", "()F", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.DOUBLE_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Double", "doubleValue", "()D", false);
        } else {
            throw (Throwable)new UnsupportedOperationException("Couldn't unbox non primitive type " + type2.getInternalName());
        }
        MethodDescription method = methodDescription;
        return this.invokeMethod(boxedValue, method, CollectionsKt.emptyList(), true);
    }

    @Nullable
    public com.sun.jdi.Value jdiInvokeMethod(@NotNull ObjectReference obj, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int policy) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return obj.invokeMethod(this.thread, method, args, policy);
    }

    @Override
    @NotNull
    public Value invokeMethod(@NotNull Value instance2, @NotNull MethodDescription methodDesc, @NotNull List<? extends Value> arguments2, boolean invokeSpecial) {
        Value value2;
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)methodDesc, (String)"methodDesc");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        if (invokeSpecial && Intrinsics.areEqual((Object)methodDesc.getName(), (Object)"<init>")) {
            Method ctor = JDIEval.findMethod$default(this, methodDesc, null, 2, null);
            ReferenceType referenceType = JDIEval.asReferenceType$default(this, ((NewObjectValue)instance2).getAsmType(), null, 1, null);
            if (referenceType == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.ClassType");
            }
            ClassType clazz = (ClassType)referenceType;
            List<com.sun.jdi.Value> args = this.mapArguments(arguments2, this.safeArgumentTypes(ctor));
            this.disableCollection(args);
            ObjectReference result2 = (ObjectReference)JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow((Function0)new Function0<ObjectReference>(this, clazz, ctor, args){
                final /* synthetic */ JDIEval this$0;
                final /* synthetic */ ClassType $clazz;
                final /* synthetic */ Method $ctor;
                final /* synthetic */ List $args;

                public final ObjectReference invoke() {
                    return this.$clazz.newInstance(this.this$0.getThread(), this.$ctor, this.$args, JDIEval.access$getInvokePolicy$p(this.this$0));
                }
                {
                    this.this$0 = jDIEval;
                    this.$clazz = classType;
                    this.$ctor = method;
                    this.$args = list2;
                    super(0);
                }
            }), ctor, null, 2, null);
            this.enableCollection(args);
            ((NewObjectValue)instance2).setValue(result2);
            return JdiValuesKt.asValue(result2);
        }
        var $fun$doInvokeMethod$1 = new Function3<ObjectReference, Method, Integer, Value>(this, arguments2, instance2, methodDesc){
            final /* synthetic */ JDIEval this$0;
            final /* synthetic */ List $arguments;
            final /* synthetic */ Value $instance;
            final /* synthetic */ MethodDescription $methodDesc;

            @NotNull
            public final Value invoke(@NotNull ObjectReference obj, @NotNull Method method, int policy) {
                Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                List args = JDIEval.access$mapArguments(this.this$0, this.$arguments, JDIEval.access$safeArgumentTypes(this.this$0, method));
                if (JDIEval.access$shouldInvokeMethodWithReflection(this.this$0, method, args)) {
                    return JDIEval.access$invokeMethodWithReflection(this.this$0, this.$instance.getAsmType(), this.$instance, args, this.$methodDesc);
                }
                JDIEval.access$disableCollection(this.this$0, args);
                com.sun.jdi.Value result2 = (com.sun.jdi.Value)JdiEvalKt.access$ifFail(JdiEvalKt.access$mayThrow((Function0)new Function0<com.sun.jdi.Value>(this, obj, method, args, policy){
                    final /* synthetic */ invokeMethod.1 this$0;
                    final /* synthetic */ ObjectReference $obj;
                    final /* synthetic */ Method $method;
                    final /* synthetic */ List $args;
                    final /* synthetic */ int $policy;

                    @Nullable
                    public final com.sun.jdi.Value invoke() {
                        return this.this$0.this$0.jdiInvokeMethod(this.$obj, this.$method, this.$args, this.$policy);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$obj = objectReference;
                        this.$method = method;
                        this.$args = list2;
                        this.$policy = n;
                        super(0);
                    }
                }), method, obj);
                JDIEval.access$enableCollection(this.this$0, args);
                return JdiValuesKt.asValue(result2);
            }
            {
                this.this$0 = jDIEval;
                this.$arguments = list2;
                this.$instance = value2;
                this.$methodDesc = methodDescription;
                super(3);
            }
        };
        ObjectReference obj = ValuesKt.checkNull(JdiValuesKt.getJdiObj(instance2));
        if (invokeSpecial) {
            Method method = JDIEval.findMethod$default(this, methodDesc, null, 2, null);
            value2 = $fun$doInvokeMethod$1.invoke(obj, method, this.invokePolicy | 2);
        } else {
            ReferenceType referenceType = obj.referenceType();
            if (referenceType == null) {
                referenceType = JDIEval.asReferenceType$default(this, MembersKt.getOwnerType(methodDesc), null, 1, null);
            }
            Method method = this.findMethod(methodDesc, referenceType);
            value2 = $fun$doInvokeMethod$1.invoke(obj, method, this.invokePolicy);
        }
        return value2;
    }

    private final boolean shouldInvokeMethodWithReflection(Method method, List<? extends com.sun.jdi.Value> args) {
        boolean bl;
        block6: {
            List<com.sun.jdi.Type> list2;
            if (method.isVarArgs()) {
                return false;
            }
            try {
                list2 = method.argumentTypes();
            }
            catch (ClassNotLoadedException e) {
                return false;
            }
            List<com.sun.jdi.Type> argumentTypes2 = list2;
            Iterable iterable = args;
            List<com.sun.jdi.Type> list3 = argumentTypes2;
            Intrinsics.checkNotNullExpressionValue(list3, (String)"argumentTypes");
            Iterable $this$any$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)list3);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    com.sun.jdi.Value value2 = (com.sun.jdi.Value)it.getFirst();
                    if (!this.isArrayOfInterfaces(value2 != null ? value2.type() : null, (com.sun.jdi.Type)it.getSecond())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isArrayOfInterfaces(com.sun.jdi.Type valueType, com.sun.jdi.Type expectedType) {
        com.sun.jdi.Type type2 = valueType;
        if (!(type2 instanceof ArrayType)) {
            type2 = null;
        }
        ArrayType arrayType = (ArrayType)type2;
        if (!((arrayType != null ? arrayType.componentType() : null) instanceof InterfaceType)) return false;
        com.sun.jdi.Type type3 = expectedType;
        if (!(type3 instanceof ArrayType)) {
            type3 = null;
        }
        ArrayType arrayType2 = (ArrayType)type3;
        com.sun.jdi.Type type4 = arrayType2 != null ? arrayType2.componentType() : null;
        Type type5 = JdiEvalKt.access$getOBJECT$p();
        Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"OBJECT");
        if (!Intrinsics.areEqual((Object)type4, (Object)JDIEval.asReferenceType$default(this, type5, null, 1, null))) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Value invokeMethodWithReflection(Type ownerType, Value instance2, List<? extends com.sun.jdi.Value> args, MethodDescription methodDesc) {
        void $this$toTypedArray$iv;
        Collection<Value> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Value value2 = this.loadClass(ownerType);
        Type type2 = JdiEvalKt.access$getCLASS$p();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"CLASS");
        String string = type2.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CLASS.internalName");
        Type type3 = JdiEvalKt.access$getCLASS$p();
        Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"CLASS");
        MethodDescription methodDescription = new MethodDescription(string, "getDeclaredMethod", "(Ljava/lang/String;[L" + type3.getInternalName() + ";)Ljava/lang/reflect/Method;", true);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)JdiValuesKt.asValue(this.vm.mirrorOf(methodDesc.getName())));
        Iterable iterable = MembersKt.getParameterTypes(methodDesc);
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        SpreadBuilder spreadBuilder3 = spreadBuilder;
        MethodDescription methodDescription2 = methodDescription;
        Value value3 = value2;
        JDIEval jDIEval = this;
        boolean $i$f$map = false;
        void var8_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Type type4 = (Type)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Value value4 = this.loadClass((Type)it);
            collection.add(value4);
        }
        collection = (List)destination$iv$iv;
        SpreadBuilder spreadBuilder4 = spreadBuilder3;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Value[] valueArray = thisCollection$iv.toArray(new Value[0]);
        if (valueArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        spreadBuilder2.addSpread((Object)valueArray);
        Value methodToInvoke = Eval.DefaultImpls.invokeMethod$default(jDIEval, value3, methodDescription2, CollectionsKt.listOf((Object[])((Value[])spreadBuilder4.toArray((Object[])new Value[spreadBuilder4.size()]))), false, 8, null);
        Type type5 = Type.getType(AccessibleObject.class);
        Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"Type.getType(AccessibleObject::class.java)");
        String string2 = type5.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Type.getType(AccessibleO\u2026:class.java).internalName");
        Eval.DefaultImpls.invokeMethod$default(this, methodToInvoke, new MethodDescription(string2, "setAccessible", "(Z)V", true), CollectionsKt.listOf((Object)JdiValuesKt.asValue(this.vm.mirrorOf(true))), false, 8, null);
        String string3 = methodToInvoke.getAsmType().getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"methodToInvoke.asmType.internalName");
        Type type6 = JdiEvalKt.access$getOBJECT$p();
        Intrinsics.checkNotNullExpressionValue((Object)type6, (String)"OBJECT");
        String string4 = type6.getInternalName();
        Type type7 = JdiEvalKt.access$getOBJECT$p();
        Intrinsics.checkNotNullExpressionValue((Object)type7, (String)"OBJECT");
        String string5 = type7.getInternalName();
        Type type8 = JdiEvalKt.access$getOBJECT$p();
        Intrinsics.checkNotNullExpressionValue((Object)type8, (String)"OBJECT");
        Value invocationResult = Eval.DefaultImpls.invokeMethod$default(this, methodToInvoke, new MethodDescription(string3, "invoke", "(L" + string4 + ";[L" + string5 + ";)L" + type8.getInternalName() + ";", true), CollectionsKt.listOf((Object[])new Value[]{instance2, this.mirrorOfArgs(args)}), false, 8, null);
        return MembersKt.getReturnType(methodDesc).getSort() != 10 && MembersKt.getReturnType(methodDesc).getSort() != 9 && MembersKt.getReturnType(methodDesc).getSort() != 0 ? this.unboxType(invocationResult, MembersKt.getReturnType(methodDesc)) : invocationResult;
    }

    /*
     * WARNING - void declaration
     */
    private final Value mirrorOfArgs(List<? extends com.sun.jdi.Value> args) {
        Type type2 = JdiEvalKt.access$getOBJECT$p();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"OBJECT");
        Type type3 = Type.getType((String)("[" + type2.getDescriptor()));
        Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"Type.getType(\"[\" + OBJECT.descriptor)");
        Value arrayObject = this.newArray(type3, args.size());
        Iterable $this$forEachIndexed$iv = args;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            com.sun.jdi.Value value3 = (com.sun.jdi.Value)item$iv;
            int index2 = n;
            boolean bl = false;
            Value indexValue = JdiValuesKt.asValue(this.vm.mirrorOf(index2));
            this.setArrayElement(arrayObject, indexValue, JdiValuesKt.asValue((com.sun.jdi.Value)value2));
        }
        return arrayObject;
    }

    private final void disableCollection(List<? extends com.sun.jdi.Value> $this$disableCollection) {
        Iterable $this$forEach$iv = $this$disableCollection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            com.sun.jdi.Value it = (com.sun.jdi.Value)element$iv;
            boolean bl = false;
            com.sun.jdi.Value value2 = it;
            if (!(value2 instanceof ObjectReference)) {
                value2 = null;
            }
            ObjectReference objectReference = (ObjectReference)value2;
            if (objectReference == null) continue;
            objectReference.disableCollection();
        }
    }

    private final void enableCollection(List<? extends com.sun.jdi.Value> $this$enableCollection) {
        Iterable $this$forEach$iv = $this$enableCollection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            com.sun.jdi.Value it = (com.sun.jdi.Value)element$iv;
            boolean bl = false;
            com.sun.jdi.Value value2 = it;
            if (!(value2 instanceof ObjectReference)) {
                value2 = null;
            }
            ObjectReference objectReference = (ObjectReference)value2;
            if (objectReference == null) continue;
            objectReference.enableCollection();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<com.sun.jdi.Value> mapArguments(List<? extends Value> arguments2, List<? extends com.sun.jdi.Type> expectedTypes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)arguments2, (Iterable)expectedTypes);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void arg;
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_12 = it;
            Value value2 = (Value)var12_12.component1();
            com.sun.jdi.Type expectedType = (com.sun.jdi.Type)var12_12.component2();
            com.sun.jdi.Value value3 = JdiValuesKt.asJdiValue((Value)arg, this.vm, JdiValuesKt.asType(expectedType));
            collection.add(value3);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    private final List<com.sun.jdi.Type> safeArgumentTypes(Method $this$safeArgumentTypes) {
        try {
            v0 = $this$safeArgumentTypes.argumentTypes();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"argumentTypes()");
            return v0;
        }
        catch (ClassNotLoadedException e) {
            v1 = $this$safeArgumentTypes.argumentTypeNames();
            Intrinsics.checkNotNull(v1);
            $this$map$iv = v1;
            $i$f$map = false;
            var5_5 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                block27: {
                    block26: {
                        var10_10 = (String)item$iv$iv;
                        var14_14 = destination$iv$iv;
                        $i$a$-map-JDIEval$safeArgumentTypes$1 = false;
                        v2 = $this$safeArgumentTypes.declaringType();
                        v3 = classLoader = v2 != null ? v2.classLoader() : null;
                        if (classLoader == null) break block26;
                        v4 = name;
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"name");
                        v5 = this.loadClassByName((String)v4, classLoader);
                        break block27;
                    }
                    if (name == null) ** GOTO lbl-1000
                    tmp = -1;
                    switch (var13_13.hashCode()) {
                        case 3625364: {
                            if (!var13_13.equals("void")) break;
                            tmp = 1;
                            break;
                        }
                        case 64711720: {
                            if (!var13_13.equals("boolean")) break;
                            tmp = 2;
                            break;
                        }
                        case 3039496: {
                            if (!var13_13.equals("byte")) break;
                            tmp = 3;
                            break;
                        }
                        case -1325958191: {
                            if (!var13_13.equals("double")) break;
                            tmp = 4;
                            break;
                        }
                        case 3052374: {
                            if (!var13_13.equals("char")) break;
                            tmp = 5;
                            break;
                        }
                        case 109413500: {
                            if (!var13_13.equals("short")) break;
                            tmp = 6;
                            break;
                        }
                        case 97526364: {
                            if (!var13_13.equals("float")) break;
                            tmp = 7;
                            break;
                        }
                        case 104431: {
                            if (!var13_13.equals("int")) break;
                            tmp = 8;
                            break;
                        }
                        case 3327612: {
                            if (!var13_13.equals("long")) break;
                            tmp = 9;
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            v6 = $this$safeArgumentTypes.virtualMachine().mirrorOfVoid().type();
                            break;
                        }
                        case 2: {
                            v7 = Type.BOOLEAN_TYPE;
                            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"Type.BOOLEAN_TYPE");
                            v6 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)v7.getClassName());
                            break;
                        }
                        case 3: {
                            v8 = Type.BYTE_TYPE;
                            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"Type.BYTE_TYPE");
                            v6 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)v8.getClassName());
                            break;
                        }
                        case 5: {
                            v9 = Type.CHAR_TYPE;
                            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"Type.CHAR_TYPE");
                            v6 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)v9.getClassName());
                            break;
                        }
                        case 6: {
                            v10 = Type.SHORT_TYPE;
                            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"Type.SHORT_TYPE");
                            v6 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)v10.getClassName());
                            break;
                        }
                        case 8: {
                            v11 = Type.INT_TYPE;
                            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"Type.INT_TYPE");
                            v6 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)v11.getClassName());
                            break;
                        }
                        case 9: {
                            v12 = Type.LONG_TYPE;
                            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"Type.LONG_TYPE");
                            v6 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)v12.getClassName());
                            break;
                        }
                        case 7: {
                            v13 = Type.FLOAT_TYPE;
                            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"Type.FLOAT_TYPE");
                            v6 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)v13.getClassName());
                            break;
                        }
                        case 4: {
                            v14 = Type.DOUBLE_TYPE;
                            Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"Type.DOUBLE_TYPE");
                            v6 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)v14.getClassName());
                            break;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            v15 = $this$safeArgumentTypes.virtualMachine().classesByName((String)name);
                            Intrinsics.checkNotNullExpressionValue(v15, (String)"virtualMachine().classesByName(name)");
                            v16 = (ReferenceType)CollectionsKt.firstOrNull(v15);
                            if (v16 == null) {
                                throw (Throwable)new IllegalStateException("Unknown class " + (String)name);
                            }
                            v6 = v16;
                        }
                    }
                    v5 = v6;
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"when (name) {\n          \u2026$name\")\n                }");
                }
                var15_15 = v5;
                var14_14.add(var15_15);
            }
            return (List)destination$iv$iv;
        }
    }

    @NotNull
    protected final ThreadReference getThread() {
        return this.thread;
    }

    public JDIEval(@NotNull VirtualMachine vm, @Nullable ClassLoaderReference defaultClassLoader, @NotNull ThreadReference thread, int invokePolicy) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.vm = vm;
        this.defaultClassLoader = defaultClassLoader;
        this.thread = thread;
        this.invokePolicy = invokePolicy;
        Pair[] pairArray = new Pair[8];
        Type type2 = Type.BOOLEAN_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"Type.BOOLEAN_TYPE");
        pairArray[0] = TuplesKt.to((Object)type2.getClassName(), (Object)this.vm.mirrorOf(true).type());
        Type type3 = Type.BYTE_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"Type.BYTE_TYPE");
        pairArray[1] = TuplesKt.to((Object)type3.getClassName(), (Object)this.vm.mirrorOf((byte)1).type());
        Type type4 = Type.SHORT_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"Type.SHORT_TYPE");
        pairArray[2] = TuplesKt.to((Object)type4.getClassName(), (Object)this.vm.mirrorOf((short)1).type());
        Type type5 = Type.INT_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"Type.INT_TYPE");
        pairArray[3] = TuplesKt.to((Object)type5.getClassName(), (Object)this.vm.mirrorOf(1).type());
        Type type6 = Type.CHAR_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type6, (String)"Type.CHAR_TYPE");
        pairArray[4] = TuplesKt.to((Object)type6.getClassName(), (Object)this.vm.mirrorOf('1').type());
        Type type7 = Type.LONG_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type7, (String)"Type.LONG_TYPE");
        pairArray[5] = TuplesKt.to((Object)type7.getClassName(), (Object)this.vm.mirrorOf(1L).type());
        Type type8 = Type.FLOAT_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type8, (String)"Type.FLOAT_TYPE");
        pairArray[6] = TuplesKt.to((Object)type8.getClassName(), (Object)this.vm.mirrorOf(1.0f).type());
        Type type9 = Type.DOUBLE_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type9, (String)"Type.DOUBLE_TYPE");
        pairArray[7] = TuplesKt.to((Object)type9.getClassName(), (Object)this.vm.mirrorOf(1.0).type());
        this.primitiveTypes = MapsKt.mapOf((Pair[])pairArray);
        this.isJava8OrLater = StringUtil.compareVersionNumbers((String)this.vm.version(), (String)"1.8") >= 0;
    }

    public static final /* synthetic */ int access$getInvokePolicy$p(JDIEval $this) {
        return $this.invokePolicy;
    }

    public static final /* synthetic */ boolean access$isJava8OrLater$p(JDIEval $this) {
        return $this.isJava8OrLater;
    }

    public static final /* synthetic */ VirtualMachine access$getVm$p(JDIEval $this) {
        return $this.vm;
    }

    public static final /* synthetic */ List access$mapArguments(JDIEval $this, List arguments2, List expectedTypes) {
        return $this.mapArguments(arguments2, expectedTypes);
    }

    public static final /* synthetic */ List access$safeArgumentTypes(JDIEval $this, Method $this$access_u24safeArgumentTypes) {
        return $this.safeArgumentTypes($this$access_u24safeArgumentTypes);
    }

    public static final /* synthetic */ boolean access$shouldInvokeMethodWithReflection(JDIEval $this, Method method, List args) {
        return $this.shouldInvokeMethodWithReflection(method, args);
    }

    public static final /* synthetic */ Value access$invokeMethodWithReflection(JDIEval $this, Type ownerType, Value instance2, List args, MethodDescription methodDesc) {
        return $this.invokeMethodWithReflection(ownerType, instance2, args, methodDesc);
    }

    public static final /* synthetic */ void access$disableCollection(JDIEval $this, List $this$access_u24disableCollection) {
        $this.disableCollection($this$access_u24disableCollection);
    }

    public static final /* synthetic */ void access$enableCollection(JDIEval $this, List $this$access_u24enableCollection) {
        $this.enableCollection($this$access_u24enableCollection);
    }
}

