/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.Decompressor;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.impl.UtilsKt;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.kotlin.config.JpsPluginSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.BaseKotlinCompilerSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPathsProvider;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004JB\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u0015JJ\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u0015J\u0016\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0004J\u001e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinPathsProvider;", "", "()V", "KOTLIN_DIST_ARTIFACT_ID", "", "KOTLIN_MAVEN_GROUP_ID", "getExpectedMavenArtifactJarPath", "Ljava/io/File;", "artifactId", "version", "getKotlinPaths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "project", "Lcom/intellij/openapi/project/Project;", "lazyDownloadAndUnpackKotlincDist", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "beforeDownload", "Lkotlin/Function0;", "", "onError", "Lkotlin/Function1;", "lazyDownloadMavenArtifact", "lazyUnpackKotlincDist", "packedDist", "resolveMavenArtifactInMavenRepo", "mavenRepo", "kotlin.core"})
public final class KotlinPathsProvider {
    @NotNull
    public static final String KOTLIN_MAVEN_GROUP_ID = "org.jetbrains.kotlin";
    @NotNull
    public static final String KOTLIN_DIST_ARTIFACT_ID = "kotlin-dist-for-ide";
    @NotNull
    public static final KotlinPathsProvider INSTANCE;

    @NotNull
    public final KotlinPaths getKotlinPaths(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return (KotlinPaths)new KotlinPathsFromHomeDir(FilesKt.resolve((File)new File(PathManager.getSystemPath(), KOTLIN_DIST_ARTIFACT_ID), (String)version2));
    }

    @NotNull
    public final KotlinPaths getKotlinPaths(@NotNull Project project2) {
        Object object;
        block3: {
            block2: {
                Object object2;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                object = KotlinJpsPluginSettings.Companion.getInstance(project2);
                if (object == null || (object = (JpsPluginSettings)((BaseKotlinCompilerSettings)object).getSettings()) == null || (object = object.getVersion()) == null) break block2;
                Object it = object2 = object;
                boolean bl = false;
                object = INSTANCE.getKotlinPaths((String)it);
                if (object != null) break block3;
            }
            object = (KotlinPaths)new KotlinPathsFromHomeDir(KotlinPluginLayout.Companion.getInstance().getKotlinc());
        }
        return object;
    }

    @NotNull
    public final File lazyUnpackKotlincDist(@NotNull File packedDist2, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)packedDist2, (String)"packedDist");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        File destination = this.getKotlinPaths(version2).getHomePath();
        long unpackedDistTimestamp = destination.lastModified();
        long packedDistTimestamp = packedDist2.lastModified();
        if (unpackedDistTimestamp != 0L && packedDistTimestamp != 0L && unpackedDistTimestamp >= packedDistTimestamp) {
            return destination;
        }
        FilesKt.deleteRecursively((File)destination);
        new Decompressor.Zip(packedDist2).extract(destination);
        boolean bl = destination.isDirectory();
        if (!bl) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return destination;
    }

    @Nullable
    public final File lazyDownloadAndUnpackKotlincDist(@NotNull Project project2, @NotNull String version2, @NotNull ProgressIndicator indicator, @NotNull Function0<Unit> beforeDownload, @NotNull Function1<? super String, Unit> onError) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(beforeDownload, (String)"beforeDownload");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        File file3 = this.lazyDownloadMavenArtifact(project2, KOTLIN_DIST_ARTIFACT_ID, version2, indicator, beforeDownload, onError);
        if (file3 != null) {
            File file4;
            File it = file4 = file3;
            boolean bl = false;
            file2 = INSTANCE.lazyUnpackKotlincDist(it, version2);
        } else {
            file2 = null;
        }
        return file2;
    }

    @Nullable
    public final File lazyDownloadMavenArtifact(@NotNull Project project2, @NotNull String artifactId2, @NotNull String version2, @NotNull ProgressIndicator indicator, @NotNull Function0<Unit> beforeDownload, @NotNull Function1<? super String, Unit> onError) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(beforeDownload, (String)"beforeDownload");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        File it = file2 = this.getExpectedMavenArtifactJarPath(artifactId2, version2);
        boolean bl = false;
        File file3 = it.exists() ? file2 : null;
        if (file3 != null) {
            it = file2 = file3;
            boolean bl2 = false;
            return it;
        }
        RepositoryLibraryProperties prop = new RepositoryLibraryProperties(KOTLIN_MAVEN_GROUP_ID, artifactId2, version2, false, CollectionsKt.emptyList());
        RemoteRepositoriesConfiguration remoteRepositoriesConfiguration = RemoteRepositoriesConfiguration.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)remoteRepositoriesConfiguration, (String)"RemoteRepositoriesConfig\u2026tion.getInstance(project)");
        List list2 = remoteRepositoriesConfiguration.getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"RemoteRepositoriesConfig\u2026nce(project).repositories");
        List repos = CollectionsKt.plus((Collection)list2, (Iterable)CollectionsKt.listOf((Object)new RemoteRepositoryDescription("kotlin.ide.plugin.dependencies", "Kotlin IDE Plugin Dependencies", "https://cache-redirector.jetbrains.com/maven.pkg.jetbrains.space/kotlin/p/kotlin/kotlin-ide-plugin-dependencies")));
        beforeDownload.invoke();
        Collection collection = JarRepositoryManager.loadDependenciesSync((Project)project2, (RepositoryLibraryProperties)prop, (boolean)false, (boolean)false, null, (Collection)repos, (ProgressIndicator)indicator);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"JarRepositoryManager.loa\u2026      indicator\n        )");
        Collection downloadedCompiler = collection;
        if (downloadedCompiler.isEmpty()) {
            RepositoryLibraryProperties $this$with = prop;
            boolean bl3 = false;
            onError.invoke((Object)("Failed to download maven artifact (" + $this$with.getGroupId() + ":" + artifactId2 + $this$with.getVersion() + "). Searched the artifact in following repos:\n" + CollectionsKt.joinToString$default((Iterable)repos, (CharSequence)"\n", null, null, (int)0, null, (Function1)lazyDownloadMavenArtifact.3.1.INSTANCE, (int)30, null)));
            return null;
        }
        Object object = CollectionsKt.singleOrNull((Iterable)downloadedCompiler);
        Object it2 = (OrderRoot)object;
        boolean bl4 = false;
        OrderRoot orderRoot = it2;
        if (orderRoot == null) {
            String string = "Expected to download only single artifact";
            throw new IllegalStateException(string.toString());
        }
        VirtualFile virtualFile2 = orderRoot.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"downloadedCompiler.singl\u2026 single artifact\") }.file");
        object = UtilsKt.toVirtualFileUrl((VirtualFile)virtualFile2, (VirtualFileUrlManager)VirtualFileUrlManagerUtil.getInstance((VirtualFileUrlManager.Companion)VirtualFileUrlManager.Companion, (Project)project2)).getPresentableUrl();
        it2 = object;
        boolean bl5 = false;
        return new File((String)it2);
    }

    @NotNull
    public final File resolveMavenArtifactInMavenRepo(@NotNull File mavenRepo, @NotNull String artifactId2, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)mavenRepo, (String)"mavenRepo");
        Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)mavenRepo, (String)StringsKt.replace$default((String)KOTLIN_MAVEN_GROUP_ID, (String)".", (String)"/", (boolean)false, (int)4, null)), (String)artifactId2), (String)version2), (String)(artifactId2 + "-" + version2 + ".jar"));
    }

    @NotNull
    public final File getExpectedMavenArtifactJarPath(@NotNull String artifactId2, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        File file2 = JarRepositoryManager.getLocalRepositoryPath();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"JarRepositoryManager.getLocalRepositoryPath()");
        return this.resolveMavenArtifactInMavenRepo(file2, artifactId2, version2);
    }

    private KotlinPathsProvider() {
    }

    static {
        KotlinPathsProvider kotlinPathsProvider;
        INSTANCE = kotlinPathsProvider = new KotlinPathsProvider();
    }
}

