/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compilerPlugin.kotlinxSerialization.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.compilerPlugin.kotlinxSerialization.KotlinSerializationBundle;
import org.jetbrains.kotlin.idea.compilerPlugin.kotlinxSerialization.quickfixes.JsonRedundantQuickFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceProperty.KotlinIntroducePropertyHandler;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationErrors;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002J4\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/compilerPlugin/kotlinxSerialization/quickfixes/JsonRedundantQuickFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "expression", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "selectContainer", "element", "Lcom/intellij/psi/PsiElement;", "onSelect", "Lkotlin/Function1;", "Factory", "kotlin.compiler-plugins.kotlinx-serialization.common"})
public final class JsonRedundantQuickFix
extends KotlinQuickFixAction<KtCallExpression> {
    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (editor2 == null) {
            return;
        }
        KtCallExpression ktCallExpression = (KtCallExpression)this.getElement();
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression element3 = ktCallExpression;
        this.selectContainer((PsiElement)element3, project2, editor2, (Function1<? super PsiElement, Unit>)((Function1)new Function1<PsiElement, Unit>(this, editor2, element3, project2, file2){
            final /* synthetic */ JsonRedundantQuickFix this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ KtCallExpression $element;
            final /* synthetic */ Project $project;
            final /* synthetic */ KtFile $file;

            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                PsiElement outermostParent = PsiUtilsKt.getOutermostParentContainedIn((PsiElement)((PsiElement)this.$element), (PsiElement)it);
                if (outermostParent == null) {
                    IntroduceUtilKt.showErrorHintByKey(this.$project, this.$editor, "cannot.refactor.no.container", this.this$0.getText());
                    return;
                }
                new KotlinIntroducePropertyHandler(null, 1, null).doInvoke(this.$project, this.$editor, this.$file, CollectionsKt.listOf((Object)this.$element), outermostParent);
            }
            {
                this.this$0 = jsonRedundantQuickFix;
                this.$editor = editor2;
                this.$element = ktCallExpression;
                this.$project = project2;
                this.$file = ktFile;
                super(1);
            }
        }));
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return KotlinSerializationBundle.message("extract.json.to.property", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final void selectContainer(PsiElement element3, Project project2, Editor editor2, Function1<? super PsiElement, Unit> onSelect) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        PsiElement psiElement2 = element3.getParent();
        if (psiElement2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Should have at least one parent"));
        }
        PsiElement parent2 = psiElement2;
        Iterable iterable = KotlinRefactoringUtilKt.getExtractionContainers(parent2, true, true);
        boolean $i$f$filter = false;
        void var9_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtElement it = (KtElement)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof KtClassBody || it instanceof KtFile && !((KtFile)it).isScript())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List containers = (List)destination$iv$iv;
        if (containers.isEmpty()) {
            IntroduceUtilKt.showErrorHintByKey(project2, editor2, "cannot.refactor.no.container", this.getText());
            return;
        }
        KotlinRefactoringUtilKt.chooseContainerElementIfNecessary(containers, editor2, KotlinBundle.message("title.select.target.code.block", new Object[0]), true, selectContainer.1.INSTANCE, (Function1)new Function1<KtElement, Unit>(onSelect){
            final /* synthetic */ Function1 $onSelect;

            public final void invoke(@NotNull KtElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$onSelect.invoke((Object)it);
            }
            {
                this.$onSelect = function1;
                super(1);
            }
        });
    }

    public JsonRedundantQuickFix(@NotNull KtCallExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super((PsiElement)expression2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/compilerPlugin/kotlinxSerialization/quickfixes/JsonRedundantQuickFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.compiler-plugins.kotlinx-serialization.common"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final Factory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            if (Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)SerializationErrors.JSON_FORMAT_REDUNDANT) ^ true) {
                return null;
            }
            SimpleDiagnostic castedDiagnostic = (SimpleDiagnostic)SerializationErrors.JSON_FORMAT_REDUNDANT.cast((UnboundDiagnostic)diagnostic);
            PsiElement psiElement2 = castedDiagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtCallExpression)) {
                psiElement2 = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)psiElement2;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression element3 = ktCallExpression;
            return new JsonRedundantQuickFix(element3);
        }

        private Factory() {
        }

        static {
            Factory factory2;
            INSTANCE = factory2 = new Factory();
        }
    }
}

