/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.utils.fqname.FqNameUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001\u0018B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0006H\u0002R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00060\nj\b\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00060\nj\b\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00060\nj\b\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00060\nj\b\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/completion/ImportableFqNameClassifier;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isImportedByDefault", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/FqName;", "", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/jvm/functions/Function1;)V", "allUnderImports", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "excludedImports", "preciseImportPackages", "preciseImports", "classify", "Lorg/jetbrains/kotlin/idea/completion/ImportableFqNameClassifier$Classification;", "fqName", "isPackage", "hasPreciseImportFromPackage", "packageName", "isImportedWithAllUnderImport", "name", "isImportedWithPreciseImport", "Classification", "kotlin.fir.frontend-independent"})
public final class ImportableFqNameClassifier {
    private final HashSet<FqName> preciseImports;
    private final HashSet<FqName> preciseImportPackages;
    private final HashSet<FqName> allUnderImports;
    private final HashSet<FqName> excludedImports;
    private final KtFile file;
    private final Function1<FqName, Boolean> isImportedByDefault;

    @NotNull
    public final Classification classify(@NotNull FqName fqName2, boolean isPackage) {
        Classification classification;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        if (isPackage) {
            Classification classification2;
            if (this.isImportedWithPreciseImport(fqName2)) {
                classification2 = Classification.preciseImport;
            } else {
                FqName fqName3 = fqName2.parent();
                Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"fqName.parent()");
                classification2 = fqName3.isRoot() ? Classification.topLevelPackage : Classification.notImported;
            }
            return classification2;
        }
        if (FqNameUtilKt.isJavaClassNotToBeUsedInKotlin(fqName2)) {
            classification = Classification.notToBeUsedInKotlin;
        } else if (Intrinsics.areEqual((Object)fqName2.parent(), (Object)this.file.getPackageFqName())) {
            classification = Classification.fromCurrentPackage;
        } else if (((Boolean)this.isImportedByDefault.invoke((Object)fqName2)).booleanValue()) {
            classification = Classification.defaultImport;
        } else if (this.isImportedWithPreciseImport(fqName2)) {
            classification = Classification.preciseImport;
        } else if (this.isImportedWithAllUnderImport(fqName2)) {
            classification = Classification.allUnderImport;
        } else {
            FqName fqName4 = fqName2.parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"fqName.parent()");
            classification = this.hasPreciseImportFromPackage(fqName4) ? Classification.siblingImported : Classification.notImported;
        }
        return classification;
    }

    private final boolean isImportedWithPreciseImport(FqName name2) {
        return this.preciseImports.contains(name2);
    }

    private final boolean isImportedWithAllUnderImport(FqName name2) {
        return this.allUnderImports.contains(name2.parent()) && !this.excludedImports.contains(name2);
    }

    private final boolean hasPreciseImportFromPackage(FqName packageName2) {
        return this.preciseImportPackages.contains(packageName2);
    }

    public ImportableFqNameClassifier(@NotNull KtFile file2, @NotNull Function1<? super FqName, Boolean> isImportedByDefault) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(isImportedByDefault, (String)"isImportedByDefault");
        this.file = file2;
        this.isImportedByDefault = isImportedByDefault;
        this.preciseImports = new HashSet();
        this.preciseImportPackages = new HashSet();
        this.allUnderImports = new HashSet();
        this.excludedImports = new HashSet();
        for (KtImportDirective ktImportDirective : this.file.getImportDirectives()) {
            ImportPath importPath2;
            if (ktImportDirective.getImportPath() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)importPath2, (String)"import.importPath ?: continue");
            FqName fqName2 = importPath2.getFqName();
            if (importPath2.isAllUnder()) {
                this.allUnderImports.add(fqName2);
                continue;
            }
            if (!importPath2.hasAlias()) {
                this.preciseImports.add(fqName2);
                this.preciseImportPackages.add(fqName2.parent());
                continue;
            }
            this.excludedImports.add(fqName2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/ImportableFqNameClassifier$Classification;", "", "(Ljava/lang/String;I)V", "fromCurrentPackage", "topLevelPackage", "preciseImport", "defaultImport", "allUnderImport", "siblingImported", "notImported", "notToBeUsedInKotlin", "kotlin.fir.frontend-independent"})
    public static final class Classification
    extends Enum<Classification> {
        public static final /* enum */ Classification fromCurrentPackage;
        public static final /* enum */ Classification topLevelPackage;
        public static final /* enum */ Classification preciseImport;
        public static final /* enum */ Classification defaultImport;
        public static final /* enum */ Classification allUnderImport;
        public static final /* enum */ Classification siblingImported;
        public static final /* enum */ Classification notImported;
        public static final /* enum */ Classification notToBeUsedInKotlin;
        private static final /* synthetic */ Classification[] $VALUES;

        static {
            Classification[] classificationArray = new Classification[8];
            Classification[] classificationArray2 = classificationArray;
            classificationArray[0] = fromCurrentPackage = new Classification();
            classificationArray[1] = topLevelPackage = new Classification();
            classificationArray[2] = preciseImport = new Classification();
            classificationArray[3] = defaultImport = new Classification();
            classificationArray[4] = allUnderImport = new Classification();
            classificationArray[5] = siblingImported = new Classification();
            classificationArray[6] = notImported = new Classification();
            classificationArray[7] = notToBeUsedInKotlin = new Classification();
            $VALUES = classificationArray;
        }

        public static Classification[] values() {
            return (Classification[])$VALUES.clone();
        }

        public static Classification valueOf(String string) {
            return Enum.valueOf(Classification.class, string);
        }
    }
}

