/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManager;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManagerKt;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMap;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotification;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "checkHideNonConfiguredNotifications", "", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.jvm"})
public final class ConfigureKotlinNotificationManagerKt {
    private static final AtomicBoolean checkInProgress = new AtomicBoolean(false);
    private static final Logger LOG;

    public static final void checkHideNonConfiguredNotifications(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (checkInProgress.get()) {
            return;
        }
        ConfigureKotlinNotification configureKotlinNotification = (ConfigureKotlinNotification)((Object)ArraysKt.firstOrNull((Object[])ConfigureKotlinNotificationManager.INSTANCE.getVisibleNotifications(project2)));
        if (configureKotlinNotification == null) {
            return;
        }
        ConfigureKotlinNotification notification2 = configureKotlinNotification;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project2, notification2){
            final /* synthetic */ Project $project;
            final /* synthetic */ ConfigureKotlinNotification $notification;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                boolean hideNotification2;
                boolean bl;
                if (!ConfigureKotlinNotificationManagerKt.access$getCheckInProgress$p().compareAndSet(false, true)) {
                    return;
                }
                DumbService.getInstance((Project)this.$project).waitForSmartMode();
                ModuleSourceRootMap moduleSourceRootMap = new ModuleSourceRootMap(this.$project);
                if (Intrinsics.areEqual((Object)this.$notification.getNotificationState().getDebugProjectName(), (Object)this.$project.getName()) ^ true) {
                    ConfigureKotlinNotificationManagerKt.access$getLOG$p().error("Bad notification check for project: " + this.$project.getName() + "\n" + this.$notification.getNotificationState());
                }
                boolean $i$f$isUnitTestMode = false;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) {
                    boolean bl2;
                    try {
                        boolean bl3;
                        block13: {
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            void $this$mapNotNullTo$iv$iv;
                            Iterable $this$mapNotNull$iv;
                            Iterable iterable = this.$notification.getNotificationState().getNotConfiguredModules();
                            boolean $i$f$mapNotNull = false;
                            Iterator<T> iterator = $this$mapNotNull$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$mapNotNullTo = false;
                            Iterator<T> $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            Module module2 = $this$forEach$iv$iv$iv.iterator();
                            while (module2.hasNext()) {
                                Module module3;
                                T element$iv$iv$iv;
                                T element$iv$iv = element$iv$iv$iv = module2.next();
                                boolean bl4 = false;
                                String it = (String)element$iv$iv;
                                boolean bl5 = false;
                                if (ModuleManager.getInstance((Project)this.$project).findModuleByName(it) == null) continue;
                                Module it$iv$iv = module3;
                                boolean bl6 = false;
                                destination$iv$iv.add(it$iv$iv);
                            }
                            $this$mapNotNull$iv = (List)destination$iv$iv;
                            boolean $i$f$map = false;
                            $this$mapNotNullTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                module2 = (Module)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl7 = false;
                                void v1 = it;
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                                ModuleSourceRootGroup moduleSourceRootGroup = moduleSourceRootMap.getWholeModuleGroup((Module)v1);
                                collection.add(moduleSourceRootGroup);
                            }
                            List moduleSourceRootGroups = (List)destination$iv$iv;
                            Iterable $this$none$iv = moduleSourceRootGroups;
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl3 = true;
                            } else {
                                for (T element$iv : $this$none$iv) {
                                    ModuleSourceRootGroup p1 = (ModuleSourceRootGroup)element$iv;
                                    boolean bl8 = false;
                                    if (!ConfigureKotlinInProjectUtilsKt.isNotConfiguredNotificationRequired(p1)) continue;
                                    bl3 = false;
                                    break block13;
                                }
                                bl3 = true;
                            }
                        }
                        bl2 = bl3;
                    }
                    catch (IndexNotReadyException e) {
                        ConfigureKotlinNotificationManagerKt.access$getCheckInProgress$p().set(false);
                        ApplicationManager.getApplication().invokeLater(new Runnable(this){
                            final /* synthetic */ checkHideNonConfiguredNotifications.1 this$0;

                            public final void run() {
                                ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications(this.this$0.$project);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        return;
                    }
                    bl = bl2;
                } else {
                    bl = hideNotification2 = true;
                }
                if (hideNotification2) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ checkHideNonConfiguredNotifications.1 this$0;

                        public final void run() {
                            ConfigureKotlinNotificationManager.INSTANCE.expireOldNotifications(this.this$0.$project);
                            ConfigureKotlinNotificationManagerKt.access$getCheckInProgress$p().set(false);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                } else {
                    ConfigureKotlinNotificationManagerKt.access$getCheckInProgress$p().set(false);
                }
            }
            {
                this.$project = project2;
                this.$notification = configureKotlinNotification;
            }
        });
    }

    static {
        Logger logger = Logger.getInstance(ConfigureKotlinNotificationManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Confi\u2026ationManager::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ AtomicBoolean access$getCheckInProgress$p() {
        return checkInProgress;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

