/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.SLRUMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.ScriptHostUtilKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManagerKt;
import org.jetbrains.kotlin.idea.core.script.ScriptTemplatesProviderAdapter;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.StandardScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.idea.core.util.CheckCanceledLock;
import org.jetbrains.kotlin.script.ScriptTemplatesProvider;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.LazyScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsSource;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 82\u00020\u00012\u00020\u0002:\u000289B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u001aH\u0016J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ\b\u0010(\u001a\u00020\nH\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002J\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020+2\u0006\u0010\"\u001a\u00020#H\u0002J\n\u0010-\u001a\u0004\u0018\u00010.H\u0002J\b\u0010/\u001a\u00020 H\u0002J\u000e\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020\u0011J\u0006\u00102\u001a\u00020 J\u0006\u00103\u001a\u00020 J\u0006\u00104\u001a\u00020 J\n\u00105\u001a\u0004\u0018\u000106H\u0002J\u0012\u00107\u001a\b\u0012\u0004\u0012\u00020\n0\u000e*\u00020\u0011H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\n0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager;", "Lorg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configurations", "Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "currentDefinitions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getCurrentDefinitions", "()Lkotlin/sequences/Sequence;", "definitions", "", "definitionsBySource", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionsSource;", "definitionsLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "failedContributorsHashes", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "scriptDefinitionsCache", "Lcom/intellij/util/containers/SLRUMap;", "", "scriptDefinitionsCacheLock", "Lorg/jetbrains/kotlin/idea/core/util/CheckCanceledLock;", "sourcesToReload", "", "dispose", "", "findDefinition", "script", "Lkotlin/script/experimental/api/SourceCode;", "findScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "fileName", "getAllDefinitions", "getDefaultDefinition", "getSources", "isReady", "", "isScratchFile", "kotlinScriptingSettingsSafe", "Lorg/jetbrains/kotlin/idea/core/script/settings/KotlinScriptingSettings;", "loadScriptDefinitions", "reloadDefinitionsBy", "source", "reloadScriptDefinitions", "reloadScriptDefinitionsIfNeeded", "reorderScriptDefinitions", "updateDefinitions", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$UpdateDefinitionsResult;", "safeGetDefinitions", "Companion", "UpdateDefinitionsResult", "kotlin.core"})
public final class ScriptDefinitionsManager
extends LazyScriptDefinitionProvider
implements Disposable {
    private final ReentrantReadWriteLock definitionsLock;
    private final Map<ScriptDefinitionsSource, List<ScriptDefinition>> definitionsBySource;
    private volatile List<? extends ScriptDefinition> definitions;
    private final Set<ScriptDefinitionsSource> sourcesToReload;
    private final HashSet<Integer> failedContributorsHashes;
    private final CheckCanceledLock scriptDefinitionsCacheLock;
    private final SLRUMap<String, ScriptDefinition> scriptDefinitionsCache;
    private volatile CompositeScriptConfigurationManager configurations;
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ScriptDefinition findDefinition(@NotNull SourceCode script) {
        ScriptDefinition scriptDefinition;
        ScriptDefinition scriptDefinition2;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String string = script.getLocationId();
        if (string == null) {
            return null;
        }
        String locationId = string;
        if (this.nonScriptId(locationId)) {
            return null;
        }
        Object object = this.configurations;
        if (object != null && (object = object.tryGetScriptDefinitionFast(locationId)) != null) {
            Object object2;
            Object fastPath = object2 = object;
            boolean bl = false;
            return fastPath;
        }
        if (!this.isReady()) {
            return null;
        }
        Object this_$iv = this.scriptDefinitionsCacheLock;
        boolean $i$f$withLock$kotlin_core = false;
        while (!CheckCanceledLock.access$getLock$p(this_$iv).tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            boolean bl = false;
            ScriptDefinition scriptDefinition3 = (ScriptDefinition)((Object)this.scriptDefinitionsCache.get((Object)locationId));
            scriptDefinition2 = scriptDefinition3;
        }
        finally {
            CheckCanceledLock.access$getLock$p(this_$iv).unlock();
        }
        if (scriptDefinition2 != null) {
            Object cached2 = this_$iv = scriptDefinition2;
            boolean bl = false;
            return cached2;
        }
        if (this.isScratchFile(script)) {
            scriptDefinition = this.getDefaultDefinition();
        } else {
            scriptDefinition = super.findDefinition(script);
            if (scriptDefinition == null) {
                return null;
            }
        }
        ScriptDefinition definition2 = scriptDefinition;
        CheckCanceledLock this_$iv2 = this.scriptDefinitionsCacheLock;
        boolean $i$f$withLock$kotlin_core2 = false;
        while (!CheckCanceledLock.access$getLock$p(this_$iv2).tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            boolean bl = false;
            this.scriptDefinitionsCache.put((Object)locationId, (Object)definition2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            CheckCanceledLock.access$getLock$p(this_$iv2).unlock();
        }
        return definition2;
    }

    private final boolean isScratchFile(SourceCode script) {
        VirtualFile virtualFile2;
        if (script instanceof VirtualFileScriptSource) {
            virtualFile2 = ((VirtualFileScriptSource)script).getVirtualFile();
        } else {
            String string = script.getLocationId();
            if (string != null) {
                String string2;
                String it = string2 = string;
                boolean bl = false;
                virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(it);
            } else {
                virtualFile2 = null;
            }
        }
        VirtualFile virtualFile3 = virtualFile2;
        return virtualFile3 != null && ScratchFileService.getInstance().getRootType(virtualFile3) instanceof ScratchRootType;
    }

    @Override
    @Nullable
    public KotlinScriptDefinition findScriptDefinition(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        ScriptDefinition scriptDefinition = this.findDefinition(ScriptHostUtilKt.toScriptSource(new File(fileName)));
        return scriptDefinition != null ? scriptDefinition.getLegacyDefinition() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reloadDefinitionsBy(@NotNull ScriptDefinitionsSource source) {
        block17: {
            UpdateDefinitionsResult updateDefinitionsResult;
            ScriptDefinitionsManager scriptDefinitionsManager;
            int n;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            ReentrantReadWriteLock $this$writeWithCheckCanceled$iv = this.definitionsLock;
            boolean $i$f$writeWithCheckCanceled = false;
            ReentrantReadWriteLock.ReadLock rl$iv = $this$writeWithCheckCanceled$iv.readLock();
            int readCount$iv = $this$writeWithCheckCanceled$iv.getWriteHoldCount() == 0 ? $this$writeWithCheckCanceled$iv.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < readCount$iv) {
                int it$iv = n2++;
                n = 0;
                rl$iv.unlock();
            }
            ReentrantReadWriteLock.WriteLock wl$iv = $this$writeWithCheckCanceled$iv.writeLock();
            while (!wl$iv.tryLock(100L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
            try {
                boolean bl = false;
                if (this.definitions == null) {
                    this.sourcesToReload.add(source);
                    return;
                }
                Map<ScriptDefinitionsSource, List<ScriptDefinition>> map2 = this.definitionsBySource;
                ScriptDefinitionsSource scriptDefinitionsSource = source;
                if (!map2.containsKey(scriptDefinitionsSource)) {
                    map2 = "Unknown script definition source: " + source;
                    throw new IllegalStateException(map2.toString());
                }
                Unit it$iv = Unit.INSTANCE;
            }
            finally {
                n = 0;
                while (n < readCount$iv) {
                    int n3 = n++;
                    boolean bl = false;
                    rl$iv.lock();
                }
                wl$iv.unlock();
            }
            List<ScriptDefinition> safeGetDefinitions = this.safeGetDefinitions(source);
            ScriptDefinitionsManager $this$run = scriptDefinitionsManager = this;
            boolean bl = false;
            ReentrantReadWriteLock $this$writeWithCheckCanceled$iv2 = $this$run.definitionsLock;
            boolean $i$f$writeWithCheckCanceled2 = false;
            ReentrantReadWriteLock.ReadLock rl$iv2 = $this$writeWithCheckCanceled$iv2.readLock();
            int readCount$iv2 = $this$writeWithCheckCanceled$iv2.getWriteHoldCount() == 0 ? $this$writeWithCheckCanceled$iv2.getReadHoldCount() : 0;
            int n4 = 0;
            while (n4 < readCount$iv2) {
                int it$iv = n4++;
                boolean bl2 = false;
                rl$iv2.unlock();
            }
            ReentrantReadWriteLock.WriteLock wl$iv2 = $this$writeWithCheckCanceled$iv2.writeLock();
            while (!wl$iv2.tryLock(100L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
            try {
                boolean bl3 = false;
                $this$run.definitionsBySource.put(source, safeGetDefinitions);
                $this$run.definitions = (List)AddToStdlibKt.flattenTo((Iterable)$this$run.definitionsBySource.values(), (Collection)new ArrayList());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n5 = 0;
                while (n5 < readCount$iv2) {
                    int it$iv = n5++;
                    boolean bl4 = false;
                    rl$iv2.lock();
                }
                wl$iv2.unlock();
            }
            UpdateDefinitionsResult updateDefinitionsResult2 = updateDefinitionsResult = $this$run.updateDefinitions();
            if (updateDefinitionsResult2 == null) break block17;
            updateDefinitionsResult2.apply();
        }
    }

    @Override
    @NotNull
    protected Sequence<ScriptDefinition> getCurrentDefinitions() {
        KotlinScriptingSettings kotlinScriptingSettings = this.kotlinScriptingSettingsSafe();
        if (kotlinScriptingSettings == null) {
            return SequencesKt.emptySequence();
        }
        KotlinScriptingSettings scriptingSettings = kotlinScriptingSettings;
        List<? extends ScriptDefinition> list2 = this.definitions;
        if (list2 == null) {
            ScriptDefinitionsManager scriptDefinitionsManager;
            ScriptDefinitionsManager $this$run = scriptDefinitionsManager = this;
            boolean bl = false;
            $this$run.reloadScriptDefinitions();
            List<? extends ScriptDefinition> list3 = $this$run.definitions;
            list2 = list3;
            Intrinsics.checkNotNull(list3);
        }
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)((Function1)new Function1<ScriptDefinition, Boolean>(scriptingSettings){
            final /* synthetic */ KotlinScriptingSettings $scriptingSettings;

            public final boolean invoke(@NotNull ScriptDefinition it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return this.$scriptingSettings.isScriptDefinitionEnabled(it);
            }
            {
                this.$scriptingSettings = kotlinScriptingSettings;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScriptDefinitionsSource> getSources() {
        void $this$mapTo$iv$iv;
        ScriptDefinitionsSource scriptDefinitionsSource;
        Collection collection;
        void $this$mapTo$iv$iv2;
        ExtensionPoint extensionPoint = Extensions.getArea((AreaInstance)((AreaInstance)this.project)).getExtensionPoint(ScriptTemplatesProvider.Companion.getEP_NAME());
        Intrinsics.checkNotNullExpressionValue((Object)extensionPoint, (String)"Extensions.getArea(proje\u2026emplatesProvider.EP_NAME)");
        Object[] objectArray = extensionPoint.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Extensions.getArea(proje\u2026vider.EP_NAME).extensions");
        Iterable $this$map$iv = ArraysKt.toList((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ScriptTemplatesProvider scriptTemplatesProvider = (ScriptTemplatesProvider)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            scriptDefinitionsSource = ScriptDefinitionsManagerKt.asSource(new ScriptTemplatesProviderAdapter((ScriptTemplatesProvider)v2));
            collection.add(scriptDefinitionsSource);
        }
        List fromDeprecatedEP = (List)destination$iv$iv;
        ExtensionPoint extensionPoint2 = ScriptDefinitionContributor.Companion.getEP_NAME().getPoint((AreaInstance)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)extensionPoint2, (String)"ScriptDefinitionContribu\u2026EP_NAME.getPoint(project)");
        Object[] objectArray2 = extensionPoint2.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"ScriptDefinitionContribu\u2026Point(project).extensions");
        Iterable $this$map$iv2 = ArraysKt.toList((Object[])objectArray2);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScriptDefinitionContributor bl = (ScriptDefinitionContributor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            void v5 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
            scriptDefinitionsSource = ScriptDefinitionsManagerKt.asSource((ScriptDefinitionContributor)v5);
            collection.add(scriptDefinitionsSource);
        }
        List fromNewEp = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.dropLast((List)fromNewEp, (int)1), (Iterable)fromDeprecatedEP), (Object)CollectionsKt.last((List)fromNewEp));
    }

    public final void reloadScriptDefinitionsIfNeeded() {
        Unit unit = this.definitions;
        if (unit == null) {
            this.loadScriptDefinitions();
            unit = Unit.INSTANCE;
        }
    }

    public final void reloadScriptDefinitions() {
        this.loadScriptDefinitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void loadScriptDefinitions() {
        ArrayList arrayList;
        int n;
        UpdateDefinitionsResult updateDefinitionsResult;
        Object object;
        int n2;
        int n3;
        if (this.project.isDisposed()) {
            return;
        }
        Iterable $this$associateWith$iv = this.getSources();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ScriptDefinitionsSource scriptDefinitionsSource = (ScriptDefinitionsSource)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            n3 = 0;
            List<ScriptDefinition> list2 = this.safeGetDefinitions((ScriptDefinitionsSource)it);
            map2.put(t, list2);
        }
        Map newDefinitionsBySource = result$iv;
        ScriptDefinitionsManager $this$run = $i$f$associateWith = this;
        boolean bl = false;
        ReentrantReadWriteLock $this$writeWithCheckCanceled$iv = $this$run.definitionsLock;
        int $i$f$writeWithCheckCanceled = 0;
        ReentrantReadWriteLock.ReadLock rl$iv = $this$writeWithCheckCanceled$iv.readLock();
        int readCount$iv = $this$writeWithCheckCanceled$iv.getWriteHoldCount() == 0 ? $this$writeWithCheckCanceled$iv.getReadHoldCount() : 0;
        n3 = 0;
        while (n3 < readCount$iv) {
            int it$iv = n3++;
            n2 = 0;
            rl$iv.unlock();
        }
        ReentrantReadWriteLock.WriteLock wl$iv = $this$writeWithCheckCanceled$iv.writeLock();
        while (!wl$iv.tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            boolean bl2 = false;
            $this$run.definitionsBySource.putAll(newDefinitionsBySource);
            $this$run.definitions = (List)AddToStdlibKt.flattenTo((Iterable)$this$run.definitionsBySource.values(), (Collection)new ArrayList());
            object = Unit.INSTANCE;
        }
        finally {
            n2 = 0;
            while (n2 < readCount$iv) {
                int it$iv = n2++;
                boolean bl3 = false;
                rl$iv.lock();
            }
            wl$iv.unlock();
        }
        UpdateDefinitionsResult updateDefinitionsResult2 = updateDefinitionsResult = $this$run.updateDefinitions();
        if (updateDefinitionsResult2 != null) {
            updateDefinitionsResult2.apply();
        }
        Object $this$writeWithCheckCanceled$iv2 = this.definitionsLock;
        boolean $i$f$writeWithCheckCanceled2 = false;
        ReentrantReadWriteLock.ReadLock rl$iv2 = ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv2).readLock();
        int readCount$iv2 = ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv2).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv2).getReadHoldCount() : 0;
        $i$f$writeWithCheckCanceled = 0;
        while ($i$f$writeWithCheckCanceled < readCount$iv2) {
            int it$iv2 = $i$f$writeWithCheckCanceled++;
            n = 0;
            rl$iv2.unlock();
        }
        ReentrantReadWriteLock.WriteLock wl$iv2 = ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv2).writeLock();
        while (!wl$iv2.tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            ArrayList arrayList2;
            boolean bl4 = false;
            Object it = object = this.sourcesToReload;
            boolean bl5 = false;
            Collection it$iv = (Collection)it;
            Object object2 = !it$iv.isEmpty() ? object : null;
            if (object2 != null) {
                it = object = object2;
                boolean bl6 = false;
                ArrayList copy = new ArrayList((Collection)it);
                it.clear();
                arrayList2 = copy;
            } else {
                arrayList2 = null;
            }
            ArrayList it$iv2 = arrayList2;
            arrayList = it$iv2;
        }
        finally {
            n = 0;
            while (n < readCount$iv2) {
                int it$iv = n++;
                boolean bl7 = false;
                rl$iv2.lock();
            }
            wl$iv2.unlock();
        }
        if (arrayList != null) {
            void $this$forEach$iv;
            $this$writeWithCheckCanceled$iv2 = arrayList;
            ScriptDefinitionsManager scriptDefinitionsManager = this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScriptDefinitionsSource p1 = (ScriptDefinitionsSource)element$iv;
                boolean bl8 = false;
                scriptDefinitionsManager.reloadDefinitionsBy(p1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reorderScriptDefinitions() {
        block11: {
            UpdateDefinitionsResult updateDefinitionsResult;
            ScriptDefinitionsManager scriptDefinitionsManager;
            KotlinScriptingSettings kotlinScriptingSettings = this.kotlinScriptingSettingsSafe();
            if (kotlinScriptingSettings == null) {
                return;
            }
            KotlinScriptingSettings scriptingSettings = kotlinScriptingSettings;
            ScriptDefinitionsManager $this$run = scriptDefinitionsManager = this;
            boolean bl = false;
            ReentrantReadWriteLock $this$writeWithCheckCanceled$iv = $this$run.definitionsLock;
            boolean $i$f$writeWithCheckCanceled = false;
            ReentrantReadWriteLock.ReadLock rl$iv = $this$writeWithCheckCanceled$iv.readLock();
            int readCount$iv = $this$writeWithCheckCanceled$iv.getWriteHoldCount() == 0 ? $this$writeWithCheckCanceled$iv.getReadHoldCount() : 0;
            int n = 0;
            while (n < readCount$iv) {
                int it$iv = n++;
                boolean bl2 = false;
                rl$iv.unlock();
            }
            ReentrantReadWriteLock.WriteLock wl$iv = $this$writeWithCheckCanceled$iv.writeLock();
            while (!wl$iv.tryLock(100L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
            try {
                Unit unit;
                boolean bl3 = false;
                List<? extends ScriptDefinition> list2 = $this$run.definitions;
                if (list2 != null) {
                    List<? extends ScriptDefinition> list3;
                    List<? extends ScriptDefinition> list4 = list3 = list2;
                    boolean bl4 = false;
                    Iterable $this$forEach$iv = list4;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ScriptDefinition it = (ScriptDefinition)((Object)element$iv);
                        boolean bl5 = false;
                        it.setOrder(scriptingSettings.getScriptDefinitionOrder(it));
                    }
                    Iterable $this$sortedBy$iv = list4;
                    boolean $i$f$sortedBy = false;
                    $this$run.definitions = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            T receiver2 = a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(((ScriptDefinition)((Object)receiver2)).getOrder());
                            receiver2 = b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            Integer n = ((ScriptDefinition)((Object)receiver2)).getOrder();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                        }
                    });
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            finally {
                int n2 = 0;
                while (n2 < readCount$iv) {
                    int it$iv = n2++;
                    boolean bl6 = false;
                    rl$iv.lock();
                }
                wl$iv.unlock();
            }
            UpdateDefinitionsResult updateDefinitionsResult2 = updateDefinitionsResult = $this$run.updateDefinitions();
            if (updateDefinitionsResult2 == null) break block11;
            updateDefinitionsResult2.apply();
        }
    }

    private final KotlinScriptingSettings kotlinScriptingSettingsSafe() {
        boolean bl;
        boolean bl2 = bl = !this.definitionsLock.isWriteLockedByCurrentThread();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "kotlinScriptingSettingsSafe should be called out if the write lock to avoid deadlocks";
            throw new AssertionError((Object)string);
        }
        boolean $i$f$runReadAction = false;
        return (KotlinScriptingSettings)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ ScriptDefinitionsManager this$0;
            {
                this.this$0 = scriptDefinitionsManager;
            }

            public final T compute() {
                boolean bl = false;
                return (T)(!ScriptDefinitionsManager.access$getProject$p(this.this$0).isDisposed() ? KotlinScriptingSettings.Companion.getInstance(ScriptDefinitionsManager.access$getProject$p(this.this$0)) : null);
            }
        });
    }

    @NotNull
    public final List<ScriptDefinition> getAllDefinitions() {
        List<ScriptDefinition> list2 = this.definitions;
        if (list2 == null) {
            ScriptDefinitionsManager scriptDefinitionsManager;
            ScriptDefinitionsManager $this$run = scriptDefinitionsManager = this;
            boolean bl = false;
            $this$run.reloadScriptDefinitions();
            List<? extends ScriptDefinition> list3 = $this$run.definitions;
            list2 = list3;
            Intrinsics.checkNotNull(list3);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReady() {
        boolean bl;
        block12: {
            Set<ScriptDefinitionsSource> it$iv2;
            if (this.definitions == null) {
                return false;
            }
            ReentrantReadWriteLock $this$writeWithCheckCanceled$iv = this.definitionsLock;
            boolean $i$f$writeWithCheckCanceled = false;
            ReentrantReadWriteLock.ReadLock rl$iv = $this$writeWithCheckCanceled$iv.readLock();
            int readCount$iv = $this$writeWithCheckCanceled$iv.getWriteHoldCount() == 0 ? $this$writeWithCheckCanceled$iv.getReadHoldCount() : 0;
            int n = 0;
            while (n < readCount$iv) {
                int it$iv2 = n++;
                boolean bl2 = false;
                rl$iv.unlock();
            }
            ReentrantReadWriteLock.WriteLock wl$iv = $this$writeWithCheckCanceled$iv.writeLock();
            while (!wl$iv.tryLock(100L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
            try {
                boolean bl3 = false;
                it$iv2 = this.definitionsBySource.keySet();
            }
            finally {
                int n2 = 0;
                while (n2 < readCount$iv) {
                    int it$iv3 = n2++;
                    boolean bl4 = false;
                    rl$iv.lock();
                }
                wl$iv.unlock();
            }
            Set<ScriptDefinitionsSource> keys = it$iv2;
            Iterable $this$all$iv = keys;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ScriptDefinitionsSource source = (ScriptDefinitionsSource)element$iv;
                    boolean bl5 = false;
                    ScriptDefinitionsSource scriptDefinitionsSource = source;
                    if (!(scriptDefinitionsSource instanceof ScriptDefinitionContributor)) {
                        scriptDefinitionsSource = null;
                    }
                    ScriptDefinitionContributor scriptDefinitionContributor = (ScriptDefinitionContributor)((Object)scriptDefinitionsSource);
                    if (scriptDefinitionContributor == null || scriptDefinitionContributor.isReady()) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ScriptDefinition getDefaultDefinition() {
        void $this$filterIsInstanceTo$iv$iv$iv;
        void this_$iv;
        Object object = ScriptDefinitionContributor.Companion;
        Project project$iv = this.project;
        boolean $i$f$find = false;
        ExtensionPoint extensionPoint = this_$iv.getEP_NAME().getPoint((AreaInstance)project$iv);
        Intrinsics.checkNotNullExpressionValue((Object)extensionPoint, (String)"EP_NAME.getPoint(project)");
        List list2 = extensionPoint.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"EP_NAME.getPoint(project).extensionList");
        Iterable $this$filterIsInstance$iv$iv = list2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof StandardScriptDefinitionContributor)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        StandardScriptDefinitionContributor standardScriptDefinitionContributor = (StandardScriptDefinitionContributor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv));
        if (standardScriptDefinitionContributor == null) {
            object = "StandardScriptDefinitionContributor should be registered in plugin.xml";
            throw new IllegalStateException(object.toString());
        }
        StandardScriptDefinitionContributor standardScriptDefinitionContributor2 = standardScriptDefinitionContributor;
        return new ScriptDefinition.FromLegacy(this.getScriptingHostConfiguration(), (KotlinScriptDefinition)((Object)CollectionsKt.last(standardScriptDefinitionContributor2.getDefinitions())), null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final UpdateDefinitionsResult updateDefinitions() {
        void $this$filterTo$iv$iv;
        boolean bl;
        boolean bl2 = bl = !this.definitionsLock.isWriteLockedByCurrentThread();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ScriptDefinitionsManager$updateDefinitions$22 = false;
            String $i$a$-assert-ScriptDefinitionsManager$updateDefinitions$22 = "updateDefinitions should be called out the write lock";
            throw new AssertionError((Object)$i$a$-assert-ScriptDefinitionsManager$updateDefinitions$22);
        }
        if (this.project.isDisposed()) {
            return null;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        Iterable $this$filter$iv = SequencesKt.toSet(this.getKnownFilenameExtensions());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileType fileTypeByExtension;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)fileTypeManager.getFileTypeByFileName("xxx." + it), (String)"fileTypeManager.getFileTypeByFileName(\"xxx.$it\")");
            boolean notKnown = Intrinsics.areEqual((Object)fileTypeByExtension, (Object)KotlinFileType.INSTANCE) ^ true;
            if (notKnown) {
                String string = fileTypeByExtension.getName();
                KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"KotlinFileType.INSTANCE");
                ScriptUtilsKt.scriptingWarnLog("extension " + it + " file type [" + string + "] is not registered as " + kotlinFileType.getName());
            }
            if (!notKnown) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set newExtensions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.clearCache();
        CheckCanceledLock this_$iv = this.scriptDefinitionsCacheLock;
        boolean $i$f$withLock$kotlin_core = false;
        while (!CheckCanceledLock.access$getLock$p(this_$iv).tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            boolean bl4 = false;
            this.scriptDefinitionsCache.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            CheckCanceledLock.access$getLock$p(this_$iv).unlock();
        }
        return new UpdateDefinitionsResult(this.project, newExtensions);
    }

    private final List<ScriptDefinition> safeGetDefinitions(ScriptDefinitionsSource $this$safeGetDefinitions) {
        if (!this.failedContributorsHashes.contains($this$safeGetDefinitions.hashCode())) {
            try {
                return SequencesKt.toList($this$safeGetDefinitions.getDefinitions());
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                this.failedContributorsHashes.add($this$safeGetDefinitions.hashCode());
                Object object = t.getCause();
                if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                    object = t.getMessage();
                }
                ScriptUtilsKt.scriptingErrorLog("Cannot load script definitions from " + $this$safeGetDefinitions + ": " + (String)object, t);
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clearCache();
        this.definitionsBySource.clear();
        this.definitions = null;
        this.failedContributorsHashes.clear();
        this.scriptDefinitionsCache.clear();
        this.configurations = null;
    }

    public ScriptDefinitionsManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.definitionsLock = new ReentrantReadWriteLock();
        this.definitionsBySource = new LinkedHashMap();
        this.sourcesToReload = new LinkedHashSet();
        this.failedContributorsHashes = new HashSet();
        this.scriptDefinitionsCacheLock = new CheckCanceledLock();
        this.scriptDefinitionsCache = new SLRUMap(10, 10);
        this.configurations = ScriptConfigurationManager.Companion.compositeScriptConfigurationManager(this.project);
    }

    public static final /* synthetic */ Project access$getProject$p(ScriptDefinitionsManager $this) {
        return $this.project;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$UpdateDefinitionsResult;", "", "project", "Lcom/intellij/openapi/project/Project;", "newExtensions", "", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "getNewExtensions", "()Ljava/util/Set;", "getProject", "()Lcom/intellij/openapi/project/Project;", "apply", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.core"})
    private static final class UpdateDefinitionsResult {
        @NotNull
        private final Project project;
        @NotNull
        private final Set<String> newExtensions;

        public final void apply() {
            Collection collection = this.newExtensions;
            if (!collection.isEmpty()) {
                KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"KotlinFileType.INSTANCE");
                ScriptUtilsKt.scriptingWarnLog("extensions " + this.newExtensions + " is about to be registered as " + kotlinFileType.getName());
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ UpdateDefinitionsResult this$0;

                    public final void run() {
                        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
                        boolean $i$f$runWriteAction = false;
                        ApplicationManager.getApplication().runWriteAction(new Computable(this, fileTypeManager){
                            final /* synthetic */ apply.1 this$0;
                            final /* synthetic */ FileTypeManager $fileTypeManager$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$fileTypeManager$inlined = fileTypeManager;
                            }

                            public final T compute() {
                                boolean bl = false;
                                Iterable $this$forEach$iv = this.this$0.this$0.getNewExtensions();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    String it = (String)element$iv;
                                    boolean bl2 = false;
                                    this.$fileTypeManager$inlined.associateExtension((FileType)KotlinFileType.INSTANCE, it);
                                }
                                return (T)Unit.INSTANCE;
                            }
                        });
                    }
                    {
                        this.this$0 = updateDefinitionsResult;
                    }
                });
            }
            ScriptConfigurationManager.Companion.getInstance(this.project).updateScriptDefinitionReferences();
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final Set<String> getNewExtensions() {
            return this.newExtensions;
        }

        public UpdateDefinitionsResult(@NotNull Project project2, @NotNull Set<String> newExtensions) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(newExtensions, (String)"newExtensions");
            this.project = project2;
            this.newExtensions = newExtensions;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final Set<String> component2() {
            return this.newExtensions;
        }

        @NotNull
        public final UpdateDefinitionsResult copy(@NotNull Project project2, @NotNull Set<String> newExtensions) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(newExtensions, (String)"newExtensions");
            return new UpdateDefinitionsResult(project2, newExtensions);
        }

        public static /* synthetic */ UpdateDefinitionsResult copy$default(UpdateDefinitionsResult updateDefinitionsResult, Project project2, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                project2 = updateDefinitionsResult.project;
            }
            if ((n & 2) != 0) {
                set2 = updateDefinitionsResult.newExtensions;
            }
            return updateDefinitionsResult.copy(project2, set2);
        }

        @NotNull
        public String toString() {
            return "UpdateDefinitionsResult(project=" + this.project + ", newExtensions=" + this.newExtensions + ")";
        }

        public int hashCode() {
            Project project2 = this.project;
            Set<String> set2 = this.newExtensions;
            return (project2 != null ? project2.hashCode() : 0) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof UpdateDefinitionsResult)) break block3;
                    UpdateDefinitionsResult updateDefinitionsResult = (UpdateDefinitionsResult)object;
                    if (!Intrinsics.areEqual((Object)this.project, (Object)updateDefinitionsResult.project) || !Intrinsics.areEqual(this.newExtensions, updateDefinitionsResult.newExtensions)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.core"})
    public static final class Companion {
        @NotNull
        public final ScriptDefinitionsManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$getServiceSafe$iv = (ComponentManager)project2;
            boolean $i$f$getServiceSafe = false;
            Object object = $this$getServiceSafe$iv.getService(ScriptDefinitionProvider.class);
            if (object == null) {
                String string = "Unable to locate service " + ScriptDefinitionProvider.class.getName();
                throw new IllegalStateException(string.toString());
            }
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager");
            }
            return (ScriptDefinitionsManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

