/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"findAlternativeKtFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "ktFile", "project", "Lcom/intellij/openapi/project/Project;", "javaSession", "Lcom/intellij/debugger/impl/DebuggerSession;", "platformMatches", "", "otherPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "kotlin.jvm-debugger.core"})
public final class KotlinAlternativeSourceNotificationProviderKt {
    /*
     * WARNING - void declaration
     */
    private static final Set<KtFile> findAlternativeKtFiles(KtFile ktFile, Project project2, DebuggerSession javaSession) {
        void $this$filterTo$iv;
        FqName packageFqName = ktFile.getPackageFqName();
        String string = ktFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ktFile.name");
        String fileName = string;
        TargetPlatform platform2 = PlatformKt.getPlatform((KtElement)ktFile);
        GlobalSearchScope globalSearchScope = javaSession.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"javaSession.searchScope");
        Iterable iterable = PackageIndexUtil.findFilesWithExactPackage(packageFqName, globalSearchScope, project2);
        Collection destination$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            KtFile it = (KtFile)element$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)fileName) && KotlinAlternativeSourceNotificationProviderKt.platformMatches(it, platform2))) continue;
            destination$iv.add(element$iv);
        }
        return (Set)destination$iv;
    }

    private static final boolean platformMatches(KtFile $this$platformMatches, TargetPlatform otherPlatform) {
        return JvmPlatformKt.isJvm((TargetPlatform)PlatformKt.getPlatform((KtElement)$this$platformMatches)) ? JvmPlatformKt.isJvm((TargetPlatform)otherPlatform) : (JsPlatformKt.isJs((TargetPlatform)PlatformKt.getPlatform((KtElement)$this$platformMatches)) ? JsPlatformKt.isJs((TargetPlatform)otherPlatform) : (NativePlatformKt.isNative((TargetPlatform)PlatformKt.getPlatform((KtElement)$this$platformMatches)) ? NativePlatformKt.isNative((TargetPlatform)otherPlatform) : (TargetPlatformKt.isCommon((TargetPlatform)PlatformKt.getPlatform((KtElement)$this$platformMatches)) ? TargetPlatformKt.isCommon((TargetPlatform)otherPlatform) : true)));
    }

    public static final /* synthetic */ Set access$findAlternativeKtFiles(KtFile ktFile, Project project2, DebuggerSession javaSession) {
        return KotlinAlternativeSourceNotificationProviderKt.findAlternativeKtFiles(ktFile, project2, javaSession);
    }
}

