/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Range;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.CallableMemberInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodFilterKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilter;", "Lcom/intellij/debugger/engine/NamedMethodFilter;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "lines", "Lcom/intellij/util/Range;", "", "methodInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lcom/intellij/util/Range;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;)V", "declarationPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "declarationMatches", "", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "getCallingExpressionLines", "getMethodName", "", "locationMatches", "nameMatches", "kotlin.jvm-debugger.core"})
public class KotlinMethodFilter
implements NamedMethodFilter {
    private final SmartPsiElementPointer<KtDeclaration> declarationPtr;
    private final Range<Integer> lines;
    private final CallableMemberInfo methodInfo;

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        if (!this.nameMatches(location2)) {
            return false;
        }
        Object object = ReadAction.nonBlocking((Callable)new Callable(this, process2, location2){
            final /* synthetic */ KotlinMethodFilter this$0;
            final /* synthetic */ DebugProcessImpl $process;
            final /* synthetic */ Location $location;

            public final Boolean call() {
                return KotlinMethodFilter.access$declarationMatches(this.this$0, this.$process, this.$location);
            }
            {
                this.this$0 = kotlinMethodFilter;
                this.$process = debugProcessImpl;
                this.$location = location2;
            }
        }).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ReadAction.nonBlocking<B\u2026 }.executeSynchronously()");
        return (Boolean)object;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean declarationMatches(DebugProcessImpl process2, Location location2) {
        boolean bl;
        block9: {
            void currentDescriptor;
            CompoundPositionManager compoundPositionManager = process2.getPositionManager();
            Intrinsics.checkNotNullExpressionValue((Object)compoundPositionManager, (String)"process.positionManager");
            Pair pair = KotlinMethodFilterKt.access$getMethodDescriptorAndDeclaration((PositionManager)compoundPositionManager, location2);
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)pair.component1();
            KtDeclaration currentDeclaration = (KtDeclaration)pair.component2();
            if (currentDescriptor == null || currentDeclaration == null) {
                return false;
            }
            if (!(currentDescriptor instanceof CallableMemberDescriptor)) {
                return false;
            }
            if (((CallableMemberDescriptor)currentDescriptor).getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
                return false;
            }
            if (this.methodInfo.isInvoke()) {
                return true;
            }
            KtDeclaration ktDeclaration = this.declarationPtr;
            if (ktDeclaration == null || (ktDeclaration = (KtDeclaration)ktDeclaration.getElement()) == null) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktDeclaration, (String)"declarationPtr?.element ?: return true");
            KtDeclaration declaration2 = ktDeclaration;
            PsiManager psiManager2 = currentDeclaration.getManager();
            if (psiManager2.areElementsEquivalent((PsiElement)currentDeclaration, (PsiElement)declaration2)) {
                return true;
            }
            Set set2 = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)((CallableDescriptor)currentDescriptor));
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"DescriptorUtils.getAllOv\u2026iptors(currentDescriptor)");
            Iterable $this$any$iv = set2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CallableMemberDescriptor baseOfCurrent = (CallableMemberDescriptor)element$iv;
                    boolean bl2 = false;
                    Project project2 = currentDeclaration.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"currentDeclaration.project");
                    CallableMemberDescriptor callableMemberDescriptor = baseOfCurrent;
                    Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"baseOfCurrent");
                    PsiElement currentBaseDeclaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, (DeclarationDescriptor)callableMemberDescriptor);
                    if (!psiManager2.areElementsEquivalent((PsiElement)declaration2, currentBaseDeclaration)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.lines;
    }

    @NotNull
    public String getMethodName() {
        return this.methodInfo.getName();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean nameMatches(Location location2) {
        Map.Entry it;
        void $this$any$iv;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Method method = SafeUtilKt.safeMethod(location2);
        if (method == null) return false;
        Method method2 = method;
        String targetMethodName = this.getMethodName();
        boolean isNameMangledInBytecode = this.methodInfo.isNameMangledInBytecode();
        String string = method2.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name()");
        String actualMethodName = DebuggerUtils.INSTANCE.trimIfMangledInBytecode(string, isNameMangledInBytecode);
        if (Intrinsics.areEqual((Object)actualMethodName, (Object)targetMethodName)) return true;
        if (Intrinsics.areEqual((Object)actualMethodName, (Object)(targetMethodName + "$default"))) return true;
        Map<LocalVariable, ClosedRange<Location>> map2 = KotlinPositionManagerKt.getInlineFunctionNamesAndBorders(method2);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it2 = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!((ClosedRange)it2.getValue()).contains((Comparable)location2)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        iterator = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry element$iv;
            if (!iterator.hasNext()) return false;
            it = element$iv = iterator.next();
            boolean bl = false;
        } while (!KotlinMethodFilterKt.access$isInlinedFromFunction((LocalVariable)it.getKey(), targetMethodName, isNameMangledInBytecode));
        return true;
    }

    public KotlinMethodFilter(@Nullable KtDeclaration declaration2, @Nullable Range<Integer> lines, @NotNull CallableMemberInfo methodInfo) {
        Intrinsics.checkNotNullParameter((Object)methodInfo, (String)"methodInfo");
        this.lines = lines;
        this.methodInfo = methodInfo;
        KtDeclaration ktDeclaration = declaration2;
        this.declarationPtr = ktDeclaration != null ? PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)ktDeclaration)) : null;
    }

    public static final /* synthetic */ boolean access$declarationMatches(KotlinMethodFilter $this, DebugProcessImpl process2, Location location2) {
        return $this.declarationMatches(process2, location2);
    }
}

