/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.IDEKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.caches.lightClasses.LightMemberOriginForCompiledElementKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.ClassFileDecompilerUtilKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.DeserializerForClassfileDecompilerKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.KotlinClassFileDecompilerKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.KotlinClassFileDecompilerKt$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.common.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.idea.decompiler.navigation.ByDescriptorIndexer;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.BuildDecompiledTextKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledText;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledTextIndexer;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.ResolverForDecompiler;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"decompilerRendererForClassFiles", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "buildDecompiledTextForClassFile", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolver", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/ResolverForDecompiler;", "kotlin.core"})
public final class KotlinClassFileDecompilerKt {
    private static final DescriptorRenderer decompilerRendererForClassFiles = DescriptorRenderer.Companion.withOptions((Function1)decompilerRendererForClassFiles.1.INSTANCE);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DecompiledText buildDecompiledTextForClassFile(@NotNull VirtualFile classFile, @NotNull ResolverForDecompiler resolver) {
        DecompiledText decompiledText2;
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        IDEKotlinBinaryClassCache.KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData = IDEKotlinBinaryClassCache.getKotlinBinaryClassHeaderData$default(IDEKotlinBinaryClassCache.Companion.getInstance(), classFile, null, 2, null);
        if (kotlinBinaryClassHeaderData == null) {
            String string = "Decompiled data factory shouldn't be called on an unsupported file: " + classFile;
            throw new IllegalStateException(string.toString());
        }
        IDEKotlinBinaryClassCache.KotlinBinaryClassHeaderData classHeader = kotlinBinaryClassHeaderData;
        ClassId classId = classHeader.getClassId();
        if (!classHeader.getMetadataVersion().isCompatible()) {
            return IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)JvmMetadataVersion.INSTANCE, (BinaryVersion)classHeader.getMetadataVersion());
        }
        var $fun$buildText$1 = new Function1<List<? extends DeclarationDescriptor>, DecompiledText>(classHeader, classId){
            final /* synthetic */ IDEKotlinBinaryClassCache.KotlinBinaryClassHeaderData $classHeader;
            final /* synthetic */ ClassId $classId;

            @NotNull
            public final DecompiledText invoke(@NotNull List<? extends DeclarationDescriptor> declarations) {
                FqName fqName2;
                Intrinsics.checkNotNullParameter(declarations, (String)"declarations");
                String string = this.$classHeader.getPackageName();
                if (string != null) {
                    String string2;
                    String p1 = string2 = string;
                    boolean bl = false;
                    fqName2 = new FqName(p1);
                } else {
                    FqName fqName3 = this.$classId.getPackageFqName();
                    fqName2 = fqName3;
                    Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"classId.packageFqName");
                }
                return BuildDecompiledTextKt.buildDecompiledText(fqName2, declarations, KotlinClassFileDecompilerKt.access$getDecompilerRendererForClassFiles$p(), CollectionsKt.listOf((Object[])new DecompiledTextIndexer[]{ByDescriptorIndexer.INSTANCE, LightMemberOriginForCompiledElementKt.getBySignatureIndexer()}));
            }
            {
                this.$classHeader = kotlinBinaryClassHeaderData;
                this.$classId = classId;
                super(1);
            }
        };
        switch (KotlinClassFileDecompilerKt$WhenMappings.$EnumSwitchMapping$0[classHeader.getKind().ordinal()]) {
            case 1: {
                FqName fqName2 = classId.asSingleFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.asSingleFqName()");
                decompiledText2 = $fun$buildText$1.invoke(resolver.resolveDeclarationsInFacade(fqName2));
                break;
            }
            case 2: {
                decompiledText2 = $fun$buildText$1.invoke(CollectionsKt.listOfNotNull((Object)resolver.resolveTopLevelClass(classId)));
                break;
            }
            case 3: {
                void $this$flatMapTo$iv$iv;
                List<KotlinJvmBinaryClass> partClasses = ClassFileDecompilerUtilKt.findMultifileClassParts(classFile, classId, classHeader.getPartNamesIfMultifileFacade());
                Iterable $this$flatMap$iv = partClasses;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    KotlinJvmBinaryClass partClass = (KotlinJvmBinaryClass)element$iv$iv;
                    boolean bl = false;
                    FqName fqName3 = partClass.getClassId().asSingleFqName();
                    Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"partClass.classId.asSingleFqName()");
                    Iterable list$iv$iv = resolver.resolveDeclarationsInFacade(fqName3);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List partMembers = (List)destination$iv$iv;
                decompiledText2 = $fun$buildText$1.invoke(partMembers);
                break;
            }
            default: {
                throw (Throwable)new UnsupportedOperationException("Unknown header kind: " + classHeader + ", class " + classId);
            }
        }
        return decompiledText2;
    }

    public static /* synthetic */ DecompiledText buildDecompiledTextForClassFile$default(VirtualFile virtualFile2, ResolverForDecompiler resolverForDecompiler, int n, Object object) {
        if ((n & 2) != 0) {
            resolverForDecompiler = DeserializerForClassfileDecompilerKt.DeserializerForClassfileDecompiler(virtualFile2);
        }
        return KotlinClassFileDecompilerKt.buildDecompiledTextForClassFile(virtualFile2, resolverForDecompiler);
    }

    public static final /* synthetic */ DescriptorRenderer access$getDecompilerRendererForClassFiles$p() {
        return decompilerRendererForClassFiles;
    }
}

