/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.editor.EntryChunk;
import org.jetbrains.kotlin.idea.editor.KotlinLiteralCopyPasteProcessor;
import org.jetbrains.kotlin.idea.editor.KotlinLiteralCopyPasteProcessorKt;
import org.jetbrains.kotlin.idea.editor.LiteralChunk;
import org.jetbrains.kotlin.idea.editor.NewLineChunk;
import org.jetbrains.kotlin.idea.editor.TemplateChunk;
import org.jetbrains.kotlin.idea.editor.TemplateTokenSequence;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004H\u0016J2\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePreProcessor;", "()V", "preprocessOnCopy", "", "file", "Lcom/intellij/psi/PsiFile;", "startOffsets", "", "endOffsets", "text", "preprocessOnPaste", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rawText", "Lcom/intellij/openapi/editor/RawText;", "kotlin.idea"})
public final class KotlinLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public String preprocessOnCopy(@NotNull PsiFile file2, @NotNull int[] startOffsets, @NotNull int[] endOffsets, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (!(file2 instanceof KtFile)) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean changed = false;
        String fileText2 = ((KtFile)file2).getText();
        int deducedBlockSelectionWidth = KotlinLiteralCopyPasteProcessorKt.access$deduceBlockSelectionWidth(startOffsets, endOffsets, text2);
        int n = 0;
        int n2 = startOffsets.length;
        while (n < n2) {
            int n3;
            void i;
            if (i > 0) {
                buffer.append('\n');
            }
            TextRange fileRange = new TextRange(startOffsets[i], endOffsets[i]);
            int givenTextOffset = fileRange.getStartOffset();
            while (givenTextOffset < fileRange.getEndOffset()) {
                String string;
                TextRange inter;
                int n4;
                PsiElement tpEntry;
                IElementType elTp;
                PsiElement element3 = file2.findElementAt(givenTextOffset);
                if (element3 == null) {
                    String string2;
                    Intrinsics.checkNotNullExpressionValue((Object)fileText2, (String)"fileText");
                    n3 = fileRange.getEndOffset() - 1;
                    String string3 = string2.substring(givenTextOffset, n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    buffer.append(string3);
                    break;
                }
                ASTNode aSTNode = element3.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node");
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode.getElementType(), (String)"element.node.elementType");
                if (Intrinsics.areEqual((Object)elTp, (Object)KtTokens.ESCAPE_SEQUENCE) && fileRange.contains(FixersUtilKt.getRange(element3))) {
                    TextRange textRange = KotlinLiteralCopyPasteProcessorKt.access$getTemplateContentRange$p(element3);
                    if (textRange != null) {
                        if (textRange.contains(fileRange)) {
                            PsiElement psiElement2 = element3.getParent();
                            if (psiElement2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry");
                            }
                            tpEntry = (KtEscapeStringTemplateEntry)psiElement2;
                            changed = true;
                            buffer.append(tpEntry.getUnescapedValue());
                            givenTextOffset = PsiUtilsKt.getEndOffset((PsiElement)element3);
                            continue;
                        }
                    }
                }
                if (Intrinsics.areEqual((Object)elTp, (Object)KtTokens.SHORT_TEMPLATE_ENTRY_START) || Intrinsics.areEqual((Object)elTp, (Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) {
                    String string4;
                    TextRange inter2;
                    PsiElement psiElement3 = tpEntry = element3.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"tpEntry");
                    Intrinsics.checkNotNull((Object)fileRange.intersection(FixersUtilKt.getRange(psiElement3)));
                    Intrinsics.checkNotNullExpressionValue((Object)fileText2, (String)"fileText");
                    n4 = inter2.getStartOffset();
                    int n5 = inter2.getEndOffset();
                    String string5 = string4.substring(n4, n5);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    buffer.append(string5);
                    givenTextOffset = inter2.getEndOffset();
                    continue;
                }
                Intrinsics.checkNotNull((Object)fileRange.intersection(FixersUtilKt.getRange(element3)));
                Intrinsics.checkNotNullExpressionValue((Object)fileText2, (String)"fileText");
                int n6 = inter.getStartOffset();
                n4 = inter.getEndOffset();
                String string6 = string.substring(n6, n4);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                buffer.append(string6);
                givenTextOffset = inter.getEndOffset();
            }
            int blockSelectionPadding = deducedBlockSelectionWidth - fileRange.getLength();
            int elTp = 0;
            n3 = blockSelectionPadding;
            while (elTp < n3) {
                void j;
                buffer.append(' ');
                ++j;
            }
            ++i;
        }
        return changed ? buffer.toString() : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String preprocessOnPaste(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Editor editor2, @NotNull String text2, @Nullable RawText rawText) {
        String string;
        CharSequence charSequence;
        StringBuilder stringBuilder;
        TemplateTokenSequence templateTokenSequence;
        block21: {
            boolean bl;
            block15: {
                CharSequence $this$all$iv;
                block20: {
                    Object object;
                    Iterator iterator;
                    boolean endsInLineBreak;
                    String lineBreak;
                    StringBuilder res;
                    block17: {
                        block18: {
                            block19: {
                                KtQualifiedExpression ktQualifiedExpression;
                                KtStringTemplateExpression beginTp;
                                PsiElement begin;
                                block16: {
                                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                                    Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                                    Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                                    if (!(file2 instanceof KtFile)) {
                                        return text2;
                                    }
                                    PsiDocumentManager.getInstance((Project)project2).commitDocument(editor2.getDocument());
                                    SelectionModel selectionModel = editor2.getSelectionModel();
                                    Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.selectionModel");
                                    SelectionModel selectionModel2 = selectionModel;
                                    PsiElement psiElement2 = file2.findElementAt(selectionModel2.getSelectionStart());
                                    if (psiElement2 == null) return text2;
                                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"file.findElementAt(selec\u2026tionStart) ?: return text");
                                    begin = psiElement2;
                                    KtStringTemplateExpression ktStringTemplateExpression = KotlinLiteralCopyPasteProcessorKt.access$getTemplateIfAtLiteral(file2, selectionModel2.getSelectionStart(), begin);
                                    if (ktStringTemplateExpression == null) return text2;
                                    beginTp = ktStringTemplateExpression;
                                    KtStringTemplateExpression ktStringTemplateExpression2 = KotlinLiteralCopyPasteProcessorKt.getTemplateIfAtLiteral$default(file2, selectionModel2.getSelectionEnd(), null, 2, null);
                                    if (ktStringTemplateExpression2 == null) return text2;
                                    KtStringTemplateExpression endTp = ktStringTemplateExpression2;
                                    if (KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)beginTp) != KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)endTp)) {
                                        return text2;
                                    }
                                    templateTokenSequence = new TemplateTokenSequence(text2);
                                    if (!KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)beginTp)) break block16;
                                    res = new StringBuilder();
                                    lineBreak = "\\n\"+\n \"";
                                    endsInLineBreak = false;
                                    Sequence $this$forEach$iv = templateTokenSequence;
                                    boolean $i$f$forEach = false;
                                    iterator = $this$forEach$iv.iterator();
                                    break block17;
                                }
                                preprocessOnPaste.2 $fun$indent$2 = preprocessOnPaste.2.INSTANCE;
                                PsiElement psiElement3 = beginTp.getFirstChild();
                                if (!Intrinsics.areEqual((Object)(psiElement3 != null ? psiElement3.getText() : null), (Object)"\"\"\"") || !Intrinsics.areEqual((ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)beginTp))) != null && (ktQualifiedExpression = UtilsKt.getCallExpression(ktQualifiedExpression)) != null && (ktQualifiedExpression = ktQualifiedExpression.getCalleeExpression()) != null ? ktQualifiedExpression.getText() : null, (Object)"trimIndent")) break block18;
                                TemplateChunk templateChunk2 = (TemplateChunk)SequencesKt.firstOrNull((Sequence)templateTokenSequence);
                                templateChunk2 = (TemplateChunk)SequencesKt.lastOrNull((Sequence)templateTokenSequence);
                                if (!Intrinsics.areEqual((Object)(templateChunk != null ? $fun$indent$2.invoke(templateChunk) : null), (Object)(templateChunk2 != null ? $fun$indent$2.invoke(templateChunk2) : null))) break block18;
                                Object object2 = begin.getParent();
                                if (object2 == null || (object2 = object2.getPrevSibling()) == null || (object2 = object2.getText()) == null) break block19;
                                StringBuilder it = stringBuilder = object2;
                                boolean bl2 = false;
                                $this$all$iv = it;
                                boolean $i$f$all = false;
                                break block20;
                            }
                            charSequence = null;
                            break block21;
                        }
                        charSequence = null;
                        break block21;
                    }
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        TemplateChunk it = (TemplateChunk)element$iv;
                        boolean bl3 = false;
                        TemplateChunk templateChunk = it;
                        if (templateChunk instanceof LiteralChunk) {
                            StringUtil.escapeStringCharacters((int)((LiteralChunk)it).getText().length(), (String)((LiteralChunk)it).getText(), (String)"$\"", (StringBuilder)res);
                        } else if (templateChunk instanceof EntryChunk) {
                            res.append(((EntryChunk)it).getText());
                        } else if (templateChunk instanceof NewLineChunk) {
                            res.append(lineBreak);
                        }
                        endsInLineBreak = it instanceof NewLineChunk;
                    }
                    if (endsInLineBreak) {
                        object = ((Object)StringsKt.removeSuffix((CharSequence)res, (CharSequence)lineBreak)).toString() + "\\n";
                        return object;
                    }
                    String string2 = res.toString();
                    object = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"res.toString()");
                    return object;
                }
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char c = element$iv = $this$all$iv.charAt(i);
                    boolean bl4 = false;
                    if (c == ' ' || c == '\t') continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
            charSequence = string = bl ? stringBuilder : null;
        }
        if (charSequence == null) {
            string = "";
        }
        String indent = string;
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        Regex tripleQuoteRe = new Regex("[\"]{3,}");
        String indentToAdd = "";
        Iterator<TemplateChunk> iterator = templateTokenSequence.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                String string3 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
                return string3;
            }
            TemplateChunk chunk = iterator.next();
            TemplateChunk templateChunk = chunk;
            if (templateChunk instanceof LiteralChunk) {
                String string4;
                String escapedDollar = string4 = StringsKt.replace$default((String)((LiteralChunk)chunk).getText(), (String)"$", (String)"${'$'}", (boolean)false, (int)4, null);
                boolean bl5 = false;
                String replaced2 = tripleQuoteRe.replace((CharSequence)escapedDollar, (Function1)preprocessOnPaste.3.replaced.1.1.INSTANCE);
                $this$buildString.append(indentToAdd + replaced2);
                indentToAdd = "";
                continue;
            }
            if (templateChunk instanceof EntryChunk) {
                $this$buildString.append(indentToAdd + ((EntryChunk)chunk).getText());
                indentToAdd = "";
                continue;
            }
            if (!(templateChunk instanceof NewLineChunk)) continue;
            StringBuilder stringBuilder2 = $this$buildString;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            indentToAdd = indent;
        }
    }
}

