/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHandlerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.findUsages.KotlinClassFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.KotlinFunctionFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.KotlinPropertyFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.handlers.DelegatingFindMemberUsagesHandler;
import org.jetbrains.kotlin.idea.findUsages.handlers.KotlinFindClassUsagesHandler;
import org.jetbrains.kotlin.idea.findUsages.handlers.KotlinFindMemberUsagesHandler;
import org.jetbrains.kotlin.idea.findUsages.handlers.KotlinTypeParameterFindUsagesHandler;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001aH\u0016J\u001e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0$H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/findUsages/KotlinFindUsagesHandlerFactory;", "Lcom/intellij/find/findUsages/FindUsagesHandlerFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "defaultOptions", "Lcom/intellij/find/findUsages/FindUsagesOptions;", "getDefaultOptions", "()Lcom/intellij/find/findUsages/FindUsagesOptions;", "findClassOptions", "Lorg/jetbrains/kotlin/idea/findUsages/KotlinClassFindUsagesOptions;", "getFindClassOptions", "()Lorg/jetbrains/kotlin/idea/findUsages/KotlinClassFindUsagesOptions;", "findFunctionOptions", "Lorg/jetbrains/kotlin/idea/findUsages/KotlinFunctionFindUsagesOptions;", "getFindFunctionOptions", "()Lorg/jetbrains/kotlin/idea/findUsages/KotlinFunctionFindUsagesOptions;", "findPropertyOptions", "Lorg/jetbrains/kotlin/idea/findUsages/KotlinPropertyFindUsagesOptions;", "getFindPropertyOptions", "()Lorg/jetbrains/kotlin/idea/findUsages/KotlinPropertyFindUsagesOptions;", "javaHandlerFactory", "Lcom/intellij/find/findUsages/JavaFindUsagesHandlerFactory;", "getJavaHandlerFactory", "()Lcom/intellij/find/findUsages/JavaFindUsagesHandlerFactory;", "canFindUsages", "", "element", "Lcom/intellij/psi/PsiElement;", "createFindUsagesHandler", "Lcom/intellij/find/findUsages/FindUsagesHandler;", "forHighlightUsages", "handlerForMultiple", "originalDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declarations", "", "kotlin.fir.frontend-independent"})
public final class KotlinFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    @NotNull
    private final JavaFindUsagesHandlerFactory javaHandlerFactory;
    @NotNull
    private final KotlinFunctionFindUsagesOptions findFunctionOptions;
    @NotNull
    private final KotlinPropertyFindUsagesOptions findPropertyOptions;
    @NotNull
    private final KotlinClassFindUsagesOptions findClassOptions;
    @NotNull
    private final FindUsagesOptions defaultOptions;

    @NotNull
    public final JavaFindUsagesHandlerFactory getJavaHandlerFactory() {
        return this.javaHandlerFactory;
    }

    @NotNull
    public final KotlinFunctionFindUsagesOptions getFindFunctionOptions() {
        return this.findFunctionOptions;
    }

    @NotNull
    public final KotlinPropertyFindUsagesOptions getFindPropertyOptions() {
        return this.findPropertyOptions;
    }

    @NotNull
    public final KotlinClassFindUsagesOptions getFindClassOptions() {
        return this.findClassOptions;
    }

    @NotNull
    public final FindUsagesOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public boolean canFindUsages(@NotNull PsiElement element3) {
        KtImportDirective ktImportDirective;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3 instanceof KtClassOrObject || element3 instanceof KtNamedFunction || element3 instanceof KtProperty || element3 instanceof KtParameter || element3 instanceof KtTypeParameter || element3 instanceof KtConstructor || element3 instanceof KtImportAlias && ((ktImportDirective = ((KtImportAlias)element3).getImportDirective()) != null && (ktImportDirective = ktImportDirective.getImportedReference()) != null && (ktImportDirective = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktImportDirective))) != null && (ktImportDirective = ReferenceUtilsKt.getMainReference((KtElement)ktImportDirective)) != null ? ktImportDirective.resolve() : null) != null;
    }

    @NotNull
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element3, boolean forHighlightUsages) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement psiElement2 = element3;
        if (psiElement2 instanceof KtImportAlias) {
            FindUsagesHandler findUsagesHandler;
            PsiElement resolvedElement;
            KtImportDirective ktImportDirective = ((KtImportAlias)element3).getImportDirective();
            PsiElement psiElement3 = ktImportDirective != null && (ktImportDirective = ktImportDirective.getImportedReference()) != null && (ktImportDirective = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktImportDirective))) != null && (ktImportDirective = ReferenceUtilsKt.getMainReference((KtElement)ktImportDirective)) != null ? ktImportDirective.resolve() : (resolvedElement = null);
            if (resolvedElement instanceof KtClassOrObject) {
                if (!forHighlightUsages) {
                    findUsagesHandler = this.createFindUsagesHandler(resolvedElement, forHighlightUsages);
                } else {
                    FindUsagesHandler findUsagesHandler2 = FindUsagesHandler.NULL_HANDLER;
                    findUsagesHandler = findUsagesHandler2;
                    Intrinsics.checkNotNullExpressionValue((Object)findUsagesHandler2, (String)"NULL_HANDLER");
                }
            } else if (resolvedElement instanceof KtNamedFunction || resolvedElement instanceof KtProperty || resolvedElement instanceof KtConstructor) {
                findUsagesHandler = this.createFindUsagesHandler(resolvedElement, forHighlightUsages);
            } else {
                FindUsagesHandler findUsagesHandler3 = FindUsagesHandler.NULL_HANDLER;
                findUsagesHandler = findUsagesHandler3;
                Intrinsics.checkNotNullExpressionValue((Object)findUsagesHandler3, (String)"NULL_HANDLER");
            }
            return findUsagesHandler;
        }
        if (psiElement2 instanceof KtClassOrObject) {
            return new KotlinFindClassUsagesHandler((KtClassOrObject)element3, this);
        }
        if (psiElement2 instanceof KtParameter) {
            return !forHighlightUsages ? this.handlerForMultiple((KtNamedDeclaration)element3, CollectionsKt.listOf((Object)element3)) : (FindUsagesHandler)KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, (KtNamedDeclaration)element3, null, this, 2, null);
        }
        if (psiElement2 instanceof KtNamedFunction || psiElement2 instanceof KtProperty || psiElement2 instanceof KtConstructor) {
            KtNamedDeclaration declaration2 = (KtNamedDeclaration)element3;
            if (forHighlightUsages) {
                return KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, declaration2, null, this, 2, null);
            }
            return this.handlerForMultiple(declaration2, CollectionsKt.listOf((Object)declaration2));
        }
        if (psiElement2 instanceof KtTypeParameter) {
            return new KotlinTypeParameterFindUsagesHandler((KtTypeParameter)element3, this);
        }
        throw (Throwable)new IllegalArgumentException("unexpected element type: " + element3);
    }

    private final FindUsagesHandler handlerForMultiple(KtNamedDeclaration originalDeclaration, Collection<? extends PsiElement> declarations) {
        FindUsagesHandler findUsagesHandler;
        switch (declarations.size()) {
            case 0: {
                FindUsagesHandler findUsagesHandler2 = FindUsagesHandler.NULL_HANDLER;
                findUsagesHandler = findUsagesHandler2;
                Intrinsics.checkNotNullExpressionValue((Object)findUsagesHandler2, (String)"NULL_HANDLER");
                break;
            }
            case 1: {
                FindUsagesHandler findUsagesHandler3;
                PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)CollectionsKt.single((Iterable)declarations)));
                if (psiElement2 == null) {
                    FindUsagesHandler findUsagesHandler4 = FindUsagesHandler.NULL_HANDLER;
                    Intrinsics.checkNotNullExpressionValue((Object)findUsagesHandler4, (String)"NULL_HANDLER");
                    return findUsagesHandler4;
                }
                PsiElement target2 = psiElement2;
                if (target2 instanceof KtNamedDeclaration) {
                    findUsagesHandler3 = KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, (KtNamedDeclaration)target2, null, this, 2, null);
                } else {
                    FindUsagesHandler findUsagesHandler5 = this.javaHandlerFactory.createFindUsagesHandler(target2, false);
                    findUsagesHandler3 = findUsagesHandler5;
                    Intrinsics.checkNotNull((Object)findUsagesHandler5);
                }
                findUsagesHandler = findUsagesHandler3;
                Intrinsics.checkNotNullExpressionValue((Object)findUsagesHandler3, (String)"if (target is KtNamedDec\u2026alse)!!\n                }");
                break;
            }
            default: {
                findUsagesHandler = new DelegatingFindMemberUsagesHandler(originalDeclaration, declarations, this);
            }
        }
        return findUsagesHandler;
    }

    public KotlinFindUsagesHandlerFactory(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.javaHandlerFactory = new JavaFindUsagesHandlerFactory(project2);
        this.findFunctionOptions = new KotlinFunctionFindUsagesOptions(project2);
        this.findPropertyOptions = new KotlinPropertyFindUsagesOptions(project2);
        this.findClassOptions = new KotlinClassFindUsagesOptions(project2);
        this.defaultOptions = new FindUsagesOptions(project2);
    }
}

