/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleTooling.builders;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinLocalModuleIdentifierImpl;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinMavenModuleIdentifierImpl;
import org.jetbrains.kotlin.idea.gradleTooling.builders.KotlinModelComponentBuilderBase;
import org.jetbrains.kotlin.idea.gradleTooling.reflect.KotlinLocalModuleIdentifierReflection;
import org.jetbrains.kotlin.idea.gradleTooling.reflect.KotlinMavenModuleIdentifierReflection;
import org.jetbrains.kotlin.idea.gradleTooling.reflect.KotlinModuleIdentifierReflection;
import org.jetbrains.kotlin.idea.projectModel.KotlinLocalModuleIdentifier;
import org.jetbrains.kotlin.idea.projectModel.KotlinMavenModuleIdentifier;
import org.jetbrains.kotlin.idea.projectModel.KotlinModuleIdentifier;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/gradleTooling/builders/KotlinModuleIdentifierBuilder;", "Lorg/jetbrains/kotlin/idea/gradleTooling/builders/KotlinModelComponentBuilderBase;", "Lorg/jetbrains/kotlin/idea/gradleTooling/reflect/KotlinModuleIdentifierReflection;", "Lorg/jetbrains/kotlin/idea/projectModel/KotlinModuleIdentifier;", "()V", "LOGGER", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "buildComponent", "origin", "KotlinLocalModuleIdentifierBuilder", "KotlinMavenModuleIdentifierBuilder", "kotlin.gradle.gradle-tooling"})
public final class KotlinModuleIdentifierBuilder
implements KotlinModelComponentBuilderBase<KotlinModuleIdentifierReflection, KotlinModuleIdentifier> {
    private static final Logger LOGGER;
    @NotNull
    public static final KotlinModuleIdentifierBuilder INSTANCE;

    @Override
    @Nullable
    public KotlinModuleIdentifier buildComponent(@NotNull KotlinModuleIdentifierReflection origin) {
        KotlinModuleIdentifier kotlinModuleIdentifier;
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        KotlinModuleIdentifierReflection kotlinModuleIdentifierReflection = origin;
        if (kotlinModuleIdentifierReflection instanceof KotlinLocalModuleIdentifierReflection) {
            kotlinModuleIdentifier = KotlinLocalModuleIdentifierBuilder.INSTANCE.buildComponent((KotlinLocalModuleIdentifierReflection)origin);
        } else if (kotlinModuleIdentifierReflection instanceof KotlinMavenModuleIdentifierReflection) {
            kotlinModuleIdentifier = KotlinMavenModuleIdentifierBuilder.INSTANCE.buildComponent((KotlinMavenModuleIdentifierReflection)origin);
        } else {
            LOGGER.error("Unknown module identifier reflection: \"" + origin.getClass().getName() + '\"');
            kotlinModuleIdentifier = null;
        }
        return kotlinModuleIdentifier;
    }

    private KotlinModuleIdentifierBuilder() {
    }

    static {
        KotlinModuleIdentifierBuilder kotlinModuleIdentifierBuilder;
        INSTANCE = kotlinModuleIdentifierBuilder = new KotlinModuleIdentifierBuilder();
        LOGGER = Logging.getLogger(INSTANCE.getClass());
    }

    @Override
    @Nullable
    public KotlinModuleIdentifier buildComponent(@NotNull KotlinModuleIdentifierReflection origin, @NotNull Unit importingContext) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)importingContext, (String)"importingContext");
        return KotlinModelComponentBuilderBase.DefaultImpls.buildComponent(this, origin, importingContext);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/gradleTooling/builders/KotlinModuleIdentifierBuilder$KotlinLocalModuleIdentifierBuilder;", "Lorg/jetbrains/kotlin/idea/gradleTooling/builders/KotlinModelComponentBuilderBase;", "Lorg/jetbrains/kotlin/idea/gradleTooling/reflect/KotlinLocalModuleIdentifierReflection;", "Lorg/jetbrains/kotlin/idea/projectModel/KotlinLocalModuleIdentifier;", "()V", "buildComponent", "origin", "kotlin.gradle.gradle-tooling"})
    private static final class KotlinLocalModuleIdentifierBuilder
    implements KotlinModelComponentBuilderBase<KotlinLocalModuleIdentifierReflection, KotlinLocalModuleIdentifier> {
        @NotNull
        public static final KotlinLocalModuleIdentifierBuilder INSTANCE;

        @Override
        @Nullable
        public KotlinLocalModuleIdentifier buildComponent(@NotNull KotlinLocalModuleIdentifierReflection origin) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            String string = origin.getBuildId();
            if (string == null) {
                return null;
            }
            String string2 = origin.getProjectId();
            if (string2 == null) {
                return null;
            }
            return new KotlinLocalModuleIdentifierImpl(origin.getModuleClassifier(), string, string2);
        }

        private KotlinLocalModuleIdentifierBuilder() {
        }

        static {
            KotlinLocalModuleIdentifierBuilder kotlinLocalModuleIdentifierBuilder;
            INSTANCE = kotlinLocalModuleIdentifierBuilder = new KotlinLocalModuleIdentifierBuilder();
        }

        @Override
        @Nullable
        public KotlinLocalModuleIdentifier buildComponent(@NotNull KotlinLocalModuleIdentifierReflection origin, @NotNull Unit importingContext) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)importingContext, (String)"importingContext");
            return KotlinModelComponentBuilderBase.DefaultImpls.buildComponent(this, origin, importingContext);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/gradleTooling/builders/KotlinModuleIdentifierBuilder$KotlinMavenModuleIdentifierBuilder;", "Lorg/jetbrains/kotlin/idea/gradleTooling/builders/KotlinModelComponentBuilderBase;", "Lorg/jetbrains/kotlin/idea/gradleTooling/reflect/KotlinMavenModuleIdentifierReflection;", "Lorg/jetbrains/kotlin/idea/projectModel/KotlinMavenModuleIdentifier;", "()V", "buildComponent", "origin", "kotlin.gradle.gradle-tooling"})
    private static final class KotlinMavenModuleIdentifierBuilder
    implements KotlinModelComponentBuilderBase<KotlinMavenModuleIdentifierReflection, KotlinMavenModuleIdentifier> {
        @NotNull
        public static final KotlinMavenModuleIdentifierBuilder INSTANCE;

        @Override
        @Nullable
        public KotlinMavenModuleIdentifier buildComponent(@NotNull KotlinMavenModuleIdentifierReflection origin) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            String string = origin.getGroup();
            if (string == null) {
                return null;
            }
            String string2 = origin.getName();
            if (string2 == null) {
                return null;
            }
            return new KotlinMavenModuleIdentifierImpl(origin.getModuleClassifier(), string, string2);
        }

        private KotlinMavenModuleIdentifierBuilder() {
        }

        static {
            KotlinMavenModuleIdentifierBuilder kotlinMavenModuleIdentifierBuilder;
            INSTANCE = kotlinMavenModuleIdentifierBuilder = new KotlinMavenModuleIdentifierBuilder();
        }

        @Override
        @Nullable
        public KotlinMavenModuleIdentifier buildComponent(@NotNull KotlinMavenModuleIdentifierReflection origin, @NotNull Unit importingContext) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)importingContext, (String)"importingContext");
            return KotlinModelComponentBuilderBase.DefaultImpls.buildComponent(this, origin, importingContext);
        }
    }
}

