/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.branchedTransformations;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedTransformationUtilsKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/branchedTransformations/IntroduceWhenSubjectInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixText", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "inspectionText", "isApplicable", "", "kotlin.idea"})
public final class IntroduceWhenSubjectInspection
extends AbstractApplicabilityBasedInspection<KtWhenExpression> {
    @Override
    public boolean isApplicable(@NotNull KtWhenExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return BranchedTransformationUtilsKt.getSubjectToIntroduce$default(element3, false, 1, null) != null;
    }

    @Override
    @NotNull
    public TextRange inspectionHighlightRangeInElement(@NotNull KtWhenExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getWhenKeyword();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.whenKeyword");
        return ExpressionExtKt.textRangeIn(psiElement2, (PsiElement)element3);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtWhenExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("when.with.subject.should.be.used", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("introduce.when.subject", new Object[0]);
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtWhenExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression ktExpression = BranchedTransformationUtilsKt.getSubjectToIntroduce$default(element3, false, 1, null);
        if (ktExpression == null) {
            return "";
        }
        KtExpression subject = ktExpression;
        Object[] objectArray = new Object[1];
        String string = subject.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"subject.text");
        objectArray[0] = string;
        return KotlinBundle.message("introduce.0.as.subject.0.when", objectArray);
    }

    @Override
    public void applyTo(@NotNull KtWhenExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        BranchedTransformationUtilsKt.introduceSubject$default(element3, false, 1, null);
    }

    public IntroduceWhenSubjectInspection() {
        super(KtWhenExpression.class);
    }
}

