/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.dfa;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.jvm.JvmDfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinAnchor;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinConstantConditionsInspection;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinConstantConditionsInspection$WhenMappings;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinProblem;
import org.jetbrains.kotlin.idea.inspections.dfa.KtControlFlowBuilder;
import org.jetbrains.kotlin.idea.inspections.dfa.KtDfaHelpersKt;
import org.jetbrains.kotlin.idea.inspections.dfa.SmartCastHelpersKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.references.ReadWriteAccessCheckerKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002BCB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\u001a\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J \u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0006H\u0002J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J#\u0010*\u001a\u00020\u00042\b\u0010+\u001a\u0004\u0018\u00010\u00132\u0006\u0010,\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0082\u0010J\u0010\u0010-\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010.\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J.\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020706H\u0002J\u0018\u00108\u001a\u0002012\u0006\u00109\u001a\u00020:2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010;\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\u0018\u0010<\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020=2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u0013H\u0002J\u0018\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020=2\u0006\u0010'\u001a\u00020(H\u0002\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "areEquivalent", "", "e1", "Lorg/jetbrains/kotlin/psi/KtElement;", "e2", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "hasOppositeCondition", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "topAnd", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "hasWritesTo", "block", "Lcom/intellij/psi/PsiElement;", "variable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isAlsoChain", "expr", "isAssertion", "parent", "value", "isCallToMethod", "call", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "packageName", "", "methodName", "isCompilationWarning", "anchor", "isLastCondition", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "isLetConstant", "isOppositeCondition", "candidate", "template", "isPairingConditionInWhen", "isUpdateChain", "logicalChain", "processDataflowAnalysis", "", "factory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "body", "states", "", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "reportProblems", "listener", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$KotlinDfaListener;", "shouldReportAsValue", "shouldSuppress", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$ConstantValue;", "shouldSuppressForCondition", "loopRange", "shouldSuppressWhenCondition", "cv", "ConstantValue", "KotlinDfaListener", "kotlin.idea"})
public final class KotlinConstantConditionsInspection
extends AbstractKotlinInspection {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldSuppress(ConstantValue value2, KtExpression expression2) {
        PsiElement target2;
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtDotQualifiedExpression && Intrinsics.areEqual((Object)((KtDotQualifiedExpression)parent2).getSelectorExpression(), (Object)expression2)) {
            return true;
        }
        while (parent2 instanceof KtParenthesizedExpression) {
            parent2 = ((KtParenthesizedExpression)parent2).getParent();
        }
        if (expression2 instanceof KtConstantExpression || expression2 instanceof KtProperty || expression2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)expression2).getOperationToken(), (Object)KtTokens.EQ)) return true;
        PsiElement psiElement2 = parent2;
        if (!(psiElement2 instanceof KtPrefixExpression)) {
            psiElement2 = null;
        }
        KtPrefixExpression ktPrefixExpression = (KtPrefixExpression)psiElement2;
        if (Intrinsics.areEqual((Object)(ktPrefixExpression != null ? ktPrefixExpression.getOperationToken() : null), (Object)KtTokens.EXCL)) {
            return true;
        }
        if (expression2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)expression2).getOperationToken(), (Object)KtTokens.ELVIS)) {
            KtExpression ktExpression = ((KtBinaryExpression)expression2).getLeft();
            if (ktExpression != null && (ktExpression = KtDfaHelpersKt.getKotlinType(ktExpression)) != null) {
                if (TypeUtilsKt.isNullableNothing((KotlinType)ktExpression)) {
                    return true;
                }
            }
        }
        if (this.isAlsoChain(expression2) || this.isLetConstant(expression2) || this.isUpdateChain(expression2)) {
            return true;
        }
        switch (KotlinConstantConditionsInspection$WhenMappings.$EnumSwitchMapping$0[value2.ordinal()]) {
            case 1: {
                if (SmartCastHelpersKt.isSmartCastNecessary(expression2, true)) {
                    return true;
                }
                if (this.isPairingConditionInWhen(expression2)) {
                    return true;
                }
                if (!this.isAssertion(parent2, true)) break;
                return true;
            }
            case 2: {
                if (SmartCastHelpersKt.isSmartCastNecessary(expression2, false)) {
                    return true;
                }
                if (!this.isAssertion(parent2, false)) break;
                return true;
            }
            case 3: {
                BindingContext bindingContext2;
                if (ReadWriteAccessCheckerKt.readWriteAccess(expression2, false).isWrite()) {
                    return true;
                }
                if (expression2 instanceof KtDotQualifiedExpression) {
                    KtExpression ktExpression = ((KtDotQualifiedExpression)expression2).getSelectorExpression();
                    if (ktExpression != null) {
                        if (ktExpression.textMatches((CharSequence)"ordinal")) {
                            KtExpression receiver2 = ((KtDotQualifiedExpression)expression2).getReceiverExpression();
                            if (receiver2 instanceof KtQualifiedExpression) {
                                receiver2 = ((KtQualifiedExpression)receiver2).getSelectorExpression();
                            }
                            if (receiver2 instanceof KtSimpleNameExpression && ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)receiver2)).resolve() instanceof KtEnumEntry) {
                                return true;
                            }
                        }
                    }
                }
                if (ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext2 = ResolutionUtils.analyze$default((KtElement)((KtElement)expression2), null, (int)1, null)) != null) {
                    return true;
                }
                if (!(expression2 instanceof KtSimpleNameExpression) || !(parent2 instanceof KtValueArgument) && (!(parent2 instanceof KtContainerNode) || !(((KtContainerNode)parent2).getParent() instanceof KtArrayAccessExpression))) break;
                return true;
            }
            case 4: {
                KotlinType kotlinType;
                if (parent2 instanceof KtProperty && ((KtProperty)parent2).getTypeReference() == null && expression2 instanceof KtSimpleNameExpression) {
                    return true;
                }
                if (expression2 instanceof KtBinaryExpressionWithTypeRHS) {
                    KtExpression ktExpression = ((KtBinaryExpressionWithTypeRHS)expression2).getLeft();
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"expression.left");
                    if (PsiUtilsKt.isNull((KtExpression)ktExpression)) {
                        return true;
                    }
                }
                if (parent2 instanceof KtBinaryExpression) {
                    IElementType iElementType = ((KtBinaryExpression)parent2).getOperationToken();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"parent.operationToken");
                    IElementType token = iElementType;
                    if (token == KtTokens.EQEQ || token == KtTokens.EXCLEQ || token == KtTokens.EQEQEQ || token == KtTokens.EXCLEQEQEQ) {
                        KtExpression ktExpression = ((KtBinaryExpression)parent2).getLeft();
                        if (ktExpression != null && PsiUtilsKt.isNull((KtExpression)ktExpression)) return true;
                        KtExpression ktExpression2 = ((KtBinaryExpression)parent2).getRight();
                        if (ktExpression2 != null) {
                            if (PsiUtilsKt.isNull((KtExpression)ktExpression2)) {
                                return true;
                            }
                        }
                    }
                }
                if (!Intrinsics.areEqual((Object)KtDfaHelpersKt.toDfType(kotlinType = KtDfaHelpersKt.getKotlinType(expression2), (KtElement)expression2), (Object)DfTypes.NULL)) break;
                return true;
            }
        }
        if (expression2 instanceof KtSimpleNameExpression && (target2 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)expression2)).resolve()) instanceof KtProperty && !((KtProperty)target2).isVar() && ((KtProperty)target2).getInitializer() instanceof KtConstantExpression) {
            return true;
        }
        if (!this.isCompilationWarning((KtElement)expression2)) return BindingContextUtilsKt.isUsedAsStatement((KtExpression)expression2, (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)expression2), (BodyResolveMode)BodyResolveMode.FULL));
        return true;
    }

    private final boolean isUpdateChain(KtExpression expression2) {
        if (!(expression2 instanceof KtSimpleNameExpression)) {
            return false;
        }
        PsiElement psiElement2 = ((KtSimpleNameExpression)expression2).getParent();
        if (!(psiElement2 instanceof KtBinaryExpression)) {
            psiElement2 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement2;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression binOp = ktBinaryExpression;
        KtOperationReferenceExpression ktOperationReferenceExpression = binOp.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"binOp.operationReference");
        String op = ktOperationReferenceExpression.getText();
        if (Intrinsics.areEqual((Object)op, (Object)"or") ^ true && Intrinsics.areEqual((Object)op, (Object)"and") ^ true && Intrinsics.areEqual((Object)op, (Object)"xor") ^ true && Intrinsics.areEqual((Object)op, (Object)"||") ^ true && Intrinsics.areEqual((Object)op, (Object)"&&") ^ true) {
            return false;
        }
        PsiElement psiElement3 = binOp.getParent();
        if (!(psiElement3 instanceof KtBinaryExpression)) {
            psiElement3 = null;
        }
        KtBinaryExpression ktBinaryExpression2 = (KtBinaryExpression)psiElement3;
        if (ktBinaryExpression2 == null) {
            return false;
        }
        KtBinaryExpression assignment2 = ktBinaryExpression2;
        if (Intrinsics.areEqual((Object)assignment2.getOperationToken(), (Object)KtTokens.EQ) ^ true) {
            return false;
        }
        KtExpression left = assignment2.getLeft();
        if (!(left instanceof KtSimpleNameExpression) || !left.textMatches((CharSequence)((KtSimpleNameExpression)expression2).getText())) {
            return false;
        }
        PsiElement psiElement4 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)expression2)).resolve();
        if (!(psiElement4 instanceof KtProperty)) {
            psiElement4 = null;
        }
        KtProperty ktProperty = (KtProperty)psiElement4;
        if (ktProperty == null) {
            return false;
        }
        KtProperty variable2 = ktProperty;
        PsiElement psiElement5 = variable2.getParent();
        if (!(psiElement5 instanceof KtBlockExpression)) {
            psiElement5 = null;
        }
        KtBlockExpression ktBlockExpression = (KtBlockExpression)psiElement5;
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression varParent = ktBlockExpression;
        PsiElement context2 = (PsiElement)assignment2;
        PsiElement block2 = context2.getParent();
        while (true) {
            block19: {
                block20: {
                    if (block2 instanceof KtContainerNode) break block19;
                    if (!(block2 instanceof KtBlockExpression)) break block20;
                    List list2 = ((KtBlockExpression)block2).getStatements();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"block.statements");
                    if (Intrinsics.areEqual((Object)((KtExpression)CollectionsKt.first((List)list2)), (Object)context2)) break block19;
                }
                if (!(block2 instanceof KtIfExpression)) break;
                KtExpression ktExpression = ((KtIfExpression)block2).getThen();
                if (!Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getParent() : null), (Object)context2) || ((KtIfExpression)block2).getElse() != null || this.hasWritesTo((PsiElement)((KtIfExpression)block2).getCondition(), variable2)) break;
            }
            context2 = block2;
            block2 = context2.getParent();
        }
        if (block2 != varParent) {
            return false;
        }
        PsiElement curExpression = variable2.getNextSibling();
        while (Intrinsics.areEqual((Object)curExpression, (Object)context2) ^ true) {
            if (this.hasWritesTo(curExpression, variable2)) {
                return false;
            }
            PsiElement psiElement6 = curExpression;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement6, (String)"curExpression");
            curExpression = psiElement6.getNextSibling();
        }
        return true;
    }

    private final boolean hasWritesTo(PsiElement block2, KtProperty variable2) {
        return !PsiTreeUtil.processElements((PsiElement)block2, KtSimpleNameExpression.class, (PsiElementProcessor)new PsiElementProcessor(variable2){
            final /* synthetic */ KtProperty $variable;

            public final boolean execute(@NotNull KtSimpleNameExpression ref2) {
                Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
                boolean write2 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ref2).isReferenceTo((PsiElement)this.$variable) && ReadWriteAccessCheckerKt.readWriteAccess((KtExpression)ref2, false).isWrite();
                return !write2;
            }
            {
                this.$variable = ktProperty;
            }
        });
    }

    private final boolean isAlsoChain(KtExpression expr) {
        KtExpression ktExpression = expr;
        if (!(ktExpression instanceof KtQualifiedExpression)) {
            ktExpression = null;
        }
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression;
        Object object = ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
        if (!(object instanceof KtCallExpression)) {
            object = null;
        }
        KtCallExpression ktCallExpression = (KtCallExpression)object;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression call = ktCallExpression;
        return this.isCallToMethod(call, "kotlin", "also");
    }

    private final boolean isLetConstant(KtExpression expr) {
        KtExpression ktExpression = expr;
        if (!(ktExpression instanceof KtQualifiedExpression)) {
            ktExpression = null;
        }
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression;
        Object object = ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
        if (!(object instanceof KtCallExpression)) {
            object = null;
        }
        KtCallExpression ktCallExpression = (KtCallExpression)object;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression call = ktCallExpression;
        if (!this.isCallToMethod(call, "kotlin", "let")) {
            return false;
        }
        List list2 = call.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"call.lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list2);
        if (ktLambdaArgument == null || (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) == null) {
            return false;
        }
        KtLambdaArgument lambda2 = ktLambdaArgument;
        Object object2 = lambda2.getBodyExpression();
        return (object2 != null && (object2 = object2.getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object2) : null) instanceof KtConstantExpression;
    }

    private final boolean isCallToMethod(KtCallExpression call, String packageName2, String methodName2) {
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)call), null, (int)1, null);
        if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
            return false;
        }
        ResolvedCall descriptor2 = resolvedCall2;
        if (Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)methodName2) ^ true) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (!(declarationDescriptor instanceof PackageFragmentDescriptor)) {
            declarationDescriptor = null;
        }
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)declarationDescriptor;
        if (packageFragmentDescriptor == null) {
            return false;
        }
        PackageFragmentDescriptor packageFragment2 = packageFragmentDescriptor;
        return Intrinsics.areEqual((Object)packageFragment2.getFqName().asString(), (Object)packageName2);
    }

    private final boolean isAssertion(PsiElement parent2, boolean value2) {
        boolean bl;
        PsiElement psiElement2 = parent2;
        if (psiElement2 instanceof KtBinaryExpression) {
            bl = (Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationToken(), (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationToken(), (Object)KtTokens.OROR)) && this.isAssertion(((KtBinaryExpression)parent2).getParent(), value2);
        } else if (psiElement2 instanceof KtParenthesizedExpression) {
            bl = this.isAssertion(((KtParenthesizedExpression)parent2).getParent(), value2);
        } else if (psiElement2 instanceof KtPrefixExpression) {
            bl = Intrinsics.areEqual((Object)((KtPrefixExpression)parent2).getOperationToken(), (Object)KtTokens.EXCL) && this.isAssertion(((KtPrefixExpression)parent2).getParent(), !value2);
        } else {
            if (psiElement2 instanceof KtValueArgument) {
                if (!value2) {
                    return false;
                }
                PsiElement psiElement3 = ((KtValueArgument)parent2).getParent();
                if (!(psiElement3 instanceof KtValueArgumentList)) {
                    psiElement3 = null;
                }
                KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement3;
                if (ktValueArgumentList == null) {
                    return false;
                }
                KtValueArgumentList valueArgList = ktValueArgumentList;
                PsiElement psiElement4 = valueArgList.getParent();
                if (!(psiElement4 instanceof KtCallExpression)) {
                    psiElement4 = null;
                }
                KtCallExpression ktCallExpression = (KtCallExpression)psiElement4;
                if (ktCallExpression == null) {
                    return false;
                }
                KtCallExpression call = ktCallExpression;
                ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)call), null, (int)1, null);
                if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
                    return false;
                }
                ResolvedCall descriptor2 = resolvedCall2;
                String string = descriptor2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.name.asString()");
                String name2 = string;
                if (Intrinsics.areEqual((Object)name2, (Object)"assert") ^ true && Intrinsics.areEqual((Object)name2, (Object)"require") ^ true && Intrinsics.areEqual((Object)name2, (Object)"check") ^ true) {
                    return false;
                }
                DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
                if (!(declarationDescriptor instanceof PackageFragmentDescriptor)) {
                    declarationDescriptor = null;
                }
                PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)declarationDescriptor;
                if (packageFragmentDescriptor == null) {
                    return false;
                }
                PackageFragmentDescriptor pkg = packageFragmentDescriptor;
                return Intrinsics.areEqual((Object)pkg.getFqName().asString(), (Object)"kotlin");
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isPairingConditionInWhen(KtExpression expression2) {
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationToken(), (Object)KtTokens.ANDAND)) {
            PsiElement nextParent;
            KtBinaryExpression topAnd = (KtBinaryExpression)parent2;
            while ((nextParent = topAnd.getParent()) instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)nextParent).getOperationToken(), (Object)KtTokens.ANDAND)) {
                topAnd = (KtBinaryExpression)nextParent;
            }
            PsiElement topAndParent = topAnd.getParent();
            if (topAndParent instanceof KtWhenConditionWithExpression) {
                KtWhenExpression whenExpression2;
                PsiElement psiElement2 = ((KtWhenConditionWithExpression)topAndParent).getParent();
                if (!(psiElement2 instanceof KtWhenEntry)) {
                    psiElement2 = null;
                }
                KtWhenEntry ktWhenEntry = (KtWhenEntry)psiElement2;
                Object object = ktWhenEntry != null ? ktWhenEntry.getParent() : null;
                if (!(object instanceof KtWhenExpression)) {
                    object = null;
                }
                if ((whenExpression2 = (KtWhenExpression)object) != null && this.hasOppositeCondition(whenExpression2, topAnd, expression2)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean hasOppositeCondition(KtWhenExpression whenExpression2, KtBinaryExpression topAnd, KtExpression expression2) {
        Iterator iterator = whenExpression2.getEntries().iterator();
        while (iterator.hasNext()) {
            KtWhenEntry entry;
            KtWhenEntry ktWhenEntry = entry = (KtWhenEntry)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)ktWhenEntry, (String)"entry");
            for (KtWhenCondition condition2 : ktWhenEntry.getConditions()) {
                if (!(condition2 instanceof KtWhenConditionWithExpression)) continue;
                KtExpression candidate2 = ((KtWhenConditionWithExpression)condition2).getExpression();
                if (candidate2 == topAnd) {
                    return false;
                }
                if (!this.isOppositeCondition(candidate2, topAnd, expression2)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean isOppositeCondition(KtExpression candidate2, KtBinaryExpression template2, KtExpression expression2) {
        while (candidate2 instanceof KtBinaryExpression && ((KtBinaryExpression)candidate2).getOperationToken() == KtTokens.ANDAND) {
            KtExpression left = ((KtBinaryExpression)candidate2).getLeft();
            KtExpression right2 = ((KtBinaryExpression)candidate2).getRight();
            if (left == null || right2 == null) {
                return false;
            }
            KtExpression templateLeft = template2.getLeft();
            KtExpression templateRight = template2.getRight();
            if (templateLeft == null || templateRight == null) {
                return false;
            }
            if (templateRight == expression2) {
                return this.areEquivalent((KtElement)left, (KtElement)templateLeft) && this.areEquivalent((KtElement)UtilsKt.negate(right2, false), (KtElement)templateRight);
            }
            if (!this.areEquivalent((KtElement)right2, (KtElement)templateRight)) {
                return false;
            }
            if (templateLeft == expression2) {
                return this.areEquivalent((KtElement)UtilsKt.negate(left, false), (KtElement)templateLeft);
            }
            if (!(templateLeft instanceof KtBinaryExpression) || ((KtBinaryExpression)templateLeft).getOperationToken() != KtTokens.ANDAND) {
                return false;
            }
            template2 = (KtBinaryExpression)templateLeft;
            candidate2 = left;
        }
        return false;
    }

    private final boolean areEquivalent(KtElement e1, KtElement e2) {
        return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)e1), (PsiElement)((PsiElement)e2), (Comparator)areEquivalent.1.INSTANCE, null, null, (boolean)false);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile2 = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"holder.file");
        Module module2 = ProjectRootsUtilKt.getModule((PsiElement)psiFile2);
        if (module2 == null || (module2 = PlatformKt.getPlatform(module2)) == null || !JvmPlatformKt.isJvm((TargetPlatform)module2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)VisitorWrappersKt.namedFunctionVisitor((Function1)((Function1)new Function1<KtNamedFunction, Unit>(this, holder){
            final /* synthetic */ KotlinConstantConditionsInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtNamedFunction function2) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                KtExpression ktExpression = function2.getBodyExpression();
                if (ktExpression == null) {
                    ktExpression = (KtExpression)function2.getBodyBlockExpression();
                }
                if (ktExpression == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"function.bodyExpression \u2026BlockExpression ?: return");
                KtExpression body2 = ktExpression;
                DfaValueFactory factory2 = new DfaValueFactory(this.$holder.getProject());
                KotlinConstantConditionsInspection.access$processDataflowAnalysis(this.this$0, factory2, body2, this.$holder, CollectionsKt.listOf((Object)new JvmDfaMemoryStateImpl(factory2)));
            }
            {
                this.this$0 = kotlinConstantConditionsInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void processDataflowAnalysis(DfaValueFactory factory2, KtExpression body2, ProblemsHolder holder, Collection<? extends DfaMemoryState> states) {
        Collection<DfaInstructionState> collection;
        PsiElement $this$mapTo$iv$iv;
        void $this$map$iv;
        ControlFlow controlFlow = new KtControlFlowBuilder(factory2, body2).buildFlow();
        if (controlFlow == null) {
            return;
        }
        ControlFlow flow = controlFlow;
        KotlinDfaListener listener2 = new KotlinDfaListener();
        StandardDataFlowInterpreter interpreter = new StandardDataFlowInterpreter(flow, (DfaListener)listener2);
        Object object = states;
        StandardDataFlowInterpreter standardDataFlowInterpreter = interpreter;
        boolean $i$f$map = false;
        void var10_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void s;
            DfaMemoryState dfaMemoryState = (DfaMemoryState)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            DfaInstructionState dfaInstructionState = new DfaInstructionState(flow.getInstruction(0), (DfaMemoryState)s);
            collection.add(dfaInstructionState);
        }
        collection = (List)destination$iv$iv;
        if (standardDataFlowInterpreter.interpret((List)collection) != RunnerResult.OK) {
            return;
        }
        this.reportProblems(listener2, holder);
        Iterator iterator = interpreter.getClosures().entrySet().iterator();
        while (iterator.hasNext()) {
            void closure;
            Object object2 = object = (Map.Entry)iterator.next();
            $this$mapTo$iv$iv = (PsiElement)object2.getKey();
            object2 = object;
            Collection closureStates = (Collection)object2.getValue();
            if (!(closure instanceof KtExpression)) continue;
            KtExpression ktExpression = (KtExpression)closure;
            Collection collection2 = closureStates;
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"closureStates");
            this.processDataflowAnalysis(factory2, ktExpression, holder, collection2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportProblems(KotlinDfaListener listener2, ProblemsHolder holder) {
        KtExpression expr;
        KotlinProblem anchor;
        Map.Entry entry;
        Map.Entry element$iv;
        Map $this$forEach$iv = listener2.getConstantConditions();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            KtExpression loopRange;
            String key;
            Map.Entry $dstr$anchor$cv = element$iv = iterator.next();
            boolean bl = false;
            entry = $dstr$anchor$cv;
            KotlinAnchor kotlinAnchor = (KotlinAnchor)entry.getKey();
            entry = $dstr$anchor$cv;
            ConstantValue cv = (ConstantValue)((Object)entry.getValue());
            if (cv == ConstantValue.UNKNOWN) continue;
            entry = anchor;
            if (entry instanceof KotlinAnchor.KotlinExpressionAnchor) {
                String string;
                expr = ((KotlinAnchor.KotlinExpressionAnchor)((Object)anchor)).getExpression();
                if (this.shouldSuppress(cv, expr)) continue;
                switch (KotlinConstantConditionsInspection$WhenMappings.$EnumSwitchMapping$1[cv.ordinal()]) {
                    case 1: {
                        if (this.shouldReportAsValue(expr)) {
                            string = "inspection.message.value.always.true";
                            break;
                        }
                        if (this.logicalChain(expr)) {
                            string = "inspection.message.condition.always.true.when.reached";
                            break;
                        }
                        string = "inspection.message.condition.always.true";
                        break;
                    }
                    case 2: {
                        if (this.shouldReportAsValue(expr)) {
                            string = "inspection.message.value.always.false";
                            break;
                        }
                        if (this.logicalChain(expr)) {
                            string = "inspection.message.condition.always.false.when.reached";
                            break;
                        }
                        string = "inspection.message.condition.always.false";
                        break;
                    }
                    case 3: {
                        string = "inspection.message.value.always.null";
                        break;
                    }
                    case 4: {
                        string = "inspection.message.value.always.zero";
                        break;
                    }
                    default: {
                        throw (Throwable)new IllegalStateException("Unexpected constant: " + cv);
                    }
                }
                key = string;
                ProblemHighlightType highlightType = this.shouldReportAsValue(expr) ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                PsiElement psiElement2 = (PsiElement)expr;
                Object[] objectArray = new Object[1];
                String string2 = expr.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"expr.text");
                objectArray[0] = string2;
                holder.registerProblem(psiElement2, KotlinBundle.message(key, objectArray), highlightType, new LocalQuickFix[0]);
                continue;
            }
            if (entry instanceof KotlinAnchor.KotlinWhenConditionAnchor) {
                KtWhenCondition condition2 = ((KotlinAnchor.KotlinWhenConditionAnchor)((Object)anchor)).getCondition();
                if (this.shouldSuppressWhenCondition(cv, condition2)) continue;
                key = cv == ConstantValue.TRUE ? "inspection.message.when.condition.always.true" : "inspection.message.when.condition.always.false";
                holder.registerProblem((PsiElement)condition2, KotlinBundle.message(key, new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            if (!(entry instanceof KotlinAnchor.KotlinForVisitedAnchor)) continue;
            Intrinsics.checkNotNull((Object)((KotlinAnchor.KotlinForVisitedAnchor)((Object)anchor)).getForExpression().getLoopRange());
            Intrinsics.checkNotNullExpressionValue((Object)loopRange, (String)"anchor.forExpression.loopRange!!");
            if (cv != ConstantValue.FALSE || this.shouldSuppressForCondition(loopRange)) continue;
            String message2 = KotlinBundle.message("inspection.message.for.never.visited", new Object[0]);
            holder.registerProblem((PsiElement)loopRange, message2, new LocalQuickFix[0]);
        }
        $this$forEach$iv = listener2.getProblems();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            KtBinaryExpressionWithTypeRHS ktBinaryExpressionWithTypeRHS;
            KtExpression anchor2;
            void problem;
            Map.Entry $dstr$problem$state = element$iv = iterator.next();
            boolean bl = false;
            entry = $dstr$problem$state;
            anchor = (KotlinProblem)entry.getKey();
            entry = $dstr$problem$state;
            ThreeState state = (ThreeState)entry.getValue();
            if (state != ThreeState.YES) continue;
            entry = problem;
            if (entry instanceof KotlinProblem.KotlinArrayIndexProblem) {
                holder.registerProblem((PsiElement)((KotlinProblem.KotlinArrayIndexProblem)problem).getIndex(), KotlinBundle.message("inspection.message.index.out.of.bounds", new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            if (entry instanceof KotlinProblem.KotlinNullCheckProblem) {
                expr = ((KotlinProblem.KotlinNullCheckProblem)problem).getExpr();
                KtExpression ktExpression = expr.getBaseExpression();
                if (ktExpression != null && PsiUtilsKt.isNull((KtExpression)ktExpression)) continue;
                holder.registerProblem((PsiElement)expr.getOperationReference(), KotlinBundle.message("inspection.message.nonnull.cast.will.always.fail", new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            if (!(entry instanceof KotlinProblem.KotlinCastProblem)) continue;
            KtExpression ktExpression = ((KotlinProblem.KotlinCastProblem)problem).getCast();
            if (!(ktExpression instanceof KtBinaryExpressionWithTypeRHS)) {
                ktExpression = null;
            }
            if (this.isCompilationWarning((KtElement)(anchor2 = (ktBinaryExpressionWithTypeRHS = (KtBinaryExpressionWithTypeRHS)ktExpression) != null && (ktBinaryExpressionWithTypeRHS = ktBinaryExpressionWithTypeRHS.getOperationReference()) != null ? (KtExpression)ktBinaryExpressionWithTypeRHS : ((KotlinProblem.KotlinCastProblem)problem).getCast()))) continue;
            holder.registerProblem((PsiElement)anchor2, KotlinBundle.message("inspection.message.cast.will.always.fail", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private final boolean shouldSuppressForCondition(KtExpression loopRange) {
        if (loopRange instanceof KtBinaryExpression) {
            KtExpression left = ((KtBinaryExpression)loopRange).getLeft();
            KtExpression right2 = ((KtBinaryExpression)loopRange).getRight();
            return left != null && right2 != null && CommonUtilsKt.isConstant(left) && CommonUtilsKt.isConstant(right2);
        }
        return false;
    }

    private final boolean shouldReportAsValue(KtExpression expr) {
        return expr instanceof KtSimpleNameExpression || expr instanceof KtQualifiedExpression && ((KtQualifiedExpression)expr).getSelectorExpression() instanceof KtSimpleNameExpression;
    }

    private final boolean logicalChain(KtExpression expr) {
        KtExpression context2 = expr;
        PsiElement parent2 = context2.getParent();
        while (parent2 instanceof KtParenthesizedExpression) {
            context2 = (KtExpression)parent2;
            parent2 = ((KtParenthesizedExpression)context2).getParent();
        }
        if (parent2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getRight(), (Object)context2)) {
            IElementType iElementType = ((KtBinaryExpression)parent2).getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"parent.operationToken");
            IElementType token = iElementType;
            return Intrinsics.areEqual((Object)token, (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)token, (Object)KtTokens.OROR);
        }
        return false;
    }

    private final boolean isCompilationWarning(KtElement anchor) {
        boolean bl;
        block4: {
            BindingContext context2 = ResolutionUtils.analyze((KtElement)anchor, (BodyResolveMode)BodyResolveMode.FULL);
            Iterable $this$any$iv = context2.getDiagnostics().forElement((PsiElement)anchor);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.CAST_NEVER_SUCCEEDS) || Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.SENSELESS_COMPARISON) || Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.SENSELESS_NULL_IN_WHEN) || Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.USELESS_IS_CHECK) || Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.DUPLICATE_LABEL_IN_WHEN))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        PsiFile rootElement = anchor.getContainingFile();
        Project project2 = anchor.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"anchor.project");
        KotlinSuppressCache suppressionCache = KotlinCacheService.Companion.getInstance(project2).getSuppressionCache();
        PsiFile psiFile2 = rootElement;
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"rootElement");
        return suppressionCache.isSuppressed((Object)anchor, (Object)psiFile2, "CAST_NEVER_SUCCEEDS", Severity.WARNING) || suppressionCache.isSuppressed((Object)anchor, (Object)rootElement, "SENSELESS_COMPARISON", Severity.WARNING) || suppressionCache.isSuppressed((Object)anchor, (Object)rootElement, "SENSELESS_NULL_IN_WHEN", Severity.WARNING) || suppressionCache.isSuppressed((Object)anchor, (Object)rootElement, "USELESS_IS_CHECK", Severity.WARNING) || suppressionCache.isSuppressed((Object)anchor, (Object)rootElement, "DUPLICATE_LABEL_IN_WHEN", Severity.WARNING);
    }

    private final boolean shouldSuppressWhenCondition(ConstantValue cv, KtWhenCondition condition2) {
        if (cv != ConstantValue.FALSE && cv != ConstantValue.TRUE) {
            return true;
        }
        if (cv == ConstantValue.TRUE && this.isLastCondition(condition2)) {
            return true;
        }
        if (condition2.getTextLength() == 0) {
            return true;
        }
        return this.isCompilationWarning((KtElement)condition2);
    }

    private final boolean isLastCondition(KtWhenCondition condition2) {
        PsiElement psiElement2 = condition2.getParent();
        if (!(psiElement2 instanceof KtWhenEntry)) {
            psiElement2 = null;
        }
        KtWhenEntry ktWhenEntry = (KtWhenEntry)psiElement2;
        if (ktWhenEntry == null) {
            return false;
        }
        KtWhenEntry entry = ktWhenEntry;
        PsiElement psiElement3 = entry.getParent();
        if (!(psiElement3 instanceof KtWhenExpression)) {
            psiElement3 = null;
        }
        KtWhenExpression ktWhenExpression = (KtWhenExpression)psiElement3;
        if (ktWhenExpression == null) {
            return false;
        }
        KtWhenExpression whenExpr = ktWhenExpression;
        Object[] objectArray = entry.getConditions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"entry.conditions");
        if (Intrinsics.areEqual((Object)((KtWhenCondition)ArraysKt.last((Object[])objectArray)), (Object)condition2)) {
            List list2 = whenExpr.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"whenExpr.entries");
            List entries = list2;
            KtWhenEntry lastEntry = (KtWhenEntry)CollectionsKt.last((List)entries);
            if (Intrinsics.areEqual((Object)lastEntry, (Object)entry)) {
                return true;
            }
            int size = entries.size();
            KtWhenEntry ktWhenEntry2 = lastEntry;
            Intrinsics.checkNotNullExpressionValue((Object)ktWhenEntry2, (String)"lastEntry");
            if (ktWhenEntry2.isElse() && size > 1 && Intrinsics.areEqual((Object)((KtWhenEntry)entries.get(size - 2)), (Object)entry)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void access$processDataflowAnalysis(KotlinConstantConditionsInspection $this, DfaValueFactory factory2, KtExpression body2, ProblemsHolder holder, Collection states) {
        $this.processDataflowAnalysis(factory2, body2, holder, states);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$ConstantValue;", "", "(Ljava/lang/String;I)V", "TRUE", "FALSE", "NULL", "ZERO", "UNKNOWN", "kotlin.idea"})
    private static final class ConstantValue
    extends Enum<ConstantValue> {
        public static final /* enum */ ConstantValue TRUE;
        public static final /* enum */ ConstantValue FALSE;
        public static final /* enum */ ConstantValue NULL;
        public static final /* enum */ ConstantValue ZERO;
        public static final /* enum */ ConstantValue UNKNOWN;
        private static final /* synthetic */ ConstantValue[] $VALUES;

        static {
            ConstantValue[] constantValueArray = new ConstantValue[5];
            ConstantValue[] constantValueArray2 = constantValueArray;
            constantValueArray[0] = TRUE = new ConstantValue();
            constantValueArray[1] = FALSE = new ConstantValue();
            constantValueArray[2] = NULL = new ConstantValue();
            constantValueArray[3] = ZERO = new ConstantValue();
            constantValueArray[4] = UNKNOWN = new ConstantValue();
            $VALUES = constantValueArray;
        }

        public static ConstantValue[] values() {
            return (ConstantValue[])$VALUES.clone();
        }

        public static ConstantValue valueOf(String string) {
            return Enum.valueOf(ConstantValue.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J(\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0012H\u0002R-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR-\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0004j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$KotlinDfaListener;", "Lcom/intellij/codeInspection/dataFlow/lang/DfaListener;", "()V", "constantConditions", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinAnchor;", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$ConstantValue;", "Lkotlin/collections/HashMap;", "getConstantConditions", "()Ljava/util/HashMap;", "problems", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinProblem;", "Lcom/intellij/util/ThreeState;", "getProblems", "beforePush", "", "args", "", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "value", "anchor", "Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;", "state", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "([Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;)V", "onCondition", "problem", "Lcom/intellij/codeInspection/dataFlow/lang/UnsatisfiedConditionProblem;", "failed", "recordExpressionValue", "kotlin.idea"})
    private static final class KotlinDfaListener
    implements DfaListener {
        @NotNull
        private final HashMap<KotlinAnchor, ConstantValue> constantConditions = new HashMap();
        @NotNull
        private final HashMap<KotlinProblem, ThreeState> problems = new HashMap();

        @NotNull
        public final HashMap<KotlinAnchor, ConstantValue> getConstantConditions() {
            return this.constantConditions;
        }

        @NotNull
        public final HashMap<KotlinProblem, ThreeState> getProblems() {
            return this.problems;
        }

        public void beforePush(@NotNull DfaValue[] args, @NotNull DfaValue value2, @NotNull DfaAnchor anchor, @NotNull DfaMemoryState state) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (anchor instanceof KotlinAnchor) {
                this.recordExpressionValue((KotlinAnchor)anchor, state, value2);
            }
        }

        public void onCondition(@NotNull UnsatisfiedConditionProblem problem, @NotNull DfaValue value2, @NotNull ThreeState failed, @NotNull DfaMemoryState state) {
            Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)failed, (String)"failed");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (problem instanceof KotlinProblem) {
                Object object = onCondition.1.INSTANCE;
                if (object != null) {
                    Function2 function2 = object;
                    object = new BiFunction(function2){
                        private final /* synthetic */ Function2 function;
                        {
                            this.function = function2;
                        }

                        public final /* synthetic */ Object apply(Object p0, Object p1) {
                            return this.function.invoke(p0, p1);
                        }
                    };
                }
                this.problems.merge((KotlinProblem)problem, failed, (BiFunction)object);
            }
        }

        private final void recordExpressionValue(KotlinAnchor anchor, DfaMemoryState state, DfaValue value2) {
            Number constVal;
            ConstantValue newVal;
            ConstantValue oldVal = this.constantConditions.get(anchor);
            if (oldVal == ConstantValue.UNKNOWN) {
                return;
            }
            DfType dfType = state.getDfType(value2);
            Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"state.getDfType(value)");
            DfType dfType2 = dfType;
            ConstantValue constantValue = Intrinsics.areEqual((Object)dfType2, (Object)DfTypes.TRUE) ? ConstantValue.TRUE : (Intrinsics.areEqual((Object)dfType2, (Object)DfTypes.FALSE) ? ConstantValue.FALSE : (Intrinsics.areEqual((Object)dfType2, (Object)DfTypes.NULL) ? ConstantValue.NULL : (newVal = (constVal = (Number)dfType2.getConstantOfType(Number.class)) != null && (Intrinsics.areEqual((Object)constVal, (Object)0) || Intrinsics.areEqual((Object)constVal, (Object)0L)) ? ConstantValue.ZERO : ConstantValue.UNKNOWN)));
            if (oldVal != null && oldVal != newVal) {
                newVal = ConstantValue.UNKNOWN;
            }
            ((Map)this.constantConditions).put(anchor, newVal);
        }
    }
}

