/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AddAnnotationFix;
import org.jetbrains.kotlin.idea.quickfix.AddFileAnnotationFix;
import org.jetbrains.kotlin.idea.quickfix.ExperimentalFixesFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.MakeModuleExperimentalFix;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0007\u0015\u0016\u0017\u0018\u0019\u001a\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0004R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ExperimentalFixesFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "OPT_IN_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getOPT_IN_FQ_NAME", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/name/FqName;", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "findFileAnnotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "annotationFqName", "fqNameIsExisting", "", "fqName", "HighPriorityPropagateOptInAnnotationFix", "HighPriorityUseOptInAnnotationFix", "HighPriorityUseOptInFileAnnotationFix", "LowPriorityMakeModuleExperimentalFix", "PropagateOptInAnnotationFix", "UseOptInAnnotationFix", "UseOptInFileAnnotationFix", "kotlin.idea"})
public final class ExperimentalFixesFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final ExperimentalFixesFactory INSTANCE;

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        KtClassOrObject containingClassOrObject;
        UseOptInAnnotationFix useOptInAnnotationFix;
        AddAnnotationFix.Kind kind2;
        ExperimentalFixesFactory experimentalFixesFactory;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement element3 = diagnostic.getPsiElement();
        KtDeclaration ktDeclaration = (KtDeclaration)PsiUtilsKt.getParentOfTypesAndPredicate((PsiElement)element3, (boolean)true, (Class[])new Class[]{KtDeclarationWithBody.class, KtClassOrObject.class, KtProperty.class, KtTypeAlias.class}, (Function1)doCreateActions.containingDeclaration.1.INSTANCE);
        if (ktDeclaration == null) {
            return CollectionsKt.emptyList();
        }
        KtDeclaration containingDeclaration2 = ktDeclaration;
        boolean containingDeclarationIsConstructor = containingDeclaration2 instanceof KtConstructor;
        DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
        Object object = Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.OPT_IN_USAGE) ? (FqName)((DiagnosticWithParameters2)Errors.OPT_IN_USAGE.cast((UnboundDiagnostic)diagnostic)).getA() : (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.OPT_IN_USAGE_ERROR) ? (FqName)((DiagnosticWithParameters2)Errors.OPT_IN_USAGE_ERROR.cast((UnboundDiagnostic)diagnostic)).getA() : (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.OPT_IN_OVERRIDE) ? (FqName)((DiagnosticWithParameters2)Errors.OPT_IN_OVERRIDE.cast((UnboundDiagnostic)diagnostic)).getA() : (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.OPT_IN_OVERRIDE_ERROR) ? (FqName)((DiagnosticWithParameters2)Errors.OPT_IN_OVERRIDE_ERROR.cast((UnboundDiagnostic)diagnostic)).getA() : null)));
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when (diagnostic.factory\u2026  } ?: return emptyList()");
        FqName annotationFqName = object;
        boolean isOverrideError = Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.OPT_IN_OVERRIDE_ERROR) || Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.OPT_IN_OVERRIDE);
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)containingDeclaration2, null, (int)1, null);
        if (declarationDescriptor == null || (declarationDescriptor = DescriptorUtilsKt.getModule((DeclarationDescriptor)declarationDescriptor)) == null) {
            return CollectionsKt.emptyList();
        }
        DeclarationDescriptor moduleDescriptor = declarationDescriptor;
        ClassDescriptor classDescriptor = DescriptorUtilKt.resolveClassByFqName((ModuleDescriptor)moduleDescriptor, (FqName)annotationFqName, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE));
        if (classDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ClassDescriptor annotationClassDescriptor = classDescriptor;
        Set set2 = AnnotationChecker.Companion.applicableTargetSet(annotationClassDescriptor);
        if (set2 == null) {
            set2 = KotlinTarget.Companion.getDEFAULT_TARGET_SET();
        }
        Set applicableTargets = set2;
        PsiElement psiElement2 = element3;
        BindingContext context2 = psiElement2 instanceof KtElement ? ResolutionUtils.analyze$default((KtElement)((KtElement)element3), null, (int)1, null) : ResolutionUtils.analyze$default((KtElement)((KtElement)containingDeclaration2), null, (int)1, null);
        var $fun$isApplicableTo$1 = new Function2<KtDeclaration, Set<? extends KotlinTarget>, Boolean>(context2){
            final /* synthetic */ BindingContext $context;

            public final boolean invoke(@NotNull KtDeclaration declaration2, @NotNull Set<? extends KotlinTarget> applicableTargets) {
                boolean bl;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    Intrinsics.checkNotNullParameter(applicableTargets, (String)"applicableTargets");
                    KtElement ktElement = (KtElement)declaration2;
                    DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor(declaration2);
                    if (!(declarationDescriptor instanceof ClassDescriptor)) {
                        declarationDescriptor = null;
                    }
                    List actualTargetList = AnnotationChecker.Companion.getDeclarationSiteActualTargetList(ktElement, (ClassDescriptor)declarationDescriptor, this.$context);
                    Iterable $this$any$iv = actualTargetList;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            KotlinTarget it = (KotlinTarget)element$iv;
                            boolean bl2 = false;
                            if (!applicableTargets.contains(it)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$context = bindingContext2;
                super(2);
            }
        };
        List result2 = new ArrayList();
        ExperimentalFixesFactory $this$run = experimentalFixesFactory = this;
        boolean bl = false;
        AddAnnotationFix.Kind kind3 = kind2 = containingDeclarationIsConstructor ? (AddAnnotationFix.Kind)AddAnnotationFix.Kind.Constructor.INSTANCE : (AddAnnotationFix.Kind)new AddAnnotationFix.Kind.Declaration(containingDeclaration2.getName());
        if ($fun$isApplicableTo$1.invoke(containingDeclaration2, applicableTargets)) {
            result2.add(isOverrideError ? (PropagateOptInAnnotationFix)new HighPriorityPropagateOptInAnnotationFix(containingDeclaration2, annotationFqName, kind2, null, 8, null) : new PropagateOptInAnnotationFix(containingDeclaration2, annotationFqName, kind2, null, 8, null));
        }
        if (isOverrideError) {
            KtAnnotationEntry ktAnnotationEntry = ModifierListModifactorKt.findAnnotation((KtAnnotated)containingDeclaration2, $this$run.getOPT_IN_FQ_NAME((ModuleDescriptor)moduleDescriptor));
            useOptInAnnotationFix = new UseOptInAnnotationFix(containingDeclaration2, (ModuleDescriptor)moduleDescriptor, kind2, annotationFqName, (SmartPsiElementPointer<KtAnnotationEntry>)(ktAnnotationEntry != null ? PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)ktAnnotationEntry)) : null));
        } else {
            KtAnnotationEntry ktAnnotationEntry = ModifierListModifactorKt.findAnnotation((KtAnnotated)containingDeclaration2, $this$run.getOPT_IN_FQ_NAME((ModuleDescriptor)moduleDescriptor));
            useOptInAnnotationFix = new HighPriorityUseOptInAnnotationFix(containingDeclaration2, (ModuleDescriptor)moduleDescriptor, kind2, annotationFqName, (SmartPsiElementPointer<KtAnnotationEntry>)(ktAnnotationEntry != null ? PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)ktAnnotationEntry)) : null));
        }
        result2.add(useOptInAnnotationFix);
        if (containingDeclaration2 instanceof KtCallableDeclaration && (containingClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)containingDeclaration2)) != null) {
            UseOptInAnnotationFix useOptInAnnotationFix2;
            AddAnnotationFix.Kind.ContainingClass kind4 = new AddAnnotationFix.Kind.ContainingClass(containingClassOrObject.getName());
            boolean applicableToContainingClassOrObject = $fun$isApplicableTo$1.invoke((KtDeclaration)containingClassOrObject, applicableTargets);
            if (applicableToContainingClassOrObject) {
                result2.add(isOverrideError ? (PropagateOptInAnnotationFix)new HighPriorityPropagateOptInAnnotationFix((KtDeclaration)containingClassOrObject, annotationFqName, kind4, null, 8, null) : new PropagateOptInAnnotationFix((KtDeclaration)containingClassOrObject, annotationFqName, kind4, null, 8, null));
            }
            if (isOverrideError) {
                KtAnnotationEntry ktAnnotationEntry = ModifierListModifactorKt.findAnnotation((KtAnnotated)containingDeclaration2, this.getOPT_IN_FQ_NAME((ModuleDescriptor)moduleDescriptor));
                useOptInAnnotationFix2 = new UseOptInAnnotationFix((KtDeclaration)containingClassOrObject, (ModuleDescriptor)moduleDescriptor, (AddAnnotationFix.Kind)kind4, annotationFqName, (SmartPsiElementPointer<KtAnnotationEntry>)(ktAnnotationEntry != null ? PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)ktAnnotationEntry)) : null));
            } else {
                KtAnnotationEntry ktAnnotationEntry = ModifierListModifactorKt.findAnnotation((KtAnnotated)containingDeclaration2, this.getOPT_IN_FQ_NAME((ModuleDescriptor)moduleDescriptor));
                useOptInAnnotationFix2 = new HighPriorityUseOptInAnnotationFix((KtDeclaration)containingClassOrObject, (ModuleDescriptor)moduleDescriptor, (AddAnnotationFix.Kind)kind4, annotationFqName, (SmartPsiElementPointer<KtAnnotationEntry>)(ktAnnotationEntry != null ? PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)ktAnnotationEntry)) : null));
            }
            result2.add(useOptInAnnotationFix2);
        }
        KtFile ktFile = containingDeclaration2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"containingDeclaration.containingKtFile");
        KtFile containingFile = ktFile;
        Module module2 = ProjectStructureUtilKt.getModule((PsiElement)containingFile);
        if (module2 != null) {
            result2.add(new LowPriorityMakeModuleExperimentalFix(containingFile, module2, annotationFqName));
        }
        KtAnnotationEntry ktAnnotationEntry = this.findFileAnnotation(containingFile, this.getOPT_IN_FQ_NAME((ModuleDescriptor)moduleDescriptor));
        result2.add(new UseOptInFileAnnotationFix(containingFile, (ModuleDescriptor)moduleDescriptor, annotationFqName, (SmartPsiElementPointer<KtAnnotationEntry>)(ktAnnotationEntry != null ? PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)ktAnnotationEntry)) : null)));
        return result2;
    }

    private final FqName getOPT_IN_FQ_NAME(ModuleDescriptor $this$OPT_IN_FQ_NAME) {
        FqName fqName2;
        FqName it = fqName2 = OptInNames.INSTANCE.getOPT_IN_FQ_NAME();
        boolean bl = false;
        Object object = INSTANCE.fqNameIsExisting($this$OPT_IN_FQ_NAME, it) ? fqName2 : null;
        if (object == null) {
            object = OptInNames.INSTANCE.getOLD_USE_EXPERIMENTAL_FQ_NAME();
        }
        return object;
    }

    private final KtAnnotationEntry findFileAnnotation(KtFile file2, FqName annotationFqName) {
        KtAnnotationEntry ktAnnotationEntry;
        BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)file2), (BodyResolveMode)BodyResolveMode.PARTIAL);
        Object object = file2.getFileAnnotationList();
        if (object != null && (object = object.getAnnotationEntries()) != null) {
            Object v2;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                    boolean bl = false;
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)entry);
                    if (!Intrinsics.areEqual((Object)(annotationDescriptor != null ? annotationDescriptor.getFqName() : null), (Object)annotationFqName)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            ktAnnotationEntry = v2;
        } else {
            ktAnnotationEntry = null;
        }
        return ktAnnotationEntry;
    }

    public final boolean fqNameIsExisting(@NotNull ModuleDescriptor $this$fqNameIsExisting, @NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)$this$fqNameIsExisting, (String)"$this$fqNameIsExisting");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return DescriptorUtilKt.resolveClassByFqName((ModuleDescriptor)$this$fqNameIsExisting, (FqName)fqName2, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE)) != null;
    }

    private ExperimentalFixesFactory() {
    }

    static {
        ExperimentalFixesFactory experimentalFixesFactory;
        INSTANCE = experimentalFixesFactory = new ExperimentalFixesFactory();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f0\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ExperimentalFixesFactory$UseOptInAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "argumentClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/SmartPsiElementPointer;)V", "elementName", "", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/util/NlsSafe;", "getFamilyName", "getText", "kotlin.idea"})
    private static class UseOptInAnnotationFix
    extends AddAnnotationFix {
        private final String elementName;
        private final AddAnnotationFix.Kind kind;
        private final FqName argumentClassFqName;

        @Override
        @NotNull
        public String getText() {
            String string;
            String string2 = this.argumentClassFqName.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"argumentClassFqName.shortName().asString()");
            String argumentText2 = string2;
            AddAnnotationFix.Kind kind2 = this.kind;
            if (Intrinsics.areEqual((Object)kind2, (Object)AddAnnotationFix.Kind.Self.INSTANCE)) {
                string = KotlinBundle.message("fix.opt_in.text.use.declaration", argumentText2, this.elementName);
            } else if (Intrinsics.areEqual((Object)kind2, (Object)AddAnnotationFix.Kind.Constructor.INSTANCE)) {
                string = KotlinBundle.message("fix.opt_in.text.use.constructor", argumentText2);
            } else if (kind2 instanceof AddAnnotationFix.Kind.Declaration) {
                Object[] objectArray = new Object[2];
                objectArray[0] = argumentText2;
                String string3 = ((AddAnnotationFix.Kind.Declaration)this.kind).getName();
                if (string3 == null) {
                    string3 = "?";
                }
                objectArray[1] = string3;
                string = KotlinBundle.message("fix.opt_in.text.use.declaration", objectArray);
            } else if (kind2 instanceof AddAnnotationFix.Kind.ContainingClass) {
                Object[] objectArray = new Object[2];
                objectArray[0] = argumentText2;
                String string4 = ((AddAnnotationFix.Kind.ContainingClass)this.kind).getName();
                if (string4 == null) {
                    string4 = "?";
                }
                objectArray[1] = string4;
                string = KotlinBundle.message("fix.opt_in.text.use.containing.class", objectArray);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("fix.opt_in.annotation.family", new Object[0]);
        }

        public UseOptInAnnotationFix(@NotNull KtDeclaration element3, @NotNull ModuleDescriptor moduleDescriptor, @NotNull AddAnnotationFix.Kind kind2, @NotNull FqName argumentClassFqName, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)argumentClassFqName, (String)"argumentClassFqName");
            super((KtModifierListOwner)element3, INSTANCE.getOPT_IN_FQ_NAME(moduleDescriptor), kind2, argumentClassFqName, existingAnnotationEntry);
            this.kind = kind2;
            this.argumentClassFqName = argumentClassFqName;
            String string = element3.getName();
            if (string == null) {
                string = "?";
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.name ?: \"?\"");
            this.elementName = string;
        }

        public /* synthetic */ UseOptInAnnotationFix(KtDeclaration ktDeclaration, ModuleDescriptor moduleDescriptor, AddAnnotationFix.Kind kind2, FqName fqName2, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                smartPsiElementPointer = null;
            }
            this(ktDeclaration, moduleDescriptor, kind2, fqName2, (SmartPsiElementPointer<KtAnnotationEntry>)smartPsiElementPointer);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ExperimentalFixesFactory$HighPriorityUseOptInAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ExperimentalFixesFactory$UseOptInAnnotationFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "argumentClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/SmartPsiElementPointer;)V", "kotlin.idea"})
    private static final class HighPriorityUseOptInAnnotationFix
    extends UseOptInAnnotationFix
    implements HighPriorityAction {
        public HighPriorityUseOptInAnnotationFix(@NotNull KtDeclaration element3, @NotNull ModuleDescriptor moduleDescriptor, @NotNull AddAnnotationFix.Kind kind2, @NotNull FqName argumentClassFqName, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)argumentClassFqName, (String)"argumentClassFqName");
            super(element3, moduleDescriptor, kind2, argumentClassFqName, existingAnnotationEntry);
        }

        public /* synthetic */ HighPriorityUseOptInAnnotationFix(KtDeclaration ktDeclaration, ModuleDescriptor moduleDescriptor, AddAnnotationFix.Kind kind2, FqName fqName2, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                smartPsiElementPointer = null;
            }
            this(ktDeclaration, moduleDescriptor, kind2, fqName2, (SmartPsiElementPointer<KtAnnotationEntry>)smartPsiElementPointer);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ExperimentalFixesFactory$UseOptInFileAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddFileAnnotationFix;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "argumentClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/SmartPsiElementPointer;)V", "fileName", "", "Lorg/jetbrains/annotations/NotNull;", "getFamilyName", "getText", "kotlin.idea"})
    private static class UseOptInFileAnnotationFix
    extends AddFileAnnotationFix {
        private final String fileName;
        private final FqName argumentClassFqName;

        @Override
        @NotNull
        public String getText() {
            String string = this.argumentClassFqName.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"argumentClassFqName.shortName().asString()");
            String argumentText2 = string;
            return KotlinBundle.message("fix.opt_in.text.use.containing.file", argumentText2, this.fileName);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("fix.opt_in.annotation.family", new Object[0]);
        }

        public UseOptInFileAnnotationFix(@NotNull KtFile file2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull FqName argumentClassFqName, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            Intrinsics.checkNotNullParameter((Object)argumentClassFqName, (String)"argumentClassFqName");
            super(file2, INSTANCE.getOPT_IN_FQ_NAME(moduleDescriptor), argumentClassFqName, existingAnnotationEntry);
            this.argumentClassFqName = argumentClassFqName;
            String string = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            this.fileName = string;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ExperimentalFixesFactory$HighPriorityUseOptInFileAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ExperimentalFixesFactory$UseOptInFileAnnotationFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "argumentClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/SmartPsiElementPointer;)V", "kotlin.idea"})
    private static class HighPriorityUseOptInFileAnnotationFix
    extends UseOptInFileAnnotationFix
    implements HighPriorityAction {
        public HighPriorityUseOptInFileAnnotationFix(@NotNull KtFile file2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull FqName argumentClassFqName, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            Intrinsics.checkNotNullParameter((Object)argumentClassFqName, (String)"argumentClassFqName");
            super(file2, moduleDescriptor, argumentClassFqName, existingAnnotationEntry);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ExperimentalFixesFactory$PropagateOptInAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getFamilyName", "", "getText", "kotlin.idea"})
    private static class PropagateOptInAnnotationFix
    extends AddAnnotationFix {
        private final FqName annotationFqName;
        private final AddAnnotationFix.Kind kind;

        @Override
        @NotNull
        public String getText() {
            String string;
            String string2 = this.annotationFqName.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"annotationFqName.shortName().asString()");
            String argumentText2 = string2;
            AddAnnotationFix.Kind kind2 = this.kind;
            if (Intrinsics.areEqual((Object)kind2, (Object)AddAnnotationFix.Kind.Self.INSTANCE)) {
                string = KotlinBundle.message("fix.opt_in.text.propagate.declaration", argumentText2, "?");
            } else if (Intrinsics.areEqual((Object)kind2, (Object)AddAnnotationFix.Kind.Constructor.INSTANCE)) {
                string = KotlinBundle.message("fix.opt_in.text.propagate.constructor", argumentText2);
            } else if (kind2 instanceof AddAnnotationFix.Kind.Declaration) {
                Object[] objectArray = new Object[2];
                objectArray[0] = argumentText2;
                String string3 = ((AddAnnotationFix.Kind.Declaration)this.kind).getName();
                if (string3 == null) {
                    string3 = "?";
                }
                objectArray[1] = string3;
                string = KotlinBundle.message("fix.opt_in.text.propagate.declaration", objectArray);
            } else if (kind2 instanceof AddAnnotationFix.Kind.ContainingClass) {
                Object[] objectArray = new Object[2];
                objectArray[0] = argumentText2;
                String string4 = ((AddAnnotationFix.Kind.ContainingClass)this.kind).getName();
                if (string4 == null) {
                    string4 = "?";
                }
                objectArray[1] = string4;
                string = KotlinBundle.message("fix.opt_in.text.propagate.containing.class", objectArray);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("fix.opt_in.annotation.family", new Object[0]);
        }

        public PropagateOptInAnnotationFix(@NotNull KtDeclaration element3, @NotNull FqName annotationFqName, @NotNull AddAnnotationFix.Kind kind2, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            super((KtModifierListOwner)element3, annotationFqName, AddAnnotationFix.Kind.Self.INSTANCE, null, existingAnnotationEntry);
            this.annotationFqName = annotationFqName;
            this.kind = kind2;
        }

        public /* synthetic */ PropagateOptInAnnotationFix(KtDeclaration ktDeclaration, FqName fqName2, AddAnnotationFix.Kind kind2, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                smartPsiElementPointer = null;
            }
            this(ktDeclaration, fqName2, kind2, (SmartPsiElementPointer<KtAnnotationEntry>)smartPsiElementPointer);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ExperimentalFixesFactory$HighPriorityPropagateOptInAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ExperimentalFixesFactory$PropagateOptInAnnotationFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;Lcom/intellij/psi/SmartPsiElementPointer;)V", "kotlin.idea"})
    private static final class HighPriorityPropagateOptInAnnotationFix
    extends PropagateOptInAnnotationFix
    implements HighPriorityAction {
        public HighPriorityPropagateOptInAnnotationFix(@NotNull KtDeclaration element3, @NotNull FqName annotationFqName, @NotNull AddAnnotationFix.Kind kind2, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            super(element3, annotationFqName, kind2, existingAnnotationEntry);
        }

        public /* synthetic */ HighPriorityPropagateOptInAnnotationFix(KtDeclaration ktDeclaration, FqName fqName2, AddAnnotationFix.Kind kind2, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                smartPsiElementPointer = null;
            }
            this(ktDeclaration, fqName2, kind2, (SmartPsiElementPointer<KtAnnotationEntry>)smartPsiElementPointer);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ExperimentalFixesFactory$LowPriorityMakeModuleExperimentalFix;", "Lorg/jetbrains/kotlin/idea/quickfix/MakeModuleExperimentalFix;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "module", "Lcom/intellij/openapi/module/Module;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/name/FqName;)V", "kotlin.idea"})
    private static final class LowPriorityMakeModuleExperimentalFix
    extends MakeModuleExperimentalFix
    implements LowPriorityAction {
        public LowPriorityMakeModuleExperimentalFix(@NotNull KtFile file2, @NotNull Module module2, @NotNull FqName annotationFqName) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
            super(file2, module2, annotationFqName);
        }
    }
}

