/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.DescriptorUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring$WhenMappings;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u0000 (*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003:\u0001(B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\b\u0010\u001b\u001a\u00020\u0018H\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH$J\u0006\u0010!\u001a\u00020\u0018J,\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d2\u0006\u0010%\u001a\u00020\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0'H\u0002R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring;", "T", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "callableDescriptor", "commandName", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Ljava/lang/String;)V", "getCallableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getCommandName", "()Ljava/lang/String;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "kind", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "getProject", "()Lcom/intellij/openapi/project/Project;", "checkModifiable", "", "element", "Lcom/intellij/psi/PsiElement;", "forcePerformForSelectedFunctionOnly", "getClosestModifiableDescriptors", "", "performRefactoring", "", "descriptorsForChange", "run", "showSuperFunctionWarningDialog", "", "superCallables", "callableFromEditor", "options", "", "Companion", "kotlin.idea"})
public abstract class CallableRefactoring<T extends CallableDescriptor> {
    private final CallableMemberDescriptor.Kind kind;
    @NotNull
    private final Project project;
    @Nullable
    private final Editor editor;
    @NotNull
    private final T callableDescriptor;
    @NotNull
    private final String commandName;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    protected boolean forcePerformForSelectedFunctionOnly() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<CallableDescriptor> getClosestModifiableDescriptors() {
        void $this$mapTo$iv$iv;
        Collection<CallableMemberDescriptor> collection;
        switch (CallableRefactoring$WhenMappings.$EnumSwitchMapping$0[this.kind.ordinal()]) {
            case 1: {
                collection = SetsKt.setOf(this.callableDescriptor);
                break;
            }
            case 2: 
            case 3: {
                T t = this.callableDescriptor;
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
                }
                collection = DescriptorUtilsKt.getDirectlyOverriddenDeclarations((CallableMemberDescriptor)t);
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unexpected callable kind: " + this.kind);
            }
        }
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CallableDescriptor callableDescriptor;
            void it;
            CallableDescriptor callableDescriptor2 = (CallableDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            DeclarationDescriptor declarationDescriptor = ExpectActualUtilKt.liftToExpected((DeclarationDescriptor)it);
            if (!(declarationDescriptor instanceof CallableDescriptor)) {
                declarationDescriptor = null;
            }
            if ((callableDescriptor = (CallableDescriptor)declarationDescriptor) == null) {
                callableDescriptor = it;
            }
            CallableDescriptor callableDescriptor3 = callableDescriptor;
            collection2.add(callableDescriptor3);
        }
        return (List)destination$iv$iv;
    }

    private final int showSuperFunctionWarningDialog(Collection<? extends CallableDescriptor> superCallables, CallableDescriptor callableFromEditor, List<String> options2) {
        Function1 function1 = showSuperFunctionWarningDialog.superString.1.INSTANCE;
        CharSequence charSequence = null;
        int n = 0;
        CharSequence charSequence2 = ".\n\n";
        CharSequence charSequence3 = ",\n    ";
        CharSequence charSequence4 = "\n    ";
        String superString2 = CollectionsKt.joinToString$default((Iterable)superCallables, (CharSequence)charSequence3, (CharSequence)charSequence4, (CharSequence)charSequence2, (int)n, charSequence, (Function1)function1, (int)24, null);
        String message2 = KotlinBundle.message("override.declaration.x.overrides.y.in.class.list", DescriptorRenderer.COMPACT.render((DeclarationDescriptor)callableFromEditor), superString2, "refactor");
        String string = IdeBundle.message((String)"title.warning", (Object[])new Object[0]);
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"title.warning\")!!");
        String title = string;
        Icon icon2 = Messages.getQuestionIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Messages.getQuestionIcon()");
        Icon icon3 = icon2;
        Collection $this$toTypedArray$iv = options2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return Messages.showDialog((String)message2, (String)title, (String[])stringArray, (int)0, (Icon)icon3);
    }

    protected final boolean checkModifiable(@NotNull PsiElement element3) {
        String unmodifiableFileName;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (KotlinRefactoringUtilKt.canRefactor(element3)) {
            return true;
        }
        PsiFile psiFile2 = element3.getContainingFile();
        String string = unmodifiableFileName = psiFile2 != null ? psiFile2.getName() : null;
        if (unmodifiableFileName != null) {
            String string2 = RefactoringBundle.message((String)"refactoring.cannot.be.performed");
            Object[] objectArray = new Object[2];
            String string3 = DescriptiveNameUtil.getDescriptiveName((PsiElement)element3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DescriptiveNameUtil.getDescriptiveName(element)");
            objectArray[0] = string3;
            objectArray[1] = unmodifiableFileName;
            String message2 = string2 + "\n" + KotlinBundle.message("error.hint.cannot.modify.0.declaration.from.1.file", objectArray);
            CommonRefactoringUtil.showErrorHint((Project)this.project, (Editor)this.editor, (String)message2, (String)CommonBundle.getErrorTitle(), null);
        } else {
            LOG.error("Could not find file for Psi element: " + element3.getText());
        }
        return false;
    }

    protected abstract void performRefactoring(@NotNull Collection<? extends CallableDescriptor> var1);

    public final boolean run() {
        Object object;
        boolean bl;
        run.1 $fun$buttonPressed$1 = run.1.INSTANCE;
        run.2 $fun$performForWholeHierarchy$2 = run.2.INSTANCE;
        run.3 $fun$performForSelectedFunctionOnly$3 = run.3.INSTANCE;
        run.4 $fun$buildDialogOptions$4 = run.4.INSTANCE;
        if (this.kind == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            LOG.error("Change signature refactoring should not be called for synthesized member " + this.callableDescriptor);
            return false;
        }
        Collection<CallableDescriptor> closestModifiableDescriptors = this.getClosestModifiableDescriptors();
        if (this.forcePerformForSelectedFunctionOnly()) {
            this.performRefactoring(closestModifiableDescriptors);
            return true;
        }
        boolean bl2 = bl = !closestModifiableDescriptors.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CallableRefactoring$run$62 = false;
            String $i$a$-assert-CallableRefactoring$run$62 = "Should contain original declaration or some of its super declarations";
            throw new AssertionError((Object)$i$a$-assert-CallableRefactoring$run$62);
        }
        T t = this.callableDescriptor;
        if (!(t instanceof CallableMemberDescriptor)) {
            t = null;
        }
        if ((object = (CallableMemberDescriptor)t) == null || (object = DescriptorUtilsKt.getDeepestSuperDeclarations$default(object, false, 1, null)) == null) {
            object = CollectionsKt.listOf(this.callableDescriptor);
        }
        Object deepestSuperDeclarations = object;
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            this.performRefactoring((Collection<CallableDescriptor>)deepestSuperDeclarations);
            return true;
        }
        if (closestModifiableDescriptors.size() == 1 && CollectionsKt.subtract((Iterable)((Iterable)deepestSuperDeclarations), (Iterable)closestModifiableDescriptors).isEmpty()) {
            this.performRefactoring(closestModifiableDescriptors);
            return true;
        }
        boolean isSingleFunctionSelected = closestModifiableDescriptors.size() == 1;
        T selectedFunction = isSingleFunctionSelected ? (CallableDescriptor)CollectionsKt.first((Iterable)closestModifiableDescriptors) : this.callableDescriptor;
        List<String> optionsForDialog = $fun$buildDialogOptions$4.invoke(isSingleFunctionSelected);
        int code = this.showSuperFunctionWarningDialog((Collection<? extends CallableDescriptor>)((Collection<CallableDescriptor>)deepestSuperDeclarations), (CallableDescriptor)selectedFunction, optionsForDialog);
        if ($fun$performForWholeHierarchy$2.invoke(optionsForDialog, code)) {
            this.performRefactoring((Collection<CallableDescriptor>)deepestSuperDeclarations);
        } else if ($fun$performForSelectedFunctionOnly$3.invoke(optionsForDialog, code)) {
            this.performRefactoring(closestModifiableDescriptors);
        } else {
            return false;
        }
        return true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final T getCallableDescriptor() {
        return this.callableDescriptor;
    }

    @NotNull
    public final String getCommandName() {
        return this.commandName;
    }

    public CallableRefactoring(@NotNull Project project2, @Nullable Editor editor2, @NotNull T callableDescriptor, @NlsContexts.Command @NotNull String commandName) {
        CallableMemberDescriptor callableMemberDescriptor;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(callableDescriptor, (String)"callableDescriptor");
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        this.project = project2;
        this.editor = editor2;
        this.callableDescriptor = callableDescriptor;
        this.commandName = commandName;
        T t = this.callableDescriptor;
        if (!(t instanceof CallableMemberDescriptor)) {
            t = null;
        }
        if ((callableMemberDescriptor = (CallableMemberDescriptor)t) == null || (callableMemberDescriptor = callableMemberDescriptor.getKind()) == null) {
            callableMemberDescriptor = CallableMemberDescriptor.Kind.DECLARATION;
        }
        Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"(callableDescriptor as? \u2026tor)?.kind ?: DECLARATION");
        this.kind = callableMemberDescriptor;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(CallableRefactoring.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Calla\u2026eRefactoring::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

