/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.stubindex.IndexUtilsKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinExtensionsByReceiverTypeIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinExtensionsInObjectsByReceiverTypeIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinJvmNameAnnotationIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinOverridableInternalMembersShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelExtensionsByReceiverTypeIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTypeAliasByExpansionShortNameIndex;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.KotlinCallableStubBase;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinModifierListStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyAccessorStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.kotlin.psi.stubs.KotlinTypeAliasStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u001a\u0010\u0014\u001a\u00020\r2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013\u001a&\u0010\u0017\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013\u001a0\u0010\u001a\u001a\u00020\r*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\r0!H\u0002\u001a,\u0010#\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f*\u00020$2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u001a\u0010%\u001a\u00020&\"\b\b\u0000\u0010\u000e*\u00020\u000f*\b\u0012\u0004\u0012\u0002H\u000e0\u0011\u001a\u0016\u0010'\u001a\u0004\u0018\u00010\"*\u00020(2\u0006\u0010)\u001a\u00020*H\u0002\u001a\u000e\u0010+\u001a\u0004\u0018\u00010\u0002*\u00020,H\u0002\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u0006\u0012\u0002\b\u00030\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006-"}, d2={"STRING_TEMPLATE_EMPTY_ARRAY", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "[Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "STRING_TEMPLATE_TYPES", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "modifierList", "Lorg/jetbrains/kotlin/psi/stubs/KotlinModifierListStub;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinStubWithFqName;", "getModifierList", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinStubWithFqName;)Lorg/jetbrains/kotlin/psi/stubs/KotlinModifierListStub;", "indexExtensionInObject", "", "TDeclaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinCallableStubBase;", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "indexInternals", "indexJvmNameAnnotation", "Lorg/jetbrains/kotlin/psi/stubs/KotlinAnnotationEntryStub;", "indexTopLevelExtension", "indexTypeAliasExpansion", "Lorg/jetbrains/kotlin/psi/stubs/KotlinTypeAliasStub;", "index", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "declaration", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "containingTypeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "occurrence", "Lkotlin/Function1;", "", "indexExtension", "Lorg/jetbrains/kotlin/idea/stubindex/KotlinExtensionsByReceiverTypeIndex;", "isDeclaredInObject", "", "stringFromAnnotation", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassUtil;", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "stringTemplateExpression", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "kotlin.core"})
public final class IndexUtilsKt {
    private static final KtStringTemplateExpression[] STRING_TEMPLATE_EMPTY_ARRAY = new KtStringTemplateExpression[0];
    private static final TokenSet STRING_TEMPLATE_TYPES;

    public static final <TDeclaration extends KtCallableDeclaration> void indexTopLevelExtension(@NotNull KotlinCallableStubBase<TDeclaration> stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        IndexUtilsKt.indexExtension(KotlinTopLevelExtensionsByReceiverTypeIndex.Companion.getINSTANCE(), stub, sink);
    }

    public static final <TDeclaration extends KtCallableDeclaration> void indexExtensionInObject(@NotNull KotlinCallableStubBase<TDeclaration> stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        IndexUtilsKt.indexExtension(KotlinExtensionsInObjectsByReceiverTypeIndex.Companion.getINSTANCE(), stub, sink);
    }

    private static final <TDeclaration extends KtCallableDeclaration> void indexExtension(KotlinExtensionsByReceiverTypeIndex $this$indexExtension, KotlinCallableStubBase<TDeclaration> stub, IndexSink sink) {
        block2: {
            KtCallableDeclaration declaration2;
            if (!stub.isExtension()) {
                return;
            }
            KtCallableDeclaration ktCallableDeclaration = declaration2 = (KtCallableDeclaration)stub.getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)ktCallableDeclaration, (String)"declaration");
            String string = ktCallableDeclaration.getName();
            if (string == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"declaration.name ?: return");
            String callableName = string;
            KtTypeReference ktTypeReference = declaration2.getReceiverTypeReference();
            Intrinsics.checkNotNull((Object)ktTypeReference);
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"declaration.receiverTypeReference!!");
            KtTypeReference containingTypeReference = ktTypeReference;
            KtTypeElement ktTypeElement = containingTypeReference.getTypeElement();
            if (ktTypeElement == null) break block2;
            IndexUtilsKt.index(ktTypeElement, (KtTypeParameterListOwner)declaration2, containingTypeReference, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>($this$indexExtension, sink, callableName){
                final /* synthetic */ KotlinExtensionsByReceiverTypeIndex $this_indexExtension;
                final /* synthetic */ IndexSink $sink;
                final /* synthetic */ String $callableName;

                public final void invoke(@NotNull String typeName) {
                    Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
                    this.$sink.occurrence(this.$this_indexExtension.getKey(), (Object)this.$this_indexExtension.buildKey(typeName, this.$callableName));
                }
                {
                    this.$this_indexExtension = kotlinExtensionsByReceiverTypeIndex;
                    this.$sink = indexSink;
                    this.$callableName = string;
                    super(1);
                }
            }));
        }
    }

    public static final void indexTypeAliasExpansion(@NotNull KotlinTypeAliasStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        KtTypeAlias declaration2 = (KtTypeAlias)stub.getPsi();
        KtTypeReference ktTypeReference = declaration2.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference2 = ktTypeReference;
        KtTypeElement ktTypeElement = typeReference2.getTypeElement();
        if (ktTypeElement == null) {
            return;
        }
        KtTypeElement typeElement = ktTypeElement;
        KtTypeAlias ktTypeAlias = declaration2;
        Intrinsics.checkNotNullExpressionValue((Object)ktTypeAlias, (String)"declaration");
        IndexUtilsKt.index(typeElement, (KtTypeParameterListOwner)ktTypeAlias, typeReference2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(sink){
            final /* synthetic */ IndexSink $sink;

            public final void invoke(@NotNull String typeName) {
                Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
                this.$sink.occurrence(KotlinTypeAliasByExpansionShortNameIndex.Companion.getKEY(), (Object)typeName);
            }
            {
                this.$sink = indexSink;
                super(1);
            }
        }));
    }

    private static final void index(KtTypeElement $this$index, KtTypeParameterListOwner declaration2, KtTypeReference containingTypeReference, Function1<? super String, Unit> occurrence) {
        index.1 $fun$indexWithVisited$1 = index.1.INSTANCE;
        $fun$indexWithVisited$1.invoke($this$index, declaration2, containingTypeReference, new LinkedHashSet(), occurrence);
    }

    public static final void indexInternals(@NotNull KotlinCallableStubBase<?> stub, @NotNull IndexSink sink) {
        block8: {
            String name2;
            block7: {
                Intrinsics.checkNotNullParameter(stub, (String)"stub");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                String string = stub.getName();
                if (string == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stub.name ?: return");
                name2 = string;
                KotlinModifierListStub kotlinModifierListStub = IndexUtilsKt.getModifierList((KotlinStubWithFqName)stub);
                if (kotlinModifierListStub == null) {
                    return;
                }
                KotlinModifierListStub modifierListStub = kotlinModifierListStub;
                KtModifierKeywordToken ktModifierKeywordToken = KtTokens.INTERNAL_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"KtTokens.INTERNAL_KEYWORD");
                if (!modifierListStub.hasModifier(ktModifierKeywordToken)) {
                    return;
                }
                if (stub.isTopLevel()) {
                    return;
                }
                KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.OPEN_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"KtTokens.OPEN_KEYWORD");
                if (modifierListStub.hasModifier(ktModifierKeywordToken2)) break block7;
                KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.ABSTRACT_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken3, (String)"KtTokens.ABSTRACT_KEYWORD");
                if (!modifierListStub.hasModifier(ktModifierKeywordToken3)) break block8;
            }
            sink.occurrence(KotlinOverridableInternalMembersShortNameIndex.Instance.getKey(), (Object)name2);
        }
    }

    private static final KtStringTemplateExpression stringTemplateExpression(ValueArgument $this$stringTemplateExpression) {
        KtExpression ktExpression;
        if ($this$stringTemplateExpression instanceof StubBasedPsiElement) {
            StubElement stubElement = ((StubBasedPsiElement)$this$stringTemplateExpression).getStub();
            if (stubElement != null) {
                StubElement stubElement2;
                StubElement it = stubElement2 = stubElement;
                boolean bl = false;
                Object[] constantExpressions = (KtStringTemplateExpression[])it.getChildrenByType(STRING_TEMPLATE_TYPES, (PsiElement[])STRING_TEMPLATE_EMPTY_ARRAY);
                Intrinsics.checkNotNullExpressionValue((Object)constantExpressions, (String)"constantExpressions");
                return (KtStringTemplateExpression)ArraysKt.firstOrNull((Object[])constantExpressions);
            }
        }
        if (!((ktExpression = $this$stringTemplateExpression.getArgumentExpression()) instanceof KtStringTemplateExpression)) {
            ktExpression = null;
        }
        return (KtStringTemplateExpression)ktExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String stringFromAnnotation(JvmFileClassUtil $this$stringFromAnnotation, KtAnnotationEntry annotation) {
        KtStringTemplateEntry ktStringTemplateEntry;
        List list2 = annotation.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"annotation.valueArguments");
        ValueArgument valueArgument = (ValueArgument)CollectionsKt.firstOrNull((List)list2);
        if (valueArgument == null) return null;
        KtStringTemplateEntry ktStringTemplateEntry2 = IndexUtilsKt.stringTemplateExpression(valueArgument);
        KtStringTemplateEntry ktStringTemplateEntry3 = ktStringTemplateEntry = ktStringTemplateEntry2;
        KtStringTemplateEntry ktStringTemplateEntry4 = ktStringTemplateEntry3;
        if (ktStringTemplateEntry3 == null) return null;
        KtStringTemplateEntry ktStringTemplateEntry5 = ktStringTemplateEntry4.getEntries();
        ktStringTemplateEntry4 = ktStringTemplateEntry5;
        if (ktStringTemplateEntry5 == null) return null;
        KtStringTemplateEntry ktStringTemplateEntry6 = (KtStringTemplateEntry)ArraysKt.singleOrNull((Object[])ktStringTemplateEntry4);
        ktStringTemplateEntry4 = ktStringTemplateEntry6;
        if (ktStringTemplateEntry6 == null) return null;
        KtStringTemplateEntry $this$safeAs$iv = ktStringTemplateEntry4;
        boolean $i$f$safeAs = false;
        KtStringTemplateEntry ktStringTemplateEntry7 = $this$safeAs$iv;
        if (!(ktStringTemplateEntry7 instanceof KtLiteralStringTemplateEntry)) {
            ktStringTemplateEntry7 = null;
        }
        KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = (KtLiteralStringTemplateEntry)ktStringTemplateEntry7;
        ktStringTemplateEntry4 = ktLiteralStringTemplateEntry;
        if (ktLiteralStringTemplateEntry == null) return null;
        String string = ktStringTemplateEntry4.getText();
        return string;
    }

    public static final void indexJvmNameAnnotation(@NotNull KotlinAnnotationEntryStub stub, @NotNull IndexSink sink) {
        String string;
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (Intrinsics.areEqual((Object)stub.getShortName(), (Object)JvmFileClassUtil.INSTANCE.getJVM_NAME_SHORT()) ^ true) {
            return;
        }
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)stub.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"stub.psi");
        String string2 = IndexUtilsKt.stringFromAnnotation(JvmFileClassUtil.INSTANCE, ktAnnotationEntry);
        if (string2 == null) {
            return;
        }
        String jvmName = string2;
        StubElement stubElement = stub.getParentStub();
        Intrinsics.checkNotNullExpressionValue((Object)stubElement, (String)"stub.parentStub");
        StubElement grandParentStub = stubElement.getParentStub();
        if (grandParentStub instanceof KotlinFileStub) {
            KtFile ktFile = (KtFile)((KotlinFileStub)grandParentStub).getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"grandParentStub.psi");
            string = ktFile.getName();
        } else if (grandParentStub instanceof NamedStub) {
            string = ((NamedStub)grandParentStub).getName();
            if (string == null) {
                string = "";
            }
        } else if (grandParentStub instanceof KotlinPropertyAccessorStub) {
            StubElement $this$safeAs$iv = ((KotlinPropertyAccessorStub)grandParentStub).getParentStub();
            boolean $i$f$safeAs = false;
            StubElement stubElement2 = $this$safeAs$iv;
            if (!(stubElement2 instanceof KotlinPropertyStub)) {
                stubElement2 = null;
            }
            if ((string = (KotlinPropertyStub)stubElement2) == null || (string = string.getName()) == null) {
                string = "";
            }
        } else {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (val grandParentStu\u2026     else -> return\n    }");
        String annotatedElementName = string;
        if (Intrinsics.areEqual((Object)annotatedElementName, (Object)jvmName) ^ true) {
            sink.occurrence(KotlinJvmNameAnnotationIndex.Companion.getINSTANCE().getKey(), (Object)jvmName);
        }
    }

    private static final KotlinModifierListStub getModifierList(KotlinStubWithFqName<?> $this$modifierList) {
        return (KotlinModifierListStub)$this$modifierList.findChildStubByType((IStubElementType)KtStubElementTypes.MODIFIER_LIST);
    }

    public static final <TDeclaration extends KtCallableDeclaration> boolean isDeclaredInObject(@NotNull KotlinCallableStubBase<TDeclaration> $this$isDeclaredInObject) {
        Intrinsics.checkNotNullParameter($this$isDeclaredInObject, (String)"$this$isDeclaredInObject");
        if ($this$isDeclaredInObject.isTopLevel()) {
            return false;
        }
        StubElement stubElement = $this$isDeclaredInObject.getParentStub();
        PsiElement containingDeclaration2 = stubElement != null && (stubElement = stubElement.getParentStub()) != null ? stubElement.getPsi() : null;
        return containingDeclaration2 instanceof KtObjectDeclaration && !((KtObjectDeclaration)containingDeclaration2).isObjectLiteral();
    }

    static {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtStubElementTypes.STRING_TEMPLATE});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(KtStubEl\u2026entTypes.STRING_TEMPLATE)");
        STRING_TEMPLATE_TYPES = tokenSet;
    }
}

