/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.j2k.DocCommentConverter;
import org.jetbrains.kotlin.j2k.CodeBuilder$WhenMappings;
import org.jetbrains.kotlin.j2k.ElementCreationStackTraceRequiredException;
import org.jetbrains.kotlin.j2k.ast.CommentsAndSpacesInheritance;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.PrototypeInfo;
import org.jetbrains.kotlin.j2k.ast.SpacesInheritance;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\u0018\u0000 52\u00020\u0001:\u0003456B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0015J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u001bH\u0086\u0004J\u001a\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u001b2\b\b\u0002\u0010#\u001a\u00020\bH\u0002J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%H\u0086\u0004J\u001a\u0010&\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u00032\b\b\u0002\u0010'\u001a\u00020\u0012H\u0002J,\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,H\u0002J&\u0010-\u001a\u00020.2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,H\u0002J \u0010/\u001a\b\u0012\u0004\u0012\u00020\u000300*\b\u0012\u0004\u0012\u00020\u0003002\u0006\u0010$\u001a\u00020\u0003H\u0002J \u00101\u001a\b\u0012\u0004\u0012\u00020\u000300*\b\u0012\u0004\u0012\u00020\u0003002\u0006\u0010$\u001a\u00020\u0003H\u0002J \u00102\u001a\b\u0012\u0004\u0012\u00020\u000300*\b\u0012\u0004\u0012\u00020\u0003002\u0006\u0010$\u001a\u00020\u0003H\u0002J \u00103\u001a\b\u0012\u0004\u0012\u00020\u000300*\b\u0012\u0004\u0012\u00020\u0003002\u0006\u0010$\u001a\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "", "topElement", "Lcom/intellij/psi/PsiElement;", "docConverter", "Lorg/jetbrains/kotlin/idea/j2k/DocCommentConverter;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/idea/j2k/DocCommentConverter;)V", "NON_COMMENT_INFO", "Lorg/jetbrains/kotlin/j2k/CodeBuilder$CommentInfo;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "commentPatternsToDrop", "", "Lkotlin/text/Regex;", "commentsAndSpacesUsed", "Ljava/util/HashSet;", "endOfLineCommentAtEnd", "", "imports", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "importsToAdd", "", "getImportsToAdd", "()Ljava/util/Set;", "resultText", "", "getResultText", "()Ljava/lang/String;", "addImport", "", "fqName", "append", "text", "commentInfo", "element", "Lorg/jetbrains/kotlin/j2k/ast/Element;", "appendCommentOrWhiteSpace", "postInsert", "collectPostfixElements", "inheritance", "Lorg/jetbrains/kotlin/j2k/ast/CommentsAndSpacesInheritance;", "notInsideElements", "", "collectPrefixElements", "Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix;", "collectCommentsAndSpacesAfter", "", "collectCommentsAndSpacesAtEnd", "collectCommentsAndSpacesAtStart", "collectCommentsAndSpacesBefore", "CommentInfo", "Companion", "Prefix", "kotlin.j2k.old"})
public final class CodeBuilder {
    private final List<Regex> commentPatternsToDrop;
    private final StringBuilder builder;
    private boolean endOfLineCommentAtEnd;
    private final HashSet<PsiElement> commentsAndSpacesUsed;
    private final LinkedHashSet<FqName> imports;
    private final CommentInfo NON_COMMENT_INFO;
    private final PsiElement topElement;
    private DocCommentConverter docConverter;
    @NotNull
    private static final Companion Companion = new Companion(null);

    @NotNull
    public final CodeBuilder append(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.append(text2, this.NON_COMMENT_INFO);
    }

    public final void addImport(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        this.imports.add(fqName2);
    }

    private final void appendCommentOrWhiteSpace(PsiElement element3, boolean postInsert) {
        block9: {
            block10: {
                boolean bl;
                block7: {
                    block8: {
                        if (!(element3 instanceof PsiDocComment)) break block8;
                        this.append(this.docConverter.convertDocComment((PsiDocComment)element3));
                        break block9;
                    }
                    if (!(element3 instanceof PsiComment)) break block10;
                    Iterable $this$any$iv = this.commentPatternsToDrop;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Regex it = (Regex)element$iv;
                            boolean bl2 = false;
                            String string = ((PsiComment)element3).getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
                            if (!it.matches((CharSequence)string)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (bl) break block9;
            }
            String string = element3.getText();
            Intrinsics.checkNotNull((Object)string);
            this.append(string, new CommentInfo(element3, postInsert));
        }
    }

    static /* synthetic */ void appendCommentOrWhiteSpace$default(CodeBuilder codeBuilder, PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        codeBuilder.appendCommentOrWhiteSpace(psiElement2, bl);
    }

    private final CodeBuilder append(String text2, CommentInfo commentInfo) {
        boolean bl;
        CharSequence charSequence = text2;
        if (charSequence.length() == 0) {
            boolean bl2;
            boolean bl3 = bl2 = !commentInfo.getEndOfLineComment();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return this;
        }
        boolean bl4 = bl = StringsKt.indexOf$default((CharSequence)text2, (char)'\r', (int)0, (boolean)false, (int)6, null) < 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CodeBuilder$append$22 = false;
            String $i$a$-assert-CodeBuilder$append$22 = "No '\\r' allowed";
            throw new AssertionError((Object)$i$a$-assert-CodeBuilder$append$22);
        }
        if (this.endOfLineCommentAtEnd) {
            if (text2.charAt(0) != '\n') {
                this.builder.append('\n');
            }
            this.endOfLineCommentAtEnd = false;
        }
        if (commentInfo.isComment()) {
            if (!commentInfo.isPostInsert() && commentInfo.isFirstNonWhitespaceElementInLine()) {
                CharSequence charSequence2;
                block11: {
                    CharSequence $this$takeLastWhile$iv = this.builder;
                    boolean $i$f$takeLastWhile = false;
                    for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                        char p1 = $this$takeLastWhile$iv.charAt(index$iv);
                        boolean bl5 = false;
                        if (CharsKt.isWhitespace((char)p1)) continue;
                        charSequence2 = $this$takeLastWhile$iv.subSequence(index$iv + 1, $this$takeLastWhile$iv.length());
                        break block11;
                    }
                    charSequence2 = $this$takeLastWhile$iv.subSequence(0, $this$takeLastWhile$iv.length());
                }
                if (!StringsKt.contains$default((CharSequence)charSequence2, (char)'\n', (boolean)false, (int)2, null)) {
                    this.builder.append('\n');
                }
            }
            if (!commentInfo.isCommentAtFirstColumn()) {
                Character c = StringsKt.lastOrNull((CharSequence)this.builder);
                if (c != null && c.charValue() == '\n') {
                    this.builder.append(" ");
                }
            }
        }
        this.builder.append(text2);
        this.endOfLineCommentAtEnd = commentInfo.getEndOfLineComment();
        return this;
    }

    static /* synthetic */ CodeBuilder append$default(CodeBuilder codeBuilder, String string, CommentInfo commentInfo, int n, Object object) {
        if ((n & 2) != 0) {
            commentInfo = codeBuilder.NON_COMMENT_INFO;
        }
        return codeBuilder.append(string, commentInfo);
    }

    @NotNull
    public final String getResultText() {
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public final Set<FqName> getImportsToAdd() {
        return this.imports;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CodeBuilder append(@NotNull Element element3) {
        boolean bl;
        int n;
        int prototype222;
        int n2;
        CommentsAndSpacesInheritance inheritance;
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (element3.isEmpty()) {
                    return this;
                }
                if (element3.getPrototypes() == null && this.topElement != null) {
                    if (element3.getCreatedAt() == null) {
                        throw (Throwable)new ElementCreationStackTraceRequiredException();
                    }
                    String s = "Element " + element3 + " has no prototypes assigned.\nUse Element.assignPrototype() or Element.assignNoPrototype().\nElement created at:\n" + element3.getCreatedAt();
                    throw (Throwable)new RuntimeException(s);
                }
                if (this.topElement == null || this.topElement instanceof PsiCompiledElement) break block14;
                List<PrototypeInfo> list2 = element3.getPrototypes();
                Intrinsics.checkNotNull(list2);
                if (!list2.isEmpty()) break block15;
            }
            element3.generateCode(this);
            element3.postGenerateCode(this);
            return this;
        }
        HashSet notInsideElements = new HashSet();
        Prefix prefix = Prefix.Companion.getEmpty();
        List<PsiElement> postfix = CollectionsKt.emptyList();
        List<PrototypeInfo> list3 = element3.getPrototypes();
        Intrinsics.checkNotNull(list3);
        for (PrototypeInfo prototypeInfo : list3) {
            void prototype222;
            boolean bl2;
            PsiElement psiElement2 = prototypeInfo.component1();
            inheritance = prototypeInfo.component2();
            boolean bl3 = bl2 = !(prototype222 instanceof PsiComment);
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl4 = bl2 = !(prototype222 instanceof PsiWhiteSpace);
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (!PsiUtilsKt.isAncestor$default((PsiElement)this.topElement, (PsiElement)prototype222, (boolean)false, (int)2, null)) continue;
            prefix = prefix.plus(this.collectPrefixElements((PsiElement)prototype222, inheritance, notInsideElements));
            postfix = Companion.plus(postfix, this.collectPostfixElements((PsiElement)prototype222, inheritance, notInsideElements));
        }
        if (prefix.getLineBreaksBefore() > 0 && (n2 = 1) <= (prototype222 = (n = prefix.getLineBreaksBefore() - Companion.trailingLineBreakCount(this.builder)))) {
            while (true) {
                void it;
                this.append("\n");
                if (it == prototype222) break;
                ++it;
            }
        }
        Iterable iterable = prefix.getElements();
        boolean $i$f$forEach = false;
        for (Object element$iv : iterable) {
            PsiElement it = (PsiElement)element$iv;
            bl = false;
            CodeBuilder.appendCommentOrWhiteSpace$default(this, it, false, 2, null);
        }
        element3.generateCode(this);
        List<PrototypeInfo> list4 = element3.getPrototypes();
        Intrinsics.checkNotNull(list4);
        for (PrototypeInfo prototypeInfo : list4) {
            void prototype2;
            PsiElement prototype222 = prototypeInfo.component1();
            inheritance = prototypeInfo.component2();
            if (!inheritance.getCommentsInside()) continue;
            prototype2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(this, notInsideElements){
                final /* synthetic */ CodeBuilder this$0;
                final /* synthetic */ HashSet $notInsideElements;

                public void visitComment(@NotNull PsiComment comment2) {
                    Intrinsics.checkNotNullParameter((Object)comment2, (String)"comment");
                    if (!this.$notInsideElements.contains(comment2) && CodeBuilder.access$getCommentsAndSpacesUsed$p(this.this$0).add(comment2)) {
                        CodeBuilder.access$appendCommentOrWhiteSpace(this.this$0, (PsiElement)comment2, true);
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$notInsideElements = $captured_local_variable$1;
                }
            });
        }
        Iterable iterable2 = postfix;
        $i$f$forEach = false;
        for (Object element$iv : iterable2) {
            PsiElement it = (PsiElement)element$iv;
            bl = false;
            CodeBuilder.appendCommentOrWhiteSpace$default(this, it, false, 2, null);
        }
        element3.postGenerateCode(this);
        return this;
    }

    private final Prefix collectPrefixElements(PsiElement element3, CommentsAndSpacesInheritance inheritance, Set<PsiElement> notInsideElements) {
        List<PsiElement> before = this.collectCommentsAndSpacesBefore((List)new SmartList(), element3);
        List<PsiElement> atStart = this.collectCommentsAndSpacesAtStart((List)new SmartList(), element3);
        notInsideElements.addAll((Collection<PsiElement>)atStart);
        if (inheritance.getSpacesBefore() == SpacesInheritance.NONE && !inheritance.getCommentsBefore()) {
            return Prefix.Companion.getEmpty();
        }
        Object object = CollectionsKt.lastOrNull(before);
        if (!(object instanceof PsiWhiteSpace)) {
            object = null;
        }
        PsiWhiteSpace firstSpace = (PsiWhiteSpace)object;
        int lineBreaks = 0;
        if (firstSpace != null) {
            lineBreaks = Companion.lineBreakCount(firstSpace);
            switch (CodeBuilder$WhenMappings.$EnumSwitchMapping$0[inheritance.getSpacesBefore().ordinal()]) {
                case 1: {
                    lineBreaks = 0;
                    break;
                }
                case 2: {
                    this.commentsAndSpacesUsed.add((PsiElement)firstSpace);
                    break;
                }
                case 3: {
                    this.commentsAndSpacesUsed.add((PsiElement)firstSpace);
                    if (lineBreaks != 1) break;
                    lineBreaks = 0;
                }
            }
        }
        if (!inheritance.getCommentsBefore()) {
            return new Prefix(CollectionsKt.emptyList(), lineBreaks);
        }
        if (firstSpace != null) {
            before.remove(CollectionsKt.getLastIndex(before));
        }
        List<PsiElement> elements2 = Companion.plus(CollectionsKt.asReversedMutable(before), atStart);
        this.commentsAndSpacesUsed.addAll((Collection<PsiElement>)elements2);
        return new Prefix(elements2, lineBreaks);
    }

    private final List<PsiElement> collectPostfixElements(PsiElement element3, CommentsAndSpacesInheritance inheritance, Set<PsiElement> notInsideElements) {
        PsiElement last;
        List<PsiElement> atEnd = this.collectCommentsAndSpacesAtEnd((List)new SmartList(), element3);
        notInsideElements.addAll((Collection<PsiElement>)atEnd);
        if (!inheritance.getCommentsAfter()) {
            return CollectionsKt.emptyList();
        }
        List<PsiElement> after = this.collectCommentsAndSpacesAfter((List)new SmartList(), element3);
        Collection collection = after;
        if (!collection.isEmpty() && (last = (PsiElement)CollectionsKt.last(after)) instanceof PsiWhiteSpace) {
            after.remove(CollectionsKt.getLastIndex(after));
        }
        List<PsiElement> result2 = Companion.plus(CollectionsKt.asReversedMutable(atEnd), after);
        this.commentsAndSpacesUsed.addAll((Collection<PsiElement>)result2);
        return result2;
    }

    private final List<PsiElement> collectCommentsAndSpacesBefore(List<PsiElement> $this$collectCommentsAndSpacesBefore, PsiElement element3) {
        if (Intrinsics.areEqual((Object)element3, (Object)this.topElement)) {
            return $this$collectCommentsAndSpacesBefore;
        }
        PsiElement prev2 = element3.getPrevSibling();
        if (prev2 != null) {
            if (Companion.isCommentOrSpace(prev2)) {
                if (!this.commentsAndSpacesUsed.contains(prev2)) {
                    $this$collectCommentsAndSpacesBefore.add(prev2);
                    this.collectCommentsAndSpacesBefore($this$collectCommentsAndSpacesBefore, prev2);
                }
            } else if (Companion.isEmptyElement(prev2)) {
                this.collectCommentsAndSpacesBefore($this$collectCommentsAndSpacesBefore, prev2);
            }
        } else {
            PsiElement psiElement2 = element3.getParent();
            Intrinsics.checkNotNull((Object)psiElement2);
            this.collectCommentsAndSpacesBefore($this$collectCommentsAndSpacesBefore, psiElement2);
        }
        return $this$collectCommentsAndSpacesBefore;
    }

    private final List<PsiElement> collectCommentsAndSpacesAfter(List<PsiElement> $this$collectCommentsAndSpacesAfter, PsiElement element3) {
        if (Intrinsics.areEqual((Object)element3, (Object)this.topElement)) {
            return $this$collectCommentsAndSpacesAfter;
        }
        PsiElement next2 = element3.getNextSibling();
        if (next2 != null) {
            if (Companion.isCommentOrSpace(next2)) {
                if (next2 instanceof PsiWhiteSpace && Companion.hasLineBreaks((PsiWhiteSpace)next2)) {
                    return $this$collectCommentsAndSpacesAfter;
                }
                if (!this.commentsAndSpacesUsed.contains(next2)) {
                    $this$collectCommentsAndSpacesAfter.add(next2);
                    this.collectCommentsAndSpacesAfter($this$collectCommentsAndSpacesAfter, next2);
                }
            } else if (Companion.isEmptyElement(next2)) {
                this.collectCommentsAndSpacesAfter($this$collectCommentsAndSpacesAfter, next2);
            }
        } else {
            PsiElement psiElement2 = element3.getParent();
            Intrinsics.checkNotNull((Object)psiElement2);
            this.collectCommentsAndSpacesAfter($this$collectCommentsAndSpacesAfter, psiElement2);
        }
        return $this$collectCommentsAndSpacesAfter;
    }

    private final List<PsiElement> collectCommentsAndSpacesAtStart(List<PsiElement> $this$collectCommentsAndSpacesAtStart, PsiElement element3) {
        for (PsiElement child = element3.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (Companion.isCommentOrSpace(child)) {
                if (this.commentsAndSpacesUsed.contains(child)) break;
                $this$collectCommentsAndSpacesAtStart.add(child);
                continue;
            }
            if (Companion.isEmptyElement(child)) continue;
            this.collectCommentsAndSpacesAtStart($this$collectCommentsAndSpacesAtStart, child);
            break;
        }
        return $this$collectCommentsAndSpacesAtStart;
    }

    private final List<PsiElement> collectCommentsAndSpacesAtEnd(List<PsiElement> $this$collectCommentsAndSpacesAtEnd, PsiElement element3) {
        for (PsiElement child = element3.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (Companion.isCommentOrSpace(child)) {
                if (this.commentsAndSpacesUsed.contains(child)) break;
                $this$collectCommentsAndSpacesAtEnd.add(child);
                continue;
            }
            if (Companion.isEmptyElement(child)) continue;
            this.collectCommentsAndSpacesAtEnd($this$collectCommentsAndSpacesAtEnd, child);
            break;
        }
        return $this$collectCommentsAndSpacesAtEnd;
    }

    public CodeBuilder(@Nullable PsiElement topElement, @NotNull DocCommentConverter docConverter) {
        Intrinsics.checkNotNullParameter((Object)docConverter, (String)"docConverter");
        this.topElement = topElement;
        this.docConverter = docConverter;
        String string = "^//[ ]*noinspection[ ]+[A-Za-z][A-Za-z0-9_]*([ ].*?)?$";
        this.commentPatternsToDrop = CollectionsKt.listOf((Object)new Regex(string));
        this.builder = new StringBuilder();
        this.commentsAndSpacesUsed = new HashSet();
        this.imports = new LinkedHashSet();
        this.NON_COMMENT_INFO = new CommentInfo(null, false);
    }

    public static final /* synthetic */ HashSet access$getCommentsAndSpacesUsed$p(CodeBuilder $this) {
        return $this.commentsAndSpacesUsed;
    }

    public static final /* synthetic */ void access$appendCommentOrWhiteSpace(CodeBuilder $this, PsiElement element3, boolean postInsert) {
        $this.appendCommentOrWhiteSpace(element3, postInsert);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder$CommentInfo;", "", "element", "Lcom/intellij/psi/PsiElement;", "isPostInsert", "", "(Lcom/intellij/psi/PsiElement;Z)V", "endOfLineComment", "getEndOfLineComment", "()Z", "isComment", "isCommentAtFirstColumn", "isFirstNonWhitespaceElementInLine", "kotlin.j2k.old"})
    private static final class CommentInfo {
        private final boolean isComment;
        private final boolean endOfLineComment;
        private final boolean isCommentAtFirstColumn;
        private final boolean isFirstNonWhitespaceElementInLine;
        private final boolean isPostInsert;

        public final boolean isComment() {
            return this.isComment;
        }

        public final boolean getEndOfLineComment() {
            return this.endOfLineComment;
        }

        public final boolean isCommentAtFirstColumn() {
            return this.isCommentAtFirstColumn;
        }

        public final boolean isFirstNonWhitespaceElementInLine() {
            return this.isFirstNonWhitespaceElementInLine;
        }

        public final boolean isPostInsert() {
            return this.isPostInsert;
        }

        public CommentInfo(@Nullable PsiElement element3, boolean isPostInsert) {
            this.isPostInsert = isPostInsert;
            this.isComment = element3 instanceof PsiComment;
            PsiElement psiElement2 = element3;
            this.endOfLineComment = psiElement2 != null ? Companion.isEndOfLineComment(psiElement2) : false;
            PsiElement psiElement3 = element3;
            this.isCommentAtFirstColumn = psiElement3 != null ? Companion.isCommentAtFirstColumn(psiElement3) : false;
            PsiElement psiElement4 = element3;
            this.isFirstNonWhitespaceElementInLine = psiElement4 != null ? Companion.isFirstNonWhitespaceElementInLine(psiElement4) : false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u0011\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix;", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "lineBreaksBefore", "", "(Ljava/util/List;I)V", "getElements", "()Ljava/util/List;", "getLineBreaksBefore", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "isEmpty", "plus", "toString", "", "Companion", "kotlin.j2k.old"})
    private static final class Prefix {
        @NotNull
        private final List<PsiElement> elements;
        private final int lineBreaksBefore;
        @NotNull
        private static final Prefix Empty;
        @NotNull
        public static final Companion Companion;

        @NotNull
        public final Prefix plus(@NotNull Prefix other) {
            Prefix prefix;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (this.isEmpty()) {
                prefix = other;
            } else if (other.isEmpty()) {
                prefix = this;
            } else {
                int n = this.lineBreaksBefore;
                int n2 = other.lineBreaksBefore;
                Prefix prefix2 = new Prefix(Companion.plus(this.elements, other.elements), Math.max(n, n2));
                prefix = prefix2;
            }
            return prefix;
        }

        private final boolean isEmpty() {
            return this.elements.isEmpty() && this.lineBreaksBefore == 0;
        }

        @NotNull
        public final List<PsiElement> getElements() {
            return this.elements;
        }

        public final int getLineBreaksBefore() {
            return this.lineBreaksBefore;
        }

        public Prefix(@NotNull List<? extends PsiElement> elements2, int lineBreaksBefore) {
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            this.elements = elements2;
            this.lineBreaksBefore = lineBreaksBefore;
        }

        static {
            Companion = new Companion(null);
            Empty = new Prefix(CollectionsKt.emptyList(), 0);
        }

        @NotNull
        public final List<PsiElement> component1() {
            return this.elements;
        }

        public final int component2() {
            return this.lineBreaksBefore;
        }

        @NotNull
        public final Prefix copy(@NotNull List<? extends PsiElement> elements2, int lineBreaksBefore) {
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            return new Prefix(elements2, lineBreaksBefore);
        }

        public static /* synthetic */ Prefix copy$default(Prefix prefix, List list2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list2 = prefix.elements;
            }
            if ((n2 & 2) != 0) {
                n = prefix.lineBreaksBefore;
            }
            return prefix.copy(list2, n);
        }

        @NotNull
        public String toString() {
            return "Prefix(elements=" + this.elements + ", lineBreaksBefore=" + this.lineBreaksBefore + ")";
        }

        public int hashCode() {
            List<PsiElement> list2 = this.elements;
            return (list2 != null ? ((Object)list2).hashCode() : 0) * 31 + Integer.hashCode(this.lineBreaksBefore);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Prefix)) break block3;
                    Prefix prefix = (Prefix)object;
                    if (!Intrinsics.areEqual(this.elements, prefix.elements) || this.lineBreaksBefore != prefix.lineBreaksBefore) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix$Companion;", "", "()V", "Empty", "Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix;", "getEmpty", "()Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix;", "kotlin.j2k.old"})
        public static final class Companion {
            @NotNull
            public final Prefix getEmpty() {
                return Empty;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005J\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0007J\n\u0010\b\u001a\u00020\u0004*\u00020\u0007J\n\u0010\t\u001a\u00020\u0004*\u00020\u0007J\n\u0010\n\u001a\u00020\u0004*\u00020\u0007J\n\u0010\u000b\u001a\u00020\u0004*\u00020\u0007J\n\u0010\f\u001a\u00020\r*\u00020\u0005J-\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000fH\u0086\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u000fJ\n\u0010\u0013\u001a\u00020\r*\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder$Companion;", "", "()V", "hasLineBreaks", "", "Lcom/intellij/psi/PsiWhiteSpace;", "isCommentAtFirstColumn", "Lcom/intellij/psi/PsiElement;", "isCommentOrSpace", "isEmptyElement", "isEndOfLineComment", "isFirstNonWhitespaceElementInLine", "lineBreakCount", "", "plus", "", "T", "other", "reversed", "trailingLineBreakCount", "", "kotlin.j2k.old"})
    private static final class Companion {
        @NotNull
        public final <T> List<T> plus(@NotNull List<? extends T> $this$plus, @NotNull List<? extends T> other) {
            List list2;
            Intrinsics.checkNotNullParameter($this$plus, (String)"$this$plus");
            Intrinsics.checkNotNullParameter(other, (String)"other");
            if ($this$plus.isEmpty()) {
                list2 = other;
            } else if (other.isEmpty()) {
                list2 = $this$plus;
            } else {
                ArrayList result2 = new ArrayList($this$plus.size() + other.size());
                result2.addAll($this$plus);
                result2.addAll(other);
                list2 = result2;
            }
            return list2;
        }

        @NotNull
        public final <T> List<T> reversed(@NotNull List<? extends T> $this$reversed) {
            Intrinsics.checkNotNullParameter($this$reversed, (String)"$this$reversed");
            return $this$reversed.size() <= 1 ? $this$reversed : CollectionsKt.asReversed($this$reversed);
        }

        public final boolean isCommentOrSpace(@NotNull PsiElement $this$isCommentOrSpace) {
            Intrinsics.checkNotNullParameter((Object)$this$isCommentOrSpace, (String)"$this$isCommentOrSpace");
            return $this$isCommentOrSpace instanceof PsiComment || $this$isCommentOrSpace instanceof PsiWhiteSpace;
        }

        public final boolean isEndOfLineComment(@NotNull PsiElement $this$isEndOfLineComment) {
            Intrinsics.checkNotNullParameter((Object)$this$isEndOfLineComment, (String)"$this$isEndOfLineComment");
            return $this$isEndOfLineComment instanceof PsiComment && Intrinsics.areEqual((Object)((PsiComment)$this$isEndOfLineComment).getTokenType(), (Object)JavaTokenType.END_OF_LINE_COMMENT);
        }

        public final boolean isEmptyElement(@NotNull PsiElement $this$isEmptyElement) {
            Intrinsics.checkNotNullParameter((Object)$this$isEmptyElement, (String)"$this$isEmptyElement");
            return $this$isEmptyElement.getFirstChild() == null && $this$isEmptyElement.getTextLength() == 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isCommentAtFirstColumn(@NotNull PsiElement $this$isCommentAtFirstColumn) {
            PsiElement psiElement2;
            Intrinsics.checkNotNullParameter((Object)$this$isCommentAtFirstColumn, (String)"$this$isCommentAtFirstColumn");
            if (!($this$isCommentAtFirstColumn instanceof PsiComment)) return false;
            PsiElement psiElement3 = ((PsiComment)$this$isCommentAtFirstColumn).getPrevSibling();
            if (psiElement3 == null) return false;
            PsiElement it = psiElement2 = psiElement3;
            boolean bl = false;
            if (!(it instanceof PsiWhiteSpace)) return false;
            String string = ((PsiWhiteSpace)it).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            if (!StringsKt.endsWith$default((String)string, (String)"\\n", (boolean)false, (int)2, null)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isFirstNonWhitespaceElementInLine(@NotNull PsiElement $this$isFirstNonWhitespaceElementInLine) {
            PsiElement psiElement2;
            Intrinsics.checkNotNullParameter((Object)$this$isFirstNonWhitespaceElementInLine, (String)"$this$isFirstNonWhitespaceElementInLine");
            if (!($this$isFirstNonWhitespaceElementInLine instanceof PsiComment)) return false;
            PsiElement psiElement3 = ((PsiComment)$this$isFirstNonWhitespaceElementInLine).getPrevSibling();
            if (psiElement3 == null) return false;
            PsiElement it = psiElement2 = psiElement3;
            boolean bl = false;
            if (!(it instanceof PsiWhiteSpace)) return false;
            String string = ((PsiWhiteSpace)it).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            if (!StringsKt.contains$default((CharSequence)string, (char)'\n', (boolean)false, (int)2, null)) return false;
            return true;
        }

        public final int lineBreakCount(@NotNull PsiWhiteSpace $this$lineBreakCount) {
            Intrinsics.checkNotNullParameter((Object)$this$lineBreakCount, (String)"$this$lineBreakCount");
            return StringUtil.getLineBreakCount((CharSequence)$this$lineBreakCount.getText());
        }

        public final boolean hasLineBreaks(@NotNull PsiWhiteSpace $this$hasLineBreaks) {
            Intrinsics.checkNotNullParameter((Object)$this$hasLineBreaks, (String)"$this$hasLineBreaks");
            return StringUtil.containsLineBreak((CharSequence)$this$hasLineBreaks.getText());
        }

        public final int trailingLineBreakCount(@NotNull CharSequence $this$trailingLineBreakCount) {
            int i;
            Intrinsics.checkNotNullParameter((Object)$this$trailingLineBreakCount, (String)"$this$trailingLineBreakCount");
            for (i = $this$trailingLineBreakCount.length() - 1; i >= 0 && $this$trailingLineBreakCount.charAt(i) == '\n'; --i) {
            }
            return $this$trailingLineBreakCount.length() - i - 1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

