/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.kotlin;

import com.intellij.lang.Language;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.analysis.UastAnalysisPlugin;
import org.jetbrains.uast.kotlin.ConverterUtilsKt;
import org.jetbrains.uast.kotlin.KotlinAbstractUExpression;
import org.jetbrains.uast.kotlin.KotlinConverter;
import org.jetbrains.uast.kotlin.KotlinInternalUastUtilsKt;
import org.jetbrains.uast.kotlin.KotlinPsiElementMappingKt;
import org.jetbrains.uast.kotlin.KotlinUFunctionCallExpression;
import org.jetbrains.uast.kotlin.KotlinUSimpleReferenceExpression;
import org.jetbrains.uast.kotlin.KotlinUastResolveProviderService;
import org.jetbrains.uast.kotlin.psi.UastFakeLightPrimaryConstructor;
import org.jetbrains.uast.util.ClassSet;
import org.jetbrains.uast.util.ClassSetsWrapper;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0010\u0010\u0017\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0014\u0018\u00010\u0018H\u0016JA\u0010\u0013\u001a\u0004\u0018\u0001H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0016\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00190\u00180\u001b\u00a2\u0006\u0002\u0010\u001cJ$\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0010\u0010\u0017\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0014\u0018\u00010\u0018H\u0016J9\u0010\u001d\u001a\u0004\u0018\u0001H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0016\u0010\u001e\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00190\u00180\u001bH\u0016\u00a2\u0006\u0002\u0010\u001fJ=\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00190!\"\b\b\u0000\u0010\u0019*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0016\u0010\u001e\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00190\u00180\u001bH\u0016\u00a2\u0006\u0002\u0010\"J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&H\u0016J$\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010)\u001a\u0004\u0018\u00010&2\u0006\u0010*\u001a\u00020&H\u0016J7\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110,2\"\u0010-\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00180\u001b\"\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0018H\u0016\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020&H\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0012\u00a8\u00063"}, d2={"Lorg/jetbrains/uast/kotlin/KotlinUastLanguagePlugin;", "Lorg/jetbrains/uast/UastLanguagePlugin;", "()V", "analysisPlugin", "Lorg/jetbrains/uast/analysis/UastAnalysisPlugin;", "getAnalysisPlugin", "()Lorg/jetbrains/uast/analysis/UastAnalysisPlugin;", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "priority", "", "getPriority", "()I", "isJvmElement", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "convertElement", "Lorg/jetbrains/uast/UElement;", "element", "parent", "requiredType", "Ljava/lang/Class;", "T", "expectedTypes", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/uast/UElement;[Ljava/lang/Class;)Lorg/jetbrains/uast/UElement;", "convertElementWithParent", "requiredTypes", "(Lcom/intellij/psi/PsiElement;[Ljava/lang/Class;)Lorg/jetbrains/uast/UElement;", "convertToAlternatives", "Lkotlin/sequences/Sequence;", "(Lcom/intellij/psi/PsiElement;[Ljava/lang/Class;)Lkotlin/sequences/Sequence;", "getConstructorCallExpression", "Lorg/jetbrains/uast/UastLanguagePlugin$ResolvedConstructor;", "fqName", "", "getMethodCallExpression", "Lorg/jetbrains/uast/UastLanguagePlugin$ResolvedMethod;", "containingClassFqName", "methodName", "getPossiblePsiSourceTypes", "Lorg/jetbrains/uast/util/ClassSet;", "uastTypes", "([Ljava/lang/Class;)Lorg/jetbrains/uast/util/ClassSet;", "isExpressionValueUsed", "Lorg/jetbrains/uast/UExpression;", "isFileSupported", "fileName", "kotlin.uast.uast-kotlin"})
public final class KotlinUastLanguagePlugin
implements UastLanguagePlugin {
    private final int priority;

    public int getPriority() {
        return this.priority;
    }

    @NotNull
    public Language getLanguage() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinLanguage, (String)"KotlinLanguage.INSTANCE");
        return (Language)kotlinLanguage;
    }

    public boolean isFileSupported(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return StringsKt.endsWith((String)fileName, (String)".kt", (boolean)false) || StringsKt.endsWith((String)fileName, (String)".kts", (boolean)false);
    }

    private final boolean isJvmElement(PsiElement $this$isJvmElement) {
        Object object = $this$isJvmElement.getProject().getService(KotlinUastResolveProviderService.class);
        Intrinsics.checkNotNull((Object)object);
        KotlinUastResolveProviderService resolveProvider = (KotlinUastResolveProviderService)object;
        return resolveProvider.isJvmElement($this$isJvmElement);
    }

    @Nullable
    public UElement convertElement(@NotNull PsiElement element3, @Nullable UElement parent2, @Nullable Class<? extends UElement> requiredType) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Class<? extends UElement>[] requiredTypes = ConverterUtilsKt.elementTypes(requiredType);
        return !KotlinPsiElementMappingKt.canConvert(element3, requiredTypes) || !this.isJvmElement(element3) ? null : KotlinConverter.INSTANCE.convertDeclarationOrElement(element3, parent2, requiredTypes);
    }

    @Nullable
    public UElement convertElementWithParent(@NotNull PsiElement element3, @Nullable Class<? extends UElement> requiredType) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Class<? extends UElement>[] requiredTypes = ConverterUtilsKt.elementTypes(requiredType);
        return !KotlinPsiElementMappingKt.canConvert(element3, requiredTypes) || !this.isJvmElement(element3) ? null : (element3 instanceof PsiFile || element3 instanceof KtLightClassForFacade ? KotlinConverter.INSTANCE.convertDeclaration(element3, null, requiredTypes) : KotlinConverter.INSTANCE.convertDeclarationOrElement(element3, null, requiredTypes));
    }

    @Nullable
    public UastLanguagePlugin.ResolvedMethod getMethodCallExpression(@NotNull PsiElement element3, @Nullable String containingClassFqName, @NotNull String methodName2) {
        PsiElement parent2;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)methodName2, (String)"methodName");
        if (!(element3 instanceof KtCallExpression)) {
            return null;
        }
        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)element3), (BindingContext)KotlinInternalUastUtilsKt.analyze((KtElement)element3));
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        CallableDescriptor resultingDescriptor = resolvedCall3.getResultingDescriptor();
        if (!(resultingDescriptor instanceof FunctionDescriptor) || Intrinsics.areEqual((Object)((FunctionDescriptor)resultingDescriptor).getName().asString(), (Object)methodName2) ^ true) {
            return null;
        }
        PsiElement psiElement2 = parent2 = ((KtCallExpression)element3).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parent");
        UElement uElement = this.convertElementWithParent(psiElement2, (Class<? extends UElement>)null);
        if (uElement == null) {
            return null;
        }
        UElement parentUElement = uElement;
        KotlinUFunctionCallExpression uExpression = new KotlinUFunctionCallExpression((KtCallElement)element3, parentUElement);
        PsiMethod psiMethod = uExpression.resolve();
        if (psiMethod == null) {
            return null;
        }
        PsiMethod method = psiMethod;
        if (Intrinsics.areEqual((Object)method.getName(), (Object)methodName2) ^ true) {
            return null;
        }
        return new UastLanguagePlugin.ResolvedMethod((UCallExpression)uExpression, method);
    }

    @Nullable
    public UastLanguagePlugin.ResolvedConstructor getConstructorCallExpression(@NotNull PsiElement element3, @NotNull String fqName2) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        if (!(element3 instanceof KtCallExpression)) {
            return null;
        }
        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)element3), (BindingContext)KotlinInternalUastUtilsKt.analyze((KtElement)element3));
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        CallableDescriptor resultingDescriptor = resolvedCall3.getResultingDescriptor();
        if (!(resultingDescriptor instanceof ConstructorDescriptor) || Intrinsics.areEqual((Object)((classifierDescriptor = ((ConstructorDescriptor)resultingDescriptor).getReturnType().getConstructor().getDeclarationDescriptor()) != null && (classifierDescriptor = classifierDescriptor.getName()) != null ? classifierDescriptor.asString() : null), (Object)fqName2) ^ true) {
            return null;
        }
        PsiElement psiElement2 = KotlinConverter.INSTANCE.unwrapElements(((KtCallExpression)element3).getParent());
        if (psiElement2 == null) {
            return null;
        }
        PsiElement parent2 = psiElement2;
        UElement uElement = this.convertElementWithParent(parent2, (Class<? extends UElement>)null);
        if (uElement == null) {
            return null;
        }
        UElement parentUElement = uElement;
        KotlinUFunctionCallExpression uExpression = new KotlinUFunctionCallExpression((KtCallElement)element3, parentUElement);
        PsiMethod psiMethod = uExpression.resolve();
        if (psiMethod == null) {
            return null;
        }
        PsiMethod method = psiMethod;
        PsiClass psiClass2 = method.getContainingClass();
        if (psiClass2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"method.containingClass ?: return null");
        PsiClass containingClass2 = psiClass2;
        return new UastLanguagePlugin.ResolvedConstructor((UCallExpression)uExpression, method, containingClass2);
    }

    public boolean isExpressionValueUsed(@NotNull UExpression element3) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        UExpression uExpression = element3;
        if (uExpression instanceof KotlinUSimpleReferenceExpression.KotlinAccessorCallExpression) {
            bl = ((KotlinUSimpleReferenceExpression.KotlinAccessorCallExpression)element3).getSetterValue() != null;
        } else if (uExpression instanceof KotlinAbstractUExpression) {
            PsiElement psiElement2 = element3.getSourcePsi();
            if (!(psiElement2 instanceof KtElement)) {
                psiElement2 = null;
            }
            KtElement ktElement = (KtElement)psiElement2;
            if (ktElement == null) {
                return false;
            }
            KtElement ktElement2 = ktElement;
            Boolean bl2 = (Boolean)KotlinInternalUastUtilsKt.analyze(ktElement2).get((ReadOnlySlice)BindingContext.USED_AS_EXPRESSION, (Object)ktElement2);
            if (bl2 == null) {
                bl2 = false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"ktElement.analyze()[Bind\u2026SION, ktElement] ?: false");
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final <T extends UElement> T convertElement(@NotNull PsiElement element3, @Nullable UElement parent2, @NotNull Class<? extends T>[] expectedTypes) {
        UElement uElement;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(expectedTypes, (String)"expectedTypes");
        Class<UElement>[] nonEmptyExpectedTypes = ConverterUtilsKt.nonEmptyOr(expectedTypes, UastContextKt.DEFAULT_TYPES_LIST);
        if (!KotlinPsiElementMappingKt.canConvert(element3, nonEmptyExpectedTypes) || !this.isJvmElement(element3)) {
            uElement = null;
        } else {
            uElement = KotlinConverter.INSTANCE.convertDeclarationOrElement(element3, parent2, nonEmptyExpectedTypes);
            if (!(uElement instanceof UElement)) {
                uElement = null;
            }
        }
        return (T)uElement;
    }

    @Nullable
    public <T extends UElement> T convertElementWithParent(@NotNull PsiElement element3, @NotNull Class<? extends T>[] requiredTypes) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(requiredTypes, (String)"requiredTypes");
        return this.convertElement(element3, null, requiredTypes);
    }

    @NotNull
    public <T extends UElement> Sequence<T> convertToAlternatives(@NotNull PsiElement element3, @NotNull Class<? extends T>[] requiredTypes) {
        Sequence sequence2;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(requiredTypes, (String)"requiredTypes");
        if (!this.isJvmElement(element3)) {
            sequence2 = SequencesKt.emptySequence();
        } else if (element3 instanceof KtFile) {
            sequence2 = KotlinConverter.INSTANCE.convertKtFile((KtFile)element3, null, requiredTypes);
            if (sequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<T>");
            }
        } else if (element3 instanceof KtProperty && !((KtProperty)element3).isLocal()) {
            sequence2 = KotlinConverter.INSTANCE.convertNonLocalProperty((KtProperty)element3, null, requiredTypes);
            if (sequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<T>");
            }
        } else if (element3 instanceof KtParameter) {
            sequence2 = KotlinConverter.INSTANCE.convertParameter((KtParameter)element3, null, requiredTypes);
            if (sequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<T>");
            }
        } else if (element3 instanceof KtClassOrObject) {
            sequence2 = KotlinConverter.INSTANCE.convertClassOrObject((KtClassOrObject)element3, null, requiredTypes);
            if (sequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<T>");
            }
        } else if (element3 instanceof UastFakeLightPrimaryConstructor) {
            sequence2 = KotlinConverter.INSTANCE.convertFakeLightConstructorAlternatives((UastFakeLightPrimaryConstructor)element3, null, requiredTypes);
            if (sequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<T>");
            }
        } else {
            Object[] objectArray = new UElement[1];
            UElement uElement = this.convertElementWithParent(element3, ConverterUtilsKt.nonEmptyOr(requiredTypes, UastContextKt.DEFAULT_TYPES_LIST));
            if (!(uElement instanceof UElement)) {
                uElement = null;
            }
            objectArray[0] = uElement;
            sequence2 = SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray));
        }
        return sequence2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ClassSet<PsiElement> getPossiblePsiSourceTypes(Class<? extends UElement> ... uastTypes) {
        ClassSet classSet;
        Intrinsics.checkNotNullParameter(uastTypes, (String)"uastTypes");
        switch (uastTypes.length) {
            case 0: {
                classSet = KotlinPsiElementMappingKt.getPossibleSourceTypes(UElement.class);
                break;
            }
            case 1: {
                classSet = KotlinPsiElementMappingKt.getPossibleSourceTypes((Class)ArraysKt.single((Object[])uastTypes));
                break;
            }
            default: {
                ClassSet[] classSetArray;
                int n = uastTypes.length;
                ClassSet[] classSetArray2 = new ClassSet[n];
                int n2 = 0;
                while (n2 < n) {
                    void it;
                    ClassSet<PsiElement> classSet2;
                    int n3 = n2;
                    int n4 = n2++;
                    classSetArray = classSetArray2;
                    boolean bl = false;
                    classSetArray[n4] = classSet2 = KotlinPsiElementMappingKt.getPossibleSourceTypes(uastTypes[it]);
                }
                ClassSet[] classSetArray3 = classSetArray = classSetArray2;
                classSet = (ClassSet)new ClassSetsWrapper(classSetArray3);
            }
        }
        return classSet;
    }

    @Nullable
    public UastAnalysisPlugin getAnalysisPlugin() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinLanguage, (String)"KotlinLanguage.INSTANCE");
        return UastAnalysisPlugin.Companion.byLanguage((Language)kotlinLanguage);
    }

    public KotlinUastLanguagePlugin() {
        this.priority = 10;
    }

    @NotNull
    public UExpression getInitializerBody(@NotNull PsiClassInitializer element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return UastLanguagePlugin.DefaultImpls.getInitializerBody((UastLanguagePlugin)this, (PsiClassInitializer)element3);
    }

    @Nullable
    public UExpression getInitializerBody(@NotNull PsiVariable element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return UastLanguagePlugin.DefaultImpls.getInitializerBody((UastLanguagePlugin)this, (PsiVariable)element3);
    }

    @Nullable
    public UExpression getMethodBody(@NotNull PsiMethod element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return UastLanguagePlugin.DefaultImpls.getMethodBody((UastLanguagePlugin)this, (PsiMethod)element3);
    }
}

