/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xmlb.annotations.Attribute;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginDescriptorConstants;
import org.jetbrains.idea.devkit.module.PluginModuleType;

@com.intellij.openapi.components.State(name="DevKit.ModuleBuildProperties")
public class PluginBuildConfiguration
implements PersistentStateComponent<State> {
    private final Module myModule;
    private final ConfigFileContainer myPluginXmlContainer;
    private VirtualFilePointer myManifestFilePointer;
    private boolean myUseUserManifest;
    @NonNls
    private static final String META_INF = "META-INF";
    @NonNls
    private static final String PLUGIN_XML = "plugin.xml";
    private State state;

    public PluginBuildConfiguration(@NotNull Module module) {
        if (module == null) {
            PluginBuildConfiguration.$$$reportNull$$$0(0);
        }
        this.myUseUserManifest = false;
        this.state = new State();
        this.myModule = module;
        this.myPluginXmlContainer = ConfigFileFactory.getInstance().createSingleFileContainer(this.myModule.getProject(), PluginDescriptorConstants.META_DATA);
        Disposer.register((Disposable)module, (Disposable)this.myPluginXmlContainer);
    }

    @Nullable
    public static PluginBuildConfiguration getInstance(@NotNull Module module) {
        if (module == null) {
            PluginBuildConfiguration.$$$reportNull$$$0(1);
        }
        return ModuleType.is((Module)module, (ModuleType)PluginModuleType.getInstance()) ? (PluginBuildConfiguration)module.getService(PluginBuildConfiguration.class) : null;
    }

    @Nullable
    public State getState() {
        this.state.url = this.getPluginXmlUrl();
        this.state.manifest = this.myManifestFilePointer == null ? null : this.myManifestFilePointer.getUrl();
        return this.state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PluginBuildConfiguration.$$$reportNull$$$0(2);
        }
        this.state = state;
        if (state.url != null) {
            this.myPluginXmlContainer.getConfiguration().replaceConfigFile(PluginDescriptorConstants.META_DATA, state.url);
        }
        if (state.manifest != null) {
            this.setManifestPath(VfsUtilCore.urlToPath((String)state.manifest));
        }
    }

    @Nullable
    public ConfigFile getPluginXML() {
        return this.myPluginXmlContainer.getConfigFile(PluginDescriptorConstants.META_DATA);
    }

    @TestOnly
    public void setPluginXmlFromVirtualFile(VirtualFile virtualFile) {
        this.myPluginXmlContainer.getConfiguration().replaceConfigFile(PluginDescriptorConstants.META_DATA, virtualFile.getUrl());
    }

    @TestOnly
    public void cleanupForNextTest() {
        this.myPluginXmlContainer.getConfiguration().removeConfigFiles(new ConfigFileMetaData[]{PluginDescriptorConstants.META_DATA});
    }

    private void createDescriptor(String url) {
        ConfigFileInfo descriptor = new ConfigFileInfo(PluginDescriptorConstants.META_DATA, url);
        this.myPluginXmlContainer.getConfiguration().addConfigFile(descriptor);
        ConfigFileFactory.getInstance().createFile(this.myModule.getProject(), descriptor.getUrl(), PluginDescriptorConstants.META_DATA.getDefaultVersion(), false);
    }

    @Nullable
    public ConfigFile getPluginXmlConfigFile() {
        return this.myPluginXmlContainer.getConfigFile(PluginDescriptorConstants.META_DATA);
    }

    @Nullable
    private String getPluginXmlUrl() {
        ConfigFile configFile = this.getPluginXmlConfigFile();
        return configFile != null ? configFile.getUrl() : null;
    }

    private String getDefaultLocation() {
        return new File(this.myModule.getModuleFilePath()).getParent() + File.separator + META_INF + File.separator + PLUGIN_XML;
    }

    @NotNull
    @NlsSafe
    public String getPluginXmlPath() {
        String url = this.getPluginXmlUrl();
        if (url == null) {
            String string = this.getDefaultLocation();
            if (string == null) {
                PluginBuildConfiguration.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url));
        if (string == null) {
            PluginBuildConfiguration.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setPluginXmlPathAndCreateDescriptorIfDoesntExist(String pluginXmlPath) {
        this.myPluginXmlContainer.getConfiguration().removeConfigFiles(new ConfigFileMetaData[]{PluginDescriptorConstants.META_DATA});
        WriteAction.runAndWait(() -> this.createDescriptor(VfsUtilCore.pathToUrl((String)pluginXmlPath)));
    }

    public void setManifestPath(@Nullable String manifestPath) {
        if (StringUtil.isEmpty((String)manifestPath)) {
            this.myManifestFilePointer = null;
            return;
        }
        VirtualFile manifest = LocalFileSystem.getInstance().findFileByPath(manifestPath);
        if (manifest == null) {
            Messages.showErrorDialog((Project)this.myModule.getProject(), (String)DevKitBundle.message("error.file.not.found.message", manifestPath), (String)DevKitBundle.message("error.file.not.found", new Object[0]));
            ReadAction.run(() -> {
                this.myManifestFilePointer = VirtualFilePointerManager.getInstance().create(VfsUtilCore.pathToUrl((String)manifestPath), (Disposable)this.myModule, null);
            });
        } else {
            ReadAction.run(() -> {
                this.myManifestFilePointer = VirtualFilePointerManager.getInstance().create(manifest, (Disposable)this.myModule, null);
            });
        }
    }

    @Nullable
    @NlsSafe
    public String getManifestPath() {
        return this.myManifestFilePointer != null ? FileUtil.toSystemDependentName((String)this.myManifestFilePointer.getPresentableUrl()) : null;
    }

    @Nullable
    public VirtualFile getManifest() {
        return this.myManifestFilePointer != null ? this.myManifestFilePointer.getFile() : null;
    }

    public boolean isUseUserManifest() {
        return this.myUseUserManifest;
    }

    public void setUseUserManifest(boolean useUserManifest) {
        this.myUseUserManifest = useUserManifest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/build/PluginBuildConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/build/PluginBuildConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginXmlPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class State {
        @Attribute
        String url;
        @Attribute
        String manifest;

        State() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            if (!Objects.equals(this.url, state.url)) {
                return false;
            }
            return Objects.equals(this.manifest, state.manifest);
        }

        public int hashCode() {
            int result = this.url != null ? this.url.hashCode() : 0;
            result = 31 * result + (this.manifest != null ? this.manifest.hashCode() : 0);
            return result;
        }
    }
}

