/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public final class LeakableMapKeyInspection
extends DevKitUastInspectionBase {
    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            LeakableMapKeyInspection.$$$reportNull$$$0(0);
        }
        return DevKitInspectionBase.isAllowedInPluginsOnly(holder.getFile());
    }

    @Override
    @NotNull
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            LeakableMapKeyInspection.$$$reportNull$$$0(1);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)holder.getProject());
        PsiFile file = holder.getFile();
        GlobalSearchScope resolveScope = file.getResolveScope();
        PsiClass languageClass = psiFacade.findClass(Language.class.getName(), resolveScope);
        PsiClass fileTypeClass = psiFacade.findClass(FileType.class.getName(), resolveScope);
        PsiClass mapClass = psiFacade.findClass(Map.class.getName(), resolveScope);
        if (languageClass == null || fileTypeClass == null || mapClass == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                LeakableMapKeyInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        UFieldVisitor visitor = new UFieldVisitor(holder, mapClass, Arrays.asList(languageClass, fileTypeClass));
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)file.getLanguage(), (AbstractUastNonRecursiveVisitor)visitor, (Class[])new Class[]{UField.class});
        if (psiElementVisitor == null) {
            LeakableMapKeyInspection.$$$reportNull$$$0(3);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/LeakableMapKeyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/LeakableMapKeyInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInternalVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAllowed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ReplaceKeyQuickFix
    implements LocalQuickFix {
        @NotNull
        @NonNls
        private final String myText;

        private ReplaceKeyQuickFix(@NonNls @NotNull String text) {
            if (text == null) {
                ReplaceKeyQuickFix.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.leakable.map.key.quick.fix.name", this.myText);
            if (string == null) {
                ReplaceKeyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ReplaceKeyQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ReplaceKeyQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement element = descriptor.getPsiElement();
            assert (ReplaceKeyQuickFix.isJavaTypeElement(element));
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            PsiTypeElement stringTypeElement = PsiElementFactory.getInstance((Project)project).createTypeElementFromText(this.myText, element.getContext());
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(element.replace((PsiElement)stringTypeElement));
        }

        @NotNull
        static @NotNull LocalQuickFix @NotNull [] createFixesFor(@NotNull PsiElement element) {
            LocalQuickFix[] localQuickFixArray;
            if (element == null) {
                ReplaceKeyQuickFix.$$$reportNull$$$0(4);
            }
            if (ReplaceKeyQuickFix.isJavaTypeElement(element)) {
                ReplaceKeyQuickFix[] replaceKeyQuickFixArray = new ReplaceKeyQuickFix[2];
                replaceKeyQuickFixArray[0] = new ReplaceKeyQuickFix("? super String");
                localQuickFixArray = replaceKeyQuickFixArray;
                replaceKeyQuickFixArray[1] = new ReplaceKeyQuickFix("String");
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            if (localQuickFixArray == null) {
                ReplaceKeyQuickFix.$$$reportNull$$$0(5);
            }
            return localQuickFixArray;
        }

        private static boolean isJavaTypeElement(@NotNull PsiElement element) {
            if (element == null) {
                ReplaceKeyQuickFix.$$$reportNull$$$0(6);
            }
            return element instanceof PsiTypeElement && element.getLanguage().is((Language)JavaLanguage.INSTANCE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/LeakableMapKeyInspection$ReplaceKeyQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/LeakableMapKeyInspection$ReplaceKeyQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFixesFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 5: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createFixesFor";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isJavaTypeElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class UFieldVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final ProblemsHolder myHolder;
        @NotNull
        private final PsiClassType myMapType;
        @NotNull
        private final List<? extends PsiClass> myBaseClasses;

        private UFieldVisitor(@NotNull ProblemsHolder holder, @NotNull PsiClass mapClass, @NotNull List<? extends PsiClass> classes) {
            if (holder == null) {
                UFieldVisitor.$$$reportNull$$$0(0);
            }
            if (mapClass == null) {
                UFieldVisitor.$$$reportNull$$$0(1);
            }
            if (classes == null) {
                UFieldVisitor.$$$reportNull$$$0(2);
            }
            this.myHolder = holder;
            this.myMapType = PsiElementFactory.getInstance((Project)holder.getProject()).createType(mapClass);
            this.myBaseClasses = classes;
        }

        public boolean visitField(@NotNull UField field) {
            PsiClass keyClass;
            PsiType fieldType;
            if (field == null) {
                UFieldVisitor.$$$reportNull$$$0(3);
            }
            if (this.myMapType.isAssignableFrom(fieldType = field.getType()) && (keyClass = UFieldVisitor.getKeyClass(fieldType)) != null && this.isLeakable(keyClass)) {
                PsiElement typeElement = UFieldVisitor.getTypeElement(field);
                PsiElement element = typeElement == null ? field.getNameIdentifier() : typeElement;
                this.myHolder.registerProblem(element, DevKitBundle.message("inspections.leakable.map.key.text", keyClass.getName()), ReplaceKeyQuickFix.createFixesFor(element));
            }
            return true;
        }

        private boolean isLeakable(@Nullable PsiClass keyClass) {
            return ContainerUtil.exists(this.myBaseClasses, baseClass -> InheritanceUtil.isInheritorOrSelf((PsiClass)keyClass, (PsiClass)baseClass, (boolean)true));
        }

        @Nullable
        private static PsiClass getKeyClass(@NotNull PsiType fieldType) {
            if (fieldType == null) {
                UFieldVisitor.$$$reportNull$$$0(4);
            }
            Object[] parameters = fieldType instanceof PsiClassType ? ((PsiClassType)fieldType).getParameters() : PsiType.EMPTY_ARRAY;
            PsiType parameterType = (PsiType)ArrayUtil.getFirstElement((Object[])parameters);
            PsiType boundType = parameterType instanceof PsiWildcardType ? ((PsiWildcardType)parameterType).getBound() : null;
            return PsiTypesUtil.getPsiClass((PsiType)(boundType == null ? parameterType : boundType));
        }

        @Nullable
        private static PsiElement getTypeElement(@NotNull UField field) {
            UTypeReferenceExpression typeReference;
            if (field == null) {
                UFieldVisitor.$$$reportNull$$$0(5);
            }
            PsiElement typeReferencePsi = (typeReference = field.getTypeReference()) == null ? null : typeReference.getSourcePsi();
            return typeReferencePsi instanceof PsiTypeElement ? UFieldVisitor.getFirstKey((PsiTypeElement)typeReferencePsi) : typeReferencePsi;
        }

        @Nullable
        private static PsiTypeElement getFirstKey(@NotNull PsiTypeElement typeElement) {
            PsiJavaCodeReferenceElement typeReference;
            if (typeElement == null) {
                UFieldVisitor.$$$reportNull$$$0(6);
            }
            if ((typeReference = typeElement.getInnermostComponentReferenceElement()) == null) {
                return null;
            }
            PsiReferenceParameterList parameterList = typeReference.getParameterList();
            return parameterList == null ? null : (PsiTypeElement)ArrayUtil.getFirstElement((Object[])parameterList.getTypeParameterElements());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classes";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeElement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/devkit/inspections/LeakableMapKeyInspection$UFieldVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getKeyClass";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTypeElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstKey";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

