/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.missingApi.resolve;

import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocation;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.BuildNumber;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.missingApi.resolve.LibrariesWithIntellijClassesSetting;
import org.jetbrains.idea.devkit.inspections.missingApi.resolve.LibraryCoordinatesState;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J<\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/resolve/IdeExternalAnnotationsLocationProvider;", "Lcom/intellij/codeInsight/externalAnnotation/location/AnnotationsLocationProvider;", "()V", "getAnnotationsLocations", "", "Lcom/intellij/codeInsight/externalAnnotation/location/AnnotationsLocation;", "ideVersion", "", "getLocations", "", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "artifactId", "groupId", "version", "intellij.devkit"})
public final class IdeExternalAnnotationsLocationProvider
implements AnnotationsLocationProvider {
    @NotNull
    public Collection<AnnotationsLocation> getLocations(@NotNull Project project, @NotNull Library library, @Nullable String artifactId, @Nullable String groupId, @Nullable String version) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            if (groupId == null || artifactId == null || version == null) {
                return CollectionsKt.emptyList();
            }
            List<LibraryCoordinatesState> libraries = LibrariesWithIntellijClassesSetting.Companion.getInstance(project).getIntellijApiContainingLibraries();
            Iterable $this$any$iv = libraries;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LibraryCoordinatesState it = (LibraryCoordinatesState)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getGroupId(), (Object)groupId) && Intrinsics.areEqual((Object)it.getArtifactId(), (Object)artifactId))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return this.getAnnotationsLocations(version);
        }
        return CollectionsKt.emptyList();
    }

    private final List<AnnotationsLocation> getAnnotationsLocations(String ideVersion) {
        Object object;
        if (StringsKt.endsWith$default((String)ideVersion, (String)"-SNAPSHOT", (boolean)false, (int)2, null)) {
            object = ideVersion;
        } else {
            BuildNumber buildNumber = BuildNumber.fromStringOrNull((String)ideVersion);
            if (buildNumber == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"BuildNumber.fromStringOr\u2026on) ?: return emptyList()");
            BuildNumber ideBuildNumber = buildNumber;
            object = ideBuildNumber.getBaselineVersion() + ".999999";
        }
        String annotationsVersion = object;
        return CollectionsKt.listOf((Object)new AnnotationsLocation("com.jetbrains.intellij.idea", "ideaIU", annotationsVersion, new String[]{"https://www.jetbrains.com/intellij-repository/releases/", "https://www.jetbrains.com/intellij-repository/snapshots/"}));
    }
}

