/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.dom.impl.ExtensionPointPropertyNameConverter;

public class AddWithTagFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("inspections.plugin.xml.fix.extension.point.add.with.tag", new Object[0]);
        if (string == null) {
            AddWithTagFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        DomElement element;
        if (project == null) {
            AddWithTagFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            AddWithTagFix.$$$reportNull$$$0(2);
        }
        if (!((element = DomUtil.getDomElement((PsiElement)descriptor.getPsiElement())) instanceof ExtensionPoint)) {
            return;
        }
        ExtensionPoint extensionPoint = (ExtensionPoint)element;
        List<PsiField> fields = extensionPoint.collectMissingWithTags();
        XmlAttributeValue navTarget = null;
        for (PsiField field : fields) {
            With with = extensionPoint.addWith();
            String tagName = ExtensionPointPropertyNameConverter.getAnnotationValue(field, Tag.class);
            if (tagName != null) {
                with.getTag().setStringValue(tagName);
            } else {
                String attributeName = ExtensionPointPropertyNameConverter.getAnnotationValue(field, Attribute.class);
                if (attributeName == null) {
                    attributeName = field.getName();
                }
                if ("forClass".equals(attributeName)) continue;
                with.getAttribute().setStringValue(attributeName);
            }
            String epName = extensionPoint.getName().getStringValue();
            String className = "";
            if (epName != null) {
                int pos = epName.lastIndexOf(46);
                epName = StringUtil.capitalize((String)(pos >= 0 ? epName.substring(pos + 1) : epName));
                PsiClass[] classesByName = PsiShortNamesCache.getInstance((Project)project).getClassesByName(epName, ProjectScope.getAllScope((Project)project));
                if (classesByName.length == 1) {
                    className = classesByName[0].getQualifiedName();
                }
            }
            with.getImplements().setStringValue(className);
            if (navTarget != null) continue;
            navTarget = with.getImplements().getXmlAttributeValue();
        }
        if (navTarget != null) {
            PsiNavigateUtil.navigate(navTarget);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/quickfix/AddWithTagFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/quickfix/AddWithTagFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

