/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.internal;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ApplicationComponents;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.ModuleComponents;
import org.jetbrains.idea.devkit.dom.ProjectComponents;
import org.jetbrains.idea.devkit.internal.AnalyzeUnloadablePluginsAction;
import org.jetbrains.idea.devkit.internal.PluginUnloadabilityStatus;
import org.jetbrains.idea.devkit.internal.UnloadabilityStatus;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J^\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/devkit/internal/AnalyzeUnloadablePluginsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "analyzePluginFile", "ideaPlugin", "Lorg/jetbrains/idea/devkit/dom/IdeaPlugin;", "analysisErrors", "", "", "components", "nonDynamicEPs", "", "unspecifiedDynamicEPs", "serviceOverrides", "allowOwnEPs", "", "analyzeUnloadable", "Lorg/jetbrains/idea/devkit/internal/PluginUnloadabilityStatus;", "allPlugins", "", "Lcom/intellij/psi/xml/XmlFile;", "resolvePluginDependency", "dependency", "Lorg/jetbrains/idea/devkit/dom/Dependency;", "showReport", "project", "Lcom/intellij/openapi/project/Project;", "result", "intellij.devkit"})
public final class AnalyzeUnloadablePluginsAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        IdeView view;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        IdeView ideView = view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        PsiDirectory dir = ideView != null ? ideView.getOrChooseDirectory() : null;
        List result = new ArrayList();
        ProgressManager progressManager = ProgressManager.getInstance();
        Runnable runnable = new Runnable(this, dir, project2, result){
            final /* synthetic */ AnalyzeUnloadablePluginsAction this$0;
            final /* synthetic */ PsiDirectory $dir;
            final /* synthetic */ Project $project;
            final /* synthetic */ List $result;

            public final void run() {
                boolean $i$f$runReadAction = false;
                ApplicationManager.getApplication().runReadAction(new Computable(this){
                    final /* synthetic */ actionPerformed.show.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final T compute() {
                        void $this$filterIsInstanceTo$iv$iv;
                        void $this$filterIsInstance$iv22;
                        PsiFile[] psiFileArray;
                        ProgressIndicator pi;
                        boolean bl = false;
                        ProgressManager progressManager = ProgressManager.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                        ProgressIndicator progressIndicator = pi = progressManager.getProgressIndicator();
                        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"pi");
                        progressIndicator.setIndeterminate(false);
                        PsiDirectory psiDirectory = this.this$0.$dir;
                        GlobalSearchScope globalSearchScope = psiDirectory == null ? GlobalSearchScopesCore.projectProductionScope((Project)this.this$0.$project) : GlobalSearchScopesCore.directoryScope((PsiDirectory)this.this$0.$dir, (boolean)true);
                        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"when (dir) {\n           \u2026pe(dir, true)\n          }");
                        GlobalSearchScope searchScope = globalSearchScope;
                        Object[] objectArray = FilenameIndex.getFilesByName((Project)this.this$0.$project, (String)"plugin.xml", (GlobalSearchScope)searchScope);
                        if (objectArray.length == 0) {
                            boolean bl2 = false;
                            psiFileArray = FilenameIndex.getFilesByName((Project)this.this$0.$project, (String)"plugin.xml", (GlobalSearchScope)GlobalSearchScopesCore.projectProductionScope((Project)this.this$0.$project));
                        } else {
                            psiFileArray = objectArray;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"FilenameIndex.getFilesBy\u2026oductionScope(project)) }");
                        objectArray = psiFileArray;
                        boolean $i$f$filterIsInstance = false;
                        Iterator<T> iterator = $this$filterIsInstance$iv22;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof XmlFile)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List pluginXmlFiles = (List)destination$iv$iv;
                        boolean $this$filterIsInstance$iv22 = false;
                        for (XmlFile pluginXmlFile : (Iterable)pluginXmlFiles) {
                            void processed;
                            pi.checkCanceled();
                            pi.setFraction((double)processed / (double)pluginXmlFiles.size());
                            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.this$0.$project);
                            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                            if (projectRootManager.getFileIndex().isUnderSourceRootOfType(pluginXmlFile.getVirtualFile(), JavaModuleSourceRootTypes.PRODUCTION)) {
                                if (DescriptorUtil.getIdeaPlugin(pluginXmlFile) == null) {
                                } else {
                                    IdeaPlugin ideaPlugin;
                                    Intrinsics.checkNotNullExpressionValue((Object)ideaPlugin, (String)"DescriptorUtil.getIdeaPl\u2026luginXmlFile) ?: continue");
                                    GenericAttributeValue<Boolean> genericAttributeValue = ideaPlugin.getRequireRestart();
                                    Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"ideaPlugin.requireRestart");
                                    if (!Intrinsics.areEqual((Object)((Boolean)genericAttributeValue.getValue()), (Object)true)) {
                                        PluginUnloadabilityStatus status = AnalyzeUnloadablePluginsAction.access$analyzeUnloadable(this.this$0.this$0, ideaPlugin, pluginXmlFiles);
                                        this.this$0.$result.add(status);
                                        pi.setText(status.getPluginId());
                                    }
                                }
                            }
                            ++processed;
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            }
            {
                this.this$0 = analyzeUnloadablePluginsAction;
                this.$dir = psiDirectory;
                this.$project = project;
                this.$result = list;
            }
        };
        Object[] objectArray = new Object[1];
        Object object = dir;
        if (object == null || (object = object.getName()) == null) {
            object = "Project";
        }
        objectArray[0] = object;
        boolean show2 = progressManager.runProcessWithProgressSynchronously(runnable, DevKitBundle.message("action.AnalyzeUnloadablePlugins.progress.title", objectArray), true, e.getProject());
        if (show2) {
            this.showReport(project2, result);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showReport(Project project, List<PluginUnloadabilityStatus> result) {
        void $this$filterTo$iv$iv;
        StringBuilder $this$filterTo$iv$iv3;
        Object status72;
        StringBuilder $this$filterTo$iv$iv4;
        Object status222;
        Object $this$filterTo$iv$iv5;
        Object status322;
        StringBuilder $this$sortedByDescending$iv2;
        StringBuilder $this$filterTo$iv$iv6;
        Object element$iv$iv;
        StringBuilder $this$filterTo$iv$iv2;
        Object status522;
        Object element$iv$iv2;
        StringBuilder $this$filterTo$iv$iv7;
        Object it;
        Object element$iv;
        boolean bl;
        Object $this$any$iv;
        StringBuilder $this$buildString;
        StringBuilder stringBuilder;
        block35: {
            $this$buildString = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$any$iv = result;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator object = $this$any$iv.iterator();
                while (object.hasNext()) {
                    element$iv = object.next();
                    it = (PluginUnloadabilityStatus)element$iv;
                    boolean bl3 = false;
                    Collection collection = ((PluginUnloadabilityStatus)it).getAnalysisErrors();
                    boolean bl4 = !collection.isEmpty();
                    if (!bl4) continue;
                    bl = true;
                    break block35;
                }
                bl = false;
            }
        }
        if (bl) {
            StringBuilder $this$filterTo$iv$iv8;
            $this$any$iv = $this$buildString;
            String $i$f$any = "Analysis errors:";
            StringBuilder stringBuilder2 = ((StringBuilder)$this$any$iv).append($i$f$any);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            element$iv = stringBuilder2.append('\n');
            Intrinsics.checkNotNullExpressionValue(element$iv, (String)"append('\\n')");
            Iterable iterable = result;
            boolean $i$f$filter222 = false;
            it = iterable;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            Iterator iterator = $this$filterTo$iv$iv8.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv22 = iterator.next();
                PluginUnloadabilityStatus pluginUnloadabilityStatus = (PluginUnloadabilityStatus)element$iv$iv22;
                boolean bl5 = false;
                Collection collection = pluginUnloadabilityStatus.getAnalysisErrors();
                if (!(!collection.isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv22);
            }
            for (PluginUnloadabilityStatus status6 : (List)destination$iv$iv) {
                StringBuilder stringBuilder3 = $this$buildString;
                Object $i$f$filter222 = status6.getPluginId();
                $this$filterTo$iv$iv8 = stringBuilder3.append((String)$i$f$filter222);
                Intrinsics.checkNotNullExpressionValue((Object)$this$filterTo$iv$iv8, (String)"append(value)");
                destination$iv$iv = $this$filterTo$iv$iv8.append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv, (String)"append('\\n')");
                for (String string : status6.getAnalysisErrors()) {
                    $this$filterTo$iv$iv8 = $this$buildString;
                    destination$iv$iv = $this$filterTo$iv$iv8.append(string);
                    Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv, (String)"append(value)");
                    StringBuilder $i$f$filterTo22 = ((StringBuilder)destination$iv$iv).append('\n');
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo22, (String)"append('\\n')");
                }
                StringBuilder stringBuilder4 = $this$buildString;
                $i$f$filter222 = stringBuilder4.append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$filter222, (String)"append('\\n')");
            }
        }
        Object $this$filter$iv = result;
        boolean bl5 = false;
        Iterable $i$f$filter222 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo32 = false;
        Object $i$f$filterTo22 = $this$filterTo$iv$iv7.iterator();
        while ($i$f$filterTo22.hasNext()) {
            element$iv$iv2 = $i$f$filterTo22.next();
            PluginUnloadabilityStatus it3 = (PluginUnloadabilityStatus)element$iv$iv2;
            boolean bl6 = false;
            if (!(it3.getStatus() == UnloadabilityStatus.UNLOADABLE)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List unloadablePlugins = (List)destination$iv$iv;
        $this$filter$iv = $this$buildString;
        String string = "Can unload " + unloadablePlugins.size() + " plugins out of " + result.size();
        $this$filterTo$iv$iv7 = ((StringBuilder)$this$filter$iv).append(string);
        Intrinsics.checkNotNullExpressionValue((Object)$this$filterTo$iv$iv7, (String)"append(value)");
        destination$iv$iv = $this$filterTo$iv$iv7.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv, (String)"append('\\n')");
        for (Object status522 : unloadablePlugins) {
            $this$filterTo$iv$iv7 = $this$buildString;
            destination$iv$iv = ((PluginUnloadabilityStatus)status522).getPluginId();
            StringBuilder $i$f$filterTo32 = $this$filterTo$iv$iv7.append((String)destination$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo32, (String)"append(value)");
            $i$f$filterTo22 = $i$f$filterTo32.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo22, (String)"append('\\n')");
        }
        status522 = $this$buildString;
        StringBuilder stringBuilder5 = ((StringBuilder)status522).append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append('\\n')");
        Iterable iterable = result;
        boolean $i$f$filter3 = false;
        destination$iv$iv = iterable;
        Iterator<String> destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2222 = false;
        element$iv$iv2 = $this$filterTo$iv$iv2.iterator();
        while (element$iv$iv2.hasNext()) {
            element$iv$iv = element$iv$iv2.next();
            PluginUnloadabilityStatus pluginUnloadabilityStatus = (PluginUnloadabilityStatus)element$iv$iv;
            boolean bl7 = false;
            if (!(pluginUnloadabilityStatus.getStatus() == UnloadabilityStatus.USES_COMPONENTS)) continue;
            destination$iv$iv2.add((String)element$iv$iv);
        }
        Iterable iterable2 = (List)((Object)destination$iv$iv2);
        boolean $i$f$sortedByDescending232 = false;
        List pluginsUsingComponents = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getComponents().size());
                it = (PluginUnloadabilityStatus)a;
                Comparable comparable2 = comparable;
                bl = false;
                Integer n = it.getComponents().size();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        StringBuilder stringBuilder6 = $this$buildString;
        Object $i$f$sortedByDescending232 = "Plugins using components (" + pluginsUsingComponents.size() + "):";
        $this$filterTo$iv$iv2 = stringBuilder6.append((String)$i$f$sortedByDescending232);
        Intrinsics.checkNotNullExpressionValue((Object)$this$filterTo$iv$iv2, (String)"append(value)");
        destination$iv$iv2 = $this$filterTo$iv$iv2.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv2, (String)"append('\\n')");
        for (PluginUnloadabilityStatus pluginUnloadabilityStatus : pluginsUsingComponents) {
            $this$filterTo$iv$iv2 = $this$buildString;
            destination$iv$iv2 = pluginUnloadabilityStatus.getPluginId() + " (" + pluginUnloadabilityStatus.getComponents().size() + ")";
            StringBuilder $i$f$filterTo2222 = $this$filterTo$iv$iv2.append((String)((Object)destination$iv$iv2));
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo2222, (String)"append(value)");
            element$iv$iv2 = $i$f$filterTo2222.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)element$iv$iv2, (String)"append('\\n')");
            for (String componentName : pluginUnloadabilityStatus.getComponents()) {
                $i$f$filterTo2222 = $this$buildString;
                element$iv$iv2 = "  " + componentName;
                element$iv$iv = $i$f$filterTo2222.append((String)element$iv$iv2);
                Intrinsics.checkNotNullExpressionValue((Object)element$iv$iv, (String)"append(value)");
                StringBuilder stringBuilder7 = ((StringBuilder)element$iv$iv).append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append('\\n')");
            }
        }
        StringBuilder stringBuilder8 = $this$buildString;
        $i$f$sortedByDescending232 = stringBuilder8.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$sortedByDescending232, (String)"append('\\n')");
        Iterable $this$filter$iv3 = result;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv3;
        Object destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo422 = false;
        element$iv$iv = $this$filterTo$iv$iv6.iterator();
        while (element$iv$iv.hasNext()) {
            Object e = element$iv$iv.next();
            PluginUnloadabilityStatus it5 = (PluginUnloadabilityStatus)e;
            boolean bl8 = false;
            if (!(it5.getStatus() == UnloadabilityStatus.USES_SERVICE_OVERRIDES)) continue;
            destination$iv$iv3.add(e);
        }
        $this$filter$iv3 = (List)destination$iv$iv3;
        boolean $i$f$sortedByDescending332 = false;
        List list = CollectionsKt.sortedWith((Iterable)((Object)$this$sortedByDescending$iv2), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getServiceOverrides().size());
                it = (PluginUnloadabilityStatus)a;
                Comparable comparable2 = comparable;
                bl = false;
                Integer n = it.getServiceOverrides().size();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        $this$sortedByDescending$iv2 = $this$buildString;
        Object $i$f$sortedByDescending332 = "Plugins using service overrides (" + list.size() + "):";
        $this$filterTo$iv$iv6 = $this$sortedByDescending$iv2.append((String)$i$f$sortedByDescending332);
        Intrinsics.checkNotNullExpressionValue((Object)$this$filterTo$iv$iv6, (String)"append(value)");
        destination$iv$iv3 = $this$filterTo$iv$iv6.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv3, (String)"append('\\n')");
        for (Object status322 : list) {
            $this$filterTo$iv$iv6 = $this$buildString;
            destination$iv$iv3 = ((PluginUnloadabilityStatus)status322).getPluginId() + " (" + CollectionsKt.joinToString$default((Iterable)((PluginUnloadabilityStatus)status322).getServiceOverrides(), null, null, null, (int)0, null, null, (int)63, null) + ")";
            StringBuilder $i$f$filterTo422 = $this$filterTo$iv$iv6.append((String)destination$iv$iv3);
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo422, (String)"append(value)");
            element$iv$iv = $i$f$filterTo422.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)element$iv$iv, (String)"append('\\n')");
        }
        status322 = $this$buildString;
        $i$f$sortedByDescending332 = ((StringBuilder)status322).append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$sortedByDescending332, (String)"append('\\n')");
        Object $this$filter$iv4 = result;
        boolean $i$f$filter432 = false;
        destination$iv$iv3 = $this$filter$iv4;
        Iterator destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo522 = false;
        Iterator iterator = $this$filterTo$iv$iv5.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv4 = iterator.next();
            PluginUnloadabilityStatus it6 = (PluginUnloadabilityStatus)element$iv$iv4;
            boolean bl9 = false;
            if (!(it6.getStatus() == UnloadabilityStatus.NON_DYNAMIC_IN_DEPENDENCIES)) continue;
            destination$iv$iv4.add(element$iv$iv4);
        }
        List pluginsWithOptionalDependencies = (List)((Object)destination$iv$iv4);
        $this$filter$iv4 = $this$buildString;
        Object $i$f$filter432 = "Plugins not unloadable because of non-dynamic EPs in optional dependencies (" + pluginsWithOptionalDependencies.size() + "):";
        $this$filterTo$iv$iv5 = ((StringBuilder)$this$filter$iv4).append((String)$i$f$filter432);
        Intrinsics.checkNotNullExpressionValue((Object)$this$filterTo$iv$iv5, (String)"append(value)");
        destination$iv$iv4 = ((StringBuilder)$this$filterTo$iv$iv5).append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv4, (String)"append('\\n')");
        for (Object status222 : pluginsWithOptionalDependencies) {
            $this$filterTo$iv$iv5 = $this$buildString;
            destination$iv$iv4 = ((PluginUnloadabilityStatus)status222).getPluginId();
            Object $i$f$filterTo522 = ((StringBuilder)$this$filterTo$iv$iv5).append((String)((Object)destination$iv$iv4));
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo522, (String)"append(value)");
            StringBuilder stringBuilder9 = ((StringBuilder)$i$f$filterTo522).append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append('\\n')");
            $i$f$filterTo522 = ((PluginUnloadabilityStatus)status222).getNonDynamicEPsInDependencies();
            destination$iv$iv4 = $i$f$filterTo522.entrySet().iterator();
            while (destination$iv$iv4.hasNext()) {
                void pluginId;
                Object element$iv$iv4 = $this$filterTo$iv$iv5 = destination$iv$iv4.next();
                $i$f$filterTo522 = (String)element$iv$iv4.getKey();
                element$iv$iv4 = $this$filterTo$iv$iv5;
                Set set = (Set)element$iv$iv4.getValue();
                element$iv$iv4 = $this$buildString;
                String it6 = "  " + (String)pluginId + " - " + CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, null, (int)63, null);
                StringBuilder bl9 = ((StringBuilder)element$iv$iv4).append(it6);
                Intrinsics.checkNotNullExpressionValue((Object)bl9, (String)"append(value)");
                StringBuilder stringBuilder10 = bl9.append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append('\\n')");
            }
        }
        status222 = $this$buildString;
        $i$f$filter432 = ((StringBuilder)status222).append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$filter432, (String)"append('\\n')");
        Object $this$filter$iv5 = result;
        boolean $i$f$filter532 = false;
        destination$iv$iv4 = $this$filter$iv5;
        Iterator<String> destination$iv$iv5 = new ArrayList();
        boolean bl7 = false;
        Object element$iv$iv4 = $this$filterTo$iv$iv4.iterator();
        while (element$iv$iv4.hasNext()) {
            Object element$iv$iv5 = element$iv$iv4.next();
            PluginUnloadabilityStatus it7 = (PluginUnloadabilityStatus)element$iv$iv5;
            boolean bl10 = false;
            if (!(it7.getStatus() == UnloadabilityStatus.DEPENDENCIES_WITHOUT_SEPARATE_CLASSLOADERS)) continue;
            destination$iv$iv5.add((String)element$iv$iv5);
        }
        List pluginsWithDependenciesWithoutSeparateClassloaders = (List)((Object)destination$iv$iv5);
        $this$filter$iv5 = $this$buildString;
        Object $i$f$filter532 = "Plugins not unloadable because of optional dependencies without separate classloaders (" + pluginsWithDependenciesWithoutSeparateClassloaders.size() + "):";
        $this$filterTo$iv$iv4 = ((StringBuilder)$this$filter$iv5).append((String)$i$f$filter532);
        Intrinsics.checkNotNullExpressionValue((Object)$this$filterTo$iv$iv4, (String)"append(value)");
        destination$iv$iv5 = $this$filterTo$iv$iv4.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv5, (String)"append('\\n')");
        for (Object status72 : pluginsWithDependenciesWithoutSeparateClassloaders) {
            $this$filterTo$iv$iv4 = $this$buildString;
            destination$iv$iv5 = ((PluginUnloadabilityStatus)status72).getPluginId();
            StringBuilder stringBuilder11 = $this$filterTo$iv$iv4.append((String)((Object)destination$iv$iv5));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(value)");
            element$iv$iv4 = stringBuilder11.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)element$iv$iv4, (String)"append('\\n')");
            for (String pluginId : ((PluginUnloadabilityStatus)status72).getDependenciesWithoutSeparateClassloaders()) {
                StringBuilder stringBuilder12 = $this$buildString;
                element$iv$iv4 = "  " + pluginId;
                StringBuilder element$iv$iv5 = stringBuilder12.append((String)element$iv$iv4);
                Intrinsics.checkNotNullExpressionValue((Object)element$iv$iv5, (String)"append(value)");
                StringBuilder it7 = element$iv$iv5.append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)it7, (String)"append('\\n')");
            }
        }
        status72 = $this$buildString;
        $i$f$filter532 = ((StringBuilder)status72).append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$filter532, (String)"append('\\n')");
        Object $this$filter$iv6 = result;
        boolean $i$f$filter622 = false;
        destination$iv$iv5 = $this$filter$iv6;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo722 = false;
        Object element$iv$iv5 = $this$filterTo$iv$iv3.iterator();
        while (element$iv$iv5.hasNext()) {
            Object element$iv$iv6 = element$iv$iv5.next();
            PluginUnloadabilityStatus it8 = (PluginUnloadabilityStatus)element$iv$iv6;
            boolean bl11 = false;
            if (!(it8.getStatus() == UnloadabilityStatus.USES_NON_DYNAMIC_EPS)) continue;
            collection.add(element$iv$iv6);
        }
        List nonDynamicPlugins = (List)collection;
        $this$filter$iv6 = nonDynamicPlugins;
        if (!$this$filter$iv6.isEmpty()) {
            Object nonDynamicPlugin22;
            $this$filter$iv6 = $this$buildString;
            Object $i$f$filter622 = "Plugins with EPs explicitly marked as dynamic=false:";
            $this$filterTo$iv$iv3 = ((StringBuilder)$this$filter$iv6).append((String)$i$f$filter622);
            Intrinsics.checkNotNullExpressionValue((Object)$this$filterTo$iv$iv3, (String)"append(value)");
            StringBuilder stringBuilder13 = $this$filterTo$iv$iv3.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append('\\n')");
            for (Object nonDynamicPlugin22 : nonDynamicPlugins) {
                $this$filterTo$iv$iv3 = $this$buildString;
                String string2 = ((PluginUnloadabilityStatus)nonDynamicPlugin22).getPluginId() + " (" + ((PluginUnloadabilityStatus)nonDynamicPlugin22).getNonDynamicEPs().size() + ")";
                StringBuilder $i$f$filterTo722 = $this$filterTo$iv$iv3.append(string2);
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo722, (String)"append(value)");
                element$iv$iv5 = $i$f$filterTo722.append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)element$iv$iv5, (String)"append('\\n')");
                for (String ep : ((PluginUnloadabilityStatus)nonDynamicPlugin22).getNonDynamicEPs()) {
                    $i$f$filterTo722 = $this$buildString;
                    element$iv$iv5 = "  " + ep;
                    StringBuilder element$iv$iv6 = $i$f$filterTo722.append((String)element$iv$iv5);
                    Intrinsics.checkNotNullExpressionValue((Object)element$iv$iv6, (String)"append(value)");
                    StringBuilder it8 = element$iv$iv6.append('\n');
                    Intrinsics.checkNotNullExpressionValue((Object)it8, (String)"append('\\n')");
                }
            }
            nonDynamicPlugin22 = $this$buildString;
            $i$f$filter622 = ((StringBuilder)nonDynamicPlugin22).append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$filter622, (String)"append('\\n')");
        }
        Object $this$filter$iv7 = result;
        boolean $i$f$filter722 = false;
        Iterable iterable3 = $this$filter$iv7;
        Object destination$iv$iv7 = new ArrayList();
        boolean $i$f$filterTo822 = false;
        for (Object element$iv$iv7 : iterable3) {
            boolean bl8;
            block36: {
                PluginUnloadabilityStatus it9 = (PluginUnloadabilityStatus)element$iv$iv7;
                boolean bl13 = false;
                Iterable $this$any$iv2 = it9.getUnspecifiedDynamicEPs();
                boolean $i$f$any = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl8 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv2) {
                        String it10 = (String)element$iv2;
                        boolean bl14 = false;
                        if (!(!StringsKt.startsWith$default((String)it10, (String)"cidr", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it10, (String)"appcode", (boolean)false, (int)2, null))) continue;
                        bl8 = true;
                        break block36;
                    }
                    bl8 = false;
                }
            }
            if (!bl8) continue;
            destination$iv$iv7.add(element$iv$iv7);
        }
        List closePlugins = (List)destination$iv$iv7;
        $this$filter$iv7 = closePlugins;
        if (!$this$filter$iv7.isEmpty()) {
            Object status822;
            $this$filter$iv7 = $this$buildString;
            Object $i$f$filter722 = "Plugins with non-dynamic EPs (" + closePlugins.size() + "):";
            StringBuilder stringBuilder14 = ((StringBuilder)$this$filter$iv7).append((String)$i$f$filter722);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(value)");
            destination$iv$iv7 = stringBuilder14.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv7, (String)"append('\\n')");
            Iterable iterable4 = closePlugins;
            boolean $i$f$sortedBy22 = false;
            for (Object status822 : CollectionsKt.sortedWith((Iterable)iterable4, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getUnspecifiedDynamicEPs().size());
                    it = (PluginUnloadabilityStatus)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    Integer n = it.getUnspecifiedDynamicEPs().size();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            })) {
                StringBuilder stringBuilder15 = $this$buildString;
                String $i$f$sortedBy22 = ((PluginUnloadabilityStatus)status822).getPluginId() + " (" + ((PluginUnloadabilityStatus)status822).getUnspecifiedDynamicEPs().size() + ")";
                StringBuilder $i$f$filterTo822 = stringBuilder15.append($i$f$sortedBy22);
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo822, (String)"append(value)");
                Object element$iv$iv6 = $i$f$filterTo822.append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)element$iv$iv6, (String)"append('\\n')");
                for (String string3 : ((PluginUnloadabilityStatus)status822).getUnspecifiedDynamicEPs()) {
                    $i$f$filterTo822 = $this$buildString;
                    element$iv$iv6 = "  " + string3;
                    StringBuilder element$iv$iv7 = $i$f$filterTo822.append((String)element$iv$iv6);
                    Intrinsics.checkNotNullExpressionValue((Object)element$iv$iv7, (String)"append(value)");
                    StringBuilder stringBuilder16 = element$iv$iv7.append('\n');
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append('\\n')");
                }
            }
            status822 = $this$buildString;
            $i$f$filter722 = ((StringBuilder)status822).append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$filter722, (String)"append('\\n')");
        }
        Map epUsagesMap = new LinkedHashMap();
        for (PluginUnloadabilityStatus pluginUnloadabilityStatus : result) {
            for (String ep : pluginUnloadabilityStatus.getUnspecifiedDynamicEPs()) {
                epUsagesMap.put(ep, ((Number)epUsagesMap.getOrDefault(ep, 0)).intValue() + 1);
            }
        }
        Iterable iterable5 = MapsKt.toList((Map)epUsagesMap);
        boolean $i$f$filter8 = false;
        Iterable $i$f$filterTo822 = iterable5;
        Collection destination$iv$iv8 = new ArrayList();
        boolean $i$f$filterTo9 = false;
        for (Object element$iv$iv8 : $this$filterTo$iv$iv) {
            Pair it11 = (Pair)element$iv$iv8;
            boolean bl15 = false;
            if (!(!StringsKt.startsWith$default((String)((String)it11.getFirst()), (String)"cidr", (boolean)false, (int)2, null))) continue;
            destination$iv$iv8.add(element$iv$iv8);
        }
        Iterable iterable6 = (List)destination$iv$iv8;
        boolean $i$f$sortedByDescending = false;
        List epUsagesList = CollectionsKt.sortedWith((Iterable)iterable6, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                Integer n = (Integer)it.getSecond();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        StringBuilder stringBuilder17 = $this$buildString;
        String string4 = "EP usage statistics (" + epUsagesList.size() + " non-dynamic EPs remaining):";
        StringBuilder stringBuilder18 = stringBuilder17.append(string4);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18, (String)"append(value)");
        StringBuilder stringBuilder19 = stringBuilder18.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19, (String)"append('\\n')");
        for (Pair pair : epUsagesList) {
            $this$buildString.append(((Number)pair.getSecond()).intValue() + ": " + (String)pair.getFirst());
            stringBuilder18 = $this$buildString;
            stringBuilder19 = stringBuilder18.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19, (String)"append('\\n')");
        }
        String string5 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
        String report = string5;
        $this$buildString = StringCompanionObject.INSTANCE;
        String bl2 = "AnalyzeUnloadablePlugins-Report-%s.txt";
        Object[] objectArray = new Object[]{DateFormatUtil.formatDateTime((long)System.currentTimeMillis())};
        String string3 = String.format(bl2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        String fileName = string3;
        LightVirtualFile file = new LightVirtualFile(fileName, (CharSequence)report);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    /*
     * WARNING - void declaration
     */
    private final PluginUnloadabilityStatus analyzeUnloadable(IdeaPlugin ideaPlugin, List<? extends XmlFile> allPlugins) {
        void $this$mapNotNullTo$iv$iv;
        Set unspecifiedDynamicEPs = new LinkedHashSet();
        Set nonDynamicEPs = new LinkedHashSet();
        List analysisErrors = new ArrayList();
        List serviceOverrides = new ArrayList();
        List components = new ArrayList();
        this.analyzePluginFile(ideaPlugin, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides, true);
        var $fun$analyzeDependencies$1 = new Function1<IdeaPlugin, Unit>(this, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides){
            final /* synthetic */ AnalyzeUnloadablePluginsAction this$0;
            final /* synthetic */ List $analysisErrors;
            final /* synthetic */ List $components;
            final /* synthetic */ Set $nonDynamicEPs;
            final /* synthetic */ Set $unspecifiedDynamicEPs;
            final /* synthetic */ List $serviceOverrides;

            public final void invoke(@NotNull IdeaPlugin ideaPlugin) {
                Intrinsics.checkNotNullParameter((Object)ideaPlugin, (String)"ideaPlugin");
                Iterator<Dependency> iterator = ideaPlugin.getDepends().iterator();
                while (iterator.hasNext()) {
                    String configFileName;
                    Dependency dependency;
                    Dependency dependency2 = dependency = iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)dependency2, (String)"dependency");
                    GenericAttributeValue<PathReference> genericAttributeValue = dependency2.getConfigFile();
                    Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"dependency.configFile");
                    if (genericAttributeValue.getStringValue() == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)configFileName, (String)"dependency.configFile.stringValue ?: continue");
                    IdeaPlugin depIdeaPlugin = AnalyzeUnloadablePluginsAction.access$resolvePluginDependency(this.this$0, dependency);
                    if (depIdeaPlugin == null) {
                        this.$analysisErrors.add("Failed to resolve dependency descriptor file " + configFileName);
                        continue;
                    }
                    AnalyzeUnloadablePluginsAction.access$analyzePluginFile(this.this$0, depIdeaPlugin, this.$analysisErrors, this.$components, this.$nonDynamicEPs, this.$unspecifiedDynamicEPs, this.$serviceOverrides, true);
                    this.invoke(depIdeaPlugin);
                }
            }
            {
                this.this$0 = analyzeUnloadablePluginsAction;
                this.$analysisErrors = list;
                this.$components = list2;
                this.$nonDynamicEPs = set;
                this.$unspecifiedDynamicEPs = set2;
                this.$serviceOverrides = list3;
                super(1);
            }
        };
        $fun$analyzeDependencies$1.invoke(ideaPlugin);
        List componentsInOptionalDependencies = new ArrayList();
        Map nonDynamicEPsInOptionalDependencies = new LinkedHashMap();
        List serviceOverridesInDependencies = new ArrayList();
        List dependenciesWithoutSeparateClassloaders = new ArrayList();
        Iterable $this$mapNotNull$iv = allPlugins;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IdeaPlugin ideaPlugin2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            XmlFile it = (XmlFile)element$iv$iv;
            boolean bl2 = false;
            IdeaPlugin ideaPlugin3 = DescriptorUtil.getIdeaPlugin(it);
            if (ideaPlugin3 == null) continue;
            IdeaPlugin it$iv$iv = ideaPlugin2 = ideaPlugin3;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterator iterator2 = ((List)destination$iv$iv).iterator();
        while (iterator2.hasNext()) {
            IdeaPlugin descriptor;
            IdeaPlugin ideaPlugin4 = descriptor = (IdeaPlugin)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPlugin4, (String)"descriptor");
            Iterator<Dependency> iterator3 = ideaPlugin4.getDepends().iterator();
            while (iterator3.hasNext()) {
                Dependency dependency;
                Dependency dependency2 = dependency = iterator3.next();
                Intrinsics.checkNotNullExpressionValue((Object)dependency2, (String)"dependency");
                GenericAttributeValue<Boolean> genericAttributeValue = dependency2.getOptional();
                Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"dependency.optional");
                if (!Intrinsics.areEqual((Object)((Boolean)genericAttributeValue.getValue()), (Object)true) || !Intrinsics.areEqual((Object)dependency.getValue(), (Object)ideaPlugin)) continue;
                IdeaPlugin depIdeaPlugin = this.resolvePluginDependency(dependency);
                if (depIdeaPlugin == null) {
                    GenericAttributeValue<PathReference> genericAttributeValue2 = dependency.getConfigFile();
                    Intrinsics.checkNotNullExpressionValue(genericAttributeValue2, (String)"dependency.configFile");
                    if (genericAttributeValue2.getStringValue() == null) continue;
                    GenericAttributeValue<PathReference> genericAttributeValue3 = dependency.getConfigFile();
                    Intrinsics.checkNotNullExpressionValue(genericAttributeValue3, (String)"dependency.configFile");
                    analysisErrors.add("Failed to resolve dependency descriptor file " + genericAttributeValue3.getStringValue());
                    continue;
                }
                if (descriptor.getPluginId() != null) {
                    Collection pluginId = destination$iv$iv;
                    boolean bl = false;
                    GenericAttributeValue<PsiPackage> genericAttributeValue4 = depIdeaPlugin.getPackage();
                    Intrinsics.checkNotNullExpressionValue(genericAttributeValue4, (String)"depIdeaPlugin.`package`");
                    if (genericAttributeValue4.getRawText() == null) {
                        Collection collection = pluginId;
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"pluginId");
                        dependenciesWithoutSeparateClassloaders.add(collection);
                    }
                }
                Set nonDynamicEPsInDependency = new LinkedHashSet();
                this.analyzePluginFile(depIdeaPlugin, analysisErrors, componentsInOptionalDependencies, nonDynamicEPsInDependency, nonDynamicEPsInDependency, serviceOverridesInDependencies, false);
                Collection collection = nonDynamicEPsInDependency;
                if (!(!collection.isEmpty())) continue;
                String string = descriptor.getPluginId();
                if (string == null) {
                    string = "<unknown>";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.pluginId ?: \"<unknown>\"");
                nonDynamicEPsInOptionalDependencies.put(string, nonDynamicEPsInDependency);
            }
        }
        String string = ideaPlugin.getPluginId();
        if (string == null) {
            string = "?";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ideaPlugin.pluginId ?: \"?\"");
        return new PluginUnloadabilityStatus(string, unspecifiedDynamicEPs, nonDynamicEPs, nonDynamicEPsInOptionalDependencies, dependenciesWithoutSeparateClassloaders, components, serviceOverrides, analysisErrors);
    }

    private final IdeaPlugin resolvePluginDependency(Dependency dependency) {
        IdeaPlugin ideaPlugin;
        XmlFile xmlFile = dependency.getResolvedConfigFile();
        GenericAttributeValue<PathReference> genericAttributeValue = dependency.getConfigFile();
        Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"dependency.configFile");
        String configFileName = genericAttributeValue.getStringValue();
        if (xmlFile == null && configFileName != null) {
            DomManager domManager = dependency.getManager();
            Intrinsics.checkNotNullExpressionValue((Object)domManager, (String)"dependency.manager");
            Project project = domManager.getProject();
            Object[] objectArray = FilenameIndex.getFilesByName((Project)project, (String)configFileName, (GlobalSearchScope)GlobalSearchScopesCore.projectProductionScope((Project)project));
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FilenameIndex.getFilesBy\u2026ProductionScope(project))");
            Object[] matchingFiles = objectArray;
            Object object = ArraysKt.singleOrNull((Object[])matchingFiles);
            if (!(object instanceof XmlFile)) {
                object = null;
            }
            xmlFile = (XmlFile)object;
        }
        XmlFile xmlFile2 = xmlFile;
        if (xmlFile2 != null) {
            XmlFile xmlFile3;
            XmlFile it = xmlFile3 = xmlFile2;
            boolean bl = false;
            ideaPlugin = DescriptorUtil.getIdeaPlugin(it);
        } else {
            ideaPlugin = null;
        }
        return ideaPlugin;
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzePluginFile(IdeaPlugin ideaPlugin, List<String> analysisErrors, List<String> components, Set<String> nonDynamicEPs, Set<String> unspecifiedDynamicEPs, List<String> serviceOverrides, boolean allowOwnEPs) {
        String string;
        Collection collection;
        void $this$mapTo$iv;
        Iterable list$iv$iv;
        Object it;
        Object $this$flatMapTo$iv$iv;
        Object ep;
        void $this$flatMapTo$iv$iv2;
        List<Extensions> list = ideaPlugin.getExtensions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"ideaPlugin.extensions");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap2 = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            Extensions it2 = (Extensions)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv2 = it2.collectExtensions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
        }
        Iterator iterator = ((List)destination$iv$iv).iterator();
        while (iterator.hasNext()) {
            Extension extension;
            Extension extension2 = extension = (Extension)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)extension2, (String)"extension");
            ep = extension2.getExtensionPoint();
            if (ep == null) {
                analysisErrors.add("Cannot resolve EP " + extension.getXmlElementName());
                continue;
            }
            if (allowOwnEPs && (Intrinsics.areEqual((Object)ep.getModule(), (Object)ideaPlugin.getModule()) || Intrinsics.areEqual((Object)ep.getModule(), (Object)extension.getModule()))) continue;
            GenericAttributeValue<Boolean> genericAttributeValue = ep.getDynamic();
            Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"ep.dynamic");
            Boolean $i$f$flatMap2 = (Boolean)genericAttributeValue.getValue();
            if (Intrinsics.areEqual((Object)$i$f$flatMap2, (Object)false)) {
                String string2 = ep.getEffectiveQualifiedName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ep.effectiveQualifiedName");
                nonDynamicEPs.add(string2);
            } else if ($i$f$flatMap2 == null) {
                String string3 = ep.getEffectiveQualifiedName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ep.effectiveQualifiedName");
                unspecifiedDynamicEPs.add(string3);
            }
            if (!Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.applicationService") && !Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.projectService") && !Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.moduleService") || !Intrinsics.areEqual((Object)extension.getXmlTag().getAttributeValue("overrides"), (Object)"true")) continue;
            String string4 = extension.getXmlTag().getAttributeValue("serviceInterface");
            if (string4 == null) {
                string4 = "<unknown>";
            }
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"extension.xmlTag.getAttr\u2026nterface\") ?: \"<unknown>\"");
            serviceOverrides.add(string4);
        }
        List<ApplicationComponents> list2 = ideaPlugin.getApplicationComponents();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"ideaPlugin.applicationComponents");
        Iterable $this$flatMap$iv2 = list2;
        boolean $i$f$flatMap3 = false;
        ep = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        destination$iv$iv = $this$flatMapTo$iv$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            Object element$iv$iv = destination$iv$iv.next();
            it = (ApplicationComponents)element$iv$iv;
            boolean bl = false;
            ApplicationComponents applicationComponents = it;
            Intrinsics.checkNotNullExpressionValue((Object)applicationComponents, (String)"it");
            list$iv$iv = applicationComponents.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it3;
            Component.Application $i$f$flatMapTo22 = (Component.Application)item$iv;
            collection = components;
            boolean bl = false;
            void v8 = it3;
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"it");
            GenericDomValue<PsiClass> genericDomValue = v8.getImplementationClass();
            Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"it.implementationClass");
            String string5 = genericDomValue.getRawText();
            if (string5 == null) {
                string5 = "?";
            }
            string = string5;
            collection.add(string);
        }
        List<ProjectComponents> list3 = ideaPlugin.getProjectComponents();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"ideaPlugin.projectComponents");
        $this$flatMap$iv2 = list3;
        $i$f$flatMap3 = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo32 = false;
        Iterator bl = $this$flatMapTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            it = (ProjectComponents)element$iv$iv;
            boolean bl2 = false;
            Object object = it;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
            list$iv$iv = object.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it4;
            Component.Project $i$f$flatMapTo32 = (Component.Project)item$iv;
            collection = components;
            boolean bl3 = false;
            void v13 = it4;
            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"it");
            GenericDomValue<PsiClass> genericDomValue = v13.getImplementationClass();
            Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"it.implementationClass");
            String string6 = genericDomValue.getRawText();
            if (string6 == null) {
                string6 = "?";
            }
            string = string6;
            collection.add(string);
        }
        List<ModuleComponents> list4 = ideaPlugin.getModuleComponents();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"ideaPlugin.moduleComponents");
        $this$flatMap$iv2 = list4;
        $i$f$flatMap3 = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo42 = false;
        Iterator bl3 = $this$flatMapTo$iv$iv.iterator();
        while (bl3.hasNext()) {
            Object element$iv$iv = bl3.next();
            it = (ModuleComponents)element$iv$iv;
            boolean bl4 = false;
            Object object = it;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
            list$iv$iv = object.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it5;
            Component.Module $i$f$flatMapTo42 = (Component.Module)item$iv;
            collection = components;
            boolean bl5 = false;
            void v18 = it5;
            Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"it");
            GenericDomValue<PsiClass> genericDomValue = v18.getImplementationClass();
            Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"it.implementationClass");
            String string7 = genericDomValue.getRawText();
            if (string7 == null) {
                string7 = "?";
            }
            string = string7;
            collection.add(string);
        }
    }

    public static final /* synthetic */ PluginUnloadabilityStatus access$analyzeUnloadable(AnalyzeUnloadablePluginsAction $this, IdeaPlugin ideaPlugin, List allPlugins) {
        return $this.analyzeUnloadable(ideaPlugin, allPlugins);
    }

    public static final /* synthetic */ IdeaPlugin access$resolvePluginDependency(AnalyzeUnloadablePluginsAction $this, Dependency dependency) {
        return $this.resolvePluginDependency(dependency);
    }

    public static final /* synthetic */ void access$analyzePluginFile(AnalyzeUnloadablePluginsAction $this, IdeaPlugin ideaPlugin, List analysisErrors, List components, Set nonDynamicEPs, Set unspecifiedDynamicEPs, List serviceOverrides, boolean allowOwnEPs) {
        $this.analyzePluginFile(ideaPlugin, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides, allowOwnEPs);
    }
}

