/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.testAssistant.TestDataFile;
import org.jetbrains.idea.devkit.testAssistant.TestDataGuessByExistingFilesUtil;
import org.jetbrains.idea.devkit.testAssistant.TestDataGuessByTestDiscoveryUtil;
import org.jetbrains.idea.devkit.testAssistant.TestDataLineMarkerProvider;
import org.jetbrains.idea.devkit.testAssistant.TestDataNavigationElement;
import org.jetbrains.idea.devkit.testAssistant.TestDataNavigationElementFactory;
import org.jetbrains.idea.devkit.testAssistant.TestDataReferenceCollector;
import org.jetbrains.idea.devkit.testAssistant.TestDataUtil;
import org.jetbrains.idea.devkit.testAssistant.vfs.TestDataGroupVirtualFile;

public class TestDataNavigationHandler
implements GutterIconNavigationHandler<PsiMethod> {
    public void navigate(MouseEvent e, PsiMethod elt) {
        List<TestDataFile> fileNames = TestDataNavigationHandler.getFileNames(elt);
        if (fileNames.isEmpty()) {
            return;
        }
        TestDataNavigationHandler.navigate(new RelativePoint(e), fileNames, elt.getProject());
    }

    @NotNull
    static List<TestDataFile> getFileNames(PsiMethod method) {
        return TestDataNavigationHandler.getFileNames(method, true);
    }

    @NotNull
    static List<TestDataFile> getFileNames(PsiMethod method, boolean collectByExistingFiles) {
        List<Object> fileNames = null;
        String testDataPath = TestDataLineMarkerProvider.getTestDataBasePath(method.getContainingClass());
        if (testDataPath != null) {
            fileNames = new TestDataReferenceCollector(testDataPath, method.getName().substring(4)).collectTestDataReferences(method, collectByExistingFiles);
        }
        if (collectByExistingFiles && (fileNames == null || fileNames.isEmpty())) {
            fileNames = new ArrayList<TestDataFile>();
            fileNames.addAll(TestDataGuessByExistingFilesUtil.collectTestDataByExistingFiles(method, testDataPath));
            fileNames.addAll(TestDataGuessByTestDiscoveryUtil.collectTestDataByExistingFiles(method));
        }
        List<Object> list = fileNames == null ? Collections.emptyList() : fileNames;
        if (list == null) {
            TestDataNavigationHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    public static void navigate(@NotNull RelativePoint point, @NotNull List<TestDataFile> testDataFiles, Project project) {
        TestDataGroupVirtualFile groupFile;
        if (point == null) {
            TestDataNavigationHandler.$$$reportNull$$$0(1);
        }
        if (testDataFiles == null) {
            TestDataNavigationHandler.$$$reportNull$$$0(2);
        }
        if (testDataFiles.isEmpty()) {
            return;
        }
        if (testDataFiles.size() == 1) {
            TestDataUtil.openOrAskToCreateFile(project, testDataFiles.get(0));
            return;
        }
        if (testDataFiles.size() == 2 && (groupFile = TestDataUtil.getTestDataGroup(testDataFiles.get(0), testDataFiles.get(1))) != null) {
            PsiNavigationSupport.getInstance().createNavigatable(project, (VirtualFile)groupFile, -1).navigate(true);
            return;
        }
        TestDataNavigationHandler.showNavigationPopup(project, testDataFiles, point);
    }

    @NotNull
    public static List<String> fastGetTestDataPathsByRelativePath(@NotNull String testDataFileRelativePath, PsiMethod method) {
        if (testDataFileRelativePath == null) {
            TestDataNavigationHandler.$$$reportNull$$$0(3);
        }
        List<String> list = TestDataNavigationHandler.getFileNames(method, false).stream().map(TestDataFile::getPath).filter(path -> path.endsWith((String)(testDataFileRelativePath.startsWith("/") ? testDataFileRelativePath : "/" + testDataFileRelativePath))).distinct().collect(Collectors.toList());
        if (list == null) {
            TestDataNavigationHandler.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static void showNavigationPopup(Project project, List<TestDataFile> filePaths, RelativePoint point) {
        filePaths.sort(Comparator.comparing(TestDataFile::getName, String.CASE_INSENSITIVE_ORDER));
        ArrayList elementsToDisplay = new ArrayList();
        ArrayList<TestDataNavigationElement> nonExistingElementsToDisplay = new ArrayList<TestDataNavigationElement>();
        HashSet<TestDataFile> files = new HashSet<TestDataFile>();
        for (TestDataFile testDataFile : filePaths) {
            if (!testDataFile.exists()) {
                if (nonExistingElementsToDisplay.isEmpty()) {
                    nonExistingElementsToDisplay.add(TestDataNavigationElementFactory.createForCreateMissingFilesOption(filePaths));
                }
                nonExistingElementsToDisplay.add(TestDataNavigationElementFactory.createForNonExistingFile(project, testDataFile));
                continue;
            }
            files.add(testDataFile);
        }
        TestDataNavigationHandler.consumeElementsToDisplay(project, files, elementsToDisplay::add);
        elementsToDisplay.addAll(nonExistingElementsToDisplay);
        JBList list = new JBList(elementsToDisplay);
        list.setSelectionMode(0);
        list.setCellRenderer(new ColoredListCellRenderer<TestDataNavigationElement>(){

            protected void customizeCellRenderer(@NotNull JList list, TestDataNavigationElement element, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                element.getTitleFragments().forEach(pair -> this.append((String)pair.getFirst(), (SimpleTextAttributes)pair.getSecond()));
                this.setIcon(element.getIcon());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationHandler$1", "customizeCellRenderer"));
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setNamerForFiltering(element -> (String)Objects.requireNonNull((Pair)ContainerUtil.getFirstItem(element.getTitleFragments())).first).setItemChoosenCallback(() -> TestDataNavigationHandler.lambda$showNavigationPopup$2((JList)list, project)).setTitle(DevKitBundle.message("testdata.popup.navigation.title", new Object[0])).createPopup().show(point);
    }

    private static void consumeElementsToDisplay(@NotNull Project project, @NotNull Set<TestDataFile> files, @NotNull Consumer<TestDataNavigationElement> consumer) {
        if (project == null) {
            TestDataNavigationHandler.$$$reportNull$$$0(5);
        }
        if (files == null) {
            TestDataNavigationHandler.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            TestDataNavigationHandler.$$$reportNull$$$0(7);
        }
        for (Map.Entry e : ContainerUtil.groupBy(files, f -> {
            VirtualFile file = f.getVirtualFile();
            assert (file != null);
            return file.getParent();
        }).entrySet()) {
            Collection dirFiles = (Collection)e.getValue();
            HashSet<TestDataFile> usedPaths = new HashSet<TestDataFile>();
            for (TestDataFile testDataFile1 : dirFiles) {
                if (usedPaths.contains(testDataFile1)) continue;
                boolean groupFound = false;
                for (TestDataFile testDataFile2 : dirFiles) {
                    TestDataGroupVirtualFile group;
                    VirtualFile file2 = testDataFile2.getVirtualFile();
                    assert (file2 != null);
                    if (testDataFile1.equals(testDataFile2) || usedPaths.contains(testDataFile1) || (group = TestDataUtil.getTestDataGroup(testDataFile1, testDataFile2)) == null) continue;
                    groupFound = true;
                    consumer.accept(TestDataNavigationElementFactory.createForGroup(project, group));
                    usedPaths.add(testDataFile1);
                    usedPaths.add(testDataFile2);
                    break;
                }
                if (groupFound) continue;
                consumer.accept(TestDataNavigationElementFactory.createForFile(project, testDataFile1));
                usedPaths.add(testDataFile1);
            }
        }
    }

    private static /* synthetic */ void lambda$showNavigationPopup$2(JList list, Project project) {
        TestDataNavigationElement selectedElement = (TestDataNavigationElement)list.getSelectedValue();
        if (selectedElement != null) {
            selectedElement.performAction(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataFileRelativePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fastGetTestDataPathsByRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fastGetTestDataPathsByRelativePath";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "consumeElementsToDisplay";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

