/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.text.StringUtil;
import icons.SvnIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public final class ConflictState
extends Enum<ConflictState> {
    public static final /* enum */ ConflictState none = new ConflictState(false, false, false, null);
    public static final /* enum */ ConflictState tree = new ConflictState(true, false, false, SvnIcons.Conflictc);
    public static final /* enum */ ConflictState text = new ConflictState(false, true, false, SvnIcons.Conflictt);
    public static final /* enum */ ConflictState prop = new ConflictState(false, false, true, SvnIcons.Conflictp);
    public static final /* enum */ ConflictState tree_text = new ConflictState(true, true, false, SvnIcons.Conflictct);
    public static final /* enum */ ConflictState tree_prop = new ConflictState(true, false, true, SvnIcons.Conflictcp);
    public static final /* enum */ ConflictState text_prop = new ConflictState(false, true, true, SvnIcons.Conflicttp);
    public static final /* enum */ ConflictState all3 = new ConflictState(true, true, true, SvnIcons.Conflictctp);
    private final boolean myTree;
    private final boolean myText;
    private final boolean myProperty;
    @Nullable
    private final Icon myIcon;
    private static final /* synthetic */ ConflictState[] $VALUES;

    public static ConflictState[] values() {
        return (ConflictState[])$VALUES.clone();
    }

    public static ConflictState valueOf(String name) {
        return Enum.valueOf(ConflictState.class, name);
    }

    private ConflictState(boolean tree, @Nullable boolean text, boolean property, Icon icon) {
        this.myTree = tree;
        this.myText = text;
        this.myProperty = property;
        this.myIcon = icon;
    }

    public boolean isTree() {
        return this.myTree;
    }

    public boolean isText() {
        return this.myText;
    }

    public boolean isProperty() {
        return this.myProperty;
    }

    public boolean isConflict() {
        return this.myProperty || this.myText || this.myTree;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nls
    public String getDescription() {
        if (!this.isConflict()) {
            return null;
        }
        List<String> conflicts = Arrays.asList(this.myTree ? SvnBundle.message("file.conflict.tree", new Object[0]) : null, this.myText ? SvnBundle.message("file.conflict.text", new Object[0]) : null, this.myProperty ? SvnBundle.message("file.conflict.property", new Object[0]) : null);
        return StringUtil.join(conflicts, (String)", ");
    }

    public static ConflictState mergeState(ConflictState leftState, ConflictState rightState) {
        return ConflictState.getInstance(leftState.myTree || rightState.myTree, leftState.myText || rightState.myText, leftState.myProperty || rightState.myProperty);
    }

    @NotNull
    public static ConflictState getInstance(boolean tree, boolean text, boolean property) {
        ConflictState[] conflictStates;
        for (ConflictState state : conflictStates = ConflictState.values()) {
            if (state.isTree() != tree || state.isText() != text || state.isProperty() != property) continue;
            ConflictState conflictState = state;
            if (conflictState == null) {
                ConflictState.$$$reportNull$$$0(0);
            }
            return conflictState;
        }
        assert (false);
        if (null == null) {
            ConflictState.$$$reportNull$$$0(1);
        }
        return null;
    }

    @NotNull
    public static ConflictState from(@NotNull Status status) {
        if (status == null) {
            ConflictState.$$$reportNull$$$0(2);
        }
        return ConflictState.getInstance(status.getTreeConflict() != null, status.is(StatusType.STATUS_CONFLICTED), status.isProperty(StatusType.STATUS_CONFLICTED));
    }

    static {
        $VALUES = new ConflictState[]{none, tree, text, prop, tree_text, tree_prop, text_prop, all3};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/ConflictState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/ConflictState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

