/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.config.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.DefaultEventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFileWriter;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogWriter;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogFileWriter;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;", "recorderId", "", "maxFileSizeInBytes", "", "isEap", "", "prefix", "(Ljava/lang/String;IZLjava/lang/String;)V", "logger", "Lcom/intellij/internal/statistic/eventLog/EventLogFileWriter;", "cleanup", "", "dispose", "getActiveFile", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "getEventLogDir", "Ljava/nio/file/Path;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "log", "logEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "rollOver", "intellij.platform.statistics"})
public final class StatisticsEventLogFileWriter
implements StatisticsEventLogWriter {
    private EventLogFileWriter logger;
    private final String recorderId;

    private final Path getEventLogDir() {
        Path path = EventLogConfiguration.Companion.getInstance().getEventLogDataPath().resolve("logs").resolve(this.recorderId);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"EventLogConfiguration.ge\u2026ogs\").resolve(recorderId)");
        return path;
    }

    @Override
    public void log(@NotNull LogEvent logEvent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)logEvent, (String)"logEvent");
            EventLogFileWriter eventLogFileWriter = this.logger;
            if (eventLogFileWriter == null) break block0;
            eventLogFileWriter.log(LogEventSerializer.INSTANCE.toString(logEvent));
        }
    }

    @Override
    @Nullable
    public EventLogFile getActiveFile() {
        Object object = this.logger;
        if (object == null || (object = ((EventLogFileWriter)object).getActiveLogName()) == null) {
            return null;
        }
        Object activeLog = object;
        return new EventLogFile(new File(new File(this.getEventLogDir().toUri()), (String)activeLog));
    }

    @Override
    @NotNull
    public EventLogFilesProvider getLogFilesProvider() {
        return new DefaultEventLogFilesProvider(this.getEventLogDir(), (Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ StatisticsEventLogFileWriter this$0;

            @Nullable
            public final String invoke() {
                EventLogFileWriter eventLogFileWriter = StatisticsEventLogFileWriter.access$getLogger$p(this.this$0);
                return eventLogFileWriter != null ? eventLogFileWriter.getActiveLogName() : null;
            }
            {
                this.this$0 = statisticsEventLogFileWriter;
                super(0);
            }
        }));
    }

    @Override
    public void cleanup() {
        block0: {
            EventLogFileWriter eventLogFileWriter = this.logger;
            if (eventLogFileWriter == null) break block0;
            eventLogFileWriter.cleanUp();
        }
    }

    @Override
    public void rollOver() {
        block0: {
            EventLogFileWriter eventLogFileWriter = this.logger;
            if (eventLogFileWriter == null) break block0;
            eventLogFileWriter.rollOver();
        }
    }

    public void dispose() {
        block0: {
            EventLogFileWriter eventLogFileWriter = this.logger;
            if (eventLogFileWriter == null) break block0;
            eventLogFileWriter.close();
        }
    }

    public StatisticsEventLogFileWriter(@NotNull String recorderId, int maxFileSizeInBytes, boolean isEap, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.recorderId = recorderId;
        try {
            EventLogFileWriter fileEventLoggerLogger;
            Path dir = this.getEventLogDir();
            EventLogBuildType buildType = isEap ? EventLogBuildType.EAP : EventLogBuildType.RELEASE;
            Function1 logFilePathProvider2 = (Function1)new Function1<Path, File>(buildType, prefix){
                final /* synthetic */ EventLogBuildType $buildType;
                final /* synthetic */ String $prefix;

                @NotNull
                public final File invoke(@NotNull Path directory) {
                    Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                    return EventLogFile.Companion.create(directory, this.$buildType, this.$prefix).getFile();
                }
                {
                    this.$buildType = eventLogBuildType;
                    this.$prefix = string;
                    super(1);
                }
            };
            this.logger = fileEventLoggerLogger = new EventLogFileWriter(dir, maxFileSizeInBytes, logFilePathProvider2, 0L, 8, null);
            if (StatisticsRecorderUtil.isTestModeEnabled(this.recorderId)) {
                AppExecutorUtil.getAppScheduledExecutorService().schedule(new Runnable(){

                    @Override
                    public final void run() {
                        fileEventLoggerLogger.flush();
                    }
                }, 10L, TimeUnit.SECONDS);
            }
        }
        catch (IOException e) {
            System.err.println("Unable to initialize logging for feature usage: " + e.getLocalizedMessage());
        }
    }

    public static final /* synthetic */ EventLogFileWriter access$getLogger$p(StatisticsEventLogFileWriter $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$setLogger$p(StatisticsEventLogFileWriter $this, EventLogFileWriter eventLogFileWriter) {
        $this.logger = eventLogFileWriter;
    }
}

