/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection;

import com.intellij.internal.statistic.config.EventLogExternalSendSettings;
import com.intellij.internal.statistic.config.bean.EventLogSendConfiguration;
import com.intellij.internal.statistic.config.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.connection.SettingsConnectionService;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUtils;
import com.intellij.internal.statistic.eventLog.filters.LogEventBucketsFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventCompositeFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventFalseFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventMetadataFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventSnapshotBuildFilter;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EventLogUploadSettingsService
extends SettingsConnectionService
implements EventLogSettingsService {
    private static final String SEND = "send";
    private static final String METADATA = "metadata";
    private static final String DICTIONARY = "dictionary";
    @NotNull
    private final EventLogApplicationInfo myApplicationInfo;

    public EventLogUploadSettingsService(@NotNull String recorderId, @NotNull EventLogApplicationInfo appInfo) {
        if (recorderId == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(0);
        }
        if (appInfo == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(1);
        }
        this(recorderId, appInfo, TimeUnit.MINUTES.toMillis(10L));
    }

    public EventLogUploadSettingsService(@NotNull String recorderId, @NotNull EventLogApplicationInfo appInfo, long settingsCacheTimeoutMs) {
        if (recorderId == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(2);
        }
        if (appInfo == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(3);
        }
        super(EventLogUploadSettingsService.getConfigUrl(recorderId, appInfo.getProductCode(), appInfo.getTemplateUrl(), appInfo.isTest()), appInfo, settingsCacheTimeoutMs);
        this.myApplicationInfo = appInfo;
    }

    @NotNull
    private static String getConfigUrl(@NotNull String recorderId, @NotNull String productCode, @NotNull String templateUrl, boolean isTest) {
        if (recorderId == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(4);
        }
        if (productCode == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(5);
        }
        if (templateUrl == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(6);
        }
        if (isTest) {
            String string = String.format(templateUrl, "test/" + recorderId, productCode);
            if (string == null) {
                EventLogUploadSettingsService.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = String.format(templateUrl, recorderId, productCode);
        if (string == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    public String getServiceUrl() {
        return this.getEndpointValue(SEND);
    }

    @Override
    @Nullable
    public String getDictionaryServiceUrl() {
        return this.getEndpointValue(DICTIONARY);
    }

    @Override
    public boolean isSettingsReachable() {
        return this.getExternalSettings() != null;
    }

    @Override
    public boolean isSendEnabled() {
        EventLogExternalSendSettings settings = this.getExternalSettings();
        return settings != null && settings.isSendEnabled();
    }

    @Override
    @NotNull
    public LogEventFilter getBaseEventFilter() {
        return new LogEventMetadataFilter(EventLogUploadSettingsService.notNull(this.loadApprovedGroupsRules(), (EventGroupsFilterRules<EventLogBuild>)EventGroupsFilterRules.empty()));
    }

    @Override
    @NotNull
    public LogEventFilter getEventFilter(@NotNull LogEventFilter base, @NotNull EventLogBuildType type) {
        EventLogSendConfiguration configuration;
        if (base == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(9);
        }
        if (type == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(10);
        }
        if ((configuration = this.getConfiguration(type)) == null) {
            DataCollectorDebugLogger logger2 = this.myApplicationInfo.getLogger();
            if (logger2.isTraceEnabled()) {
                logger2.trace("Cannot find send configuration for '" + type + "' -> clean up log file");
            }
            LogEventFalseFilter logEventFalseFilter = LogEventFalseFilter.INSTANCE;
            if (logEventFalseFilter == null) {
                EventLogUploadSettingsService.$$$reportNull$$$0(11);
            }
            return logEventFalseFilter;
        }
        return new LogEventCompositeFilter(new LogEventBucketsFilter(configuration.getBuckets()), base, LogEventSnapshotBuildFilter.INSTANCE);
    }

    private static EventGroupsFilterRules<EventLogBuild> notNull(@Nullable EventGroupsFilterRules<EventLogBuild> groupFilterConditions, @NotNull EventGroupsFilterRules<EventLogBuild> defaultValue) {
        if (defaultValue == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(12);
        }
        return groupFilterConditions != null ? groupFilterConditions : defaultValue;
    }

    @Override
    @NotNull
    public EventLogApplicationInfo getApplicationInfo() {
        EventLogApplicationInfo eventLogApplicationInfo = this.myApplicationInfo;
        if (eventLogApplicationInfo == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(13);
        }
        return eventLogApplicationInfo;
    }

    @Nullable
    protected EventGroupsFilterRules<EventLogBuild> loadApprovedGroupsRules() {
        String productUrl = this.getMetadataProductUrl();
        if (productUrl == null) {
            return null;
        }
        EventLogConnectionSettings settings = this.myApplicationInfo.getConnectionSettings();
        return EventLogMetadataUtils.loadAndParseGroupsFilterRules(productUrl, settings);
    }

    @NonNls
    @Nullable
    public String getMetadataProductUrl() {
        String baseMetadataUrl = this.getEndpointValue(METADATA);
        if (baseMetadataUrl == null) {
            return null;
        }
        return baseMetadataUrl + this.myApplicationInfo.getProductCode() + ".json";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productCode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateUrl";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/connection/EventLogUploadSettingsService";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/connection/EventLogUploadSettingsService";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigUrl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventFilter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConfigUrl";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEventFilter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "notNull";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

